/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriterImpl;
import org.eigenbase.rel.RelXmlWriter;
import org.eigenbase.rel.rules.PullConstantsThroughAggregatesRule;
import org.eigenbase.rel.rules.RemoveEmptyRules;
import org.eigenbase.rel.rules.WindowedAggSplitterRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.VisitorRelVisitor;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlPostfixOperator;
import org.eigenbase.sql.fun.SqlMinMaxAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.MultisetSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.MappingType;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelOptUtil {
    public static Set<String> getVariablesSet(RelNode rel) {
        VariableSetVisitor visitor = new VariableSetVisitor();
        RelOptUtil.go(visitor, rel);
        return visitor.variables;
    }

    public static Set<String> getVariablesUsed(RelNode rel) {
        final VariableUsedVisitor vuv = new VariableUsedVisitor();
        VisitorRelVisitor visitor = new VisitorRelVisitor(vuv){

            public void visit(RelNode p, int ordinal, RelNode parent) {
                p.collectVariablesUsed(vuv.variables);
                super.visit(p, ordinal, parent);
                vuv.variables.removeAll(p.getVariablesStopped());
            }
        };
        visitor.go(rel);
        return vuv.variables;
    }

    public static void go(RelVisitor visitor, RelNode p) {
        try {
            visitor.go(p);
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "while visiting tree");
        }
    }

    public static List<RelDataType> getFieldTypeList(final RelDataType type) {
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return type.getFieldList().get(index).getType();
            }

            @Override
            public int size() {
                return type.getFieldCount();
            }
        };
    }

    public static boolean areRowTypesEqual(RelDataType rowType1, RelDataType rowType2, boolean compareNames) {
        if (rowType1 == rowType2) {
            return true;
        }
        if (compareNames) {
            return false;
        }
        if (rowType2.getFieldCount() != rowType1.getFieldCount()) {
            return false;
        }
        List<RelDataTypeField> f1 = rowType1.getFieldList();
        List<RelDataTypeField> f2 = rowType2.getFieldList();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(f1, f2)) {
            RelDataType type1 = ((RelDataTypeField)pair.left).getType();
            RelDataType type2 = ((RelDataTypeField)pair.right).getType();
            if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static void verifyTypeEquivalence(RelNode originalRel, RelNode newRel, Object equivalenceClass) {
        RelDataType actualRowType;
        RelDataType expectedRowType = originalRel.getRowType();
        if (RelOptUtil.areRowTypesEqual(expectedRowType, actualRowType = newRel.getRowType(), false)) {
            return;
        }
        String s = "Cannot add expression of different type to set:\nset type is " + expectedRowType.getFullTypeString() + "\nexpression type is " + actualRowType.getFullTypeString() + "\nset is " + equivalenceClass.toString() + "\nexpression is " + newRel.toString();
        throw Util.newInternal(s);
    }

    public static Mappings.TargetMapping permutation(List<RexNode> nodes, RelDataType inputRowType) {
        Mapping mapping = Mappings.create(MappingType.PARTIAL_FUNCTION, nodes.size(), inputRowType.getFieldCount());
        for (Ord<RexNode> node : Ord.zip(nodes)) {
            RexNode operand;
            if (node.e instanceof RexInputRef) {
                mapping.set(node.i, ((RexInputRef)node.e).getIndex());
                continue;
            }
            if (!((RexNode)node.e).isA(SqlKind.CAST) || !((operand = ((RexCall)node.e).getOperands().get(0)) instanceof RexInputRef)) continue;
            mapping.set(node.i, ((RexInputRef)operand).getIndex());
        }
        return mapping;
    }

    public static RelNode createExistsPlan(RelOptCluster cluster, RelNode seekRel, boolean isIn, boolean isExists, boolean needsOuterJoin) {
        RelNode ret = seekRel;
        if (isIn || isExists) {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            ArrayList<RexNode> exprs = new ArrayList<RexNode>();
            if (isIn) {
                for (int i = 0; i < ret.getRowType().getFieldCount(); ++i) {
                    exprs.add(rexBuilder.makeInputRef(ret, i));
                }
            }
            if (needsOuterJoin) {
                RexLiteral trueExp = rexBuilder.makeLiteral(true);
                exprs.add(trueExp);
                ret = CalcRel.createProject(ret, exprs, null);
                ImmutableList<RelDataType> argTypes = ImmutableList.of(typeFactory.createSqlType(SqlTypeName.BOOLEAN));
                SqlMinMaxAggFunction minFunction = new SqlMinMaxAggFunction(argTypes, true, 1);
                int newProjFieldCount = ret.getRowType().getFieldCount();
                RelDataType returnType = minFunction.inferReturnType(new AggregateRelBase.AggCallBinding(typeFactory, minFunction, argTypes, newProjFieldCount - 1));
                AggregateCall aggCall = new AggregateCall(minFunction, false, Collections.singletonList(newProjFieldCount - 1), returnType, null);
                ret = new AggregateRel(ret.getCluster(), ret, BitSets.range(newProjFieldCount - 1), Collections.singletonList(aggCall));
            } else {
                ret = new AggregateRel(ret.getCluster(), ret, BitSets.range(ret.getRowType().getFieldCount()), Collections.<AggregateCall>emptyList());
            }
        }
        return ret;
    }

    public static RelNode createCastRel(RelNode rel, RelDataType castRowType, boolean rename) {
        RelDataType rowType = rel.getRowType();
        if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
            return rel;
        }
        List<RexNode> castExps = RexUtil.generateCastExpressions(rel.getCluster().getRexBuilder(), castRowType, rowType);
        if (rename) {
            return CalcRel.createProject(rel, castExps, castRowType.getFieldNames());
        }
        return CalcRel.createProject(rel, castExps, rowType.getFieldNames());
    }

    public static RelNode createSingleValueAggRel(RelOptCluster cluster, RelNode rel) {
        int aggCallCnt = rel.getRowType().getFieldCount();
        ArrayList<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        for (int i = 0; i < aggCallCnt; ++i) {
            RelDataType returnType = SqlStdOperatorTable.SINGLE_VALUE.inferReturnType(cluster.getRexBuilder().getTypeFactory(), ImmutableList.of(rel.getRowType().getFieldList().get(i).getType()));
            aggCalls.add(new AggregateCall(SqlStdOperatorTable.SINGLE_VALUE, false, Collections.singletonList(i), returnType, null));
        }
        return new AggregateRel(rel.getCluster(), rel, BitSets.of(new int[0]), aggCalls);
    }

    public static RelNode createDistinctRel(RelNode rel) {
        return new AggregateRel(rel.getCluster(), rel, BitSets.range(rel.getRowType().getFieldCount()), ImmutableList.<AggregateCall>of());
    }

    public static RexNode splitJoinCondition(RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left.getRowType().getFieldCount(), condition, leftKeys, rightKeys, nonEquiList);
        return RexUtil.composeConjunction(left.getCluster().getRexBuilder(), nonEquiList, false);
    }

    public static RexNode splitCorrelatedFilterCondition(FilterRel filterRel, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, boolean extractCorrelatedFieldAccess) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitCorrelatedFilterCondition(filterRel, filterRel.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
        return RexUtil.composeConjunction(filterRel.getCluster().getRexBuilder(), nonEquiList, true);
    }

    private static void splitCorrelatedFilterCondition(FilterRel filterRel, RexNode condition, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList, boolean extractCorrelatedFieldAccess) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitCorrelatedFilterCondition(filterRel, operand, joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
                }
                return;
            }
            if (call.getOperator() == SqlStdOperatorTable.EQUALS) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                if (extractCorrelatedFieldAccess) {
                    if (!RexUtil.containsFieldAccess(op0) && op1 instanceof RexFieldAccess) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexFieldAccess && !RexUtil.containsFieldAccess(op1)) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                } else {
                    if (!RexUtil.containsInputRef(op0) && op1 instanceof RexInputRef) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexInputRef && !RexUtil.containsInputRef(op1)) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                }
            }
        }
        nonEquiList.add(condition);
    }

    private static void splitJoinCondition(int leftFieldCount, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys, List<RexNode> nonEquiList) {
        if (condition instanceof RexCall) {
            List<RexNode> operands;
            RexCall call = (RexCall)condition;
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitJoinCondition(leftFieldCount, operand, leftKeys, rightKeys, nonEquiList);
                }
                return;
            }
            if ((operator == SqlStdOperatorTable.EQUALS || operator == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) && (operands = call.getOperands()).get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                RexInputRef rightField;
                RexInputRef leftField;
                RexInputRef op0 = (RexInputRef)operands.get(0);
                RexInputRef op1 = (RexInputRef)operands.get(1);
                if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                    leftField = op0;
                    rightField = op1;
                } else if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                    leftField = op1;
                    rightField = op0;
                } else {
                    nonEquiList.add(condition);
                    return;
                }
                leftKeys.add(leftField.getIndex());
                rightKeys.add(rightField.getIndex() - leftFieldCount);
                return;
            }
        }
        if (!condition.isAlwaysTrue()) {
            nonEquiList.add(condition);
        }
    }

    public static void registerAbstractRels(RelOptPlanner planner) {
        planner.addRule(PullConstantsThroughAggregatesRule.INSTANCE);
        planner.addRule(RemoveEmptyRules.UNION_INSTANCE);
        planner.addRule(RemoveEmptyRules.PROJECT_INSTANCE);
        planner.addRule(RemoveEmptyRules.FILTER_INSTANCE);
        planner.addRule(RemoveEmptyRules.SORT_INSTANCE);
        planner.addRule(RemoveEmptyRules.AGGREGATE_INSTANCE);
        planner.addRule(RemoveEmptyRules.JOIN_LEFT_INSTANCE);
        planner.addRule(RemoveEmptyRules.JOIN_RIGHT_INSTANCE);
        planner.addRule(RemoveEmptyRules.SORT_FETCH_ZERO_INSTANCE);
        planner.addRule(WindowedAggSplitterRule.PROJECT);
    }

    public static String dumpPlan(String header, RelNode rel, boolean asXml, SqlExplainLevel detailLevel) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (!header.equals("")) {
            pw.println(header);
        }
        RelWriterImpl planWriter = asXml ? new RelXmlWriter(pw, detailLevel) : new RelWriterImpl(pw, detailLevel, false);
        rel.explain(planWriter);
        pw.flush();
        return sw.toString();
    }

    public static RelDataType createDmlRowType(SqlKind kind, RelDataTypeFactory typeFactory) {
        switch (kind) {
            case INSERT: {
                return typeFactory.createStructType(Collections.singletonList(Pair.of("ROWCOUNT", typeFactory.createSqlType(SqlTypeName.BIGINT))));
            }
            case EXPLAIN: {
                return typeFactory.createStructType(Collections.singletonList(Pair.of("PLAN", typeFactory.createSqlType(SqlTypeName.VARCHAR, -1))));
            }
        }
        throw Util.unexpected(kind);
    }

    public static boolean eq(String desc1, RelDataType type1, String desc2, RelDataType type2, boolean fail) {
        if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY) {
            return true;
        }
        if (type1 != type2) {
            assert (!fail) : "type mismatch:\n" + desc1 + ":\n" + type1.getFullTypeString() + "\n" + desc2 + ":\n" + type2.getFullTypeString();
            return false;
        }
        return true;
    }

    public static boolean equal(String desc1, RelDataType type1, String desc2, RelDataType type2, boolean fail) {
        if (!RelOptUtil.areRowTypesEqual(type1, type2, false)) {
            if (fail) {
                throw new AssertionError((Object)("Type mismatch:\n" + desc1 + ":\n" + type1.getFullTypeString() + "\n" + desc2 + ":\n" + type2.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    public static boolean equalType(String desc0, RelNode rel0, String desc1, RelNode rel1, boolean fail) {
        return RelOptUtil.equal(desc0, rel0.getRowType(), desc1, rel1.getRowType(), fail);
    }

    public static RexNode isDistinctFrom(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        RexNode ret = null;
        if (x.getType().isStruct()) {
            assert (y.getType().isStruct());
            List<RelDataTypeField> xFields = x.getType().getFieldList();
            List<RelDataTypeField> yFields = y.getType().getFieldList();
            assert (xFields.size() == yFields.size());
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(xFields, yFields)) {
                RelDataTypeField xField = (RelDataTypeField)pair.left;
                RelDataTypeField yField = (RelDataTypeField)pair.right;
                RexNode newX = rexBuilder.makeFieldAccess(x, xField.getIndex());
                RexNode newY = rexBuilder.makeFieldAccess(y, yField.getIndex());
                RexNode newCall = RelOptUtil.isDistinctFromInternal(rexBuilder, newX, newY, neg);
                if (ret == null) {
                    ret = newCall;
                    continue;
                }
                ret = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ret, newCall);
            }
        } else {
            ret = RelOptUtil.isDistinctFromInternal(rexBuilder, x, y, neg);
        }
        ret = rexBuilder.makeCast(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN), ret);
        return ret;
    }

    private static RexNode isDistinctFromInternal(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        SqlBinaryOperator eqOp;
        SqlPostfixOperator nullOp;
        if (neg) {
            nullOp = SqlStdOperatorTable.IS_NULL;
            eqOp = SqlStdOperatorTable.EQUALS;
        } else {
            nullOp = SqlStdOperatorTable.IS_NOT_NULL;
            eqOp = SqlStdOperatorTable.NOT_EQUALS;
        }
        RexNode[] whenThenElse = new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, x), rexBuilder.makeCall((SqlOperator)nullOp, y), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, y), rexBuilder.makeCall((SqlOperator)nullOp, x), rexBuilder.makeCall((SqlOperator)eqOp, x, y)};
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, whenThenElse);
    }

    public static String toString(RelNode rel) {
        return RelOptUtil.toString(rel, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
    }

    public static String toString(RelNode rel, SqlExplainLevel detailLevel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        RelWriterImpl planWriter = new RelWriterImpl(new PrintWriter(sw), detailLevel, false);
        rel.explain(planWriter);
        return sw.toString();
    }

    public static String dumpType(RelDataType type) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TypeDumper typeDumper = new TypeDumper(pw);
        if (type.isStruct()) {
            typeDumper.acceptFields(type.getFieldList());
        } else {
            typeDumper.accept(type);
        }
        pw.flush();
        return sw.toString();
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.AND)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeConjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList, List<RexNode> notList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        switch (rexPredicate.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                    RelOptUtil.decomposeConjunction(operand, rexList, notList);
                }
                break;
            }
            case NOT: {
                RexNode e = ((RexCall)rexPredicate).getOperands().get(0);
                if (e.isAlwaysFalse()) {
                    return;
                }
                notList.add(e);
                break;
            }
            default: {
                rexList.add(rexPredicate);
            }
        }
    }

    public static void decomposeDisjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysFalse()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.OR)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeDisjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static List<RexNode> conjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(rexPredicate, list);
        return list;
    }

    public static List<RexNode> disjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeDisjunction(rexPredicate, list);
        return list;
    }

    public static boolean classifyFilters(RelNode joinRel, List<RexNode> filters, boolean pushJoin, boolean pushLeft, boolean pushRight, List<RexNode> joinFilters, List<RexNode> leftFilters, List<RexNode> rightFilters) {
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        boolean filterPushed = false;
        List<RelDataTypeField> joinFields = joinRel.getRowType().getFieldList();
        int nTotalFields = joinFields.size();
        boolean nSysFields = false;
        List<RelDataTypeField> leftFields = joinRel.getInputs().get(0).getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        List<RelDataTypeField> rightFields = joinRel.getInputs().get(1).getRowType().getFieldList();
        int nFieldsRight = rightFields.size();
        assert (nTotalFields == 0 + nFieldsLeft + nFieldsRight);
        BitSet leftBitmap = BitSets.range(0, 0 + nFieldsLeft);
        BitSet rightBitmap = BitSets.range(0 + nFieldsLeft, nTotalFields);
        ListIterator<RexNode> filterIter = filters.listIterator();
        while (filterIter.hasNext()) {
            RexNode filter = filterIter.next();
            BitSet filterBitmap = InputFinder.bits(filter);
            if (pushLeft && BitSets.contains(leftBitmap, filterBitmap)) {
                filterPushed = true;
                if (!filter.isAlwaysTrue()) {
                    RexNode shiftedFilter = RelOptUtil.shiftFilter(0, 0 + nFieldsLeft, 0, rexBuilder, joinFields, nTotalFields, leftFields, filter);
                    leftFilters.add(shiftedFilter);
                }
                filterIter.remove();
                continue;
            }
            if (pushRight && BitSets.contains(rightBitmap, filterBitmap)) {
                filterPushed = true;
                if (!filter.isAlwaysTrue()) {
                    RexNode shilftedFilter = RelOptUtil.shiftFilter(0 + nFieldsLeft, nTotalFields, -(0 + nFieldsLeft), rexBuilder, joinFields, nTotalFields, rightFields, filter);
                    rightFilters.add(shilftedFilter);
                }
                filterIter.remove();
                continue;
            }
            if (!pushJoin) continue;
            filterPushed = true;
            joinFilters.add(filter);
            filterIter.remove();
        }
        return filterPushed;
    }

    private static RexNode shiftFilter(int start, int end, int offset, RexBuilder rexBuilder, List<RelDataTypeField> joinFields, int nTotalFields, List<RelDataTypeField> rightFields, RexNode filter) {
        int[] adjustments = new int[nTotalFields];
        for (int i = start; i < end; ++i) {
            adjustments[i] = offset;
        }
        return filter.accept(new RexInputConverter(rexBuilder, joinFields, rightFields, adjustments));
    }

    public static boolean checkProjAndChildInputs(ProjectRelBase project, boolean checkNames) {
        if (!project.isBoxed()) {
            return false;
        }
        int n = project.getProjects().size();
        RelDataType inputType = project.getChild().getRowType();
        if (inputType.getFieldList().size() != n) {
            return false;
        }
        List<RelDataTypeField> projFields = project.getRowType().getFieldList();
        List<RelDataTypeField> inputFields = inputType.getFieldList();
        boolean namesDifferent = false;
        for (int i = 0; i < n; ++i) {
            RexNode exp = project.getProjects().get(i);
            if (!(exp instanceof RexInputRef)) {
                return false;
            }
            RexInputRef fieldAccess = (RexInputRef)exp;
            if (i != fieldAccess.getIndex()) {
                return false;
            }
            if (!checkNames) continue;
            String inputFieldName = inputFields.get(i).getName();
            String projFieldName = projFields.get(i).getName();
            if (projFieldName.equals(inputFieldName)) continue;
            namesDifferent = true;
        }
        return !checkNames || namesDifferent;
    }

    public static List<RexNode> createSwappedJoinExprs(RelNode newJoin, JoinRelBase origJoin, boolean origOrder) {
        List<RelDataTypeField> newJoinFields = newJoin.getRowType().getFieldList();
        RexBuilder rexBuilder = newJoin.getCluster().getRexBuilder();
        ArrayList<RexNode> exps = new ArrayList<RexNode>();
        int nFields = origOrder ? origJoin.getRight().getRowType().getFieldCount() : origJoin.getLeft().getRowType().getFieldCount();
        for (int i = 0; i < newJoinFields.size(); ++i) {
            int source = (i + nFields) % newJoinFields.size();
            RelDataTypeField field = origOrder ? newJoinFields.get(source) : newJoinFields.get(i);
            exps.add(rexBuilder.makeInputRef(field.getType(), source));
        }
        return exps;
    }

    public static RexNode pushFilterPastProject(RexNode filter, ProjectRelBase projRel) {
        RexBuilder rexBuilder = projRel.getCluster().getRexBuilder();
        RexProgram bottomProgram = RexProgram.create(projRel.getChild().getRowType(), projRel.getProjects(), null, projRel.getRowType(), rexBuilder);
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(projRel.getRowType(), rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(filter);
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }

    public static <T extends RelNode> T addTrait(T rel, RelTrait trait) {
        return (T)rel.copy(rel.getTraitSet().replace(trait), rel.getInputs());
    }

    public static RelNode replaceInput(RelNode parent, int ordinal, RelNode newInput) {
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(parent.getInputs());
        if (inputs.get(ordinal) == newInput) {
            return parent;
        }
        inputs.set(ordinal, newInput);
        return parent.copy(parent.getTraitSet(), inputs);
    }

    public static ProjectRel project(RelNode child, Mappings.TargetMapping mapping) {
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        ArrayList<String> names = new ArrayList<String>();
        List<RelDataTypeField> fields = child.getRowType().getFieldList();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            int source = mapping.getSourceOpt(i);
            RelDataTypeField field = fields.get(source);
            nodes.add(new RexInputRef(source, field.getType()));
            names.add(field.getName());
        }
        return new ProjectRel(child.getCluster(), child, nodes, names, 1);
    }

    public static boolean contains(RelNode ancestor, final RelNode target) {
        if (ancestor == target) {
            return true;
        }
        try {
            new RelVisitor(){

                public void visit(RelNode node, int ordinal, RelNode parent) {
                    if (node == target) {
                        throw Util.FoundOne.NULL;
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(ancestor);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static RelNode replace(RelNode query, RelNode find, RelNode replace) {
        if (find == replace) {
            return query;
        }
        assert (RelOptUtil.equalType("find", find, "replace", replace, true));
        if (query == find) {
            return replace;
        }
        return RelOptUtil.replaceRecurse(query, find, replace);
    }

    private static RelNode replaceRecurse(RelNode query, RelNode find, RelNode replace) {
        if (query == find) {
            return replace;
        }
        List<RelNode> inputs = query.getInputs();
        if (!inputs.isEmpty()) {
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : inputs) {
                newInputs.add(RelOptUtil.replaceRecurse(input, find, replace));
            }
            if (!newInputs.equals(inputs)) {
                return query.copy(query.getTraitSet(), newInputs);
            }
        }
        return query;
    }

    public static RelOptTable.ToRelContext getContext(final RelOptCluster cluster) {
        return new RelOptTable.ToRelContext(){

            @Override
            public RelOptCluster getCluster() {
                return cluster;
            }

            @Override
            public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int countJoins(RelNode rootRel) {
        class JoinCounter
        extends RelVisitor {
            int joinCount;

            JoinCounter() {
            }

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof JoinRelBase) {
                    ++this.joinCount;
                }
                super.visit(node, ordinal, parent);
            }

            int run(RelNode node) {
                this.go(node);
                return this.joinCount;
            }
        }
        return new JoinCounter().run(rootRel);
    }

    public static RelNode pushExpInEqualJoinCondIntoProj(RelOptCluster cluster, RexNode joinCond, JoinRelType joinType, RelNode leftRel, RelNode rightRel) {
        List<RelDataTypeField> fields;
        final ArrayList<RexNode> extraLeftExprs = new ArrayList<RexNode>();
        final ArrayList<RexNode> extraRightExprs = new ArrayList<RexNode>();
        final int leftCount = leftRel.getRowType().getFieldCount();
        final int rightCount = rightRel.getRowType().getFieldCount();
        if (!RelOptUtil.containsGet(joinCond)) {
            joinCond = RelOptUtil.pushDownEqualJoinConditions(joinCond, leftCount, rightCount, extraLeftExprs, extraRightExprs);
        }
        if (!extraLeftExprs.isEmpty()) {
            fields = leftRel.getRowType().getFieldList();
            leftRel = CalcRel.createProject(leftRel, (List<Pair<RexNode, String>>)new AbstractList<Pair<RexNode, String>>(){

                @Override
                public int size() {
                    return leftCount + extraLeftExprs.size();
                }

                @Override
                public Pair<RexNode, String> get(int index) {
                    if (index < leftCount) {
                        RelDataTypeField field = (RelDataTypeField)fields.get(index);
                        return Pair.of(new RexInputRef(index, field.getType()), field.getName());
                    }
                    return Pair.of(extraLeftExprs.get(index - leftCount), null);
                }
            }, true);
        }
        if (!extraRightExprs.isEmpty()) {
            fields = rightRel.getRowType().getFieldList();
            final int newLeftCount = leftCount + extraLeftExprs.size();
            rightRel = CalcRel.createProject(rightRel, (List<Pair<RexNode, String>>)new AbstractList<Pair<RexNode, String>>(){

                @Override
                public int size() {
                    return rightCount + extraRightExprs.size();
                }

                @Override
                public Pair<RexNode, String> get(int index) {
                    if (index < rightCount) {
                        RelDataTypeField field = (RelDataTypeField)fields.get(index);
                        return Pair.of(new RexInputRef(index, field.getType()), field.getName());
                    }
                    return Pair.of(RexUtil.shift((RexNode)extraRightExprs.get(index - rightCount), -newLeftCount), null);
                }
            }, true);
        }
        JoinRel newJoin = new JoinRel(cluster, leftRel, rightRel, joinCond, joinType, ImmutableSet.<String>of());
        if (!extraLeftExprs.isEmpty() || !extraRightExprs.isEmpty()) {
            Mappings.TargetMapping mapping = Mappings.createShiftMapping(leftCount + extraLeftExprs.size() + rightCount + extraRightExprs.size(), 0, 0, leftCount, leftCount, leftCount + extraLeftExprs.size(), rightCount);
            return RelOptUtil.project(newJoin, mapping);
        }
        return newJoin;
    }

    private static boolean containsGet(RexNode node) {
        try {
            node.accept(new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            });
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    private static RexNode pushDownEqualJoinConditions(RexNode node, int leftCount, int rightCount, List<RexNode> extraLeftExprs, List<RexNode> extraRightExprs) {
        switch (node.getKind()) {
            case EQUALS: 
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<RexNode> list = new ArrayList<RexNode>();
                ArrayList<RexNode> operands = Lists.newArrayList(call.getOperands());
                for (int i = 0; i < operands.size(); ++i) {
                    RexNode operand = (RexNode)operands.get(i);
                    int left2 = leftCount + extraLeftExprs.size();
                    int right2 = rightCount + extraRightExprs.size();
                    RexNode e = RelOptUtil.pushDownEqualJoinConditions(operand, leftCount, rightCount, extraLeftExprs, extraRightExprs);
                    List<RexNode> remainingOperands = Util.skip(operands, i + 1);
                    int left3 = leftCount + extraLeftExprs.size();
                    int right3 = rightCount + extraRightExprs.size();
                    RelOptUtil.fix(remainingOperands, left2, left3);
                    RelOptUtil.fix(list, left2, left3);
                    list.add(e);
                }
                if (!list.equals(call.getOperands())) {
                    return call.clone(call.getType(), list);
                }
                return call;
            }
            case OR: 
            case INPUT_REF: 
            case LITERAL: {
                return node;
            }
        }
        BitSet bits = InputFinder.bits(node);
        int mid = leftCount + extraLeftExprs.size();
        switch (Side.of(bits, mid)) {
            case LEFT: {
                RelOptUtil.fix(extraRightExprs, mid, mid + 1);
                extraLeftExprs.add(node);
                return new RexInputRef(mid, node.getType());
            }
            case RIGHT: {
                int index2 = mid + rightCount + extraRightExprs.size();
                extraRightExprs.add(node);
                return new RexInputRef(index2, node.getType());
            }
        }
        return node;
    }

    private static void fix(List<RexNode> operands, int before, int after) {
        if (before == after) {
            return;
        }
        for (int i = 0; i < operands.size(); ++i) {
            RexNode node = operands.get(i);
            operands.set(i, RexUtil.shift(node, before, after - before));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RexInputConverter
    extends RexShuttle {
        protected final RexBuilder rexBuilder;
        private final List<RelDataTypeField> srcFields;
        protected final List<RelDataTypeField> destFields;
        private final List<RelDataTypeField> leftDestFields;
        private final List<RelDataTypeField> rightDestFields;
        private final int nLeftDestFields;
        private final int[] adjustments;

        private RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, List<RelDataTypeField> leftDestFields, List<RelDataTypeField> rightDestFields, int[] adjustments) {
            this.rexBuilder = rexBuilder;
            this.srcFields = srcFields;
            this.destFields = destFields;
            this.adjustments = adjustments;
            this.leftDestFields = leftDestFields;
            this.rightDestFields = rightDestFields;
            if (leftDestFields == null) {
                this.nLeftDestFields = 0;
            } else {
                assert (destFields == null);
                this.nLeftDestFields = leftDestFields.size();
            }
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, int[] adjustments) {
            this(rexBuilder, srcFields, destFields, null, null, adjustments);
        }

        @Override
        public RexNode visitInputRef(RexInputRef var) {
            int srcIndex = var.getIndex();
            int destIndex = srcIndex + this.adjustments[srcIndex];
            RelDataType type = this.destFields != null ? this.destFields.get(destIndex).getType() : (this.leftDestFields != null ? (destIndex < this.nLeftDestFields ? this.leftDestFields.get(destIndex).getType() : this.rightDestFields.get(destIndex - this.nLeftDestFields).getType()) : this.srcFields.get(srcIndex).getType());
            if (this.adjustments[srcIndex] != 0 || this.srcFields == null || type != this.srcFields.get(srcIndex).getType()) {
                return this.rexBuilder.makeInputRef(type, destIndex);
            }
            return var;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputFinder
    extends RexVisitorImpl<Void> {
        private final BitSet rexRefSet;
        private final Set<RelDataTypeField> extraFields;

        public InputFinder(BitSet rexRefSet) {
            this(rexRefSet, null);
        }

        public InputFinder(BitSet rexRefSet, Set<RelDataTypeField> extraFields) {
            super(true);
            this.rexRefSet = rexRefSet;
            this.extraFields = extraFields;
        }

        public static BitSet bits(RexNode node) {
            BitSet inputBitSet = new BitSet();
            node.accept(new InputFinder(inputBitSet));
            return inputBitSet;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.rexRefSet.set(inputRef.getIndex());
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                RexLiteral literal = (RexLiteral)call.getOperands().get(1);
                this.extraFields.add(new RelDataTypeFieldImpl((String)literal.getValue2(), -1, call.getType()));
            }
            return (Void)super.visitCall(call);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeDumper {
        private final String extraIndent = "  ";
        private String indent;
        private final PrintWriter pw;

        TypeDumper(PrintWriter pw) {
            this.pw = pw;
            this.indent = "";
        }

        void accept(RelDataType type) {
            if (type.isStruct()) {
                List<RelDataTypeField> fields = type.getFieldList();
                this.pw.println("RECORD (");
                String prevIndent = this.indent;
                this.indent = this.indent + "  ";
                this.acceptFields(fields);
                this.indent = prevIndent;
                this.pw.print(")");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else if (type instanceof MultisetSqlType) {
                this.accept(type.getComponentType());
                this.pw.print(" MULTISET");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else {
                this.pw.print(type.getFullTypeString());
            }
        }

        private void acceptFields(List<RelDataTypeField> fields) {
            for (int i = 0; i < fields.size(); ++i) {
                RelDataTypeField field = fields.get(i);
                if (i > 0) {
                    this.pw.println(",");
                }
                this.pw.print(this.indent);
                this.pw.print(field.getName());
                this.pw.print(" ");
                this.accept(field.getType());
            }
        }
    }

    public static class VariableUsedVisitor
    extends RexShuttle {
        public final Set<String> variables = new LinkedHashSet<String>();

        public RexNode visitCorrelVariable(RexCorrelVariable p) {
            this.variables.add(p.getName());
            return p;
        }
    }

    private static class VariableSetVisitor
    extends RelVisitor {
        final Set<String> variables = new HashSet<String>();

        private VariableSetVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            p.collectVariablesUsed(this.variables);
            this.variables.removeAll(p.getVariablesStopped());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Side {
        LEFT,
        RIGHT,
        BOTH,
        EMPTY;


        static Side of(BitSet bitSet, int middle) {
            int firstBit = bitSet.nextSetBit(0);
            if (firstBit < 0) {
                return EMPTY;
            }
            if (firstBit >= middle) {
                return RIGHT;
            }
            if (bitSet.nextSetBit(middle) < 0) {
                return LEFT;
            }
            return BOTH;
        }
    }
}

