/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;

public class FilterToCalcRule
extends RelOptRule {
    public static final FilterToCalcRule INSTANCE = new FilterToCalcRule();

    private FilterToCalcRule() {
        super(FilterToCalcRule.operand(FilterRel.class, FilterToCalcRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel filter = (FilterRel)call.rel(0);
        RelNode rel = filter.getChild();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelDataType inputRowType = rel.getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(filter.getCondition());
        RexProgram program = programBuilder.getProgram();
        CalcRel calc = new CalcRel(filter.getCluster(), filter.getTraitSet(), rel, inputRowType, program, ImmutableList.<RelCollation>of());
        call.transformTo(calc);
    }
}

