/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValuesRelBase
extends AbstractRelNode {
    private static final Function1<List<RexLiteral>, Object> F = new Function1<List<RexLiteral>, Object>(){

        @Override
        public Object apply(List<RexLiteral> tuple) {
            String s = tuple.toString();
            assert (s.startsWith("["));
            assert (s.endsWith("]"));
            return "{ " + s.substring(1, s.length() - 1) + " }";
        }
    };
    protected final List<List<RexLiteral>> tuples;

    protected ValuesRelBase(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, traits);
        this.rowType = rowType;
        this.tuples = tuples;
        assert (this.assertRowType());
    }

    public List<List<RexLiteral>> getTuples() {
        return this.tuples;
    }

    private boolean assertRowType() {
        for (List<RexLiteral> tuple : this.tuples) {
            assert (tuple.size() == this.rowType.getFieldCount());
            for (Pair<RexLiteral, RelDataTypeField> pair : Pair.zip(tuple, this.rowType.getFieldList())) {
                RexLiteral literal = (RexLiteral)pair.left;
                RelDataType fieldType = ((RelDataTypeField)pair.right).getType();
                if (!RexLiteral.isNullLiteral(literal)) assert (SqlTypeUtil.canAssignFrom(fieldType, literal.getType())) : "to " + fieldType + " from " + literal;
            }
        }
        return true;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public double getRows() {
        return this.tuples.size();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("type", this.rowType, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("type", this.rowType.getFieldList(), pw.nest()).itemIf("tuples", Functions.adapt(this.tuples, F), !pw.nest()).itemIf("tuples", this.tuples, pw.nest());
    }
}

