/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncollectRel
extends SingleRel {
    public UncollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child) {
        super(cluster, traitSet, child);
        assert (this.deriveRowType() != null) : "invalid child rowtype";
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, UncollectRel.sole(inputs));
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new UncollectRel(this.getCluster(), traitSet, input);
    }

    @Override
    protected RelDataType deriveRowType() {
        return UncollectRel.deriveUncollectRowType(this.getChild());
    }

    public static RelDataType deriveUncollectRowType(RelNode rel) {
        RelDataType inputType = rel.getRowType();
        assert (inputType.isStruct()) : inputType + " is not a struct";
        List<RelDataTypeField> fields = inputType.getFieldList();
        assert (1 == fields.size()) : "expected 1 field";
        RelDataType ret = fields.get(0).getType().getComponentType();
        assert (null != ret);
        if (!ret.isStruct()) {
            ret = rel.getCluster().getTypeFactory().builder().add(SqlUtil.deriveAliasFromOrdinal(0), ret).build();
        }
        return ret;
    }
}

