/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableFunctionRelBase
extends AbstractRelNode {
    private final RexNode rexCall;
    private final Type elementType;
    private ImmutableList<RelNode> inputs;
    protected final ImmutableSet<RelColumnMapping> columnMappings;

    protected TableFunctionRelBase(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, RexNode rexCall, Type elementType, RelDataType rowType, Set<RelColumnMapping> columnMappings) {
        super(cluster, traits);
        this.rexCall = rexCall;
        this.elementType = elementType;
        this.rowType = rowType;
        this.inputs = ImmutableList.copyOf(inputs);
        this.columnMappings = columnMappings == null ? null : ImmutableSet.copyOf(columnMappings);
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of(this.rexCall);
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = ImmutableList.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public double getRows() {
        if (this.inputs.size() == 0) {
            return super.getRows();
        }
        double nRows = 0.0;
        for (RelNode input : this.inputs) {
            Double d = RelMetadataQuery.getRowCount(input);
            if (d == null) continue;
            nRows += d.doubleValue();
        }
        return nRows;
    }

    public RexNode getCall() {
        return this.rexCall;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        pw.item("invocation", this.rexCall).item("rowType", this.rowType);
        if (this.elementType != null) {
            pw.item("elementType", this.elementType);
        }
        return pw;
    }

    public Set<RelColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    public Type getElementType() {
        return this.elementType;
    }
}

