/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexChecker;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectRelBase
extends SingleRel {
    protected final ImmutableList<RexNode> exps;
    protected int flags;
    protected final ImmutableList<RelCollation> collationList;

    protected ProjectRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traits, child);
        assert (rowType != null);
        this.exps = ImmutableList.copyOf(exps);
        this.rowType = rowType;
        this.flags = flags;
        RelCollation collation = traits.getTrait(RelCollationTraitDef.INSTANCE);
        ImmutableList<Object> immutableList = this.collationList = collation == null ? ImmutableList.of() : ImmutableList.of(collation);
        assert (this.isValid(true));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, ProjectRelBase.sole(inputs), this.exps, this.rowType);
    }

    public abstract ProjectRelBase copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, RelDataType var4);

    @Override
    public List<RelCollation> getCollationList() {
        return this.collationList;
    }

    public boolean isBoxed() {
        return (this.flags & 1) == 1;
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.exps;
    }

    public List<RexNode> getProjects() {
        return this.exps;
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isValid(boolean fail) {
        if (!super.isValid(fail)) {
            assert (!fail);
            return false;
        }
        if (!RexUtil.compatibleTypes(this.exps, this.getRowType(), true)) {
            assert (!fail);
            return false;
        }
        RexChecker checker = new RexChecker(this.getChild().getRowType(), fail);
        for (RexNode exp : this.exps) {
            exp.accept(checker);
        }
        if (checker.getFailureCount() > 0) {
            assert (!fail);
            return false;
        }
        if (!this.isBoxed() && this.exps.size() != 1) {
            assert (!fail);
            return false;
        }
        if (this.collationList == null) {
            assert (!fail);
            return false;
        }
        if (!this.collationList.isEmpty() && this.collationList.get(0) != this.traitSet.getTrait(RelCollationTraitDef.INSTANCE)) {
            assert (!fail);
            return false;
        }
        if (!Util.isDistinct(this.rowType.getFieldNames())) {
            assert (!fail) : this.rowType;
            return false;
        }
        return true;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", this.exps);
        } else {
            for (Ord<RelDataTypeField> field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, this.exps.get(field.i));
            }
        }
        if (pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES) {
            // empty if block
        }
        return pw;
    }
}

