/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CorrelatorRel
extends JoinRelBase {
    protected final ImmutableList<Correlation> correlations;

    public CorrelatorRel(RelOptCluster cluster, RelNode left, RelNode right, RexNode joinCond, List<Correlation> correlations, JoinRelType joinType) {
        super(cluster, cluster.traitSetOf(Convention.NONE), left, right, joinCond, joinType, ImmutableSet.<String>of());
        this.correlations = ImmutableList.copyOf(correlations);
        assert (joinType == JoinRelType.LEFT || joinType == JoinRelType.INNER);
    }

    public CorrelatorRel(RelOptCluster cluster, RelNode left, RelNode right, List<Correlation> correlations, JoinRelType joinType) {
        this(cluster, left, right, cluster.getRexBuilder().makeLiteral(true), correlations, joinType);
    }

    @Override
    public CorrelatorRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new CorrelatorRel(this.getCluster(), left, right, this.correlations, this.joinType);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlations", this.correlations);
    }

    public List<Correlation> getCorrelations() {
        return this.correlations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Correlation
    implements Cloneable,
    Comparable<Correlation> {
        private final int id;
        private final int offset;

        public Correlation(int id, int offset) {
            this.id = id;
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "var" + this.id + "=offset" + this.offset;
        }

        @Override
        public int compareTo(Correlation other) {
            return this.id - other.id;
        }
    }
}

