/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectRel
extends SingleRel {
    protected final String fieldName;

    public CollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, String fieldName) {
        super(cluster, traitSet, child);
        this.fieldName = fieldName;
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, CollectRel.sole(inputs));
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new CollectRel(this.getCluster(), traitSet, input, this.fieldName);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("field", this.fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected RelDataType deriveRowType() {
        return CollectRel.deriveCollectRowType(this, this.fieldName);
    }

    public static RelDataType deriveCollectRowType(SingleRel rel, String fieldName) {
        RelDataType childType = rel.getChild().getRowType();
        assert (childType.isStruct());
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType ret = SqlTypeUtil.createMultisetType(typeFactory, childType, false);
        ret = typeFactory.builder().add(fieldName, ret).build();
        return typeFactory.createTypeWithNullability(ret, false);
    }
}

