/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalcRelBase
extends SingleRel {
    protected final RexProgram program;
    private final ImmutableList<RelCollation> collationList;

    protected CalcRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, RexProgram program, List<RelCollation> collationList) {
        super(cluster, traits, child);
        this.rowType = rowType;
        this.program = program;
        this.collationList = ImmutableList.copyOf(collationList);
        assert (this.isValid(true));
    }

    @Override
    public final CalcRelBase copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, CalcRelBase.sole(inputs), this.program, this.collationList);
    }

    public abstract CalcRelBase copy(RelTraitSet var1, RelNode var2, RexProgram var3, List<RelCollation> var4);

    @Override
    public boolean isValid(boolean fail) {
        if (!RelOptUtil.equal("program's input type", this.program.getInputRowType(), "child's output type", this.getChild().getRowType(), fail)) {
            return false;
        }
        if (!RelOptUtil.equal("rowtype of program", this.program.getOutputRowType(), "declared rowtype of rel", this.rowType, fail)) {
            return false;
        }
        if (!this.program.isValid(fail)) {
            return false;
        }
        if (!this.program.isNormalized(fail, this.getCluster().getRexBuilder())) {
            return false;
        }
        return RelCollationImpl.isValid(this.getRowType(), this.collationList, fail);
    }

    public RexProgram getProgram() {
        return this.program;
    }

    @Override
    public double getRows() {
        return FilterRel.estimateFilteredRows(this.getChild(), this.program);
    }

    @Override
    public List<RelCollation> getCollationList() {
        return this.collationList;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.program.explainCalc(super.explainTerms(pw));
    }
}

