/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import java.util.Set;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CalcRel
extends CalcRelBase {
    public CalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, RexProgram program, List<RelCollation> collationList) {
        super(cluster, traits, child, rowType, program, collationList);
    }

    @Override
    public CalcRelBase copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        return new CalcRel(this.getCluster(), traitSet, child, program.getOutputRowType(), program, collationList);
    }

    public static RelNode createProject(RelNode child, List<RexNode> exprList, List<String> fieldNameList) {
        return CalcRel.createProject(child, exprList, fieldNameList, false);
    }

    public static RelNode createProject(RelNode child, List<Pair<RexNode, String>> projectList, boolean optimize) {
        return CalcRel.createProject(child, Pair.left(projectList), Pair.right(projectList), optimize);
    }

    public static RelNode createProject(RelNode child, List<Integer> posList) {
        return RelFactories.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, child, posList);
    }

    public static RelNode createProject(RelNode child, List<RexNode> exprs, List<String> fieldNames, boolean optimize) {
        RelOptCluster cluster = child.getCluster();
        RexProgram program = RexProgram.create(child.getRowType(), exprs, null, fieldNames, cluster.getRexBuilder());
        List<RelCollation> collationList = program.getCollations(child.getCollationList());
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), exprs, fieldNames == null ? null : SqlValidatorUtil.uniquify(fieldNames, SqlValidatorUtil.F_SUGGESTER));
        if (optimize && RemoveTrivialProjectRule.isIdentity(exprs, rowType, child.getRowType())) {
            return child;
        }
        return new ProjectRel(cluster, cluster.traitSetOf(collationList.isEmpty() ? RelCollationImpl.EMPTY : collationList.get(0)), child, exprs, rowType, 1);
    }

    public static RelNode createFilter(RelNode child, RexNode condition) {
        return new FilterRel(child.getCluster(), child, condition);
    }

    @Override
    public void collectVariablesUsed(Set<String> variableSet) {
        RelOptUtil.VariableUsedVisitor vuv = new RelOptUtil.VariableUsedVisitor();
        for (RexNode expr : this.program.getExprList()) {
            expr.accept(vuv);
        }
        variableSet.addAll(vuv.variables);
    }
}

