/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.resource.Resources;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.CompositeList;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateRelBase
extends SingleRel {
    protected final List<AggregateCall> aggCalls;
    protected final BitSet groupSet;

    protected AggregateRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) {
        super(cluster, traits, child);
        assert (aggCalls != null);
        this.aggCalls = ImmutableList.copyOf(aggCalls);
        this.groupSet = groupSet;
        assert (groupSet != null);
        assert (groupSet.isEmpty() == (groupSet.cardinality() == 0)) : "See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6222207";
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, AggregateRelBase.sole(inputs), this.groupSet, this.aggCalls);
    }

    public abstract AggregateRelBase copy(RelTraitSet var1, RelNode var2, BitSet var3, List<AggregateCall> var4);

    @Override
    public boolean isDistinct() {
        return true;
    }

    public List<AggregateCall> getAggCallList() {
        return this.aggCalls;
    }

    public int getGroupCount() {
        return this.groupSet.cardinality();
    }

    public BitSet getGroupSet() {
        return this.groupSet;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw).item("group", this.groupSet).itemIf("aggs", this.aggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord<AggregateCall> ord : Ord.zip(this.aggCalls)) {
                pw.item(Util.first(((AggregateCall)ord.e).name, "agg#" + ord.i), ord.e);
            }
        }
        return pw;
    }

    @Override
    public double getRows() {
        int groupCount = this.groupSet.cardinality();
        if (groupCount == 0) {
            return 1.0;
        }
        double rowCount = super.getRows();
        return rowCount *= 1.0 - Math.pow(0.5, groupCount);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createStructType(CompositeList.of(new AbstractList<RelDataTypeField>(){

            @Override
            public int size() {
                return AggregateRelBase.this.groupSet.cardinality();
            }

            @Override
            public RelDataTypeField get(int index) {
                return AggregateRelBase.this.getChild().getRowType().getFieldList().get((Integer)BitSets.toList(AggregateRelBase.this.groupSet).get(index));
            }
        }, new AbstractList<RelDataTypeField>(){

            @Override
            public int size() {
                return AggregateRelBase.this.aggCalls.size();
            }

            @Override
            public RelDataTypeField get(int index) {
                AggregateCall aggCall = AggregateRelBase.this.aggCalls.get(index);
                String name = aggCall.name != null ? aggCall.name : "$f" + (AggregateRelBase.this.groupSet.cardinality() + index);
                assert (AggregateRelBase.this.typeMatchesInferred(aggCall, true));
                return new RelDataTypeFieldImpl(name, index, aggCall.type);
            }
        }));
    }

    private boolean typeMatchesInferred(AggregateCall aggCall, boolean fail) {
        SqlAggFunction aggFunction = (SqlAggFunction)aggCall.getAggregation();
        AggCallBinding callBinding = aggCall.createBinding(this);
        RelDataType type = aggFunction.inferReturnType(callBinding);
        RelDataType expectedType = aggCall.type;
        return RelOptUtil.eq("aggCall type", expectedType, "inferred type", type, fail);
    }

    public boolean containsDistinctCall() {
        for (AggregateCall call : this.aggCalls) {
            if (!call.isDistinct()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AggCallBinding
    extends SqlOperatorBinding {
        private final List<RelDataType> operands;
        private final int groupCount;

        public AggCallBinding(RelDataTypeFactory typeFactory, SqlAggFunction aggFunction, List<RelDataType> operands, int groupCount) {
            super(typeFactory, aggFunction);
            this.operands = operands;
            this.groupCount = groupCount;
            assert (operands != null) : "operands of aggregate call should not be null";
            assert (groupCount >= 0) : "number of group by columns should be greater than zero in aggregate call. Got " + groupCount;
        }

        @Override
        public int getGroupCount() {
            return this.groupCount;
        }

        @Override
        public int getOperandCount() {
            return this.operands.size();
        }

        @Override
        public RelDataType getOperandType(int ordinal) {
            return this.operands.get(ordinal);
        }

        @Override
        public EigenbaseException newError(Resources.ExInst e) {
            return SqlUtil.newContextException(SqlParserPos.ZERO, e);
        }
    }
}

