/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.JaninoRuntimeException;

public class ClassFile {
    private short majorVersion = (short)45;
    private short minorVersion = (short)3;
    public List constantPool = new ArrayList();
    public short accessFlags;
    public short thisClass;
    public short superclass;
    public short[] interfaces;
    public List fieldInfos;
    public List methodInfos;
    private List attributes;
    private Map constantPoolMap;

    public ClassFile(short accessFlags, String thisClassFD, String superclassFD, String[] interfaceFDs) {
        this.constantPool.add(null);
        this.constantPoolMap = new HashMap();
        this.accessFlags = accessFlags;
        this.thisClass = this.addConstantClassInfo(thisClassFD);
        this.superclass = this.addConstantClassInfo(superclassFD);
        this.interfaces = new short[interfaceFDs.length];
        for (int i = 0; i < interfaceFDs.length; ++i) {
            this.interfaces[i] = this.addConstantClassInfo(interfaceFDs[i]);
        }
        this.fieldInfos = new ArrayList();
        this.methodInfos = new ArrayList();
        this.attributes = new ArrayList();
    }

    public void addSourceFileAttribute(String sourceFileName) {
        this.attributes.add(new SourceFileAttribute(this.addConstantUtf8Info("SourceFile"), this.addConstantUtf8Info(sourceFileName)));
    }

    public void addDeprecatedAttribute() {
        this.attributes.add(new DeprecatedAttribute(this.addConstantUtf8Info("Deprecated")));
    }

    public InnerClassesAttribute getInnerClassesAttribute() {
        Short ni = (Short)this.constantPoolMap.get(new ConstantUtf8Info("InnerClasses"));
        if (ni == null) {
            return null;
        }
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            AttributeInfo ai = (AttributeInfo)it.next();
            if (ai.nameIndex != ni || !(ai instanceof InnerClassesAttribute)) continue;
            return (InnerClassesAttribute)ai;
        }
        return null;
    }

    public void addInnerClassesAttributeEntry(InnerClassesAttribute.Entry e) {
        InnerClassesAttribute ica = this.getInnerClassesAttribute();
        if (ica == null) {
            ica = new InnerClassesAttribute(this.addConstantUtf8Info("InnerClasses"));
            this.attributes.add(ica);
        }
        ica.getEntries().add(e);
    }

    public String getThisClassName() {
        return this.getConstantClassName(this.thisClass).replace('/', '.');
    }

    public short addConstantClassInfo(String typeFD) {
        String s;
        if (Descriptor.isClassOrInterfaceReference(typeFD)) {
            s = Descriptor.toInternalForm(typeFD);
        } else if (Descriptor.isArrayReference(typeFD)) {
            s = typeFD;
        } else {
            throw new JaninoRuntimeException("\"" + Descriptor.toString(typeFD) + "\" is neither a class nor an array");
        }
        return this.addToConstantPool(new ConstantClassInfo(this.addConstantUtf8Info(s)));
    }

    public short addConstantFieldrefInfo(String classFD, String fieldName, String fieldFD) {
        return this.addToConstantPool(new ConstantFieldrefInfo(this.addConstantClassInfo(classFD), this.addConstantNameAndTypeInfo(fieldName, fieldFD)));
    }

    public short addConstantMethodrefInfo(String classFD, String methodName, String methodMD) {
        return this.addToConstantPool(new ConstantMethodrefInfo(this.addConstantClassInfo(classFD), this.addConstantNameAndTypeInfo(methodName, methodMD)));
    }

    public short addConstantInterfaceMethodrefInfo(String classFD, String methodName, String methodMD) {
        return this.addToConstantPool(new ConstantInterfaceMethodrefInfo(this.addConstantClassInfo(classFD), this.addConstantNameAndTypeInfo(methodName, methodMD)));
    }

    public short addConstantStringInfo(String string) {
        return this.addToConstantPool(new ConstantStringInfo(this.addConstantUtf8Info(string)));
    }

    public short addConstantIntegerInfo(int value) {
        return this.addToConstantPool(new ConstantIntegerInfo(value));
    }

    public short addConstantFloatInfo(float value) {
        return this.addToConstantPool(new ConstantFloatInfo(value));
    }

    public short addConstantLongInfo(long value) {
        return this.addToConstantPool(new ConstantLongInfo(value));
    }

    public short addConstantDoubleInfo(double value) {
        return this.addToConstantPool(new ConstantDoubleInfo(value));
    }

    private short addConstantNameAndTypeInfo(String name, String descriptor) {
        return this.addToConstantPool(new ConstantNameAndTypeInfo(this.addConstantUtf8Info(name), this.addConstantUtf8Info(descriptor)));
    }

    public short addConstantUtf8Info(String s) {
        return this.addToConstantPool(new ConstantUtf8Info(s));
    }

    private short addConstantSIFLDInfo(Object cv) {
        if (cv instanceof String) {
            return this.addConstantStringInfo((String)cv);
        }
        if (cv instanceof Byte || cv instanceof Short || cv instanceof Integer) {
            return this.addConstantIntegerInfo(((Number)cv).intValue());
        }
        if (cv instanceof Boolean) {
            return this.addConstantIntegerInfo((Boolean)cv != false ? 1 : 0);
        }
        if (cv instanceof Character) {
            return this.addConstantIntegerInfo(((Character)cv).charValue());
        }
        if (cv instanceof Float) {
            return this.addConstantFloatInfo(((Float)cv).floatValue());
        }
        if (cv instanceof Long) {
            return this.addConstantLongInfo((Long)cv);
        }
        if (cv instanceof Double) {
            return this.addConstantDoubleInfo((Double)cv);
        }
        throw new JaninoRuntimeException("Unexpected constant value type \"" + cv.getClass().getName() + "\"");
    }

    private short addToConstantPool(ConstantPoolInfo cpi) {
        Short index = (Short)this.constantPoolMap.get(cpi);
        if (index != null) {
            return index;
        }
        int res = this.constantPool.size();
        if (res > 65535) {
            throw new JaninoRuntimeException("Constant pool has grown past JVM limit of 0xFFFF");
        }
        this.constantPool.add(cpi);
        if (cpi.isWide()) {
            this.constantPool.add(null);
        }
        this.constantPoolMap.put(cpi, new Short((short)res));
        return (short)res;
    }

    public FieldInfo addFieldInfo(short accessFlags, String fieldName, String fieldTypeFD, Object optionalConstantValue) {
        ArrayList<ConstantValueAttribute> attributes = new ArrayList<ConstantValueAttribute>();
        if (optionalConstantValue != null) {
            attributes.add(new ConstantValueAttribute(this.addConstantUtf8Info("ConstantValue"), this.addConstantSIFLDInfo(optionalConstantValue)));
        }
        FieldInfo fi = new FieldInfo(accessFlags, this.addConstantUtf8Info(fieldName), this.addConstantUtf8Info(fieldTypeFD), attributes);
        this.fieldInfos.add(fi);
        return fi;
    }

    public MethodInfo addMethodInfo(short accessFlags, String methodName, String methodMD) {
        MethodInfo mi = new MethodInfo(accessFlags, this.addConstantUtf8Info(methodName), this.addConstantUtf8Info(methodMD), new ArrayList());
        this.methodInfos.add(mi);
        return mi;
    }

    public ConstantPoolInfo getConstantPoolInfo(short index) {
        return (ConstantPoolInfo)this.constantPool.get(0xFFFF & index);
    }

    public String getConstantClassName(short index) {
        ConstantClassInfo cci = (ConstantClassInfo)this.getConstantPoolInfo(index);
        ConstantUtf8Info cui = (ConstantUtf8Info)this.getConstantPoolInfo(cci.nameIndex);
        return cui.s;
    }

    public void store(OutputStream os) throws IOException {
        DataOutputStream dos = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        dos.writeInt(-889275714);
        dos.writeShort(this.minorVersion);
        dos.writeShort(this.majorVersion);
        ClassFile.storeConstantPool(dos, this.constantPool);
        dos.writeShort(this.accessFlags);
        dos.writeShort(this.thisClass);
        dos.writeShort(this.superclass);
        ClassFile.storeShortArray(dos, this.interfaces);
        ClassFile.storeFields(dos, this.fieldInfos);
        ClassFile.storeMethods(dos, this.methodInfos);
        ClassFile.storeAttributes(dos, this.attributes);
    }

    private static void storeConstantPool(DataOutputStream dos, List constantPool) throws IOException {
        dos.writeShort(constantPool.size());
        for (int i = 1; i < constantPool.size(); ++i) {
            ConstantPoolInfo cpi = (ConstantPoolInfo)constantPool.get(i);
            if (cpi == null) continue;
            cpi.store(dos);
        }
    }

    private static void storeShortArray(DataOutputStream dos, short[] sa) throws IOException {
        dos.writeShort(sa.length);
        for (int i = 0; i < sa.length; ++i) {
            dos.writeShort(sa[i]);
        }
    }

    private static void storeFields(DataOutputStream dos, List fieldInfos) throws IOException {
        dos.writeShort(fieldInfos.size());
        for (int i = 0; i < fieldInfos.size(); ++i) {
            ((FieldInfo)fieldInfos.get(i)).store(dos);
        }
    }

    private static void storeMethods(DataOutputStream dos, List methodInfos) throws IOException {
        dos.writeShort(methodInfos.size());
        for (int i = 0; i < methodInfos.size(); ++i) {
            ((MethodInfo)methodInfos.get(i)).store(dos);
        }
    }

    private static void storeAttributes(DataOutputStream dos, List attributeInfos) throws IOException {
        dos.writeShort(attributeInfos.size());
        for (int i = 0; i < attributeInfos.size(); ++i) {
            ((AttributeInfo)attributeInfos.get(i)).store(dos);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.store(baos);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException(ex.toString());
        }
        return baos.toByteArray();
    }

    public static class DeprecatedAttribute
    extends AttributeInfo {
        public DeprecatedAttribute(short attributeNameIndex) {
            super(attributeNameIndex);
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
        }
    }

    public static class LocalVariableTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        public LocalVariableTableAttribute(short attributeNameIndex, Entry[] entries) {
            super(attributeNameIndex);
            this.entries = entries;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.length);
            for (int i = 0; i < this.entries.length; ++i) {
                Entry lnte = this.entries[i];
                dos.writeShort(lnte.startPC);
                dos.writeShort(lnte.length);
                dos.writeShort(lnte.nameIndex);
                dos.writeShort(lnte.descriptorIndex);
                dos.writeShort(lnte.index);
            }
        }

        public static class Entry {
            public final short startPC;
            public final short length;
            public final short nameIndex;
            public final short descriptorIndex;
            public final short index;

            public Entry(short startPC, short length, short nameIndex, short descriptorIndex, short index) {
                this.startPC = startPC;
                this.length = length;
                this.nameIndex = nameIndex;
                this.descriptorIndex = descriptorIndex;
                this.index = index;
            }
        }
    }

    public static class LineNumberTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        public LineNumberTableAttribute(short attributeNameIndex, Entry[] entries) {
            super(attributeNameIndex);
            this.entries = entries;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.length);
            for (int i = 0; i < this.entries.length; ++i) {
                dos.writeShort(this.entries[i].startPC);
                dos.writeShort(this.entries[i].lineNumber);
            }
        }

        public static class Entry {
            public final int startPC;
            public final int lineNumber;

            public Entry(int startPC, int lineNumber) {
                this.startPC = startPC;
                this.lineNumber = lineNumber;
            }
        }
    }

    public static class SourceFileAttribute
    extends AttributeInfo {
        private final short sourceFileIndex;

        public SourceFileAttribute(short attributeNameIndex, short sourceFileIndex) {
            super(attributeNameIndex);
            this.sourceFileIndex = sourceFileIndex;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.sourceFileIndex);
        }
    }

    public static class InnerClassesAttribute
    extends AttributeInfo {
        private final List entries = new ArrayList();

        InnerClassesAttribute(short attributeNameIndex) {
            super(attributeNameIndex);
        }

        public List getEntries() {
            return this.entries;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.size());
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                Entry e = (Entry)it.next();
                dos.writeShort(e.innerClassInfoIndex);
                dos.writeShort(e.outerClassInfoIndex);
                dos.writeShort(e.innerNameIndex);
                dos.writeShort(e.innerClassAccessFlags);
            }
        }

        public static class Entry {
            public final short innerClassInfoIndex;
            public final short outerClassInfoIndex;
            public final short innerNameIndex;
            public final short innerClassAccessFlags;

            public Entry(short innerClassInfoIndex, short outerClassInfoIndex, short innerNameIndex, short innerClassAccessFlags) {
                this.innerClassInfoIndex = innerClassInfoIndex;
                this.outerClassInfoIndex = outerClassInfoIndex;
                this.innerNameIndex = innerNameIndex;
                this.innerClassAccessFlags = innerClassAccessFlags;
            }
        }
    }

    public static class ExceptionsAttribute
    extends AttributeInfo {
        private final short[] exceptionIndexes;

        public ExceptionsAttribute(short attributeNameIndex, short[] exceptionIndexes) {
            super(attributeNameIndex);
            this.exceptionIndexes = exceptionIndexes;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            ClassFile.storeShortArray(dos, this.exceptionIndexes);
        }
    }

    public static class ConstantValueAttribute
    extends AttributeInfo {
        private final short constantValueIndex;

        ConstantValueAttribute(short attributeNameIndex, short constantValueIndex) {
            super(attributeNameIndex);
            this.constantValueIndex = constantValueIndex;
        }

        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.constantValueIndex);
        }
    }

    public static abstract class AttributeInfo {
        private final short nameIndex;

        public AttributeInfo(short nameIndex) {
            this.nameIndex = nameIndex;
        }

        public void store(DataOutputStream dos) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.storeBody(new DataOutputStream(baos));
            dos.writeShort(this.nameIndex);
            dos.writeInt(baos.size());
            baos.writeTo(dos);
        }

        protected abstract void storeBody(DataOutputStream var1) throws IOException;
    }

    public static class FieldInfo {
        private final short accessFlags;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List attributes;

        public FieldInfo(short accessFlags, short nameIndex, short descriptorIndex, List attributes) {
            this.accessFlags = accessFlags;
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.attributes = attributes;
        }

        public void addAttribute(AttributeInfo attribute) {
            this.attributes.add(attribute);
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeShort(this.accessFlags);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dos, this.attributes);
        }
    }

    public class MethodInfo {
        private final short accessFlags;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List attributes;

        public MethodInfo(short accessFlags, short nameIndex, short descriptorIndex, List attributes) {
            this.accessFlags = accessFlags;
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.attributes = attributes;
        }

        public ClassFile getClassFile() {
            return ClassFile.this;
        }

        public void addAttribute(AttributeInfo attribute) {
            this.attributes.add(attribute);
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeShort(this.accessFlags);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dos, this.attributes);
        }
    }

    public static class ConstantUtf8Info
    extends ConstantPoolInfo {
        private final String s;

        public ConstantUtf8Info(String s) {
            if (s == null) {
                throw new JaninoRuntimeException();
            }
            this.s = s;
        }

        public String getString() {
            return this.s;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(1);
            try {
                dos.writeUTF(this.s);
            }
            catch (UTFDataFormatException e) {
                throw new ClassFormatError("String constant too long to store in class file");
            }
        }

        public boolean equals(Object o) {
            return o instanceof ConstantUtf8Info && ((ConstantUtf8Info)o).s.equals(this.s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }
    }

    public static class ConstantNameAndTypeInfo
    extends ConstantPoolInfo {
        private final short nameIndex;
        private final short descriptorIndex;

        public ConstantNameAndTypeInfo(short nameIndex, short descriptorIndex) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(12);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantNameAndTypeInfo && ((ConstantNameAndTypeInfo)o).nameIndex == this.nameIndex && ((ConstantNameAndTypeInfo)o).descriptorIndex == this.descriptorIndex;
        }

        public int hashCode() {
            return this.nameIndex + (this.descriptorIndex << 16);
        }
    }

    private static class ConstantDoubleInfo
    extends ConstantValuePoolInfo {
        private final double value;

        public ConstantDoubleInfo(double value) {
            this.value = value;
        }

        public boolean isWide() {
            return true;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(6);
            dos.writeDouble(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantDoubleInfo && ((ConstantDoubleInfo)o).value == this.value;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.value);
            return (int)bits ^ (int)(bits >> 32);
        }
    }

    private static class ConstantLongInfo
    extends ConstantValuePoolInfo {
        private final long value;

        public ConstantLongInfo(long value) {
            this.value = value;
        }

        public boolean isWide() {
            return true;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(5);
            dos.writeLong(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantLongInfo && ((ConstantLongInfo)o).value == this.value;
        }

        public int hashCode() {
            return (int)this.value ^ (int)(this.value >> 32);
        }
    }

    private static class ConstantFloatInfo
    extends ConstantValuePoolInfo {
        private final float value;

        public ConstantFloatInfo(float value) {
            this.value = value;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(4);
            dos.writeFloat(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantFloatInfo && ((ConstantFloatInfo)o).value == this.value;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }
    }

    private static class ConstantIntegerInfo
    extends ConstantValuePoolInfo {
        private final int value;

        public ConstantIntegerInfo(int value) {
            this.value = value;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(3);
            dos.writeInt(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantIntegerInfo && ((ConstantIntegerInfo)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    static class ConstantStringInfo
    extends ConstantValuePoolInfo {
        private final short stringIndex;

        public ConstantStringInfo(short stringIndex) {
            this.stringIndex = stringIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(8);
            dos.writeShort(this.stringIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantStringInfo && ((ConstantStringInfo)o).stringIndex == this.stringIndex;
        }

        public int hashCode() {
            return this.stringIndex;
        }
    }

    public static class ConstantInterfaceMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantInterfaceMethodrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(11);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantInterfaceMethodrefInfo && ((ConstantInterfaceMethodrefInfo)o).classIndex == this.classIndex && ((ConstantInterfaceMethodrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantMethodrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(10);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantMethodrefInfo && ((ConstantMethodrefInfo)o).classIndex == this.classIndex && ((ConstantMethodrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantFieldrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantFieldrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(9);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantFieldrefInfo && ((ConstantFieldrefInfo)o).classIndex == this.classIndex && ((ConstantFieldrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantClassInfo
    extends ConstantPoolInfo {
        private final short nameIndex;

        public ConstantClassInfo(short nameIndex) {
            this.nameIndex = nameIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(7);
            dos.writeShort(this.nameIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantClassInfo && ((ConstantClassInfo)o).nameIndex == this.nameIndex;
        }

        public int hashCode() {
            return this.nameIndex;
        }
    }

    public static abstract class ConstantValuePoolInfo
    extends ConstantPoolInfo {
    }

    public static abstract class ConstantPoolInfo {
        public abstract void store(DataOutputStream var1) throws IOException;

        public abstract boolean isWide();
    }
}

