/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.Access;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;

public class UnitCompiler {
    private static final RuntimeException STOP_COMPILING_CODE = new RuntimeException("SNO: This exception should have been caught and processed");
    private final Map onDemandImportableTypes;
    private static final HashMap PRIMITIVE_WIDENING_CONVERSIONS = new HashMap();
    private static final HashMap PRIMITIVE_NARROWING_CONVERSIONS;
    private CodeContext codeContext;
    private ErrorHandler optionalCompileErrorHandler;
    private int compileErrorCount;
    private WarningHandler optionalWarningHandler;
    public final Java.CompilationUnit compilationUnit;
    private final IClassLoader iClassLoader;
    private final boolean isStringBuilderAvailable;
    private List generatedClassFiles;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    private final Map singleTypeImports;
    private final Collection typeImportsOnDemand;
    private final Map singleStaticImports;
    private final Collection staticImportsOnDemand;

    public UnitCompiler(Java.CompilationUnit compilationUnit, IClassLoader iClassLoader) throws CompileException {
        block8: {
            this.onDemandImportableTypes = new HashMap();
            this.codeContext = null;
            this.optionalCompileErrorHandler = null;
            this.compileErrorCount = 0;
            this.optionalWarningHandler = null;
            this.singleTypeImports = new HashMap();
            this.singleStaticImports = new HashMap();
            this.staticImportsOnDemand = new ArrayList();
            this.compilationUnit = compilationUnit;
            this.iClassLoader = iClassLoader;
            try {
                boolean allowStringBuilder = true;
                String targetVersion = System.getProperty("Janino.TargetVersion");
                if (targetVersion != null && Double.parseDouble(targetVersion) <= 1.4) {
                    allowStringBuilder = false;
                }
                if (iClassLoader.loadIClass("Ljava/lang/StringBuilder;") != null && allowStringBuilder) {
                    this.isStringBuilderAvailable = true;
                    break block8;
                }
                if (iClassLoader.loadIClass("Ljava/lang/StringBuffer;") != null) {
                    this.isStringBuilderAvailable = false;
                    break block8;
                }
                throw new JaninoRuntimeException("SNO: Could neither load \"StringBuffer\" nor \"StringBuilder\"");
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException("SNO: Error loading \"StringBuffer\" or \"StringBuilder\": " + ex.getMessage());
            }
        }
        this.typeImportsOnDemand = new ArrayList();
        this.typeImportsOnDemand.add(new String[]{"java", "lang"});
        Iterator it = this.compilationUnit.importDeclarations.iterator();
        while (it.hasNext()) {
            class UCE
            extends RuntimeException {
                final CompileException ce;

                UCE(CompileException ce) {
                    this.ce = ce;
                }
            }
            Java.CompilationUnit.ImportDeclaration id = (Java.CompilationUnit.ImportDeclaration)it.next();
            try {
                id.accept(new Visitor.ImportVisitor(){

                    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                        try {
                            UnitCompiler.this.import2(stid);
                        }
                        catch (CompileException e) {
                            throw new UCE(e);
                        }
                    }

                    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                        UnitCompiler.this.import2(tiodd);
                    }

                    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                    }

                    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                    }
                });
            }
            catch (UCE uce) {
                throw uce.ce;
            }
        }
    }

    private void import2(Java.CompilationUnit.SingleTypeImportDeclaration stid) throws CompileException {
        IClass iClass;
        Object[] ids = stid.identifiers;
        String name = UnitCompiler.last((String[])ids);
        Object[] prev = this.singleTypeImports.put(name, ids);
        if (prev != null && !Arrays.equals(prev, ids)) {
            this.compileError("Class \"" + name + "\" was previously imported as " + "\"" + Java.join(prev, ".") + "\", now as \"" + Java.join(ids, ".") + "\"", stid.getLocation());
        }
        if ((iClass = this.loadFullyQualifiedClass((String[])ids)) == null) {
            this.compileError("Imported class \"" + Java.join(ids, ".") + "\" could not be loaded", stid.getLocation());
        }
    }

    private void import2(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
        this.typeImportsOnDemand.add(tiodd.identifiers);
    }

    private void import2(Java.CompilationUnit.SingleStaticImportDeclaration ssid) throws CompileException {
        IClass iClass;
        String name = UnitCompiler.last(ssid.identifiers);
        ArrayList<Object> importedObjects = (ArrayList<Object>)this.singleStaticImports.get(name);
        if (importedObjects == null) {
            importedObjects = new ArrayList<Object>();
            this.singleStaticImports.put(name, importedObjects);
        }
        if ((iClass = this.loadFullyQualifiedClass(ssid.identifiers)) != null) {
            importedObjects.add(iClass);
            return;
        }
        Object[] typeName = UnitCompiler.allButLast(ssid.identifiers);
        IClass iClass2 = this.loadFullyQualifiedClass((String[])typeName);
        if (iClass2 == null) {
            this.compileError("Could not load \"" + Java.join(typeName, ".") + "\"", ssid.getLocation());
            return;
        }
        IClass.IField iField = iClass2.getDeclaredIField(name);
        if (iField != null) {
            if (!iField.isStatic()) {
                this.compileError("Field \"" + name + "\" of \"" + Java.join(typeName, ".") + "\" must be static", ssid.getLocation());
            }
            importedObjects.add(iField);
            return;
        }
        IClass.IMethod[] ms = iClass2.getDeclaredIMethods(name);
        if (ms.length > 0) {
            importedObjects.addAll(Arrays.asList(ms));
            return;
        }
        this.compileError("\"" + Java.join(typeName, ".") + "\" has no static member \"" + name + "\"", ssid.getLocation());
    }

    private void import2(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) throws CompileException {
        IClass iClass = this.loadFullyQualifiedClass(siodd.identifiers);
        if (iClass == null) {
            this.compileError("Could not load \"" + Java.join(siodd.identifiers, ".") + "\"", siodd.getLocation());
            return;
        }
        this.staticImportsOnDemand.add(iClass);
    }

    public ClassFile[] compileUnit(boolean debugSource, boolean debugLines, boolean debugVars) throws CompileException {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
        Iterator it = this.compilationUnit.importDeclarations.iterator();
        while (it.hasNext()) {
            class UCE
            extends RuntimeException {
                final CompileException ce;

                UCE(CompileException ce) {
                    this.ce = ce;
                }
            }
            Java.CompilationUnit.ImportDeclaration id = (Java.CompilationUnit.ImportDeclaration)it.next();
            try {
                id.accept(new Visitor.ImportVisitor(){

                    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                    }

                    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                    }

                    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                        try {
                            UnitCompiler.this.import2(ssid);
                        }
                        catch (CompileException e) {
                            throw new UCE(e);
                        }
                    }

                    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                        try {
                            UnitCompiler.this.import2(siodd);
                        }
                        catch (CompileException e) {
                            throw new UCE(e);
                        }
                    }
                });
            }
            catch (UCE uce) {
                throw uce.ce;
            }
        }
        this.generatedClassFiles = new ArrayList();
        it = this.compilationUnit.packageMemberTypeDeclarations.iterator();
        while (it.hasNext()) {
            this.compile((Java.PackageMemberTypeDeclaration)it.next());
        }
        if (this.compileErrorCount > 0) {
            throw new CompileException(this.compileErrorCount + " error(s) while compiling unit \"" + this.compilationUnit.optionalFileName + "\"", null);
        }
        List l = this.generatedClassFiles;
        return l.toArray(new ClassFile[l.size()]);
    }

    private void compile(Java.TypeDeclaration td) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        Visitor.TypeDeclarationVisitor tdv = new Visitor.TypeDeclarationVisitor(){

            public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration acd) {
                try {
                    UnitCompiler.this.compile2(acd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalClassDeclaration(Java.LocalClassDeclaration lcd) {
                try {
                    UnitCompiler.this.compile2(lcd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration pmcd) {
                try {
                    UnitCompiler.this.compile2(pmcd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration mid) {
                try {
                    UnitCompiler.this.compile2(mid);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration pmid) {
                try {
                    UnitCompiler.this.compile2(pmid);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitMemberClassDeclaration(Java.MemberClassDeclaration mcd) {
                try {
                    UnitCompiler.this.compile2(mcd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            td.accept(tdv);
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    public void compile2(Java.PackageMemberTypeDeclaration pmtd) throws CompileException {
        Java.PackageMemberTypeDeclaration otherPMTD;
        Java.CompilationUnit declaringCompilationUnit = pmtd.getDeclaringCompilationUnit();
        Object[] ss = this.getSingleTypeImport(pmtd.getName());
        if (ss != null) {
            this.compileError("Package member type declaration \"" + pmtd.getName() + "\" conflicts with single-type-import \"" + Java.join(ss, ".") + "\"", pmtd.getLocation());
        }
        if ((otherPMTD = declaringCompilationUnit.getPackageMemberTypeDeclaration(pmtd.getName())) != pmtd) {
            this.compileError("Redeclaration of type \"" + pmtd.getName() + "\", previously declared in " + otherPMTD.getLocation(), pmtd.getLocation());
        }
        if (pmtd instanceof Java.NamedClassDeclaration) {
            this.compile2((Java.NamedClassDeclaration)((Object)pmtd));
        } else if (pmtd instanceof Java.InterfaceDeclaration) {
            this.compile2((Java.InterfaceDeclaration)((Object)pmtd));
        } else {
            throw new JaninoRuntimeException("PMTD of unexpected type " + pmtd.getClass().getName());
        }
    }

    public void compile2(Java.ClassDeclaration cd) throws CompileException {
        IClass iClass = this.resolve(cd);
        if ((cd.getModifiers() & 0x400) == 0) {
            IClass.IMethod[] ms = iClass.getIMethods();
            for (int i = 0; i < ms.length; ++i) {
                IClass.IMethod override;
                IClass.IMethod base = ms[i];
                if (!base.isAbstract() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) != null && !override.isAbstract() && base.getReturnType().isAssignableFrom(override.getReturnType())) continue;
                this.compileError("Non-abstract class \"" + iClass + "\" must implement method \"" + base + "\"", cd.getLocation());
            }
        }
        ClassFile cf = new ClassFile((short)(cd.getModifiers() | 0x20), iClass.getDescriptor(), iClass.getSuperclass().getDescriptor(), IClass.getDescriptors(iClass.getInterfaces()));
        if (!(cd.getEnclosingScope() instanceof Java.CompilationUnit)) {
            short innerClassInfoIndex;
            if (cd.getEnclosingScope() instanceof Java.Block) {
                innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short innerNameIndex = this instanceof Java.NamedTypeDeclaration ? cf.addConstantUtf8Info(((Java.NamedTypeDeclaration)((Object)this)).getName()) : (short)0;
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, 0, innerNameIndex, cd.getModifiers()));
            } else if (cd.getEnclosingScope() instanceof Java.TypeDeclaration) {
                innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve((Java.TypeDeclaration)cd.getEnclosingScope()).getDescriptor());
                short innerNameIndex = cf.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)cd)).getName());
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, cd.getModifiers()));
            }
        }
        if (this.debugSource) {
            String s = cd.getLocation().getFileName();
            String sourceFileName = s != null ? new File(s).getName() : (cd instanceof Java.NamedTypeDeclaration ? ((Java.NamedTypeDeclaration)((Object)cd)).getName() + ".java" : "ANONYMOUS.java");
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (cd instanceof Java.DocCommentable && ((Java.DocCommentable)((Object)cd)).hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        Iterator it = cd.variableDeclaratorsAndInitializers.iterator();
        while (it.hasNext()) {
            Java.TypeBodyDeclaration tbd = (Java.TypeBodyDeclaration)it.next();
            if (!tbd.isStatic()) continue;
            statements.add((Java.BlockStatement)((Object)tbd));
        }
        this.maybeCreateInitMethod(cd, cf, statements);
        this.compileDeclaredMethods(cd, cf);
        int declaredMethodCount = cd.getMethodDeclarations().size();
        int syntheticFieldCount = cd.syntheticFields.size();
        Java.ConstructorDeclarator[] cds = cd.getConstructors();
        for (int i = 0; i < cds.length; ++i) {
            this.compile(cds[i], cf);
            if (syntheticFieldCount == cd.syntheticFields.size()) continue;
            throw new JaninoRuntimeException("SNO: Compilation of constructor \"" + cds[i] + "\" (" + cds[i].getLocation() + ") added synthetic fields!?");
        }
        this.compileDeclaredMemberTypes(cd, cf);
        this.compileDeclaredMethods(cd, cf, declaredMethodCount);
        IClass.IMethod[] ms = iClass.getIMethods();
        for (int i = 0; i < ms.length; ++i) {
            IClass.IMethod override;
            IClass.IMethod base = ms[i];
            if (base.isStatic() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) == null || base.getReturnType().equals(override.getReturnType())) continue;
            this.compileBridgeMethod(cf, base, override);
        }
        Iterator<Object> it2 = cd.variableDeclaratorsAndInitializers.iterator();
        while (it2.hasNext()) {
            Java.TypeBodyDeclaration tbd = (Java.TypeBodyDeclaration)it2.next();
            if (!(tbd instanceof Java.FieldDeclaration)) continue;
            this.addFields((Java.FieldDeclaration)tbd, cf);
        }
        it2 = cd.syntheticFields.values().iterator();
        while (it2.hasNext()) {
            IClass.IField f = (IClass.IField)it2.next();
            cf.addFieldInfo((short)0, f.getName(), f.getType().getDescriptor(), null);
        }
        this.generatedClassFiles.add(cf);
    }

    private void addFields(Java.FieldDeclaration fd, ClassFile cf) throws CompileException {
        for (int j = 0; j < fd.variableDeclarators.length; ++j) {
            Java.VariableDeclarator vd = fd.variableDeclarators[j];
            Java.Type type = fd.type;
            for (int k = 0; k < vd.brackets; ++k) {
                type = new Java.ArrayType(type);
            }
            Object ocv = null;
            if ((fd.modifiers & 0x10) != 0 && vd.optionalInitializer != null) {
                if (vd.optionalInitializer instanceof Java.Rvalue) {
                    ocv = this.getConstantValue((Java.Rvalue)vd.optionalInitializer);
                }
                if (ocv == Java.Rvalue.CONSTANT_VALUE_NULL) {
                    ocv = null;
                }
            }
            ClassFile.FieldInfo fi = Mod.isPrivateAccess(fd.modifiers) ? cf.addFieldInfo(Mod.changeAccess(fd.modifiers, (short)0), vd.name, this.getType(type).getDescriptor(), ocv) : cf.addFieldInfo(fd.modifiers, vd.name, this.getType(type).getDescriptor(), ocv);
            if (!fd.hasDeprecatedDocTag()) continue;
            fi.addAttribute(new ClassFile.DeprecatedAttribute(cf.addConstantUtf8Info("Deprecated")));
        }
    }

    public void compile2(Java.AnonymousClassDeclaration acd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)acd);
    }

    public void compile2(Java.LocalClassDeclaration lcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)lcd);
    }

    public void compile2(Java.InnerClassDeclaration icd) throws CompileException {
        List ocs = UnitCompiler.getOuterClasses(icd);
        int nesting = ocs.size();
        if (nesting >= 2) {
            icd.defineSyntheticField(new SimpleIField(this.resolve(icd), "this$" + (nesting - 2), this.resolve((Java.TypeDeclaration)ocs.get(1))));
        }
        if (icd instanceof Java.AnonymousClassDeclaration || icd instanceof Java.LocalClassDeclaration) {
            Java.ClassDeclaration cd = (Java.ClassDeclaration)((Object)icd);
            for (int i = 0; i < cd.variableDeclaratorsAndInitializers.size(); ++i) {
                Java.TypeBodyDeclaration tbd = (Java.TypeBodyDeclaration)cd.variableDeclaratorsAndInitializers.get(i);
                if (!(tbd instanceof Java.FieldDeclaration)) continue;
                Java.FieldDeclaration fd = (Java.FieldDeclaration)tbd;
                for (int j = 0; j < fd.variableDeclarators.length; ++j) {
                    Java.VariableDeclarator vd = fd.variableDeclarators[j];
                    if (vd.optionalInitializer == null) continue;
                    this.fakeCompile(vd.optionalInitializer);
                }
            }
        }
        this.compile2((Java.ClassDeclaration)((Object)icd));
    }

    public void compile2(Java.MemberClassDeclaration mcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)mcd);
    }

    public void compile2(Java.InterfaceDeclaration id) throws CompileException {
        IClass iClass = this.resolve(id);
        id.interfaces = new IClass[id.extendedTypes.length];
        String[] interfaceDescriptors = new String[id.interfaces.length];
        for (int i = 0; i < id.extendedTypes.length; ++i) {
            id.interfaces[i] = this.getType(id.extendedTypes[i]);
            interfaceDescriptors[i] = id.interfaces[i].getDescriptor();
        }
        ClassFile cf = new ClassFile((short)(id.getModifiers() | 0x20 | 0x200 | 0x400), iClass.getDescriptor(), "Ljava/lang/Object;", interfaceDescriptors);
        if (this.debugSource) {
            String s = id.getLocation().getFileName();
            String sourceFileName = s != null ? new File(s).getName() : id.getName() + ".java";
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (id.hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        if (!id.constantDeclarations.isEmpty()) {
            ArrayList statements = new ArrayList();
            statements.addAll(id.constantDeclarations);
            this.maybeCreateInitMethod(id, cf, statements);
        }
        this.compileDeclaredMethods(id, cf);
        for (int i = 0; i < id.constantDeclarations.size(); ++i) {
            Java.BlockStatement bs = (Java.BlockStatement)id.constantDeclarations.get(i);
            if (!(bs instanceof Java.FieldDeclaration)) continue;
            this.addFields((Java.FieldDeclaration)bs, cf);
        }
        this.compileDeclaredMemberTypes(id, cf);
        this.generatedClassFiles.add(cf);
    }

    private void maybeCreateInitMethod(Java.AbstractTypeDeclaration decl, ClassFile cf, List statements) throws CompileException {
        if (this.generatesCode2ListStatements(statements)) {
            Java.MethodDeclarator md = new Java.MethodDeclarator(decl.getLocation(), null, 9, new Java.BasicType(decl.getLocation(), 0), "<clinit>", new Java.FunctionDeclarator.FormalParameter[0], new Java.ReferenceType[0], statements);
            md.setDeclaringType(decl);
            this.compile(md, cf);
        }
    }

    private void compileDeclaredMemberTypes(Java.TypeDeclaration decl, ClassFile cf) throws CompileException {
        Iterator it = decl.getMemberTypeDeclarations().iterator();
        while (it.hasNext()) {
            Java.MemberTypeDeclaration td = (Java.MemberTypeDeclaration)it.next();
            this.compile(td);
            short innerClassInfoIndex = cf.addConstantClassInfo(this.resolve(td).getDescriptor());
            short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve(decl).getDescriptor());
            short innerNameIndex = cf.addConstantUtf8Info(td.getName());
            cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, td.getModifiers()));
        }
    }

    private void compileDeclaredMethods(Java.AbstractTypeDeclaration typeDeclaration, ClassFile cf) throws CompileException {
        this.compileDeclaredMethods(typeDeclaration, cf, 0);
    }

    private void compileDeclaredMethods(Java.TypeDeclaration typeDeclaration, ClassFile cf, int startPos) throws CompileException {
        for (int i = startPos; i < typeDeclaration.getMethodDeclarations().size(); ++i) {
            this.compile((Java.MethodDeclarator)typeDeclaration.getMethodDeclarations().get(i), cf);
        }
    }

    private void compileBridgeMethod(ClassFile cf, IClass.IMethod base, IClass.IMethod override) throws CompileException {
        int i;
        ClassFile.MethodInfo mi = cf.addMethodInfo((short)4097, base.getName(), base.getDescriptor());
        IClass[] thrownExceptions = base.getThrownExceptions();
        if (thrownExceptions.length > 0) {
            short eani = cf.addConstantUtf8Info("Exceptions");
            short[] tecciis = new short[thrownExceptions.length];
            for (int i2 = 0; i2 < thrownExceptions.length; ++i2) {
                tecciis[i2] = cf.addConstantClassInfo(thrownExceptions[i2].getDescriptor());
            }
            mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
        }
        final CodeContext codeContext = new CodeContext(mi.getClassFile());
        CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
        codeContext.saveLocalVariables();
        codeContext.allocateLocalVariable((short)1, "this", override.getDeclaringIClass());
        IClass[] paramTypes = override.getParameterTypes();
        Java.LocalVariableSlot[] locals = new Java.LocalVariableSlot[paramTypes.length];
        for (i = 0; i < paramTypes.length; ++i) {
            locals[i] = codeContext.allocateLocalVariable(Descriptor.size(paramTypes[i].getDescriptor()), "param" + i, paramTypes[i]);
        }
        this.writeOpcode(Java.Located.NOWHERE, 42);
        for (i = 0; i < locals.length; ++i) {
            this.load(Java.Located.NOWHERE, locals[i].getType(), locals[i].getSlotIndex());
        }
        this.writeOpcode(Java.Located.NOWHERE, -74);
        this.writeConstantMethodrefInfo(override.getDeclaringIClass().getDescriptor(), override.getName(), override.getDescriptor());
        this.writeOpcode(Java.Located.NOWHERE, -80);
        this.replaceCodeContext(savedCodeContext);
        codeContext.flowAnalysis(override.getName());
        mi.addAttribute(new ClassFile.AttributeInfo(cf.addConstantUtf8Info("Code")){

            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, (short)0, (short)0);
            }
        });
    }

    private boolean compile(Java.BlockStatement bs) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final boolean[] res = new boolean[1];
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            public void visitInitializer(Java.Initializer i) {
                try {
                    res[0] = UnitCompiler.this.compile2(i);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                try {
                    res[0] = UnitCompiler.this.compile2(fd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLabeledStatement(Java.LabeledStatement ls) {
                try {
                    res[0] = UnitCompiler.this.compile2(ls);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBlock(Java.Block b) {
                try {
                    res[0] = UnitCompiler.this.compile2(b);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitExpressionStatement(Java.ExpressionStatement es) {
                try {
                    res[0] = UnitCompiler.this.compile2(es);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitIfStatement(Java.IfStatement is) {
                try {
                    res[0] = UnitCompiler.this.compile2(is);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitForStatement(Java.ForStatement fs) {
                try {
                    res[0] = UnitCompiler.this.compile2(fs);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitWhileStatement(Java.WhileStatement ws) {
                try {
                    res[0] = UnitCompiler.this.compile2(ws);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitTryStatement(Java.TryStatement ts) {
                try {
                    res[0] = UnitCompiler.this.compile2(ts);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSwitchStatement(Java.SwitchStatement ss) {
                try {
                    res[0] = UnitCompiler.this.compile2(ss);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                try {
                    res[0] = UnitCompiler.this.compile2(ss);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitDoStatement(Java.DoStatement ds) {
                try {
                    res[0] = UnitCompiler.this.compile2(ds);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                try {
                    res[0] = UnitCompiler.this.compile2(lvds);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitReturnStatement(Java.ReturnStatement rs) {
                try {
                    res[0] = UnitCompiler.this.compile2(rs);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitThrowStatement(Java.ThrowStatement ts) {
                try {
                    res[0] = UnitCompiler.this.compile2(ts);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBreakStatement(Java.BreakStatement bs) {
                try {
                    res[0] = UnitCompiler.this.compile2(bs);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitContinueStatement(Java.ContinueStatement cs) {
                try {
                    res[0] = UnitCompiler.this.compile2(cs);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitEmptyStatement(Java.EmptyStatement es) {
                res[0] = UnitCompiler.this.compile2(es);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                try {
                    res[0] = UnitCompiler.this.compile2(lcds);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                try {
                    res[0] = UnitCompiler.this.compile2(aci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                try {
                    res[0] = UnitCompiler.this.compile2(sci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            bs.accept(bsv);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private boolean compile2(Java.Initializer i) throws CompileException {
        return this.compile(i.block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.Block b) throws CompileException {
        this.codeContext.saveLocalVariables();
        try {
            boolean bl = this.compileStatements(b.statements);
            return bl;
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
    }

    private boolean compileStatements(List statements) throws CompileException {
        boolean previousStatementCanCompleteNormally = true;
        for (int i = 0; i < statements.size(); ++i) {
            Java.BlockStatement bs = (Java.BlockStatement)statements.get(i);
            if (!previousStatementCanCompleteNormally && this.generatesCode(bs)) {
                this.compileError("Statement is unreachable", bs.getLocation());
                break;
            }
            previousStatementCanCompleteNormally = this.compile(bs);
        }
        return previousStatementCanCompleteNormally;
    }

    private boolean compile2(Java.DoStatement ds) throws CompileException {
        Object cvc = this.getConstantValue(ds.condition);
        if (cvc != null) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("DSTC", "Condition of DO statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ds.getLocation());
                return this.compileUnconditionalLoop(ds, ds.body, null);
            }
            this.warning("DSNR", "DO statement never repeats", ds.getLocation());
        }
        ds.whereToContinue = this.codeContext.new CodeContext.Offset();
        ds.bodyHasContinue = false;
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        if (!this.compile(ds.body) && !ds.bodyHasContinue) {
            this.warning("DSNTC", "\"do\" statement never tests its condition", ds.getLocation());
            if (ds.whereToBreak == null) {
                return false;
            }
            ds.whereToBreak.set();
            return true;
        }
        ds.whereToContinue.set();
        this.compileBoolean(ds.condition, bodyOffset, true);
        if (ds.whereToBreak != null) {
            ds.whereToBreak.set();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.ForStatement fs) throws CompileException {
        this.codeContext.saveLocalVariables();
        try {
            if (fs.optionalInit != null) {
                this.compile(fs.optionalInit);
            }
            if (fs.optionalCondition == null) {
                boolean bl = this.compileUnconditionalLoop(fs, fs.body, fs.optionalUpdate);
                return bl;
            }
            Object cvc = this.getConstantValue(fs.optionalCondition);
            if (cvc != null) {
                if (Boolean.TRUE.equals(cvc)) {
                    this.warning("FSTC", "Condition of FOR statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", fs.getLocation());
                    boolean bl = this.compileUnconditionalLoop(fs, fs.body, fs.optionalUpdate);
                    return bl;
                }
                this.warning("FSNR", "FOR statement never repeats", fs.getLocation());
            }
            CodeContext.Offset toCondition = this.codeContext.new CodeContext.Offset();
            this.writeBranch(fs, -89, toCondition);
            fs.whereToContinue = this.codeContext.new CodeContext.Offset();
            fs.bodyHasContinue = false;
            CodeContext.Offset bodyOffset = this.codeContext.newOffset();
            boolean bodyCCN = this.compile(fs.body);
            fs.whereToContinue.set();
            if (fs.optionalUpdate != null) {
                if (!bodyCCN && !fs.bodyHasContinue) {
                    this.warning("FUUR", "For update is unreachable", fs.getLocation());
                } else {
                    for (int i = 0; i < fs.optionalUpdate.length; ++i) {
                        this.compile(fs.optionalUpdate[i]);
                    }
                }
            }
            toCondition.set();
            this.compileBoolean(fs.optionalCondition, bodyOffset, true);
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
        if (fs.whereToBreak != null) {
            fs.whereToBreak.set();
        }
        return true;
    }

    private boolean compile2(Java.WhileStatement ws) throws CompileException {
        Object cvc = this.getConstantValue(ws.condition);
        if (cvc != null) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("WSTC", "Condition of WHILE statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ws.getLocation());
                return this.compileUnconditionalLoop(ws, ws.body, null);
            }
            this.warning("WSNR", "WHILE statement never repeats", ws.getLocation());
        }
        ws.whereToContinue = this.codeContext.new CodeContext.Offset();
        ws.bodyHasContinue = false;
        this.writeBranch(ws, -89, ws.whereToContinue);
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        this.compile(ws.body);
        ws.whereToContinue.set();
        this.compileBoolean(ws.condition, bodyOffset, true);
        if (ws.whereToBreak != null) {
            ws.whereToBreak.set();
        }
        return true;
    }

    private boolean compileUnconditionalLoop(Java.ContinuableStatement cs, Java.BlockStatement body, Java.Rvalue[] optionalUpdate) throws CompileException {
        if (optionalUpdate != null) {
            return this.compileUnconditionalLoopWithUpdate(cs, body, optionalUpdate);
        }
        cs.whereToContinue = this.codeContext.newOffset();
        cs.bodyHasContinue = false;
        if (this.compile(body)) {
            this.writeBranch(cs, -89, cs.whereToContinue);
        }
        if (cs.whereToBreak == null) {
            return false;
        }
        cs.whereToBreak.set();
        return true;
    }

    private boolean compileUnconditionalLoopWithUpdate(Java.ContinuableStatement cs, Java.BlockStatement body, Java.Rvalue[] update) throws CompileException {
        cs.whereToContinue = this.codeContext.new CodeContext.Offset();
        cs.bodyHasContinue = false;
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        boolean bodyCCN = this.compile(body);
        cs.whereToContinue.set();
        if (!bodyCCN && !cs.bodyHasContinue) {
            this.warning("LUUR", "Loop update is unreachable", update[0].getLocation());
        } else {
            for (int i = 0; i < update.length; ++i) {
                this.compile(update[i]);
            }
            this.writeBranch(cs, -89, bodyOffset);
        }
        if (cs.whereToBreak == null) {
            return false;
        }
        cs.whereToBreak.set();
        return true;
    }

    private boolean compile2(Java.LabeledStatement ls) throws CompileException {
        boolean canCompleteNormally = this.compile(ls.body);
        if (ls.whereToBreak != null) {
            ls.whereToBreak.set();
            canCompleteNormally = true;
        }
        return canCompleteNormally;
    }

    private boolean compile2(Java.SwitchStatement ss) throws CompileException {
        IClass switchExpressionType = this.compileGetValue(ss.condition);
        this.assignmentConversion(ss, switchExpressionType, IClass.INT, null);
        TreeMap<Integer, CodeContext.Offset> caseLabelMap = new TreeMap<Integer, CodeContext.Offset>();
        CodeContext.Offset defaultLabelOffset = null;
        CodeContext.Offset[] sbsgOffsets = new CodeContext.Offset[ss.sbsgs.size()];
        for (int i = 0; i < ss.sbsgs.size(); ++i) {
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = (Java.SwitchStatement.SwitchBlockStatementGroup)ss.sbsgs.get(i);
            sbsgOffsets[i] = this.codeContext.new CodeContext.Offset();
            for (int j = 0; j < sbsg.caseLabels.size(); ++j) {
                Integer civ;
                Java.Rvalue rv = (Java.Rvalue)sbsg.caseLabels.get(j);
                Object cv = this.getConstantValue(rv);
                if (cv == null) {
                    this.compileError("Value of \"case\" label does not pose a constant value", rv.getLocation());
                    cv = new Integer(99);
                }
                IClass rvType = this.getType(rv);
                this.assignmentConversion(ss, rvType, switchExpressionType, cv);
                if (cv instanceof Integer) {
                    civ = (Integer)cv;
                } else if (cv instanceof Number) {
                    civ = new Integer(((Number)cv).intValue());
                } else if (cv instanceof Character) {
                    civ = new Integer(((Character)cv).charValue());
                } else {
                    this.compileError("Value of case label must be a char, byte, short or int constant", rv.getLocation());
                    civ = new Integer(99);
                }
                if (caseLabelMap.containsKey(civ)) {
                    this.compileError("Duplicate \"case\" switch label value", rv.getLocation());
                }
                caseLabelMap.put(civ, sbsgOffsets[i]);
            }
            if (!sbsg.hasDefaultLabel) continue;
            if (defaultLabelOffset != null) {
                this.compileError("Duplicate \"default\" switch label", sbsg.getLocation());
            }
            defaultLabelOffset = sbsgOffsets[i];
        }
        if (defaultLabelOffset == null) {
            defaultLabelOffset = this.getWhereToBreak(ss);
        }
        CodeContext.Offset switchOffset = this.codeContext.newOffset();
        if (!caseLabelMap.isEmpty()) {
            if ((Integer)caseLabelMap.firstKey() + caseLabelMap.size() >= (Integer)caseLabelMap.lastKey() - caseLabelMap.size()) {
                int low = (Integer)caseLabelMap.firstKey();
                int high = (Integer)caseLabelMap.lastKey();
                this.writeOpcode(ss, -86);
                new Java.Padder(this.codeContext).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(low);
                this.writeInt(high);
                Iterator si = caseLabelMap.entrySet().iterator();
                int cur = low;
                while (si.hasNext()) {
                    Map.Entry me = si.next();
                    int val = (Integer)me.getKey();
                    while (cur < val) {
                        this.writeOffset(switchOffset, defaultLabelOffset);
                        ++cur;
                    }
                    this.writeOffset(switchOffset, (CodeContext.Offset)me.getValue());
                    ++cur;
                }
            } else {
                this.writeOpcode(ss, -85);
                new Java.Padder(this.codeContext).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(caseLabelMap.size());
                Iterator si = caseLabelMap.entrySet().iterator();
                while (si.hasNext()) {
                    Map.Entry me = si.next();
                    this.writeInt((Integer)me.getKey());
                    this.writeOffset(switchOffset, (CodeContext.Offset)me.getValue());
                }
            }
        }
        boolean canCompleteNormally = true;
        block5: for (int i = 0; i < ss.sbsgs.size(); ++i) {
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = (Java.SwitchStatement.SwitchBlockStatementGroup)ss.sbsgs.get(i);
            sbsgOffsets[i].set();
            canCompleteNormally = true;
            for (int j = 0; j < sbsg.blockStatements.size(); ++j) {
                Java.BlockStatement bs = (Java.BlockStatement)sbsg.blockStatements.get(j);
                if (!canCompleteNormally) {
                    this.compileError("Statement is unreachable", bs.getLocation());
                    continue block5;
                }
                canCompleteNormally = this.compile(bs);
            }
        }
        if (ss.whereToBreak != null) {
            ss.whereToBreak.set();
            canCompleteNormally = true;
        }
        return canCompleteNormally;
    }

    private boolean compile2(Java.BreakStatement bs) throws CompileException {
        Java.BreakableStatement brokenStatement = null;
        if (bs.optionalLabel == null) {
            Java.Scope s = bs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.BreakableStatement) {
                    brokenStatement = (Java.BreakableStatement)s;
                    break;
                }
                s = s.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("\"break\" statement is not enclosed by a breakable statement", bs.getLocation());
                return false;
            }
        } else {
            Java.Scope s = bs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s;
                    if (ls.label.equals(bs.optionalLabel)) {
                        brokenStatement = ls;
                        break;
                    }
                }
                s = s.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("Statement \"break " + bs.optionalLabel + "\" is not enclosed by a breakable statement with label \"" + bs.optionalLabel + "\"", bs.getLocation());
                return false;
            }
        }
        this.leaveStatements(bs.getEnclosingScope(), brokenStatement.getEnclosingScope(), null);
        this.writeBranch(bs, -89, this.getWhereToBreak(brokenStatement));
        return false;
    }

    private boolean compile2(Java.ContinueStatement cs) throws CompileException {
        Java.ContinuableStatement continuedStatement = null;
        if (cs.optionalLabel == null) {
            Java.Scope s = cs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.ContinuableStatement) {
                    continuedStatement = (Java.ContinuableStatement)s;
                    break;
                }
                s = s.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("\"continue\" statement is not enclosed by a continuable statement", cs.getLocation());
                return false;
            }
        } else {
            Java.Scope s = cs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s;
                    if (ls.label.equals(cs.optionalLabel)) {
                        Java.Statement st = ls.body;
                        while (st instanceof Java.LabeledStatement) {
                            st = ((Java.LabeledStatement)st).body;
                        }
                        if (!(st instanceof Java.ContinuableStatement)) {
                            this.compileError("Labeled statement is not continuable", st.getLocation());
                            return false;
                        }
                        continuedStatement = (Java.ContinuableStatement)st;
                        break;
                    }
                }
                s = s.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("Statement \"continue " + cs.optionalLabel + "\" is not enclosed by a continuable statement with label \"" + cs.optionalLabel + "\"", cs.getLocation());
                return false;
            }
        }
        continuedStatement.bodyHasContinue = true;
        this.leaveStatements(cs.getEnclosingScope(), continuedStatement.getEnclosingScope(), null);
        this.writeBranch(cs, -89, continuedStatement.whereToContinue);
        return false;
    }

    private boolean compile2(Java.EmptyStatement es) {
        return true;
    }

    private boolean compile2(Java.ExpressionStatement ee) throws CompileException {
        this.compile(ee.rvalue);
        return true;
    }

    private boolean compile2(Java.FieldDeclaration fd) throws CompileException {
        for (int i = 0; i < fd.variableDeclarators.length; ++i) {
            Java.VariableDeclarator vd = fd.variableDeclarators[i];
            Java.ArrayInitializerOrRvalue initializer = this.getNonConstantFinalInitializer(fd, vd);
            if (initializer == null) continue;
            if ((fd.modifiers & 8) == 0) {
                this.writeOpcode(fd, 42);
            }
            IClass fieldType = this.getType(fd.type);
            if (initializer instanceof Java.Rvalue) {
                Java.Rvalue rvalue = (Java.Rvalue)initializer;
                IClass initializerType = this.compileGetValue(rvalue);
                fieldType = fieldType.getArrayIClass(vd.brackets, this.iClassLoader.OBJECT);
                this.assignmentConversion(fd, initializerType, fieldType, this.getConstantValue(rvalue));
            } else if (initializer instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)initializer, fieldType);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + initializer.getClass().getName());
            }
            if ((fd.modifiers & 8) != 0) {
                this.writeOpcode(fd, -77);
            } else {
                this.writeOpcode(fd, -75);
            }
            this.writeConstantFieldrefInfo(this.resolve(fd.getDeclaringType()).getDescriptor(), vd.name, fieldType.getDescriptor());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.IfStatement is) throws CompileException {
        Java.BlockStatement es;
        Object cv = this.getConstantValue(is.condition);
        Java.BlockStatement blockStatement = es = is.optionalElseStatement != null ? is.optionalElseStatement : new Java.EmptyStatement(is.thenStatement.getLocation());
        if (cv instanceof Boolean) {
            Java.BlockStatement blindStatement;
            Java.BlockStatement seeingStatement;
            this.fakeCompile(is.condition);
            if (((Boolean)cv).booleanValue()) {
                seeingStatement = is.thenStatement;
                blindStatement = es;
            } else {
                seeingStatement = es;
                blindStatement = is.thenStatement;
            }
            CodeContext.Inserter ins = this.codeContext.newInserter();
            boolean ssccn = this.compile(seeingStatement);
            if (ssccn) {
                return true;
            }
            Java.Scope s = is.getEnclosingScope();
            while (s instanceof Java.Block) {
                s = s.getEnclosingScope();
            }
            if (s instanceof Java.FunctionDeclarator) {
                throw STOP_COMPILING_CODE;
            }
            CodeContext.Offset off = this.codeContext.newOffset();
            this.codeContext.pushInserter(ins);
            try {
                this.pushConstant(is, new Integer(0));
                this.writeBranch(is, -102, off);
            }
            finally {
                this.codeContext.popInserter();
            }
            return this.compile(blindStatement);
        }
        if (this.generatesCode(is.thenStatement)) {
            if (this.generatesCode(es)) {
                CodeContext.Offset eso = this.codeContext.new CodeContext.Offset();
                CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(is.condition, eso, false);
                boolean tsccn = this.compile(is.thenStatement);
                if (tsccn) {
                    this.writeBranch(is, -89, end);
                }
                eso.set();
                boolean esccn = this.compile(es);
                end.set();
                return tsccn || esccn;
            }
            CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(is.condition, end, false);
            this.compile(is.thenStatement);
            end.set();
            return true;
        }
        if (this.generatesCode(es)) {
            CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(is.condition, end, true);
            this.compile(es);
            end.set();
            return true;
        }
        IClass conditionType = this.compileGetValue(is.condition);
        if (conditionType != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", is.getLocation());
        }
        this.pop(is, conditionType);
        return true;
    }

    private boolean compile2(Java.LocalClassDeclarationStatement lcds) throws CompileException {
        Java.LocalClassDeclaration otherLCD = this.findLocalClassDeclaration(lcds, lcds.lcd.name);
        if (otherLCD != lcds.lcd) {
            this.compileError("Redeclaration of local class \"" + lcds.lcd.name + "\"; previously declared in " + otherLCD.getLocation());
        }
        this.compile(lcds.lcd);
        return true;
    }

    private Java.LocalClassDeclaration findLocalClassDeclaration(Java.Scope s, String name) {
        Java.Scope es;
        while (!((es = s.getEnclosingScope()) instanceof Java.CompilationUnit)) {
            if (s instanceof Java.BlockStatement && (es instanceof Java.Block || es instanceof Java.FunctionDeclarator)) {
                Java.BlockStatement bs = (Java.BlockStatement)s;
                List statements = es instanceof Java.BlockStatement ? ((Java.Block)es).statements : ((Java.FunctionDeclarator)es).optionalStatements;
                Iterator it = statements.iterator();
                while (it.hasNext()) {
                    Java.BlockStatement bs2 = (Java.BlockStatement)it.next();
                    if (bs2 instanceof Java.LocalClassDeclarationStatement) {
                        Java.LocalClassDeclarationStatement lcds = (Java.LocalClassDeclarationStatement)bs2;
                        if (lcds.lcd.name.equals(name)) {
                            return lcds.lcd;
                        }
                    }
                    if (bs2 != bs) continue;
                    break;
                }
            }
            s = es;
        }
        return null;
    }

    private boolean compile2(Java.LocalVariableDeclarationStatement lvds) throws CompileException {
        if ((lvds.modifiers & 0xFFFFFFEF) != 0) {
            this.compileError("The only allowed modifier in local variable declarations is \"final\"", lvds.getLocation());
        }
        for (int j = 0; j < lvds.variableDeclarators.length; ++j) {
            Java.VariableDeclarator vd = lvds.variableDeclarators[j];
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), vd.name, lv.type));
            if (vd.optionalInitializer == null) continue;
            if (vd.optionalInitializer instanceof Java.Rvalue) {
                Java.Rvalue rhs = (Java.Rvalue)vd.optionalInitializer;
                this.assignmentConversion(lvds, this.compileGetValue(rhs), lv.type, this.getConstantValue(rhs));
            } else if (vd.optionalInitializer instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)vd.optionalInitializer, lv.type);
            } else {
                throw new JaninoRuntimeException("Unexpected rvalue or array initialized class " + vd.optionalInitializer.getClass().getName());
            }
            this.store((Java.Locatable)lvds, lv.type, lv);
        }
        return true;
    }

    public Java.LocalVariable getLocalVariable(Java.LocalVariableDeclarationStatement lvds, Java.VariableDeclarator vd) throws CompileException {
        if (vd.localVariable == null) {
            Java.Type variableType = lvds.type;
            for (int k = 0; k < vd.brackets; ++k) {
                variableType = new Java.ArrayType(variableType);
            }
            vd.localVariable = new Java.LocalVariable((lvds.modifiers & 0x10) != 0, this.getType(variableType));
        }
        return vd.localVariable;
    }

    private boolean compile2(Java.ReturnStatement rs) throws CompileException {
        Java.FunctionDeclarator enclosingFunction = null;
        Java.Scope s = rs.getEnclosingScope();
        while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        enclosingFunction = (Java.FunctionDeclarator)s;
        IClass returnType = this.getReturnType(enclosingFunction);
        if (returnType == IClass.VOID) {
            if (rs.optionalReturnValue != null) {
                this.compileError("Method must not return a value", rs.getLocation());
            }
            this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, null);
            this.writeOpcode(rs, -79);
            return false;
        }
        if (rs.optionalReturnValue == null) {
            this.compileError("Method must return a value", rs.getLocation());
            return false;
        }
        IClass type = this.compileGetValue(rs.optionalReturnValue);
        this.assignmentConversion(rs, type, returnType, this.getConstantValue(rs.optionalReturnValue));
        this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, returnType);
        this.writeOpcode(rs, -84 + this.ilfda(returnType));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.SynchronizedStatement ss) throws CompileException {
        if (!this.iClassLoader.OBJECT.isAssignableFrom(this.compileGetValue(ss.expression))) {
            this.compileError("Monitor object of \"synchronized\" statement is not a subclass of \"Object\"", ss.getLocation());
        }
        this.codeContext.saveLocalVariables();
        boolean canCompleteNormally = false;
        try {
            ss.monitorLvIndex = this.codeContext.allocateLocalVariable((short)1);
            this.writeOpcode(ss, 89);
            this.store((Java.Locatable)ss, this.iClassLoader.OBJECT, ss.monitorLvIndex);
            this.writeOpcode(ss, -62);
            CodeContext.Offset monitorExitOffset = this.codeContext.new CodeContext.Offset();
            CodeContext.Offset beginningOfBody = this.codeContext.newOffset();
            canCompleteNormally = this.compile(ss.body);
            if (canCompleteNormally) {
                this.writeBranch(ss, -89, monitorExitOffset);
            }
            CodeContext.Offset here = this.codeContext.newOffset();
            this.codeContext.addExceptionTableEntry(beginningOfBody, here, here, null);
            this.leave(ss, this.iClassLoader.THROWABLE);
            this.writeOpcode(ss, -65);
            if (canCompleteNormally) {
                monitorExitOffset.set();
                this.leave(ss, null);
            }
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
        return canCompleteNormally;
    }

    private boolean compile2(Java.ThrowStatement ts) throws CompileException {
        IClass expressionType = this.compileGetValue(ts.expression);
        this.checkThrownException(ts, expressionType, ts.getEnclosingScope());
        this.writeOpcode(ts, -65);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.TryStatement ts) throws CompileException {
        if (ts.optionalFinally != null) {
            ts.finallyOffset = this.codeContext.new CodeContext.Offset();
        }
        CodeContext.Offset beginningOfBody = this.codeContext.newOffset();
        CodeContext.Offset afterStatement = this.codeContext.new CodeContext.Offset();
        this.codeContext.saveLocalVariables();
        try {
            short pcLVIndex = ts.optionalFinally != null ? this.codeContext.allocateLocalVariable((short)1) : (short)0;
            boolean canCompleteNormally = this.compile(ts.body);
            CodeContext.Offset afterBody = this.codeContext.newOffset();
            if (canCompleteNormally) {
                this.writeBranch(ts, -89, afterStatement);
            }
            if (beginningOfBody.offset != afterBody.offset) {
                this.codeContext.saveLocalVariables();
                try {
                    for (int i = 0; i < ts.catchClauses.size(); ++i) {
                        try {
                            this.codeContext.saveLocalVariables();
                            Java.CatchClause cc = (Java.CatchClause)ts.catchClauses.get(i);
                            IClass caughtExceptionType = this.getType(cc.caughtException.type);
                            Java.LocalVariableSlot exceptionVarSlot = this.codeContext.allocateLocalVariable((short)1, cc.caughtException.name, caughtExceptionType);
                            short evi = exceptionVarSlot.getSlotIndex();
                            this.getLocalVariable(cc.caughtException).setSlot(exceptionVarSlot);
                            this.codeContext.addExceptionTableEntry(beginningOfBody, afterBody, this.codeContext.newOffset(), caughtExceptionType.getDescriptor());
                            this.store((Java.Locatable)cc, caughtExceptionType, evi);
                            if (!this.compile(cc.body)) continue;
                            canCompleteNormally = true;
                            if (i >= ts.catchClauses.size() - 1 && ts.optionalFinally == null) continue;
                            this.writeBranch(cc, -89, afterStatement);
                            continue;
                        }
                        finally {
                            this.codeContext.restoreLocalVariables();
                        }
                    }
                }
                finally {
                    this.codeContext.restoreLocalVariables();
                }
            }
            if (ts.optionalFinally != null) {
                CodeContext.Offset here = this.codeContext.newOffset();
                this.codeContext.addExceptionTableEntry(beginningOfBody, here, here, null);
                this.codeContext.saveLocalVariables();
                try {
                    short evi = this.codeContext.allocateLocalVariable((short)1);
                    this.store((Java.Locatable)ts.optionalFinally, this.iClassLoader.OBJECT, evi);
                    this.writeBranch(ts.optionalFinally, -88, ts.finallyOffset);
                    this.load(ts.optionalFinally, this.iClassLoader.OBJECT, evi);
                    this.writeOpcode(ts.optionalFinally, -65);
                    ts.finallyOffset.set();
                    this.store((Java.Locatable)ts.optionalFinally, this.iClassLoader.OBJECT, pcLVIndex);
                    if (this.compile(ts.optionalFinally)) {
                        if (pcLVIndex > 255) {
                            this.writeOpcode(ts.optionalFinally, -60);
                            this.writeOpcode(ts.optionalFinally, -87);
                            this.writeShort(pcLVIndex);
                        } else {
                            this.writeOpcode(ts.optionalFinally, -87);
                            this.writeByte(pcLVIndex);
                        }
                    }
                }
                finally {
                    this.codeContext.restoreLocalVariables();
                }
            }
            afterStatement.set();
            if (canCompleteNormally) {
                this.leave(ts, null);
            }
            boolean bl = canCompleteNormally;
            return bl;
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(Java.FunctionDeclarator fd, ClassFile classFile) throws CompileException {
        short lvtani;
        CodeContext codeContext;
        ClassFile.MethodInfo mi;
        block26: {
            mi = Mod.isPrivateAccess(fd.modifiers) ? (fd instanceof Java.MethodDeclarator && !fd.isStatic() ? classFile.addMethodInfo((short)(Mod.changeAccess(fd.modifiers, (short)0) | 8), fd.name + '$', MethodDescriptor.prependParameter(this.toIMethod((Java.MethodDeclarator)fd).getDescriptor(), this.resolve(fd.getDeclaringType()).getDescriptor())) : classFile.addMethodInfo(Mod.changeAccess(fd.modifiers, (short)0), fd.name, this.toIInvocable(fd).getDescriptor())) : classFile.addMethodInfo(fd.modifiers, fd.name, this.toIInvocable(fd).getDescriptor());
            if (fd.thrownExceptions.length > 0) {
                short eani = classFile.addConstantUtf8Info("Exceptions");
                short[] tecciis = new short[fd.thrownExceptions.length];
                for (int i = 0; i < fd.thrownExceptions.length; ++i) {
                    tecciis[i] = classFile.addConstantClassInfo(this.getType(fd.thrownExceptions[i]).getDescriptor());
                }
                mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
            }
            if (fd.hasDeprecatedDocTag()) {
                mi.addAttribute(new ClassFile.DeprecatedAttribute(classFile.addConstantUtf8Info("Deprecated")));
            }
            if ((fd.modifiers & 0x500) != 0) {
                return;
            }
            codeContext = new CodeContext(mi.getClassFile());
            CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
            try {
                block25: {
                    this.codeContext.saveLocalVariables();
                    if ((fd.modifiers & 8) == 0) {
                        this.codeContext.allocateLocalVariable((short)1, "this", this.resolve(fd.getDeclaringType()));
                    }
                    if (fd instanceof Java.ConstructorDeclarator) {
                        Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)fd;
                        Iterator it = constructorDeclarator.getDeclaringClass().syntheticFields.values().iterator();
                        while (it.hasNext()) {
                            IClass.IField sf = (IClass.IField)it.next();
                            Java.LocalVariable lv = new Java.LocalVariable(true, sf.getType());
                            lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(sf.getDescriptor()), null, null));
                            constructorDeclarator.syntheticParameters.put(sf.getName(), lv);
                        }
                    }
                    this.buildLocalVariableMap(fd);
                    if (fd instanceof Java.ConstructorDeclarator) {
                        Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
                        if (cd.optionalConstructorInvocation != null) {
                            this.compile(cd.optionalConstructorInvocation);
                            if (cd.optionalConstructorInvocation instanceof Java.SuperConstructorInvocation) {
                                this.assignSyntheticParametersToSyntheticFields(cd);
                                this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                            }
                        } else {
                            Java.QualifiedThisReference qualification = null;
                            IClass outerClassOfSuperclass = this.resolve(cd.getDeclaringClass()).getSuperclass().getOuterIClass();
                            if (outerClassOfSuperclass != null) {
                                qualification = new Java.QualifiedThisReference(cd.getLocation(), new Java.SimpleType(cd.getLocation(), outerClassOfSuperclass));
                            }
                            Java.SuperConstructorInvocation sci = new Java.SuperConstructorInvocation(cd.getLocation(), qualification, new Java.Rvalue[0]);
                            sci.setEnclosingScope(fd);
                            this.compile(sci);
                            this.assignSyntheticParametersToSyntheticFields(cd);
                            this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                        }
                    }
                    try {
                        if (fd.optionalStatements != null) break block25;
                        this.compileError("Method must have a body", fd.getLocation());
                        return;
                    }
                    catch (RuntimeException ex) {
                        if (ex != STOP_COMPILING_CODE) {
                            throw ex;
                        }
                        break block26;
                    }
                }
                if (this.compileStatements(fd.optionalStatements)) {
                    if (this.getReturnType(fd) != IClass.VOID) {
                        this.compileError("Method must return a value", fd.getLocation());
                    }
                    this.writeOpcode(fd, -79);
                }
            }
            finally {
                this.codeContext.restoreLocalVariables();
                this.replaceCodeContext(savedCodeContext);
            }
        }
        if (this.compileErrorCount > 0) {
            return;
        }
        codeContext.fixUpAndRelocate();
        codeContext.flowAnalysis(fd.toString());
        final short lntani = this.debugLines ? classFile.addConstantUtf8Info("LineNumberTable") : (short)0;
        if (this.debugVars) {
            this.makeLocalVariableNames(codeContext, mi);
            lvtani = classFile.addConstantUtf8Info("LocalVariableTable");
        } else {
            lvtani = 0;
        }
        mi.addAttribute(new ClassFile.AttributeInfo(classFile.addConstantUtf8Info("Code")){

            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, lntani, lvtani);
            }
        });
    }

    private void makeLocalVariableNames(CodeContext cc, ClassFile.MethodInfo mi) {
        ClassFile cf = mi.getClassFile();
        Iterator iter = cc.getAllLocalVars().iterator();
        cf.addConstantUtf8Info("LocalVariableTable");
        while (iter.hasNext()) {
            Java.LocalVariableSlot slot = (Java.LocalVariableSlot)iter.next();
            if (slot.getName() == null) continue;
            String typeName = slot.getType().getDescriptor();
            cf.addConstantUtf8Info(typeName);
            cf.addConstantUtf8Info(slot.getName());
        }
    }

    private void buildLocalVariableMap(Java.FunctionDeclarator fd) throws CompileException {
        Map<String, Java.LocalVariable> localVars = new HashMap<String, Java.LocalVariable>();
        for (int i = 0; i < fd.formalParameters.length; ++i) {
            Java.FunctionDeclarator.FormalParameter fp = fd.formalParameters[i];
            Java.LocalVariable lv = this.getLocalVariable(fp);
            lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), fp.name, this.getType(fp.type)));
            if (localVars.put(fp.name, lv) == null) continue;
            this.compileError("Redefinition of parameter \"" + fp.name + "\"", fd.getLocation());
        }
        fd.localVariables = localVars;
        if (fd instanceof Java.ConstructorDeclarator) {
            Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
            if (cd.optionalConstructorInvocation != null) {
                this.buildLocalVariableMap(cd.optionalConstructorInvocation, localVars);
            }
        }
        if (fd.optionalStatements != null) {
            Iterator it = fd.optionalStatements.iterator();
            while (it.hasNext()) {
                Java.BlockStatement bs = (Java.BlockStatement)it.next();
                localVars = this.buildLocalVariableMap(bs, localVars);
            }
        }
    }

    private Map buildLocalVariableMap(Java.BlockStatement bs, final Map localVars) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final Map[] resVars = new Map[]{localVars};
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.this.buildLocalVariableMap(aci, localVars);
            }

            public void visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.this.buildLocalVariableMap(bs, localVars);
            }

            public void visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.this.buildLocalVariableMap(cs, localVars);
            }

            public void visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.this.buildLocalVariableMap(es, localVars);
            }

            public void visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.this.buildLocalVariableMap(es, localVars);
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.this.buildLocalVariableMap(fd, localVars);
            }

            public void visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.this.buildLocalVariableMap(rs, localVars);
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.this.buildLocalVariableMap(sci, localVars);
            }

            public void visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.this.buildLocalVariableMap(ts, localVars);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.this.buildLocalVariableMap(lcds, localVars);
            }

            public void visitBlock(Java.Block b) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(b, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitDoStatement(Java.DoStatement ds) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ds, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitForStatement(Java.ForStatement fs) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(fs, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitIfStatement(Java.IfStatement is) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(is, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitInitializer(Java.Initializer i) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(i, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSwitchStatement(Java.SwitchStatement ss) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ss, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ss, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitTryStatement(Java.TryStatement ts) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ts, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitWhileStatement(Java.WhileStatement ws) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ws, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLabeledStatement(Java.LabeledStatement ls) {
                try {
                    resVars[0] = UnitCompiler.this.buildLocalVariableMap(ls, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                try {
                    resVars[0] = UnitCompiler.this.buildLocalVariableMap(lvds, localVars);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            bs.accept(bsv);
        }
        catch (UCE uce) {
            throw uce.ce;
        }
        return resVars[0];
    }

    private Map buildLocalVariableMap(Java.Statement s, Map localVars) {
        s.localVariables = localVars;
        return s.localVariables;
    }

    private Map buildLocalVariableMap(Java.ConstructorInvocation ci, Map localVars) {
        ci.localVariables = localVars;
        return ci.localVariables;
    }

    private void buildLocalVariableMap(Java.Block block, Map localVars) throws CompileException {
        block.localVariables = localVars;
        Iterator it = block.statements.iterator();
        while (it.hasNext()) {
            Java.BlockStatement bs = (Java.BlockStatement)it.next();
            localVars = this.buildLocalVariableMap(bs, localVars);
        }
    }

    private void buildLocalVariableMap(Java.DoStatement ds, Map localVars) throws CompileException {
        ds.localVariables = localVars;
        this.buildLocalVariableMap(ds.body, localVars);
    }

    private void buildLocalVariableMap(Java.ForStatement fs, Map localVars) throws CompileException {
        Map inner = localVars;
        if (fs.optionalInit != null) {
            inner = this.buildLocalVariableMap(fs.optionalInit, localVars);
        }
        fs.localVariables = inner;
        this.buildLocalVariableMap(fs.body, inner);
    }

    private void buildLocalVariableMap(Java.IfStatement is, Map localVars) throws CompileException {
        is.localVariables = localVars;
        this.buildLocalVariableMap(is.thenStatement, localVars);
        if (is.optionalElseStatement != null) {
            this.buildLocalVariableMap(is.optionalElseStatement, localVars);
        }
    }

    private void buildLocalVariableMap(Java.Initializer i, Map localVars) throws CompileException {
        this.buildLocalVariableMap(i.block, localVars);
    }

    private void buildLocalVariableMap(Java.SwitchStatement ss, Map localVars) throws CompileException {
        ss.localVariables = localVars;
        Map vars = localVars;
        Iterator cases = ss.sbsgs.iterator();
        while (cases.hasNext()) {
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = (Java.SwitchStatement.SwitchBlockStatementGroup)cases.next();
            Iterator stmts = sbsg.blockStatements.iterator();
            while (stmts.hasNext()) {
                Java.BlockStatement bs = (Java.BlockStatement)stmts.next();
                vars = this.buildLocalVariableMap(bs, vars);
            }
        }
    }

    private void buildLocalVariableMap(Java.SynchronizedStatement ss, Map localVars) throws CompileException {
        ss.localVariables = localVars;
        this.buildLocalVariableMap(ss.body, localVars);
    }

    private void buildLocalVariableMap(Java.TryStatement ts, Map localVars) throws CompileException {
        ts.localVariables = localVars;
        this.buildLocalVariableMap(ts.body, localVars);
        Iterator it = ts.catchClauses.iterator();
        while (it.hasNext()) {
            Java.CatchClause cc = (Java.CatchClause)it.next();
            this.buildLocalVariableMap(cc, localVars);
        }
        if (ts.optionalFinally != null) {
            this.buildLocalVariableMap(ts.optionalFinally, localVars);
        }
    }

    private void buildLocalVariableMap(Java.WhileStatement ws, Map localVars) throws CompileException {
        ws.localVariables = localVars;
        this.buildLocalVariableMap(ws.body, localVars);
    }

    private Map buildLocalVariableMap(Java.LabeledStatement ls, Map localVars) throws CompileException {
        ls.localVariables = localVars;
        return this.buildLocalVariableMap((Java.BlockStatement)ls.body, localVars);
    }

    private Map buildLocalVariableMap(Java.LocalVariableDeclarationStatement lvds, Map localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> newVars = new HashMap<String, Java.LocalVariable>();
        newVars.putAll(localVars);
        for (int i = 0; i < lvds.variableDeclarators.length; ++i) {
            Java.VariableDeclarator vd = lvds.variableDeclarators[i];
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            if (newVars.put(vd.name, lv) == null) continue;
            this.compileError("Redefinition of local variable \"" + vd.name + "\" ", vd.getLocation());
        }
        lvds.localVariables = newVars;
        return newVars;
    }

    protected void buildLocalVariableMap(Java.CatchClause cc, Map localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> vars = new HashMap<String, Java.LocalVariable>();
        vars.putAll(localVars);
        Java.LocalVariable lv = this.getLocalVariable(cc.caughtException);
        vars.put(cc.caughtException.name, lv);
        this.buildLocalVariableMap(cc.body, vars);
    }

    public Java.LocalVariable getLocalVariable(Java.FunctionDeclarator.FormalParameter fp) throws CompileException {
        if (fp.localVariable == null) {
            fp.localVariable = new Java.LocalVariable(fp.finaL, this.getType(fp.type));
        }
        return fp.localVariable;
    }

    private void fakeCompile(Java.ArrayInitializerOrRvalue aior) throws CompileException {
        if (aior instanceof Java.Rvalue) {
            Java.Rvalue rv = (Java.Rvalue)aior;
            this.fakeCompile(rv);
        }
        if (aior instanceof Java.ArrayInitializer) {
            Java.ArrayInitializer ai = (Java.ArrayInitializer)aior;
            for (int i = 0; i < ai.values.length; ++i) {
                this.fakeCompile(ai.values[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fakeCompile(Java.Rvalue rv) throws CompileException {
        CodeContext savedCodeContext = this.replaceCodeContext(this.createDummyCodeContext());
        try {
            this.compileContext(rv);
            this.compileGet(rv);
        }
        finally {
            this.replaceCodeContext(savedCodeContext);
        }
    }

    private void compile(Java.Rvalue rv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    UnitCompiler.this.compile2(al);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAssignment(Java.Assignment a) {
                try {
                    UnitCompiler.this.compile2(a);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    UnitCompiler.this.compile2(uo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    UnitCompiler.this.compile2(bo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCast(Java.Cast c) {
                try {
                    UnitCompiler.this.compile2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    UnitCompiler.this.compile2(cl);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    UnitCompiler.this.compile2(ce);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCrement(Java.Crement c) {
                try {
                    UnitCompiler.this.compile2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitInstanceof(Java.Instanceof io) {
                try {
                    UnitCompiler.this.compile2(io);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    UnitCompiler.this.compile2(mi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    UnitCompiler.this.compile2(smi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLiteral(Java.Literal l) {
                try {
                    UnitCompiler.this.compile2(l);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    UnitCompiler.this.compile2(naci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewArray(Java.NewArray na) {
                try {
                    UnitCompiler.this.compile2(na);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    UnitCompiler.this.compile2(nia);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    UnitCompiler.this.compile2(nci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    UnitCompiler.this.compile2(pa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    UnitCompiler.this.compile2(qtr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitThisReference(Java.ThisReference tr) {
                try {
                    UnitCompiler.this.compile2(tr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compile2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compile2(aae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compile2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compile2(fae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compile2(scfae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                try {
                    UnitCompiler.this.compile2(lva);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compile2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private void compile2(Java.Rvalue rv) throws CompileException {
        this.pop(rv, this.compileGetValue(rv));
    }

    private void compile2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            this.compileContext(a.lhs);
            this.assignmentConversion(a, this.compileGetValue(a.rhs), this.getType(a.lhs), this.getConstantValue(a.rhs));
            this.compileSet(a.lhs);
            return;
        }
        int lhsCS = this.compileContext(a.lhs);
        this.dup(a, lhsCS);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!this.tryIdentityConversion(resultType, lhsType) && !this.tryNarrowingPrimitiveConversion(a, resultType, lhsType)) {
            throw new JaninoRuntimeException("SNO: \"" + a.operator + "\" reconversion failed");
        }
        this.compileSet(a.lhs);
    }

    private void compile2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLV(c);
        if (lv != null) {
            this.compileLocalVariableCrement(c, lv);
            return;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        this.compileSet(c.operand);
    }

    private void compile2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compile(pe.value);
    }

    private boolean compile2(Java.AlternateConstructorInvocation aci) throws CompileException {
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)aci.getEnclosingScope();
        IClass declaringIClass = this.resolve(declaringConstructor.getDeclaringClass());
        this.writeOpcode(aci, 42);
        if (declaringIClass.getOuterIClass() != null) {
            this.writeOpcode(aci, 43);
        }
        this.invokeConstructor(aci, declaringConstructor, null, declaringIClass, aci.arguments);
        return true;
    }

    private boolean compile2(Java.SuperConstructorInvocation sci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)sci.getEnclosingScope();
        this.writeOpcode(sci, 42);
        Java.ClassDeclaration declaringClass = declaringConstructor.getDeclaringClass();
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        if (sci.optionalQualification != null) {
            optionalEnclosingInstance = sci.optionalQualification;
        } else {
            IClass outerIClassOfSuperclass = superclass.getOuterIClass();
            if (outerIClassOfSuperclass == null) {
                optionalEnclosingInstance = null;
            } else {
                optionalEnclosingInstance = new Java.QualifiedThisReference(sci.getLocation(), new Java.SimpleType(sci.getLocation(), outerIClassOfSuperclass));
                optionalEnclosingInstance.setEnclosingBlockStatement(sci);
            }
        }
        this.invokeConstructor(sci, declaringConstructor, optionalEnclosingInstance, superclass, sci.arguments);
        return true;
    }

    private void compileBoolean(Java.Rvalue rv, final CodeContext.Offset dst, final boolean orientation) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    UnitCompiler.this.compileBoolean2(al, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAssignment(Java.Assignment a) {
                try {
                    UnitCompiler.this.compileBoolean2(a, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    UnitCompiler.this.compileBoolean2(uo, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    UnitCompiler.this.compileBoolean2(bo, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCast(Java.Cast c) {
                try {
                    UnitCompiler.this.compileBoolean2(c, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    UnitCompiler.this.compileBoolean2(cl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    UnitCompiler.this.compileBoolean2(ce, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCrement(Java.Crement c) {
                try {
                    UnitCompiler.this.compileBoolean2(c, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitInstanceof(Java.Instanceof io) {
                try {
                    UnitCompiler.this.compileBoolean2(io, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    UnitCompiler.this.compileBoolean2(mi, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    UnitCompiler.this.compileBoolean2(smi, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLiteral(Java.Literal l) {
                try {
                    UnitCompiler.this.compileBoolean2(l, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    UnitCompiler.this.compileBoolean2(naci, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewArray(Java.NewArray na) {
                try {
                    UnitCompiler.this.compileBoolean2(na, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    UnitCompiler.this.compileBoolean2(nia, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    UnitCompiler.this.compileBoolean2(nci, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    UnitCompiler.this.compileBoolean2(pa, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    UnitCompiler.this.compileBoolean2(qtr, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitThisReference(Java.ThisReference tr) {
                try {
                    UnitCompiler.this.compileBoolean2(tr, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compileBoolean2(an, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compileBoolean2(aae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compileBoolean2(fa, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compileBoolean2(fae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compileBoolean2(scfae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                try {
                    UnitCompiler.this.compileBoolean2(lva, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compileBoolean2(pe, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private void compileBoolean2(Java.Rvalue rv, CodeContext.Offset dst, boolean orientation) throws CompileException {
        IClass type = this.compileGetValue(rv);
        IClassLoader icl = this.iClassLoader;
        if (type == icl.BOOLEAN) {
            this.unboxingConversion(rv, icl.BOOLEAN, IClass.BOOLEAN);
        } else if (type != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", rv.getLocation());
        }
        this.writeBranch(rv, orientation ? -102 : -103, dst);
    }

    private void compileBoolean2(Java.UnaryOperation ue, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (ue.operator == "!") {
            this.compileBoolean(ue.operand, dst, !orientation);
            return;
        }
        this.compileError("Boolean expression expected", ue.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileBoolean2(Java.BinaryOperation bo, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            this.compileBoolean2((Java.Rvalue)bo, dst, orientation);
            return;
        }
        if (bo.op == "||" || bo.op == "&&") {
            Object lhsCV = this.getConstantValue(bo.lhs);
            if (lhsCV instanceof Boolean) {
                if ((Boolean)lhsCV ^ bo.op == "||") {
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                } else {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                    this.fakeCompile(bo.rhs);
                }
                return;
            }
            Object rhsCV = this.getConstantValue(bo.rhs);
            if (rhsCV instanceof Boolean) {
                if ((Boolean)rhsCV ^ bo.op == "||") {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                } else {
                    this.pop(bo.lhs, this.compileGetValue(bo.lhs));
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                }
                return;
            }
            if (bo.op == "||" ^ !orientation) {
                this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
            } else {
                CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(bo.lhs, end, false ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                end.set();
            }
            return;
        }
        if (bo.op == "==" || bo.op == "!=" || bo.op == "<=" || bo.op == ">=" || bo.op == "<" || bo.op == ">") {
            boolean rhsIsNull;
            int opIdx;
            int n = bo.op == "==" ? 0 : (bo.op == "!=" ? 1 : (bo.op == "<" ? 2 : (bo.op == ">=" ? 3 : (bo.op == ">" ? 4 : (opIdx = bo.op == "<=" ? 5 : Integer.MIN_VALUE)))));
            if (!orientation) {
                opIdx ^= 1;
            }
            boolean lhsIsNull = this.getConstantValue(bo.lhs) == Java.Rvalue.CONSTANT_VALUE_NULL;
            boolean bl = rhsIsNull = this.getConstantValue(bo.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL;
            if (lhsIsNull || rhsIsNull) {
                IClass ohsType;
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on operand \"null\"", bo.getLocation());
                }
                if (!(lhsIsNull && rhsIsNull || !(ohsType = this.compileGetValue(lhsIsNull ? bo.rhs : bo.lhs)).isPrimitive())) {
                    this.compileError("Cannot compare \"null\" with primitive type \"" + ohsType.toString() + "\"", bo.getLocation());
                }
                this.writeBranch(bo, -58 + opIdx, dst);
                return;
            }
            IClass lhsType = this.compileGetValue(bo.lhs);
            CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
            IClass rhsType = this.compileGetValue(bo.rhs);
            if (this.getUnboxedType(lhsType).isPrimitiveNumeric() && this.getUnboxedType(rhsType).isPrimitiveNumeric() && (bo.op != "==" && bo.op != "!=" || lhsType.isPrimitive() || rhsType.isPrimitive())) {
                IClass promotedType = this.binaryNumericPromotion(bo, lhsType, convertLhsInserter, rhsType);
                if (promotedType == IClass.INT) {
                    this.writeBranch(bo, -97 + opIdx, dst);
                } else if (promotedType == IClass.LONG) {
                    this.writeOpcode(bo, -108);
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.FLOAT) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -107);
                    } else {
                        this.writeOpcode(bo, -106);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.DOUBLE) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -105);
                    } else {
                        this.writeOpcode(bo, -104);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else {
                    throw new JaninoRuntimeException("Unexpected promoted type \"" + promotedType + "\"");
                }
                return;
            }
            if (lhsType == IClass.BOOLEAN && this.getUnboxedType(rhsType) == IClass.BOOLEAN || rhsType == IClass.BOOLEAN && this.getUnboxedType(lhsType) == IClass.BOOLEAN) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on boolean operands", bo.getLocation());
                }
                IClassLoader icl = this.iClassLoader;
                if (lhsType == icl.BOOLEAN) {
                    this.codeContext.pushInserter(convertLhsInserter);
                    try {
                        this.unboxingConversion(bo, icl.BOOLEAN, IClass.BOOLEAN);
                    }
                    finally {
                        this.codeContext.popInserter();
                    }
                }
                if (rhsType == icl.BOOLEAN) {
                    this.unboxingConversion(bo, icl.BOOLEAN, IClass.BOOLEAN);
                }
                this.writeBranch(bo, -97 + opIdx, dst);
                return;
            }
            if (!lhsType.isPrimitive() && !rhsType.isPrimitive()) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on reference operands", bo.getLocation());
                }
                this.writeBranch(bo, -91 + opIdx, dst);
                return;
            }
            this.compileError("Cannot compare types \"" + lhsType + "\" and \"" + rhsType + "\"", bo.getLocation());
        }
        this.compileError("Boolean expression expected", bo.getLocation());
    }

    private void compileBoolean2(Java.ParenthesizedExpression pe, CodeContext.Offset dst, boolean orientation) throws CompileException {
        this.compileBoolean(pe.value, dst, orientation);
    }

    private int compileContext(Java.Rvalue rv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final int[] res = new int[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(al);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.compileContext2(a);
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                res[0] = UnitCompiler.this.compileContext2(uo);
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                res[0] = UnitCompiler.this.compileContext2(bo);
            }

            public void visitCast(Java.Cast c) {
                res[0] = UnitCompiler.this.compileContext2(c);
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.compileContext2(cl);
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                res[0] = UnitCompiler.this.compileContext2(ce);
            }

            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.compileContext2(c);
            }

            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.compileContext2(io);
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.compileContext2(mi);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.compileContext2(smi);
            }

            public void visitLiteral(Java.Literal l) {
                res[0] = UnitCompiler.this.compileContext2(l);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.compileContext2(naci);
            }

            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.compileContext2(na);
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.compileContext2(nia);
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.compileContext2(nci);
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.compileContext2(pa);
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.compileContext2(qtr);
            }

            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.compileContext2(tr);
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(aae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(fae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(scfae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.compileContext2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private int compileContext2(Java.Rvalue rv) {
        return 0;
    }

    private int compileContext2(Java.AmbiguousName an) throws CompileException {
        return this.compileContext(this.toRvalueOrCE(this.reclassify(an)));
    }

    private int compileContext2(Java.FieldAccess fa) throws CompileException {
        if (fa.field.isStatic()) {
            Java.Rvalue rv = fa.lhs.toRvalue();
            if (rv != null) {
                this.warning("CNSFA", "Left-hand side of static field access should be a type, not an rvalue", fa.lhs.getLocation());
                this.pop(fa.lhs, this.compileGetValue(rv));
            }
            return 0;
        }
        this.compileGetValue(this.toRvalueOrCE(fa.lhs));
        return 1;
    }

    private int compileContext2(Java.ArrayLength al) throws CompileException {
        if (!this.compileGetValue(al.lhs).isArray()) {
            this.compileError("Cannot determine length of non-array type", al.getLocation());
        }
        return 1;
    }

    private int compileContext2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass indexType;
        IClass lhsType = this.compileGetValue(aae.lhs);
        if (!lhsType.isArray()) {
            this.compileError("Subscript not allowed on non-array type \"" + lhsType.toString() + "\"", aae.getLocation());
        }
        if (!this.tryIdentityConversion(indexType = this.compileGetValue(aae.index), IClass.INT) && !this.tryWideningPrimitiveConversion(aae, indexType, IClass.INT)) {
            this.compileError("Index expression of type \"" + indexType + "\" cannot be widened to \"int\"", aae.getLocation());
        }
        return 2;
    }

    private int compileContext2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.compileContext(fae.value);
    }

    private int compileContext2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.compileContext(scfae.value);
    }

    private int compileContext2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileContext(pe.value);
    }

    private IClass compileGet(Java.Rvalue rv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final IClass[] res = new IClass[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.compileGet2(al);
            }

            public void visitAssignment(Java.Assignment a) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(a);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(uo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(bo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(cl);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(ce);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCrement(Java.Crement c) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitInstanceof(Java.Instanceof io) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(io);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(mi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(smi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLiteral(Java.Literal l) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(l);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(naci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewArray(Java.NewArray na) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(na);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(nia);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(nci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(pa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(qtr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitThisReference(Java.ThisReference tr) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(tr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(aae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(fae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(scfae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.compileGet2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private IClass compileGet2(Java.BooleanRvalue brv) throws CompileException {
        CodeContext.Offset isTrue = this.codeContext.new CodeContext.Offset();
        this.compileBoolean(brv, isTrue, true);
        this.writeOpcode(brv, 3);
        CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
        this.writeBranch(brv, -89, end);
        isTrue.set();
        this.writeOpcode(brv, 4);
        end.set();
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.AmbiguousName an) throws CompileException {
        return this.compileGet(this.toRvalueOrCE(this.reclassify(an)));
    }

    private IClass compileGet2(Java.LocalVariableAccess lva) {
        return this.load(lva, lva.localVariable);
    }

    private IClass compileGet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingBlockStatement());
        if (fa.field.isStatic()) {
            this.writeOpcode(fa, -78);
        } else {
            this.writeOpcode(fa, -76);
        }
        this.writeConstantFieldrefInfo(fa.field.getDeclaringIClass().getDescriptor(), fa.field.getName(), fa.field.getType().getDescriptor());
        return fa.field.getType();
    }

    private IClass compileGet2(Java.ArrayLength al) {
        this.writeOpcode(al, -66);
        return IClass.INT;
    }

    private IClass compileGet2(Java.ThisReference tr) throws CompileException {
        this.referenceThis(tr);
        return this.getIClass(tr);
    }

    private IClass compileGet2(Java.QualifiedThisReference qtr) throws CompileException {
        this.referenceThis(qtr, this.getDeclaringClass(qtr), this.getDeclaringTypeBodyDeclaration(qtr), this.getTargetIClass(qtr));
        return this.getTargetIClass(qtr);
    }

    private IClass compileGet2(Java.ClassLiteral cl) throws CompileException {
        String classDollarFieldName;
        List statics;
        Location loc = cl.getLocation();
        IClassLoader icl = this.iClassLoader;
        IClass iClass = this.getType(cl.type);
        if (iClass.isPrimitive()) {
            String wrapperClassDescriptor;
            this.writeOpcode(cl, -78);
            String string = iClass == IClass.VOID ? "Ljava/lang/Void;" : (iClass == IClass.BYTE ? "Ljava/lang/Byte;" : (iClass == IClass.CHAR ? "Ljava/lang/Character;" : (iClass == IClass.DOUBLE ? "Ljava/lang/Double;" : (iClass == IClass.FLOAT ? "Ljava/lang/Float;" : (iClass == IClass.INT ? "Ljava/lang/Integer;" : (iClass == IClass.LONG ? "Ljava/lang/Long;" : (iClass == IClass.SHORT ? "Ljava/lang/Short;" : (wrapperClassDescriptor = iClass == IClass.BOOLEAN ? "Ljava/lang/Boolean;" : null))))))));
            if (wrapperClassDescriptor == null) {
                throw new JaninoRuntimeException("SNO: Unidentifiable primitive type \"" + iClass + "\"");
            }
            this.writeConstantFieldrefInfo(wrapperClassDescriptor, "TYPE", "Ljava/lang/Class;");
            return icl.CLASS;
        }
        Java.Scope s = cl.getEnclosingBlockStatement();
        while (true) {
            if (s instanceof Java.TypeDeclaration) break;
            s = s.getEnclosingScope();
        }
        Java.AbstractTypeDeclaration declaringType = (Java.AbstractTypeDeclaration)s;
        if (declaringType.getMethodDeclaration("class$") == null) {
            this.declareClassDollarMethod(cl);
        }
        if (declaringType instanceof Java.ClassDeclaration) {
            statics = ((Java.ClassDeclaration)declaringType).variableDeclaratorsAndInitializers;
        } else if (declaringType instanceof Java.InterfaceDeclaration) {
            statics = ((Java.InterfaceDeclaration)declaringType).constantDeclarations;
        } else {
            throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
        }
        String className = Descriptor.toClassName(iClass.getDescriptor());
        if (className.startsWith("[")) {
            classDollarFieldName = "array" + className.replace('.', '$').replace('[', '$');
            if (classDollarFieldName.endsWith(";")) {
                classDollarFieldName = classDollarFieldName.substring(0, classDollarFieldName.length() - 1);
            }
        } else {
            classDollarFieldName = "class$" + className.replace('.', '$');
        }
        boolean hasClassDollarField = false;
        Iterator it = statics.iterator();
        block1: while (it.hasNext()) {
            Java.TypeBodyDeclaration tbd = (Java.TypeBodyDeclaration)it.next();
            if (!tbd.isStatic() || !(tbd instanceof Java.FieldDeclaration)) continue;
            Java.FieldDeclaration fd = (Java.FieldDeclaration)tbd;
            IClass.IField[] fds = this.getIFields(fd);
            for (int j = 0; j < fds.length; ++j) {
                if (!fds[j].getName().equals(classDollarFieldName)) continue;
                hasClassDollarField = true;
                break block1;
            }
        }
        if (!hasClassDollarField) {
            Java.SimpleType classType = new Java.SimpleType(loc, icl.CLASS);
            Java.FieldDeclaration fd = new Java.FieldDeclaration(loc, null, 8, classType, new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, classDollarFieldName, 0, null)});
            if (declaringType instanceof Java.ClassDeclaration) {
                ((Java.ClassDeclaration)declaringType).addVariableDeclaratorOrInitializer(fd);
            } else if (declaringType instanceof Java.InterfaceDeclaration) {
                ((Java.InterfaceDeclaration)declaringType).addConstantDeclaration(fd);
            } else {
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }
        }
        Java.SimpleType declaringClassOrInterfaceType = new Java.SimpleType(loc, this.resolve(declaringType));
        Java.FieldAccessExpression classDollarFieldAccess = new Java.FieldAccessExpression(loc, declaringClassOrInterfaceType, classDollarFieldName);
        Java.ConditionalExpression ce = new Java.ConditionalExpression(loc, new Java.BinaryOperation(loc, classDollarFieldAccess, "!=", new Java.Literal(loc, null)), classDollarFieldAccess, new Java.Assignment(loc, classDollarFieldAccess, "=", new Java.MethodInvocation(loc, declaringClassOrInterfaceType, "class$", new Java.Rvalue[]{new Java.Literal(loc, className)})));
        ce.setEnclosingBlockStatement(cl.getEnclosingBlockStatement());
        return this.compileGet(ce);
    }

    private IClass compileGet2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            int lhsCS = this.compileContext(a.lhs);
            IClass rhsType = this.compileGetValue(a.rhs);
            IClass lhsType = this.getType(a.lhs);
            Object rhsCV = this.getConstantValue(a.rhs);
            this.assignmentConversion(a, rhsType, lhsType, rhsCV);
            this.dupx(a, lhsType, lhsCS);
            this.compileSet(a.lhs);
            return lhsType;
        }
        int lhsCS = this.compileContext(a.lhs);
        this.dup(a, lhsCS);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!this.tryIdentityConversion(resultType, lhsType) && !this.tryNarrowingPrimitiveConversion(a, resultType, lhsType)) {
            throw new JaninoRuntimeException("SNO: \"" + a.operator + "\" reconversion failed");
        }
        this.dupx(a, lhsType, lhsCS);
        this.compileSet(a.lhs);
        return lhsType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IClass compileGet2(Java.ConditionalExpression ce) throws CompileException {
        IClass expressionType;
        CodeContext.Inserter rhsConvertInserter;
        IClass rhsType;
        CodeContext.Inserter mhsConvertInserter;
        IClass mhsType;
        CodeContext.Offset toEnd = this.codeContext.new CodeContext.Offset();
        Object cv = this.getConstantValue(ce.lhs);
        if (cv instanceof Boolean) {
            if (((Boolean)cv).booleanValue()) {
                mhsType = this.compileGetValue(ce.mhs);
                mhsConvertInserter = this.codeContext.newInserter();
                rhsType = this.getType(ce.rhs);
                rhsConvertInserter = null;
            } else {
                mhsType = this.getType(ce.mhs);
                mhsConvertInserter = null;
                rhsType = this.compileGetValue(ce.rhs);
                rhsConvertInserter = this.codeContext.currentInserter();
            }
        } else {
            CodeContext.Offset toRhs = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(ce.lhs, toRhs, false);
            mhsType = this.compileGetValue(ce.mhs);
            mhsConvertInserter = this.codeContext.newInserter();
            this.writeBranch(ce, -89, toEnd);
            toRhs.set();
            rhsType = this.compileGetValue(ce.rhs);
            rhsConvertInserter = this.codeContext.currentInserter();
        }
        if (mhsType == rhsType) {
            expressionType = mhsType;
        } else if (mhsType.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
            expressionType = this.binaryNumericPromotion(ce, mhsType, mhsConvertInserter, rhsType, rhsConvertInserter);
        } else if (this.getConstantValue(ce.mhs) == Java.Rvalue.CONSTANT_VALUE_NULL && !rhsType.isPrimitive()) {
            expressionType = rhsType;
        } else if (!mhsType.isPrimitive() && this.getConstantValue(ce.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL) {
            expressionType = mhsType;
        } else if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
            if (mhsType.isAssignableFrom(rhsType)) {
                expressionType = mhsType;
            } else {
                if (!rhsType.isAssignableFrom(mhsType)) {
                    this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
                    return this.iClassLoader.OBJECT;
                }
                expressionType = rhsType;
            }
        } else {
            this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
            return this.iClassLoader.OBJECT;
        }
        toEnd.set();
        return expressionType;
    }

    private IClass compileGet2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLV(c);
        if (lv != null) {
            if (!c.pre) {
                this.load(c, lv);
            }
            this.compileLocalVariableCrement(c, lv);
            if (c.pre) {
                this.load(c, lv);
            }
            return lv.type;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        if (!c.pre) {
            this.dupx(c, type, cs);
        }
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        if (c.pre) {
            this.dupx(c, type, cs);
        }
        this.compileSet(c.operand);
        return type;
    }

    private void compileLocalVariableCrement(Java.Crement c, Java.LocalVariable lv) {
        if (lv.getSlotIndex() > 255) {
            this.writeOpcode(c, -60);
            this.writeOpcode(c, -124);
            this.writeShort(lv.getSlotIndex());
            this.writeShort(c.operator == "++" ? 1 : -1);
        } else {
            this.writeOpcode(c, -124);
            this.writeByte(lv.getSlotIndex());
            this.writeByte(c.operator == "++" ? 1 : -1);
        }
    }

    private IClass compileGet2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass lhsComponentType = this.getType(aae);
        this.writeOpcode(aae, 46 + UnitCompiler.ilfdabcs(lhsComponentType));
        return lhsComponentType;
    }

    private IClass compileGet2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.compileGet(fae.value);
    }

    private IClass compileGet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.compileGet(scfae.value);
    }

    private IClass compileGet2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return this.compileGet2((Java.BooleanRvalue)uo);
        }
        if (uo.operator == "+") {
            return this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
        }
        if (uo.operator == "-") {
            if (uo.operand instanceof Java.Literal) {
                Java.Literal l = (Java.Literal)uo.operand;
                this.pushConstant(uo, this.getNegatedConstantValue2(l));
                return this.unaryNumericPromotion(uo, this.getType2(l));
            }
            IClass promotedType = this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
            this.writeOpcode(uo, 116 + UnitCompiler.ilfd(promotedType));
            return promotedType;
        }
        if (uo.operator == "~") {
            IClass operandType = this.compileGetValue(uo.operand);
            IClass promotedType = this.unaryNumericPromotion(uo, operandType);
            if (promotedType == IClass.INT) {
                this.writeOpcode(uo, 2);
                this.writeOpcode(uo, -126);
                return IClass.INT;
            }
            if (promotedType == IClass.LONG) {
                this.writeOpcode(uo, 20);
                this.writeConstantLongInfo(-1L);
                this.writeOpcode(uo, -125);
                return IClass.LONG;
            }
            this.compileError("Operator \"~\" not applicable to type \"" + promotedType + "\"", uo.getLocation());
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return this.iClassLoader.OBJECT;
    }

    private IClass compileGet2(Java.Instanceof io) throws CompileException {
        IClass lhsType = this.compileGetValue(io.lhs);
        IClass rhsType = this.getType(io.rhs);
        if (lhsType.isInterface() || rhsType.isInterface() || lhsType.isAssignableFrom(rhsType) || rhsType.isAssignableFrom(lhsType)) {
            this.writeOpcode(io, -63);
            this.writeConstantClassInfo(rhsType.getDescriptor());
        } else {
            this.compileError("\"" + lhsType + "\" can never be an instance of \"" + rhsType + "\"", io.getLocation());
        }
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return this.compileGet2((Java.BooleanRvalue)bo);
        }
        return this.compileArithmeticOperation(bo, null, bo.unrollLeftAssociation(), bo.op);
    }

    private IClass compileGet2(Java.Cast c) throws CompileException {
        IClass tt = this.getType(c.targetType);
        IClass vt = this.compileGetValue(c.value);
        if (!(this.tryIdentityConversion(vt, tt) || this.tryWideningPrimitiveConversion(c, vt, tt) || this.tryNarrowingPrimitiveConversion(c, vt, tt) || this.tryWideningReferenceConversion(vt, tt) || this.tryNarrowingReferenceConversion(c, vt, tt) || this.tryBoxingConversion(c, vt, tt) || this.tryUnboxingConversion(c, vt, tt))) {
            this.compileError("Cannot cast \"" + vt + "\" to \"" + tt + "\"", c.getLocation());
        }
        return tt;
    }

    private IClass compileGet2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileGet(pe.value);
    }

    private IClass compileGet2(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod = this.findIMethod(mi);
        if (mi.optionalTarget == null) {
            Java.Scope s = mi.getEnclosingBlockStatement();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeBodyDeclaration scopeTBD = (Java.TypeBodyDeclaration)s;
            if (!(s instanceof Java.ClassDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.ClassDeclaration scopeClassDeclaration = (Java.ClassDeclaration)s;
            if (iMethod.isStatic()) {
                this.warning("IASM", "Implicit access to static method \"" + iMethod.toString() + "\"", mi.getLocation());
            } else {
                this.warning("IANSM", "Implicit access to non-static method \"" + iMethod.toString() + "\"", mi.getLocation());
                if (scopeTBD.isStatic()) {
                    this.compileError("Instance method \"" + iMethod.toString() + "\" cannot be invoked in static context", mi.getLocation());
                }
                this.referenceThis(mi, scopeClassDeclaration, scopeTBD, iMethod.getDeclaringIClass());
            }
        } else {
            boolean staticContext = this.isType(mi.optionalTarget);
            if (staticContext) {
                this.getType(this.toTypeOrCE(mi.optionalTarget));
            } else {
                this.compileGetValue(this.toRvalueOrCE(mi.optionalTarget));
            }
            if (iMethod.isStatic()) {
                if (!staticContext) {
                    this.pop(mi.optionalTarget, this.getType(mi.optionalTarget));
                }
            } else if (staticContext) {
                this.compileError("Instance method \"" + mi.methodName + "\" cannot be invoked in static context", mi.getLocation());
            }
        }
        IClass[] parameterTypes = iMethod.getParameterTypes();
        for (int i = 0; i < mi.arguments.length; ++i) {
            this.assignmentConversion(mi, this.compileGetValue(mi.arguments[i]), parameterTypes[i], this.getConstantValue(mi.arguments[i]));
        }
        this.checkAccessible(iMethod, mi.getEnclosingBlockStatement());
        if (iMethod.getDeclaringIClass().isInterface()) {
            this.writeOpcode(mi, -71);
            this.writeConstantInterfaceMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
            IClass[] pts = iMethod.getParameterTypes();
            int count = 1;
            for (int i = 0; i < pts.length; ++i) {
                count += Descriptor.size(pts[i].getDescriptor());
            }
            this.writeByte(count);
            this.writeByte(0);
        } else if (!iMethod.isStatic() && iMethod.getAccess() == Access.PRIVATE) {
            this.writeOpcode(mi, -72);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName() + '$', MethodDescriptor.prependParameter(iMethod.getDescriptor(), iMethod.getDeclaringIClass().getDescriptor()));
        } else {
            int opcode = iMethod.isStatic() ? -72 : -74;
            this.writeOpcode(mi, opcode);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
        }
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        Java.FunctionDeclarator fd;
        IClass.IMethod iMethod = this.findIMethod(scmi);
        Java.Scope s = scmi.getEnclosingBlockStatement();
        while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        Java.FunctionDeclarator functionDeclarator = fd = s instanceof Java.FunctionDeclarator ? (Java.FunctionDeclarator)s : null;
        if (fd == null) {
            this.compileError("Cannot invoke superclass method in non-method scope", scmi.getLocation());
            return IClass.INT;
        }
        if ((fd.modifiers & 8) != 0) {
            this.compileError("Cannot invoke superclass method in static context", scmi.getLocation());
        }
        this.load(scmi, this.resolve(fd.getDeclaringType()), 0);
        IClass[] parameterTypes = iMethod.getParameterTypes();
        for (int i = 0; i < scmi.arguments.length; ++i) {
            this.assignmentConversion(scmi, this.compileGetValue(scmi.arguments[i]), parameterTypes[i], this.getConstantValue(scmi.arguments[i]));
        }
        this.writeOpcode(scmi, -73);
        this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), scmi.methodName, iMethod.getDescriptor());
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.NewClassInstance nci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        if (nci.iClass == null) {
            nci.iClass = this.getType(nci.type);
        }
        this.writeOpcode(nci, -69);
        this.writeConstantClassInfo(nci.iClass.getDescriptor());
        this.writeOpcode(nci, 89);
        if (nci.iClass.isInterface()) {
            this.compileError("Cannot instantiate \"" + nci.iClass + "\"", nci.getLocation());
        }
        this.checkAccessible(nci.iClass, nci.getEnclosingBlockStatement());
        if (nci.iClass.isAbstract()) {
            this.compileError("Cannot instantiate abstract \"" + nci.iClass + "\"", nci.getLocation());
        }
        if (nci.optionalQualification != null) {
            if (nci.iClass.getOuterIClass() == null) {
                this.compileError("Static member class cannot be instantiated with qualified NEW");
            }
            optionalEnclosingInstance = nci.optionalQualification;
        } else {
            Java.Scope s = nci.getEnclosingBlockStatement();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeBodyDeclaration enclosingTypeBodyDeclaration = (Java.TypeBodyDeclaration)s;
            Java.TypeDeclaration enclosingTypeDeclaration = (Java.TypeDeclaration)s.getEnclosingScope();
            if (!(enclosingTypeDeclaration instanceof Java.ClassDeclaration) || enclosingTypeBodyDeclaration.isStatic()) {
                if (nci.iClass.getOuterIClass() != null) {
                    this.compileError("Instantiation of \"" + nci.type + "\" requires an enclosing instance", nci.getLocation());
                }
                optionalEnclosingInstance = null;
            } else {
                IClass optionalOuterIClass = nci.iClass.getDeclaringIClass();
                if (optionalOuterIClass == null) {
                    optionalEnclosingInstance = null;
                } else {
                    optionalEnclosingInstance = new Java.QualifiedThisReference(nci.getLocation(), new Java.SimpleType(nci.getLocation(), optionalOuterIClass));
                    optionalEnclosingInstance.setEnclosingBlockStatement(nci.getEnclosingBlockStatement());
                }
            }
        }
        this.invokeConstructor(nci, nci.getEnclosingBlockStatement(), optionalEnclosingInstance, nci.iClass, nci.arguments);
        return nci.iClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileGet2(Java.NewAnonymousClassInstance naci) throws CompileException {
        Java.AnonymousClassDeclaration acd = naci.anonymousClassDeclaration;
        IClass sc = this.resolve(acd).getSuperclass();
        IClass.IInvocable[] iConstructors = sc.getDeclaredIConstructors();
        if (iConstructors.length == 0) {
            throw new JaninoRuntimeException("SNO: Base class has no constructors");
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(naci, iConstructors, naci.arguments, acd);
        IClass[] pts = iConstructor.getParameterTypes();
        Location loc = naci.getLocation();
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        if (naci.optionalQualification != null) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, this.getType(naci.optionalQualification)), "this$base"));
        }
        for (int i = 0; i < pts.length; ++i) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, pts[i]), "p" + i));
        }
        Java.FunctionDeclarator.FormalParameter[] fps = l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]);
        IClass[] tes = iConstructor.getThrownExceptions();
        Java.Type[] tets = new Java.Type[tes.length];
        for (int i = 0; i < tes.length; ++i) {
            tets[i] = new Java.SimpleType(loc, tes[i]);
        }
        int j = 0;
        Java.ParameterAccess optionalQualificationAccess = naci.optionalQualification == null ? null : new Java.ParameterAccess(loc, fps[j++]);
        Java.Rvalue[] parameterAccesses = new Java.Rvalue[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            parameterAccesses[i] = new Java.ParameterAccess(loc, fps[j++]);
        }
        Java.ConstructorDeclarator anonymousConstructor = new Java.ConstructorDeclarator(loc, null, 0, fps, tets, new Java.SuperConstructorInvocation(loc, optionalQualificationAccess, parameterAccesses), Collections.EMPTY_LIST);
        acd.addConstructor(anonymousConstructor);
        try {
            Java.ThisReference oei;
            Java.Rvalue[] arguments2;
            this.compile(acd);
            this.writeOpcode(naci, -69);
            this.writeConstantClassInfo(this.resolve(naci.anonymousClassDeclaration).getDescriptor());
            this.writeOpcode(naci, 89);
            if (naci.optionalQualification == null) {
                arguments2 = naci.arguments;
            } else {
                arguments2 = new Java.Rvalue[naci.arguments.length + 1];
                arguments2[0] = naci.optionalQualification;
                System.arraycopy(naci.arguments, 0, arguments2, 1, naci.arguments.length);
            }
            Java.Scope s = naci.getEnclosingBlockStatement();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            if (((Java.TypeBodyDeclaration)s).isStatic()) {
                oei = null;
            } else {
                oei = new Java.ThisReference(loc);
                oei.setEnclosingBlockStatement(naci.getEnclosingBlockStatement());
            }
            this.invokeConstructor(naci, naci.getEnclosingBlockStatement(), oei, this.resolve(naci.anonymousClassDeclaration), arguments2);
        }
        finally {
            acd.constructors.remove(acd.constructors.size() - 1);
        }
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass compileGet2(Java.ParameterAccess pa) throws CompileException {
        Java.LocalVariable lv = this.getLocalVariable(pa.formalParameter);
        this.load(pa, lv);
        return lv.type;
    }

    private IClass compileGet2(Java.NewArray na) throws CompileException {
        for (int i = 0; i < na.dimExprs.length; ++i) {
            IClass dimType = this.compileGetValue(na.dimExprs[i]);
            if (dimType == IClass.INT || this.unaryNumericPromotion(na, dimType) == IClass.INT) continue;
            this.compileError("Invalid array size expression type", na.getLocation());
        }
        return this.newArray(na, na.dimExprs.length, na.dims, this.getType(na.type));
    }

    private IClass compileGet2(Java.NewInitializedArray nia) throws CompileException {
        IClass at = this.getType(nia.arrayType);
        this.compileGetValue(nia.arrayInitializer, at);
        return at;
    }

    private void compileGetValue(Java.ArrayInitializer ai, IClass arrayType) throws CompileException {
        if (!arrayType.isArray()) {
            this.compileError("Array initializer not allowed for non-array type \"" + arrayType.toString() + "\"");
        }
        IClass ct = arrayType.getComponentType();
        this.pushConstant(ai, new Integer(ai.values.length));
        this.newArray(ai, 1, 0, ct);
        for (int i = 0; i < ai.values.length; ++i) {
            this.writeOpcode(ai, 89);
            this.pushConstant(ai, new Integer(i));
            Java.ArrayInitializerOrRvalue aiorv = ai.values[i];
            if (aiorv instanceof Java.Rvalue) {
                Java.Rvalue rv = (Java.Rvalue)aiorv;
                this.assignmentConversion(ai, this.compileGetValue(rv), ct, this.getConstantValue(rv));
            } else if (aiorv instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)aiorv, ct);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + aiorv.getClass().getName());
            }
            this.writeOpcode(ai, 79 + UnitCompiler.ilfdabcs(ct));
        }
    }

    private IClass compileGet2(Java.Literal l) throws CompileException {
        if (l.value == Scanner.MAGIC_INTEGER || l.value == Scanner.MAGIC_LONG) {
            this.compileError("This literal value may only appear in a negated context", l.getLocation());
        }
        return this.pushConstant(l, l.value == null ? Java.Rvalue.CONSTANT_VALUE_NULL : l.value);
    }

    private IClass compileGetValue(Java.Rvalue rv) throws CompileException {
        Object cv = this.getConstantValue(rv);
        if (cv != null) {
            this.fakeCompile(rv);
            this.pushConstant(rv, cv);
            return this.getType(rv);
        }
        this.compileContext(rv);
        return this.compileGet(rv);
    }

    public final Object getConstantValue(Java.Rvalue rv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        if (rv.constantValue != Java.Rvalue.CONSTANT_VALUE_UNKNOWN) {
            return rv.constantValue;
        }
        final Object[] res = new Object[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.getConstantValue2(al);
            }

            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.getConstantValue2(a);
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(uo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(bo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.getConstantValue2(cl);
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(ce);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.getConstantValue2(c);
            }

            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.getConstantValue2(io);
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.getConstantValue2(mi);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.getConstantValue2(smi);
            }

            public void visitLiteral(Java.Literal l) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(l);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.getConstantValue2(naci);
            }

            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.getConstantValue2(na);
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.getConstantValue2(nia);
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.getConstantValue2(nci);
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.getConstantValue2(pa);
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.getConstantValue2(qtr);
            }

            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.getConstantValue2(tr);
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                res[0] = UnitCompiler.this.getConstantValue2(aae);
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                res[0] = UnitCompiler.this.getConstantValue2(fae);
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                res[0] = UnitCompiler.this.getConstantValue2(scfae);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.getConstantValue2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            rv.constantValue = res[0];
            return rv.constantValue;
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private Object getConstantValue2(Java.Rvalue rv) {
        return null;
    }

    private Object getConstantValue2(Java.AmbiguousName an) throws CompileException {
        return this.getConstantValue(this.toRvalueOrCE(this.reclassify(an)));
    }

    private Object getConstantValue2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getConstantValue();
    }

    private Object getConstantValue2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator.equals("+")) {
            return this.getConstantValue(uo.operand);
        }
        if (uo.operator.equals("-")) {
            return this.getNegatedConstantValue(uo.operand);
        }
        if (uo.operator.equals("!")) {
            Object cv = this.getConstantValue(uo.operand);
            return cv instanceof Boolean ? (((Boolean)cv).booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
        }
        return null;
    }

    private Object getConstantValue2(Java.ConditionalExpression ce) throws CompileException {
        Object lhsValue = this.getConstantValue(ce.lhs);
        if (lhsValue instanceof Boolean) {
            return (Boolean)lhsValue != false ? this.getConstantValue(ce.mhs) : this.getConstantValue(ce.rhs);
        }
        return null;
    }

    private Object getConstantValue2(Java.BinaryOperation bo) throws CompileException {
        Object lhsValue;
        if ((bo.op == "==" || bo.op == "!=") && this.getConstantValue(bo.lhs) == Java.Rvalue.CONSTANT_VALUE_NULL && this.getConstantValue(bo.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL) {
            return bo.op == "==" ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bo.op == "|" || bo.op == "^" || bo.op == "&" || bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-") {
            ArrayList<Object> cvs = new ArrayList<Object>();
            Iterator it = bo.unrollLeftAssociation();
            while (it.hasNext()) {
                Object cv = this.getConstantValue((Java.Rvalue)it.next());
                if (cv == null) {
                    return null;
                }
                cvs.add(cv);
            }
            it = cvs.iterator();
            Object lhs = it.next();
            while (it.hasNext()) {
                Object rhs = it.next();
                if (bo.op == "+" && (lhs instanceof String || rhs instanceof String)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(lhs.toString()).append(rhs.toString());
                    while (it.hasNext()) {
                        sb.append(it.next().toString());
                    }
                    return sb.toString();
                }
                if (!(lhs instanceof Number) || !(rhs instanceof Number)) {
                    return null;
                }
                try {
                    if (lhs instanceof Double || rhs instanceof Double) {
                        double lhsD = ((Number)lhs).doubleValue();
                        double rhsD = ((Number)rhs).doubleValue();
                        lhs = bo.op == "*" ? new Double(lhsD * rhsD) : (bo.op == "/" ? new Double(lhsD / rhsD) : (bo.op == "%" ? new Double(lhsD % rhsD) : (bo.op == "+" ? new Double(lhsD + rhsD) : (bo.op == "-" ? new Double(lhsD - rhsD) : null))));
                    } else if (lhs instanceof Float || rhs instanceof Float) {
                        float lhsF = ((Number)lhs).floatValue();
                        float rhsF = ((Number)rhs).floatValue();
                        lhs = bo.op == "*" ? new Float(lhsF * rhsF) : (bo.op == "/" ? new Float(lhsF / rhsF) : (bo.op == "%" ? new Float(lhsF % rhsF) : (bo.op == "+" ? new Float(lhsF + rhsF) : (bo.op == "-" ? new Float(lhsF - rhsF) : null))));
                    } else if (lhs instanceof Long || rhs instanceof Long) {
                        long lhsL = ((Number)lhs).longValue();
                        long rhsL = ((Number)rhs).longValue();
                        lhs = bo.op == "|" ? new Long(lhsL | rhsL) : (bo.op == "^" ? new Long(lhsL ^ rhsL) : (bo.op == "&" ? new Long(lhsL & rhsL) : (bo.op == "*" ? new Long(lhsL * rhsL) : (bo.op == "/" ? new Long(lhsL / rhsL) : (bo.op == "%" ? new Long(lhsL % rhsL) : (bo.op == "+" ? new Long(lhsL + rhsL) : (bo.op == "-" ? new Long(lhsL - rhsL) : null)))))));
                    } else {
                        int lhsI = ((Number)lhs).intValue();
                        int rhsI = ((Number)rhs).intValue();
                        Number number = bo.op == "|" ? new Integer(lhsI | rhsI) : (bo.op == "^" ? new Integer(lhsI ^ rhsI) : (bo.op == "&" ? new Integer(lhsI & rhsI) : (bo.op == "*" ? new Integer(lhsI * rhsI) : (bo.op == "/" ? new Integer(lhsI / rhsI) : (bo.op == "%" ? new Integer(lhsI % rhsI) : (bo.op == "+" ? new Integer(lhsI + rhsI) : (lhs = bo.op == "-" ? new Integer(lhsI - rhsI) : null)))))));
                    }
                    if (lhs != null) continue;
                    return null;
                }
                catch (ArithmeticException ae) {
                    return null;
                }
            }
            return lhs;
        }
        if ((bo.op == "&&" || bo.op == "||") && (lhsValue = this.getConstantValue(bo.lhs)) instanceof Boolean) {
            boolean lhsBV = (Boolean)lhsValue;
            return bo.op == "&&" ? (lhsBV ? this.getConstantValue(bo.rhs) : Boolean.FALSE) : (lhsBV ? Boolean.TRUE : this.getConstantValue(bo.rhs));
        }
        return null;
    }

    private Object getConstantValue2(Java.Cast c) throws CompileException {
        Object cv = this.getConstantValue(c.value);
        if (cv == null) {
            return null;
        }
        if (cv instanceof Number) {
            IClass tt = this.getType(c.targetType);
            if (tt == IClass.BYTE) {
                return new Byte(((Number)cv).byteValue());
            }
            if (tt == IClass.SHORT) {
                return new Short(((Number)cv).shortValue());
            }
            if (tt == IClass.INT) {
                return new Integer(((Number)cv).intValue());
            }
            if (tt == IClass.LONG) {
                return new Long(((Number)cv).longValue());
            }
            if (tt == IClass.FLOAT) {
                return new Float(((Number)cv).floatValue());
            }
            if (tt == IClass.DOUBLE) {
                return new Double(((Number)cv).doubleValue());
            }
        }
        return null;
    }

    private Object getConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getConstantValue(pe.value);
    }

    private Object getConstantValue2(Java.Literal l) throws CompileException {
        if (l.value == Scanner.MAGIC_INTEGER || l.value == Scanner.MAGIC_LONG) {
            this.compileError("This literal value may only appear in a negated context", l.getLocation());
        }
        return l.value == null ? Java.Rvalue.CONSTANT_VALUE_NULL : l.value;
    }

    private Object getNegatedConstantValue(Java.Rvalue rv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final Object[] res = new Object[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(al);
            }

            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(a);
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(uo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(bo);
            }

            public void visitCast(Java.Cast c) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(c);
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(cl);
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(ce);
            }

            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(c);
            }

            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(io);
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(mi);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(smi);
            }

            public void visitLiteral(Java.Literal l) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(l);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(naci);
            }

            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(na);
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(nia);
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(nci);
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(pa);
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(qtr);
            }

            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(tr);
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(an);
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(aae);
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(fa);
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(fae);
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(scfae);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.getNegatedConstantValue2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private Object getNegatedConstantValue2(Java.Rvalue rv) {
        return null;
    }

    private Object getNegatedConstantValue2(Java.UnaryOperation uo) throws CompileException {
        return uo.operator.equals("+") ? this.getNegatedConstantValue(uo.operand) : (uo.operator.equals("-") ? this.getConstantValue(uo.operand) : null);
    }

    private Object getNegatedConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getNegatedConstantValue(pe.value);
    }

    private Object getNegatedConstantValue2(Java.Literal l) throws CompileException {
        if (l.value instanceof Byte) {
            return new Byte(-((Byte)l.value).byteValue());
        }
        if (l.value instanceof Short) {
            return new Short(-((Short)l.value).shortValue());
        }
        if (l.value instanceof Integer) {
            return new Integer(-((Integer)l.value).intValue());
        }
        if (l.value instanceof Long) {
            return new Long(-((Long)l.value).longValue());
        }
        if (l.value instanceof Float) {
            return new Float(-((Float)l.value).floatValue());
        }
        if (l.value instanceof Double) {
            return new Double(-((Double)l.value).doubleValue());
        }
        this.compileError("Cannot negate this literal", l.getLocation());
        return null;
    }

    private boolean generatesCode(Java.BlockStatement bs) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final boolean[] res = new boolean[1];
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            public void visitInitializer(Java.Initializer i) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(i);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(fd);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLabeledStatement(Java.LabeledStatement ls) {
                res[0] = UnitCompiler.this.generatesCode2(ls);
            }

            public void visitBlock(Java.Block b) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(b);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitExpressionStatement(Java.ExpressionStatement es) {
                res[0] = UnitCompiler.this.generatesCode2(es);
            }

            public void visitIfStatement(Java.IfStatement is) {
                res[0] = UnitCompiler.this.generatesCode2(is);
            }

            public void visitForStatement(Java.ForStatement fs) {
                res[0] = UnitCompiler.this.generatesCode2(fs);
            }

            public void visitWhileStatement(Java.WhileStatement ws) {
                res[0] = UnitCompiler.this.generatesCode2(ws);
            }

            public void visitTryStatement(Java.TryStatement ts) {
                res[0] = UnitCompiler.this.generatesCode2(ts);
            }

            public void visitSwitchStatement(Java.SwitchStatement ss) {
                res[0] = UnitCompiler.this.generatesCode2(ss);
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                res[0] = UnitCompiler.this.generatesCode2(ss);
            }

            public void visitDoStatement(Java.DoStatement ds) {
                res[0] = UnitCompiler.this.generatesCode2(ds);
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                res[0] = UnitCompiler.this.generatesCode2(lvds);
            }

            public void visitReturnStatement(Java.ReturnStatement rs) {
                res[0] = UnitCompiler.this.generatesCode2(rs);
            }

            public void visitThrowStatement(Java.ThrowStatement ts) {
                res[0] = UnitCompiler.this.generatesCode2(ts);
            }

            public void visitBreakStatement(Java.BreakStatement bs) {
                res[0] = UnitCompiler.this.generatesCode2(bs);
            }

            public void visitContinueStatement(Java.ContinueStatement cs) {
                res[0] = UnitCompiler.this.generatesCode2(cs);
            }

            public void visitEmptyStatement(Java.EmptyStatement es) {
                res[0] = UnitCompiler.this.generatesCode2(es);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                res[0] = UnitCompiler.this.generatesCode2(lcds);
            }

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                res[0] = UnitCompiler.this.generatesCode2(aci);
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                res[0] = UnitCompiler.this.generatesCode2(sci);
            }
        };
        try {
            bs.accept(bsv);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    public boolean generatesCode2(Java.BlockStatement bs) {
        return true;
    }

    public boolean generatesCode2(Java.EmptyStatement es) {
        return false;
    }

    public boolean generatesCode2(Java.LocalClassDeclarationStatement lcds) {
        return false;
    }

    public boolean generatesCode2(Java.Initializer i) throws CompileException {
        return this.generatesCode(i.block);
    }

    public boolean generatesCode2ListStatements(List l) throws CompileException {
        for (int i = 0; i < l.size(); ++i) {
            if (!this.generatesCode((Java.BlockStatement)l.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean generatesCode2(Java.Block b) throws CompileException {
        return this.generatesCode2ListStatements(b.statements);
    }

    public boolean generatesCode2(Java.FieldDeclaration fd) throws CompileException {
        for (int i = 0; i < fd.variableDeclarators.length; ++i) {
            Java.VariableDeclarator vd = fd.variableDeclarators[i];
            if (this.getNonConstantFinalInitializer(fd, vd) == null) continue;
            return true;
        }
        return false;
    }

    private void leave(Java.BlockStatement bs, final IClass optionalStackValueType) {
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            public void visitInitializer(Java.Initializer i) {
                UnitCompiler.this.leave2(i, optionalStackValueType);
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.this.leave2(fd, optionalStackValueType);
            }

            public void visitLabeledStatement(Java.LabeledStatement ls) {
                UnitCompiler.this.leave2(ls, optionalStackValueType);
            }

            public void visitBlock(Java.Block b) {
                UnitCompiler.this.leave2(b, optionalStackValueType);
            }

            public void visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
            }

            public void visitIfStatement(Java.IfStatement is) {
                UnitCompiler.this.leave2(is, optionalStackValueType);
            }

            public void visitForStatement(Java.ForStatement fs) {
                UnitCompiler.this.leave2(fs, optionalStackValueType);
            }

            public void visitWhileStatement(Java.WhileStatement ws) {
                UnitCompiler.this.leave2(ws, optionalStackValueType);
            }

            public void visitTryStatement(Java.TryStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
            }

            public void visitSwitchStatement(Java.SwitchStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
            }

            public void visitDoStatement(Java.DoStatement ds) {
                UnitCompiler.this.leave2(ds, optionalStackValueType);
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                UnitCompiler.this.leave2(lvds, optionalStackValueType);
            }

            public void visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.this.leave2(rs, optionalStackValueType);
            }

            public void visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
            }

            public void visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.this.leave2(bs, optionalStackValueType);
            }

            public void visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.this.leave2(cs, optionalStackValueType);
            }

            public void visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.this.leave2(lcds, optionalStackValueType);
            }

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.this.leave2(aci, optionalStackValueType);
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.this.leave2(sci, optionalStackValueType);
            }
        };
        bs.accept(bsv);
    }

    public void leave2(Java.BlockStatement bs, IClass optionalStackValueType) {
    }

    public void leave2(Java.SynchronizedStatement ss, IClass optionalStackValueType) {
        this.load(ss, this.iClassLoader.OBJECT, ss.monitorLvIndex);
        this.writeOpcode(ss, -61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave2(Java.TryStatement ts, IClass optionalStackValueType) {
        if (ts.finallyOffset != null) {
            this.codeContext.saveLocalVariables();
            try {
                short sv = 0;
                if (optionalStackValueType != null) {
                    sv = this.codeContext.allocateLocalVariable(Descriptor.size(optionalStackValueType.getDescriptor()));
                    this.store((Java.Locatable)ts, optionalStackValueType, sv);
                }
                this.writeBranch(ts, -88, ts.finallyOffset);
                if (optionalStackValueType != null) {
                    this.load(ts, optionalStackValueType, sv);
                }
            }
            finally {
                this.codeContext.restoreLocalVariables();
            }
        }
    }

    private void compileSet(Java.Lvalue lv) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        Visitor.LvalueVisitor lvv = new Visitor.LvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compileSet2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compileSet2(aae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compileSet2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compileSet2(fae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compileSet2(scfae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                UnitCompiler.this.compileSet2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compileSet2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            lv.accept(lvv);
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private void compileSet2(Java.AmbiguousName an) throws CompileException {
        this.compileSet(this.toLvalueOrCE(this.reclassify(an)));
    }

    private void compileSet2(Java.LocalVariableAccess lva) {
        this.store((Java.Locatable)lva, lva.localVariable.type, lva.localVariable);
    }

    private void compileSet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingBlockStatement());
        this.writeOpcode(fa, fa.field.isStatic() ? -77 : -75);
        this.writeConstantFieldrefInfo(fa.field.getDeclaringIClass().getDescriptor(), fa.field.getName(), fa.field.getDescriptor());
    }

    private void compileSet2(Java.ArrayAccessExpression aae) throws CompileException {
        this.writeOpcode(aae, 79 + UnitCompiler.ilfdabcs(this.getType(aae)));
    }

    private void compileSet2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        this.compileSet(this.toLvalueOrCE(fae.value));
    }

    private void compileSet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        this.compileSet(this.toLvalueOrCE(scfae.value));
    }

    private void compileSet2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compileSet(this.toLvalueOrCE(pe.value));
    }

    private IClass getType(Java.Atom a) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final IClass[] res = new IClass[1];
        Visitor.AtomVisitor av = new Visitor.AtomVisitor(){

            public void visitPackage(Java.Package p) {
                try {
                    res[0] = UnitCompiler.this.getType2(p);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayType(Java.ArrayType at) {
                try {
                    res[0] = UnitCompiler.this.getType2(at);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBasicType(Java.BasicType bt) {
                res[0] = UnitCompiler.this.getType2(bt);
            }

            public void visitReferenceType(Java.ReferenceType rt) {
                try {
                    res[0] = UnitCompiler.this.getType2(rt);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitRvalueMemberType(Java.RvalueMemberType rmt) {
                try {
                    res[0] = UnitCompiler.this.getType2(rmt);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSimpleType(Java.SimpleType st) {
                res[0] = UnitCompiler.this.getType2(st);
            }

            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.getType2(al);
            }

            public void visitAssignment(Java.Assignment a) {
                try {
                    res[0] = UnitCompiler.this.getType2(a);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getType2(uo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.getType2(bo);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.getType2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.getType2(cl);
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.getType2(ce);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitCrement(Java.Crement c) {
                try {
                    res[0] = UnitCompiler.this.getType2(c);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.getType2(io);
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    res[0] = UnitCompiler.this.getType2(mi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    res[0] = UnitCompiler.this.getType2(smi);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLiteral(Java.Literal l) {
                res[0] = UnitCompiler.this.getType2(l);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.getType2(naci);
            }

            public void visitNewArray(Java.NewArray na) {
                try {
                    res[0] = UnitCompiler.this.getType2(na);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    res[0] = UnitCompiler.this.getType2(nia);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    res[0] = UnitCompiler.this.getType2(nci);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    res[0] = UnitCompiler.this.getType2(pa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    res[0] = UnitCompiler.this.getType2(qtr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitThisReference(Java.ThisReference tr) {
                try {
                    res[0] = UnitCompiler.this.getType2(tr);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.getType2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.getType2(aae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.getType2(fa);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.getType2(fae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.getType2(scfae);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.getType2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getType2(pe);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }
        };
        try {
            a.accept(av);
            return res[0] != null ? res[0] : this.iClassLoader.OBJECT;
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private IClass getType2(Java.SimpleType st) {
        return st.iClass;
    }

    private IClass getType2(Java.BasicType bt) {
        switch (bt.index) {
            case 0: {
                return IClass.VOID;
            }
            case 1: {
                return IClass.BYTE;
            }
            case 2: {
                return IClass.SHORT;
            }
            case 3: {
                return IClass.CHAR;
            }
            case 4: {
                return IClass.INT;
            }
            case 5: {
                return IClass.LONG;
            }
            case 6: {
                return IClass.FLOAT;
            }
            case 7: {
                return IClass.DOUBLE;
            }
            case 8: {
                return IClass.BOOLEAN;
            }
        }
        throw new JaninoRuntimeException("Invalid index " + bt.index);
    }

    private IClass getType2(Java.ReferenceType rt) throws CompileException {
        Java.BlockStatement scopeBlockStatement = null;
        Java.TypeDeclaration scopeTypeDeclaration = null;
        Java.Scope s = rt.getEnclosingScope();
        while (true) {
            if (s instanceof Java.BlockStatement && scopeBlockStatement == null) {
                scopeBlockStatement = (Java.BlockStatement)s;
            }
            if (s instanceof Java.TypeDeclaration && scopeTypeDeclaration == null) {
                scopeTypeDeclaration = (Java.TypeDeclaration)s;
            }
            if (s instanceof Java.CompilationUnit) break;
            s = s.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s;
        if (rt.identifiers.length == 1) {
            IClass importedClass;
            String simpleTypeName = rt.identifiers[0];
            Java.LocalClassDeclaration lcd = this.findLocalClassDeclaration(rt.getEnclosingScope(), simpleTypeName);
            if (lcd != null) {
                return this.resolve(lcd);
            }
            if (scopeTypeDeclaration != null) {
                Java.Scope s2 = scopeTypeDeclaration;
                while (!(s2 instanceof Java.CompilationUnit)) {
                    IClass mt;
                    if (s2 instanceof Java.TypeDeclaration && (mt = this.findMemberType(this.resolve((Java.AbstractTypeDeclaration)s2), simpleTypeName, rt.getLocation())) != null) {
                        return mt;
                    }
                    s2 = s2.getEnclosingScope();
                }
            }
            if ((importedClass = this.importSingleType(simpleTypeName, rt.getLocation())) != null) {
                return importedClass;
            }
            Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(simpleTypeName);
            if (pmtd != null) {
                return this.resolve((Java.AbstractTypeDeclaration)((Object)pmtd));
            }
            String pkg = scopeCompilationUnit.optionalPackageDeclaration == null ? null : scopeCompilationUnit.optionalPackageDeclaration.packageName;
            String className = pkg == null ? simpleTypeName : pkg + "." + simpleTypeName;
            IClass result = this.findClassByName(rt.getLocation(), className);
            if (result != null) {
                return result;
            }
            importedClass = this.importTypeOnDemand(simpleTypeName, rt.getLocation());
            if (importedClass != null) {
                return importedClass;
            }
            List l = (List)this.singleStaticImports.get(simpleTypeName);
            if (l != null) {
                IClass importedMemberType = null;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    IClass mt;
                    Object o = it.next();
                    if (!(o instanceof IClass) || !this.isAccessible(mt = (IClass)o, (Java.Scope)scopeBlockStatement)) continue;
                    if (importedMemberType != null && importedMemberType != mt) {
                        this.compileError("Ambiguous static imports: \"" + importedMemberType.toString() + "\" vs. \"" + mt.toString() + "\"");
                    }
                    importedMemberType = mt;
                }
                if (importedMemberType != null) {
                    return importedMemberType;
                }
            }
            IClass importedMemberType = null;
            Iterator it = this.staticImportsOnDemand.iterator();
            while (it.hasNext()) {
                IClass ic = (IClass)it.next();
                IClass[] memberTypes = ic.getDeclaredIClasses();
                for (int i = 0; i < memberTypes.length; ++i) {
                    IClass mt = memberTypes[i];
                    if (!this.isAccessible(mt, (Java.Scope)scopeBlockStatement) || !mt.getDescriptor().endsWith('$' + simpleTypeName + ';')) continue;
                    if (importedMemberType != null) {
                        this.compileError("Ambiguous static imports: \"" + importedMemberType.toString() + "\" vs. \"" + mt.toString() + "\"");
                    }
                    importedMemberType = mt;
                }
            }
            if (importedMemberType != null) {
                return importedMemberType;
            }
            this.compileError("Cannot determine simple type name \"" + simpleTypeName + "\"", rt.getLocation());
            return this.iClassLoader.OBJECT;
        }
        Java.Atom q = this.reclassifyName(rt.getLocation(), rt.getEnclosingScope(), rt.identifiers, rt.identifiers.length - 1);
        if (q instanceof Java.Package) {
            String className = Java.join(rt.identifiers, ".");
            IClass result = this.findClassByName(rt.getLocation(), className);
            if (result != null) {
                return result;
            }
            this.compileError("Class \"" + className + "\" not found", rt.getLocation());
            return this.iClassLoader.OBJECT;
        }
        String memberTypeName = rt.identifiers[rt.identifiers.length - 1];
        IClass[] types = this.getType(this.toTypeOrCE(q)).findMemberType(memberTypeName);
        if (types.length == 1) {
            return types[0];
        }
        if (types.length == 0) {
            this.compileError("\"" + q + "\" declares no member type \"" + memberTypeName + "\"", rt.getLocation());
        } else {
            this.compileError("\"" + q + "\" and its supertypes declare more than one member type \"" + memberTypeName + "\"", rt.getLocation());
        }
        return this.iClassLoader.OBJECT;
    }

    private IClass getType2(Java.RvalueMemberType rvmt) throws CompileException {
        IClass rvt = this.getType(rvmt.rvalue);
        IClass memberType = this.findMemberType(rvt, rvmt.identifier, rvmt.getLocation());
        if (memberType == null) {
            this.compileError("\"" + rvt + "\" has no member type \"" + rvmt.identifier + "\"", rvmt.getLocation());
        }
        return memberType;
    }

    private IClass getType2(Java.ArrayType at) throws CompileException {
        return this.getType(at.componentType).getArrayIClass(this.iClassLoader.OBJECT);
    }

    private IClass getType2(Java.AmbiguousName an) throws CompileException {
        return this.getType(this.reclassify(an));
    }

    private IClass getType2(Java.Package p) throws CompileException {
        this.compileError("Unknown variable or type \"" + p.name + "\"", p.getLocation());
        return this.iClassLoader.OBJECT;
    }

    private IClass getType2(Java.LocalVariableAccess lva) {
        return lva.localVariable.type;
    }

    private IClass getType2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getType();
    }

    private IClass getType2(Java.ArrayLength al) {
        return IClass.INT;
    }

    private IClass getType2(Java.ThisReference tr) throws CompileException {
        return this.getIClass(tr);
    }

    private IClass getType2(Java.QualifiedThisReference qtr) throws CompileException {
        return this.getTargetIClass(qtr);
    }

    private IClass getType2(Java.ClassLiteral cl) {
        return this.iClassLoader.CLASS;
    }

    private IClass getType2(Java.Assignment a) throws CompileException {
        return this.getType(a.lhs);
    }

    private IClass getType2(Java.ConditionalExpression ce) throws CompileException {
        IClass rhsType;
        IClass mhsType = this.getType(ce.mhs);
        if (mhsType == (rhsType = this.getType(ce.rhs))) {
            return mhsType;
        }
        if (mhsType.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
            return this.binaryNumericPromotionType(ce, mhsType, rhsType);
        }
        if (this.getConstantValue(ce.mhs) == Java.Rvalue.CONSTANT_VALUE_NULL && !rhsType.isPrimitive()) {
            return rhsType;
        }
        if (!mhsType.isPrimitive() && this.getConstantValue(ce.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL) {
            return mhsType;
        }
        if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
            if (mhsType.isAssignableFrom(rhsType)) {
                return mhsType;
            }
            if (rhsType.isAssignableFrom(mhsType)) {
                return rhsType;
            }
            this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
            return this.iClassLoader.OBJECT;
        }
        this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
        return this.iClassLoader.OBJECT;
    }

    private IClass getType2(Java.Crement c) throws CompileException {
        return this.getType(c.operand);
    }

    private IClass getType2(Java.ArrayAccessExpression aae) throws CompileException {
        return this.getType(aae.lhs).getComponentType();
    }

    private IClass getType2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.getType(fae.value);
    }

    private IClass getType2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.getType(scfae.value);
    }

    private IClass getType2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return IClass.BOOLEAN;
        }
        if (uo.operator == "+" || uo.operator == "-" || uo.operator == "~") {
            return this.unaryNumericPromotionType(uo, this.getUnboxedType(this.getType(uo.operand)));
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.Instanceof io) {
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return IClass.BOOLEAN;
        }
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            IClass lhsType = this.getType(bo.lhs);
            return lhsType == IClass.BOOLEAN || lhsType == this.iClassLoader.BOOLEAN ? IClass.BOOLEAN : this.binaryNumericPromotionType(bo, lhsType, this.getType(bo.rhs));
        }
        if (bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-") {
            IClassLoader icl = this.iClassLoader;
            Iterator ops = bo.unrollLeftAssociation();
            IClass lhsType = this.getUnboxedType(this.getType((Java.Rvalue)ops.next()));
            if (bo.op == "+" && lhsType == icl.STRING) {
                return icl.STRING;
            }
            do {
                IClass rhsType = this.getUnboxedType(this.getType((Java.Rvalue)ops.next()));
                if (bo.op == "+" && rhsType == icl.STRING) {
                    return icl.STRING;
                }
                lhsType = this.binaryNumericPromotionType(bo, lhsType, rhsType);
            } while (ops.hasNext());
            return lhsType;
        }
        if (bo.op == "<<" || bo.op == ">>" || bo.op == ">>>") {
            IClass lhsType = this.getType(bo.lhs);
            return this.unaryNumericPromotionType(bo, lhsType);
        }
        this.compileError("Unexpected operator \"" + bo.op + "\"", bo.getLocation());
        return this.iClassLoader.OBJECT;
    }

    private IClass getUnboxedType(IClass type) {
        IClass c = this.isUnboxingConvertible(type);
        return c != null ? c : type;
    }

    private IClass getType2(Java.Cast c) throws CompileException {
        return this.getType(c.targetType);
    }

    private IClass getType2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getType(pe.value);
    }

    private IClass getType2(Java.MethodInvocation mi) throws CompileException {
        if (mi.iMethod == null) {
            mi.iMethod = this.findIMethod(mi);
        }
        return mi.iMethod.getReturnType();
    }

    private IClass getType2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        return this.findIMethod(scmi).getReturnType();
    }

    private IClass getType2(Java.NewClassInstance nci) throws CompileException {
        if (nci.iClass == null) {
            nci.iClass = this.getType(nci.type);
        }
        return nci.iClass;
    }

    private IClass getType2(Java.NewAnonymousClassInstance naci) {
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass getType2(Java.ParameterAccess pa) throws CompileException {
        return this.getLocalVariable((Java.FunctionDeclarator.FormalParameter)pa.formalParameter).type;
    }

    private IClass getType2(Java.NewArray na) throws CompileException {
        IClass res = this.getType(na.type);
        return res.getArrayIClass(na.dimExprs.length + na.dims, this.iClassLoader.OBJECT);
    }

    private IClass getType2(Java.NewInitializedArray nia) throws CompileException {
        return this.getType(nia.arrayType);
    }

    private IClass getType2(Java.Literal l) {
        if (l.value instanceof Short) {
            return IClass.SHORT;
        }
        if (l.value instanceof Byte) {
            return IClass.BYTE;
        }
        if (l.value instanceof Integer) {
            return IClass.INT;
        }
        if (l.value instanceof Long) {
            return IClass.LONG;
        }
        if (l.value instanceof Float) {
            return IClass.FLOAT;
        }
        if (l.value instanceof Double) {
            return IClass.DOUBLE;
        }
        if (l.value instanceof String) {
            return this.iClassLoader.STRING;
        }
        if (l.value instanceof Character) {
            return IClass.CHAR;
        }
        if (l.value instanceof Boolean) {
            return IClass.BOOLEAN;
        }
        if (l.value == null) {
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("SNO: Unidentifiable literal type \"" + l.value.getClass().getName() + "\"");
    }

    private boolean isType(Java.Atom a) throws CompileException {
        class UCE
        extends RuntimeException {
            final CompileException ce;

            UCE(CompileException ce) {
                this.ce = ce;
            }
        }
        final boolean[] res = new boolean[1];
        Visitor.AtomVisitor av = new Visitor.AtomVisitor(){

            public void visitPackage(Java.Package p) {
                res[0] = UnitCompiler.this.isType2(p);
            }

            public void visitArrayType(Java.ArrayType at) {
                res[0] = UnitCompiler.this.isType2(at);
            }

            public void visitBasicType(Java.BasicType bt) {
                res[0] = UnitCompiler.this.isType2(bt);
            }

            public void visitReferenceType(Java.ReferenceType rt) {
                res[0] = UnitCompiler.this.isType2(rt);
            }

            public void visitRvalueMemberType(Java.RvalueMemberType rmt) {
                res[0] = UnitCompiler.this.isType2(rmt);
            }

            public void visitSimpleType(Java.SimpleType st) {
                res[0] = UnitCompiler.this.isType2(st);
            }

            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.isType2(al);
            }

            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.isType2(a);
            }

            public void visitUnaryOperation(Java.UnaryOperation uo) {
                res[0] = UnitCompiler.this.isType2(uo);
            }

            public void visitBinaryOperation(Java.BinaryOperation bo) {
                res[0] = UnitCompiler.this.isType2(bo);
            }

            public void visitCast(Java.Cast c) {
                res[0] = UnitCompiler.this.isType2(c);
            }

            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.isType2(cl);
            }

            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                res[0] = UnitCompiler.this.isType2(ce);
            }

            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.isType2(c);
            }

            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.isType2(io);
            }

            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.isType2(mi);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.isType2(smi);
            }

            public void visitLiteral(Java.Literal l) {
                res[0] = UnitCompiler.this.isType2(l);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.isType2(naci);
            }

            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.isType2(na);
            }

            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.isType2(nia);
            }

            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.isType2(nci);
            }

            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.isType2(pa);
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.isType2(qtr);
            }

            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.isType2(tr);
            }

            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.isType2(an);
                }
                catch (CompileException e) {
                    throw new UCE(e);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                res[0] = UnitCompiler.this.isType2(aae);
            }

            public void visitFieldAccess(Java.FieldAccess fa) {
                res[0] = UnitCompiler.this.isType2(fa);
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                res[0] = UnitCompiler.this.isType2(fae);
            }

            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                res[0] = UnitCompiler.this.isType2(scfae);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.isType2(lva);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                res[0] = UnitCompiler.this.isType2(pe);
            }
        };
        try {
            a.accept(av);
            return res[0];
        }
        catch (UCE uce) {
            throw uce.ce;
        }
    }

    private boolean isType2(Java.Atom a) {
        return a instanceof Java.Type;
    }

    private boolean isType2(Java.AmbiguousName an) throws CompileException {
        return this.isType(this.reclassify(an));
    }

    private boolean isAccessible(IClass.IMember member, Java.Scope contextScope) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        boolean acc = this.isAccessible(declaringIClass, contextScope);
        acc = acc && this.isAccessible(declaringIClass, member.getAccess(), contextScope);
        return acc;
    }

    private void checkAccessible(IClass.IMember member, Java.BlockStatement contextBlockStatement) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        this.checkAccessible(declaringIClass, contextBlockStatement);
        this.checkAccessible(declaringIClass, member.getAccess(), contextBlockStatement);
    }

    private boolean isAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(iClassDeclaringMember, memberAccess, contextScope);
    }

    private void checkAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.BlockStatement contextBlockStatement) throws CompileException {
        String message = this.internalCheckAccessible(iClassDeclaringMember, memberAccess, contextBlockStatement);
        if (message != null) {
            this.compileError(message, contextBlockStatement.getLocation());
        }
    }

    private String internalCheckAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        if (memberAccess == Access.PUBLIC) {
            return null;
        }
        Java.Scope s = contextScope;
        while (true) {
            if (s instanceof Java.TypeDeclaration) break;
            s = s.getEnclosingScope();
        }
        IClass iClassDeclaringContextBlockStatement = this.resolve((Java.TypeDeclaration)s);
        if (iClassDeclaringContextBlockStatement == iClassDeclaringMember) {
            return null;
        }
        IClass topLevelIClassEnclosingMember = iClassDeclaringMember;
        for (IClass c = iClassDeclaringMember.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
            topLevelIClassEnclosingMember = c;
        }
        IClass topLevelIClassEnclosingContextBlockStatement = iClassDeclaringContextBlockStatement;
        for (IClass c = iClassDeclaringContextBlockStatement.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
            topLevelIClassEnclosingContextBlockStatement = c;
        }
        if (topLevelIClassEnclosingMember == topLevelIClassEnclosingContextBlockStatement) {
            return null;
        }
        if (memberAccess == Access.PRIVATE) {
            return "Private member cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\".";
        }
        if (Descriptor.areInSamePackage(iClassDeclaringMember.getDescriptor(), iClassDeclaringContextBlockStatement.getDescriptor())) {
            return null;
        }
        if (memberAccess == Access.DEFAULT) {
            return "Member with \"" + memberAccess + "\" access cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\".";
        }
        IClass parentClass = iClassDeclaringContextBlockStatement;
        do {
            if (!iClassDeclaringMember.isAssignableFrom(parentClass)) continue;
            return null;
        } while ((parentClass = parentClass.getOuterIClass()) != null);
        return "Protected member cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\", which is neither declared in the same package as nor is a subclass of \"" + iClassDeclaringMember + "\".";
    }

    private boolean isAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(type, contextScope);
    }

    private void checkAccessible(IClass type, Java.BlockStatement contextBlockStatement) throws CompileException {
        String message = this.internalCheckAccessible(type, contextBlockStatement);
        if (message != null) {
            this.compileError(message, contextBlockStatement.getLocation());
        }
    }

    private String internalCheckAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        IClass iClassDeclaringType = type.getDeclaringIClass();
        if (iClassDeclaringType == null) {
            if (type.getAccess() == Access.PUBLIC) {
                return null;
            }
            if (type.getAccess() == Access.DEFAULT) {
                Java.Scope s = contextScope;
                while (true) {
                    if (s instanceof Java.TypeDeclaration) break;
                    s = s.getEnclosingScope();
                }
                IClass iClassDeclaringContextBlockStatement = this.resolve((Java.TypeDeclaration)s);
                String packageDeclaringType = Descriptor.getPackageName(type.getDescriptor());
                String contextPackage = Descriptor.getPackageName(iClassDeclaringContextBlockStatement.getDescriptor());
                if (packageDeclaringType == null ? contextPackage != null : !packageDeclaringType.equals(contextPackage)) {
                    return "\"" + type + "\" is inaccessible from this package";
                }
                return null;
            }
            throw new JaninoRuntimeException("\"" + type + "\" has unexpected access \"" + type.getAccess() + "\"");
        }
        return this.internalCheckAccessible(iClassDeclaringType, type.getAccess(), contextScope);
    }

    private Java.Type toTypeOrCE(Java.Atom a) throws CompileException {
        Java.Type result = a.toType();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not a type", a.getLocation());
            return new Java.SimpleType(a.getLocation(), this.iClassLoader.OBJECT);
        }
        return result;
    }

    private Java.Rvalue toRvalueOrCE(Java.Atom a) throws CompileException {
        Java.Rvalue result = a.toRvalue();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an rvalue", a.getLocation());
            return new Java.Literal(a.getLocation(), "X");
        }
        return result;
    }

    public final Java.Lvalue toLvalueOrCE(final Java.Atom a) throws CompileException {
        Java.Lvalue result = a.toLvalue();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an lvalue", a.getLocation());
            return new Java.Lvalue(a.getLocation()){

                public String toString() {
                    return a.toString();
                }

                public void accept(Visitor.AtomVisitor visitor) {
                }

                public void accept(Visitor.RvalueVisitor visitor) {
                }

                public void accept(Visitor.LvalueVisitor visitor) {
                }
            };
        }
        return result;
    }

    void assignSyntheticParametersToSyntheticFields(Java.ConstructorDeclarator cd) throws CompileException {
        Iterator it = cd.getDeclaringClass().syntheticFields.values().iterator();
        while (it.hasNext()) {
            IClass.IField sf = (IClass.IField)it.next();
            Java.LocalVariable syntheticParameter = (Java.LocalVariable)cd.syntheticParameters.get(sf.getName());
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter for synthetic field \"" + sf.getName() + "\" not found");
            }
            Java.ExpressionStatement es = new Java.ExpressionStatement(new Java.Assignment(cd.getLocation(), new Java.FieldAccess(cd.getLocation(), new Java.ThisReference(cd.getLocation()), sf), "=", new Java.LocalVariableAccess(cd.getLocation(), syntheticParameter)));
            es.setEnclosingScope(cd);
            this.compile(es);
        }
    }

    void initializeInstanceVariablesAndInvokeInstanceInitializers(Java.ConstructorDeclarator cd) throws CompileException {
        for (int i = 0; i < cd.getDeclaringClass().variableDeclaratorsAndInitializers.size(); ++i) {
            Java.BlockStatement bs;
            Java.TypeBodyDeclaration tbd = (Java.TypeBodyDeclaration)cd.getDeclaringClass().variableDeclaratorsAndInitializers.get(i);
            if (tbd.isStatic() || this.compile(bs = (Java.BlockStatement)((Object)tbd))) continue;
            this.compileError("Instance variable declarator or instance initializer does not complete normally", bs.getLocation());
        }
    }

    private void leaveStatements(Java.Scope from, Java.Scope to, IClass optionalStackValueType) {
        for (Java.Scope s = from; s != to; s = s.getEnclosingScope()) {
            if (!(s instanceof Java.BlockStatement)) continue;
            this.leave((Java.BlockStatement)s, optionalStackValueType);
        }
    }

    private IClass compileArithmeticBinaryOperation(Java.Locatable l, IClass lhsType, String operator, Java.Rvalue rhs) throws CompileException {
        return this.compileArithmeticOperation(l, lhsType, Arrays.asList(rhs).iterator(), operator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileArithmeticOperation(Java.Locatable l, IClass type, Iterator operands, String operator) throws CompileException {
        if (operator == "|" || operator == "^" || operator == "&") {
            int iopcode = operator == "&" ? 126 : (operator == "|" ? -128 : (operator == "^" ? -126 : Integer.MAX_VALUE));
            do {
                Java.Rvalue operand = (Java.Rvalue)operands.next();
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                IClass rhsType = this.compileGetValue(operand);
                if (type.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
                    IClass promotedType = this.binaryNumericPromotion(l, type, convertLhsInserter, rhsType);
                    if (promotedType == IClass.INT) {
                        this.writeOpcode(l, iopcode);
                    } else if (promotedType == IClass.LONG) {
                        this.writeOpcode(l, iopcode + 1);
                    } else {
                        this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", l.getLocation());
                    }
                    type = promotedType;
                    continue;
                }
                if (type == IClass.BOOLEAN && this.getUnboxedType(rhsType) == IClass.BOOLEAN || this.getUnboxedType(type) == IClass.BOOLEAN && rhsType == IClass.BOOLEAN) {
                    IClassLoader icl = this.iClassLoader;
                    if (type == icl.BOOLEAN) {
                        this.codeContext.pushInserter(convertLhsInserter);
                        try {
                            this.unboxingConversion(l, icl.BOOLEAN, IClass.BOOLEAN);
                        }
                        finally {
                            this.codeContext.popInserter();
                        }
                    }
                    if (rhsType == icl.BOOLEAN) {
                        this.unboxingConversion(l, icl.BOOLEAN, IClass.BOOLEAN);
                    }
                    this.writeOpcode(l, iopcode);
                    type = IClass.BOOLEAN;
                    continue;
                }
                this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", l.getLocation());
                type = IClass.INT;
            } while (operands.hasNext());
            return type;
        }
        if (operator == "*" || operator == "/" || operator == "%" || operator == "+" || operator == "-") {
            int iopcode = operator == "*" ? 104 : (operator == "/" ? 108 : (operator == "%" ? 112 : (operator == "+" ? 96 : (operator == "-" ? 100 : Integer.MAX_VALUE))));
            do {
                int opcode;
                IClass rhsType;
                Java.Rvalue operand = (Java.Rvalue)operands.next();
                IClass operandType = this.getType(operand);
                IClassLoader icl = this.iClassLoader;
                if (operator == "+" && (type == icl.STRING || operandType == icl.STRING)) {
                    return this.compileStringConcatenation(l, type, operand, operands);
                }
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                if ((type = this.binaryNumericPromotion(l, type, convertLhsInserter, rhsType = this.compileGetValue(operand))) == IClass.INT) {
                    opcode = iopcode;
                } else if (type == IClass.LONG) {
                    opcode = iopcode + 1;
                } else if (type == IClass.FLOAT) {
                    opcode = iopcode + 2;
                } else if (type == IClass.DOUBLE) {
                    opcode = iopcode + 3;
                } else {
                    this.compileError("Unexpected promoted type \"" + type + "\"", l.getLocation());
                    opcode = iopcode;
                }
                this.writeOpcode(l, opcode);
            } while (operands.hasNext());
            return type;
        }
        if (operator == "<<" || operator == ">>" || operator == ">>>") {
            int iopcode = operator == "<<" ? 120 : (operator == ">>" ? 122 : (operator == ">>>" ? 124 : Integer.MAX_VALUE));
            do {
                IClass promotedRhsType;
                IClass promotedLhsType;
                Java.Rvalue operand = (Java.Rvalue)operands.next();
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                IClass rhsType = this.compileGetValue(operand);
                this.codeContext.pushInserter(convertLhsInserter);
                try {
                    promotedLhsType = this.unaryNumericPromotion(l, type);
                }
                finally {
                    this.codeContext.popInserter();
                }
                if (promotedLhsType != IClass.INT && promotedLhsType != IClass.LONG) {
                    this.compileError("Shift operation not allowed on operand type \"" + type + "\"", l.getLocation());
                }
                if ((promotedRhsType = this.unaryNumericPromotion(l, rhsType)) != IClass.INT && promotedRhsType != IClass.LONG) {
                    this.compileError("Shift distance of type \"" + rhsType + "\" is not allowed", l.getLocation());
                }
                if (promotedRhsType == IClass.LONG) {
                    this.writeOpcode(l, -120);
                }
                this.writeOpcode(l, promotedLhsType == IClass.LONG ? iopcode + 1 : iopcode);
                type = promotedLhsType;
            } while (operands.hasNext());
            return type;
        }
        throw new JaninoRuntimeException("Unexpected operator \"" + operator + "\"");
    }

    private IClass compileStringConcatenation(final Java.Locatable l, IClass type, Java.Rvalue operand, Iterator operands) throws CompileException {
        String stringBuilferFD;
        Iterator it;
        boolean operandOnStack;
        if (type != null) {
            this.stringConversion(l, type);
            operandOnStack = true;
        } else {
            operandOnStack = false;
        }
        ArrayList<Compilable> tmp = new ArrayList<Compilable>();
        do {
            Object cv;
            if ((cv = this.getConstantValue(operand)) == null) {
                final Java.Rvalue finalOperand = operand;
                tmp.add(new Compilable(){

                    public void compile() throws CompileException {
                        UnitCompiler.this.stringConversion(l, UnitCompiler.this.compileGetValue(finalOperand));
                    }
                });
                operand = operands.hasNext() ? (Java.Rvalue)operands.next() : null;
                continue;
            }
            if (operands.hasNext()) {
                operand = (Java.Rvalue)operands.next();
                Object cv2 = this.getConstantValue(operand);
                if (cv2 != null) {
                    StringBuffer sb = new StringBuffer(cv.toString()).append(cv2);
                    while (true) {
                        if (!operands.hasNext()) {
                            operand = null;
                            break;
                        }
                        operand = (Java.Rvalue)operands.next();
                        Object cv3 = this.getConstantValue(operand);
                        if (cv3 == null) break;
                        sb.append(cv3);
                    }
                    cv = sb.toString();
                }
            } else {
                operand = null;
            }
            String[] ss = UnitCompiler.makeUTF8Able(cv.toString());
            for (int i = 0; i < ss.length; ++i) {
                final String s = ss[i];
                tmp.add(new Compilable(){

                    public void compile() throws CompileException {
                        UnitCompiler.this.pushConstant(l, s);
                    }
                });
            }
        } while (operand != null);
        if (tmp.size() <= (operandOnStack ? 2 : 3)) {
            it = tmp.iterator();
            while (it.hasNext()) {
                Compilable c = (Compilable)it.next();
                c.compile();
                if (operandOnStack) {
                    this.writeOpcode(l, -74);
                    this.writeConstantMethodrefInfo("Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                    continue;
                }
                operandOnStack = true;
            }
            return this.iClassLoader.STRING;
        }
        it = tmp.iterator();
        String string = stringBuilferFD = this.isStringBuilderAvailable ? "Ljava/lang/StringBuilder;" : "Ljava/lang/StringBuffer;";
        if (operandOnStack) {
            this.writeOpcode(l, -69);
            this.writeConstantClassInfo(stringBuilferFD);
            this.writeOpcode(l, 90);
            this.writeOpcode(l, 95);
        } else {
            this.writeOpcode(l, -69);
            this.writeConstantClassInfo(stringBuilferFD);
            this.writeOpcode(l, 89);
            ((Compilable)it.next()).compile();
        }
        this.writeOpcode(l, -73);
        this.writeConstantMethodrefInfo(stringBuilferFD, "<init>", "(Ljava/lang/String;)V");
        while (it.hasNext()) {
            ((Compilable)it.next()).compile();
            this.writeOpcode(l, -74);
            this.writeConstantMethodrefInfo(stringBuilferFD, "append", "(Ljava/lang/String;)" + stringBuilferFD);
        }
        this.writeOpcode(l, -74);
        this.writeConstantMethodrefInfo(stringBuilferFD, "toString", "()Ljava/lang/String;");
        return this.iClassLoader.STRING;
    }

    private void stringConversion(Java.Locatable l, IClass sourceType) {
        this.writeOpcode(l, -72);
        this.writeConstantMethodrefInfo("Ljava/lang/String;", "valueOf", "(" + (sourceType == IClass.BOOLEAN || sourceType == IClass.CHAR || sourceType == IClass.LONG || sourceType == IClass.FLOAT || sourceType == IClass.DOUBLE ? sourceType.getDescriptor() : (sourceType == IClass.BYTE || sourceType == IClass.SHORT || sourceType == IClass.INT ? "I" : "Ljava/lang/Object;")) + ")" + "Ljava/lang/String;");
    }

    private void invokeConstructor(Java.Locatable l, Java.Scope scope, Java.Rvalue optionalEnclosingInstance, IClass targetClass, Java.Rvalue[] arguments) throws CompileException {
        IClass.IConstructor iConstructor;
        block19: {
            Java.TypeDeclaration scopeTypeDeclaration;
            Java.TypeBodyDeclaration scopeTBD;
            IClass.IField[] syntheticFields;
            block18: {
                IClass eiic;
                IClass outerIClass;
                IClass.IInvocable[] iConstructors = targetClass.getDeclaredIConstructors();
                if (iConstructors.length == 0) {
                    throw new JaninoRuntimeException("SNO: Target class \"" + targetClass.getDescriptor() + "\" has no constructors");
                }
                iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(l, iConstructors, arguments, scope);
                IClass[] thrownExceptions = iConstructor.getThrownExceptions();
                for (int i = 0; i < thrownExceptions.length; ++i) {
                    this.checkThrownException(l, thrownExceptions[i], scope);
                }
                if (optionalEnclosingInstance != null && (outerIClass = targetClass.getOuterIClass()) != null && !outerIClass.isAssignableFrom(eiic = this.compileGetValue(optionalEnclosingInstance))) {
                    this.compileError("Type of enclosing instance (\"" + eiic + "\") is not assignable to \"" + outerIClass + "\"", l.getLocation());
                }
                syntheticFields = targetClass.getSyntheticIFields();
                Java.Scope s = scope;
                while (!(s instanceof Java.TypeBodyDeclaration)) {
                    s = s.getEnclosingScope();
                }
                scopeTBD = (Java.TypeBodyDeclaration)s;
                scopeTypeDeclaration = scopeTBD.getDeclaringType();
                if (scopeTypeDeclaration instanceof Java.ClassDeclaration) break block18;
                if (syntheticFields.length > 0) {
                    throw new JaninoRuntimeException("SNO: Target class has synthetic fields");
                }
                break block19;
            }
            Java.ClassDeclaration scopeClassDeclaration = (Java.ClassDeclaration)scopeTypeDeclaration;
            for (int i = 0; i < syntheticFields.length; ++i) {
                Java.LocalVariable lv;
                block17: {
                    IClass.IField sf = syntheticFields[i];
                    if (!sf.getName().startsWith("val$")) continue;
                    IClass.IField eisf = (IClass.IField)scopeClassDeclaration.syntheticFields.get(sf.getName());
                    if (eisf != null) {
                        if (scopeTBD instanceof Java.MethodDeclarator) {
                            this.load(l, this.resolve(scopeClassDeclaration), 0);
                            this.writeOpcode(l, -76);
                            this.writeConstantFieldrefInfo(this.resolve(scopeClassDeclaration).getDescriptor(), sf.getName(), sf.getDescriptor());
                            continue;
                        }
                        if (scopeTBD instanceof Java.ConstructorDeclarator) {
                            Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scopeTBD;
                            Java.LocalVariable syntheticParameter = (Java.LocalVariable)constructorDeclarator.syntheticParameters.get(sf.getName());
                            if (syntheticParameter == null) {
                                this.compileError("Compiler limitation: Constructor cannot access local variable \"" + sf.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. " + "As a workaround, declare a dummy method that accesses the local variable.", l.getLocation());
                                this.writeOpcode(l, 1);
                                continue;
                            }
                            this.load(l, syntheticParameter);
                            continue;
                        }
                        this.compileError("Compiler limitation: Initializers cannot access local variables declared in an enclosing block.", l.getLocation());
                        this.writeOpcode(l, 1);
                        continue;
                    }
                    String localVariableName = sf.getName().substring(4);
                    Java.Scope s = scope;
                    while (s instanceof Java.BlockStatement) {
                        block22: {
                            Java.BlockStatement bs2;
                            List statements;
                            Java.BlockStatement bs;
                            block21: {
                                Java.Scope es;
                                block20: {
                                    bs = (Java.BlockStatement)s;
                                    es = bs.getEnclosingScope();
                                    if (!(es instanceof Java.Block)) break block20;
                                    statements = ((Java.Block)es).statements;
                                    break block21;
                                }
                                if (!(es instanceof Java.FunctionDeclarator)) break block22;
                                statements = ((Java.FunctionDeclarator)es).optionalStatements;
                            }
                            Iterator it = statements.iterator();
                            while ((bs2 = (Java.BlockStatement)it.next()) != bs) {
                                if (!(bs2 instanceof Java.LocalVariableDeclarationStatement)) continue;
                                Java.LocalVariableDeclarationStatement lvds = (Java.LocalVariableDeclarationStatement)bs2;
                                Java.VariableDeclarator[] vds = lvds.variableDeclarators;
                                for (int j = 0; j < vds.length; ++j) {
                                    if (!vds[j].name.equals(localVariableName)) continue;
                                    lv = this.getLocalVariable(lvds, vds[j]);
                                    break block17;
                                }
                            }
                        }
                        s = s.getEnclosingScope();
                    }
                    while (!(s instanceof Java.FunctionDeclarator)) {
                        s = s.getEnclosingScope();
                    }
                    Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s;
                    for (int j = 0; j < fd.formalParameters.length; ++j) {
                        Java.FunctionDeclarator.FormalParameter fp = fd.formalParameters[j];
                        if (!fp.name.equals(localVariableName)) continue;
                        lv = this.getLocalVariable(fp);
                        break block17;
                    }
                    throw new JaninoRuntimeException("SNO: Synthetic field \"" + sf.getName() + "\" neither maps a synthetic field of an enclosing instance nor a local variable");
                }
                this.load(l, lv);
            }
        }
        IClass[] parameterTypes = iConstructor.getParameterTypes();
        for (int i = 0; i < arguments.length; ++i) {
            this.assignmentConversion(l, this.compileGetValue(arguments[i]), parameterTypes[i], this.getConstantValue(arguments[i]));
        }
        this.writeOpcode(l, -73);
        this.writeConstantMethodrefInfo(targetClass.getDescriptor(), "<init>", iConstructor.getDescriptor());
    }

    IClass.IField[] getIFields(final Java.FieldDeclaration fd) {
        IClass.IField[] res = new IClass.IField[fd.variableDeclarators.length];
        for (int i = 0; i < res.length; ++i) {
            final Java.VariableDeclarator vd = fd.variableDeclarators[i];
            IClass iClass = this.resolve(fd.getDeclaringType());
            iClass.getClass();
            res[i] = new IClass.IField(iClass){

                public Access getAccess() {
                    switch (fd.modifiers & 7) {
                        case 2: {
                            return Access.PRIVATE;
                        }
                        case 4: {
                            return Access.PROTECTED;
                        }
                        case 0: {
                            return Access.DEFAULT;
                        }
                        case 1: {
                            return Access.PUBLIC;
                        }
                    }
                    throw new JaninoRuntimeException("Invalid access");
                }

                public boolean isStatic() {
                    return (fd.modifiers & 8) != 0;
                }

                public IClass getType() throws CompileException {
                    return UnitCompiler.this.getType(fd.type).getArrayIClass(vd.brackets, ((UnitCompiler)UnitCompiler.this).iClassLoader.OBJECT);
                }

                public String getName() {
                    return vd.name;
                }

                public Object getConstantValue() throws CompileException {
                    Object constantInitializerValue;
                    if ((fd.modifiers & 0x10) != 0 && vd.optionalInitializer instanceof Java.Rvalue && (constantInitializerValue = UnitCompiler.this.getConstantValue((Java.Rvalue)vd.optionalInitializer)) != null) {
                        return UnitCompiler.this.assignmentConversion((Java.Locatable)((Object)vd.optionalInitializer), constantInitializerValue, this.getType());
                    }
                    return null;
                }
            };
        }
        return res;
    }

    Java.ArrayInitializerOrRvalue getNonConstantFinalInitializer(Java.FieldDeclaration fd, Java.VariableDeclarator vd) throws CompileException {
        if (vd.optionalInitializer == null) {
            return null;
        }
        if ((fd.modifiers & 8) != 0 && (fd.modifiers & 0x10) != 0 && vd.optionalInitializer instanceof Java.Rvalue && this.getConstantValue((Java.Rvalue)vd.optionalInitializer) != null) {
            return null;
        }
        return vd.optionalInitializer;
    }

    private Java.Atom reclassify(Java.AmbiguousName an) throws CompileException {
        if (an.reclassified == null) {
            an.reclassified = this.reclassifyName(an.getLocation(), an.getEnclosingBlockStatement(), an.identifiers, an.n);
        }
        return an.reclassified;
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, final String[] identifiers, int n) throws CompileException {
        if (n == 1) {
            return this.reclassifyName(location, scope, identifiers[0]);
        }
        Java.Atom lhs = this.reclassifyName(location, scope, identifiers, n - 1);
        String rhs = identifiers[n - 1];
        if (lhs instanceof Java.Package) {
            String className = ((Java.Package)lhs).name + '.' + rhs;
            IClass result = this.findClassByName(location, className);
            if (result != null) {
                return new Java.SimpleType(location, result);
            }
            return new Java.Package(location, className);
        }
        if (rhs.equals("length") && this.getType(lhs).isArray()) {
            Java.ArrayLength al = new Java.ArrayLength(location, this.toRvalueOrCE(lhs));
            if (!(scope instanceof Java.BlockStatement)) {
                this.compileError("\".length\" only allowed in expression context");
                return al;
            }
            al.setEnclosingBlockStatement((Java.BlockStatement)scope);
            return al;
        }
        IClass lhsType = this.getType(lhs);
        IClass.IField field = this.findIField(lhsType, rhs, location);
        if (field != null) {
            Java.FieldAccess fa = new Java.FieldAccess(location, lhs, field);
            fa.setEnclosingBlockStatement((Java.BlockStatement)scope);
            return fa;
        }
        IClass[] classes = lhsType.getDeclaredIClasses();
        for (int i = 0; i < classes.length; ++i) {
            IClass memberType = classes[i];
            String name = Descriptor.toClassName(memberType.getDescriptor());
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals(rhs)) continue;
            return new Java.SimpleType(location, memberType);
        }
        this.compileError("\"" + rhs + "\" is neither a method, a field, nor a member class of \"" + lhsType + "\"", location);
        return new Java.Atom(location){

            public String toString() {
                return Java.join(identifiers, ".");
            }

            public final void accept(Visitor.AtomVisitor visitor) {
            }
        };
    }

    private IClass findClassByName(Location location, String className) throws CompileException {
        IClass res = this.findClass(className);
        if (res != null) {
            return res;
        }
        try {
            return this.iClassLoader.loadIClass(Descriptor.fromClassName(className));
        }
        catch (ClassNotFoundException ex) {
            if (ex.getException() instanceof CompileException) {
                throw (CompileException)ex.getException();
            }
            throw new CompileException(className, location, ex);
        }
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, String identifier) throws CompileException {
        IClass memberType;
        Object o;
        Iterator it;
        IClass.IField f;
        Java.LocalVariable lv;
        Java.BlockStatement scopeBlockStatement = null;
        Java.TypeBodyDeclaration scopeTBD = null;
        Java.AbstractTypeDeclaration scopeTypeDeclaration = null;
        Java.Scope s = scope;
        if (s instanceof Java.BlockStatement) {
            scopeBlockStatement = (Java.BlockStatement)s;
        }
        while ((s instanceof Java.BlockStatement || s instanceof Java.CatchClause) && !(s instanceof Java.TypeBodyDeclaration)) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.TypeBodyDeclaration) {
            scopeTBD = (Java.TypeBodyDeclaration)s;
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.TypeDeclaration) {
            scopeTypeDeclaration = (Java.AbstractTypeDeclaration)s;
            s = s.getEnclosingScope();
        }
        while (!(s instanceof Java.CompilationUnit)) {
            s = s.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s;
        s = scope;
        if (s instanceof Java.BlockStatement) {
            Java.BlockStatement bs = (Java.BlockStatement)s;
            lv = bs.findLocalVariable(identifier);
            if (lv != null) {
                Java.LocalVariableAccess lva = new Java.LocalVariableAccess(location, lv);
                lva.setEnclosingBlockStatement(bs);
                return lva;
            }
            s = s.getEnclosingScope();
        }
        while (s instanceof Java.BlockStatement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.FunctionDeclarator) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.InnerClassDeclaration) {
            Java.InnerClassDeclaration icd = (Java.InnerClassDeclaration)s;
            if ((s = s.getEnclosingScope()) instanceof Java.AnonymousClassDeclaration) {
                s = s.getEnclosingScope();
            }
            while (s instanceof Java.BlockStatement) {
                lv = ((Java.BlockStatement)s).findLocalVariable(identifier);
                if (lv != null) {
                    if (!lv.finaL) {
                        this.compileError("Cannot access non-final local variable \"" + identifier + "\" from inner class");
                    }
                    IClass lvType = lv.type;
                    SimpleIField iField = new SimpleIField(this.resolve(icd), "val$" + identifier, lvType);
                    icd.defineSyntheticField(iField);
                    Java.FieldAccess fa = new Java.FieldAccess(location, new Java.QualifiedThisReference(location, new Java.SimpleType(location, this.resolve(icd))), iField);
                    fa.setEnclosingBlockStatement((Java.BlockStatement)scope);
                    return fa;
                }
                s = s.getEnclosingScope();
                while (s instanceof Java.BlockStatement) {
                    s = s.getEnclosingScope();
                }
                if (!(s instanceof Java.FunctionDeclarator) || !((s = s.getEnclosingScope()) instanceof Java.InnerClassDeclaration)) break;
                icd = (Java.InnerClassDeclaration)s;
                s = s.getEnclosingScope();
            }
        }
        Java.BlockStatement enclosingBlockStatement = null;
        Java.Scope s2 = scope;
        while (!(s2 instanceof Java.CompilationUnit)) {
            Java.AbstractTypeDeclaration enclosingTypeDecl;
            IClass etd;
            if (s2 instanceof Java.BlockStatement && enclosingBlockStatement == null) {
                enclosingBlockStatement = (Java.BlockStatement)s2;
            }
            if (s2 instanceof Java.TypeDeclaration && (f = this.findIField(etd = this.resolve(enclosingTypeDecl = (Java.AbstractTypeDeclaration)s2), identifier, location)) != null) {
                if (f.isStatic()) {
                    this.warning("IASF", "Implicit access to static field \"" + identifier + "\" of declaring class (better write \"" + f.getDeclaringIClass() + '.' + f.getName() + "\")", location);
                } else if (f.getDeclaringIClass() == etd) {
                    this.warning("IANSF", "Implicit access to non-static field \"" + identifier + "\" of declaring class (better write \"this." + f.getName() + "\")", location);
                } else {
                    this.warning("IANSFEI", "Implicit access to non-static field \"" + identifier + "\" of enclosing instance (better write \"" + f.getDeclaringIClass() + ".this." + f.getName() + "\")", location);
                }
                Java.SimpleType ct = new Java.SimpleType(scopeTypeDeclaration.getLocation(), etd);
                Java.Atom lhs = scopeTBD.isStatic() ? ct : (f.isStatic() ? ct : new Java.QualifiedThisReference(location, ct));
                Java.FieldAccess res = new Java.FieldAccess(location, lhs, f);
                res.setEnclosingBlockStatement(enclosingBlockStatement);
                return res;
            }
            s2 = s2.getEnclosingScope();
        }
        List l = (List)this.singleStaticImports.get(identifier);
        if (l != null) {
            it = l.iterator();
            while (it.hasNext()) {
                o = it.next();
                if (!(o instanceof IClass.IField)) continue;
                Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, ((IClass.IField)o).getDeclaringIClass()), (IClass.IField)o);
                fieldAccess.setEnclosingBlockStatement(enclosingBlockStatement);
                return fieldAccess;
            }
        }
        IClass.IField importedField = null;
        it = this.staticImportsOnDemand.iterator();
        while (it.hasNext()) {
            IClass iClass = (IClass)it.next();
            f = iClass.getDeclaredIField(identifier);
            if (f == null || !this.isAccessible(f, (Java.Scope)enclosingBlockStatement)) continue;
            if (importedField != null) {
                this.compileError("Ambiguous static field import: \"" + importedField.toString() + "\" vs. \"" + f.toString() + "\"");
            }
            importedField = f;
        }
        if (importedField != null) {
            if (!importedField.isStatic()) {
                this.compileError("Cannot static-import non-static field");
            }
            Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, importedField.getDeclaringIClass()), importedField);
            fieldAccess.setEnclosingBlockStatement(enclosingBlockStatement);
            return fieldAccess;
        }
        if (identifier.equals("java")) {
            return new Java.Package(location, identifier);
        }
        Java.LocalClassDeclaration lcd = this.findLocalClassDeclaration(scope, identifier);
        if (lcd != null) {
            return new Java.SimpleType(location, this.resolve(lcd));
        }
        if (scopeTypeDeclaration != null && (memberType = this.findMemberType(this.resolve(scopeTypeDeclaration), identifier, location)) != null) {
            return new Java.SimpleType(location, memberType);
        }
        IClass iClass = this.importSingleType(identifier, location);
        if (iClass != null) {
            return new Java.SimpleType(location, iClass);
        }
        Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(identifier);
        if (pmtd != null) {
            return new Java.SimpleType(location, this.resolve((Java.AbstractTypeDeclaration)((Object)pmtd)));
        }
        String className = scopeCompilationUnit.optionalPackageDeclaration == null ? identifier : scopeCompilationUnit.optionalPackageDeclaration.packageName + '.' + identifier;
        IClass result = this.findClassByName(location, className);
        if (result != null) {
            return new Java.SimpleType(location, result);
        }
        IClass importedClass = this.importTypeOnDemand(identifier, location);
        if (importedClass != null) {
            return new Java.SimpleType(location, importedClass);
        }
        l = (List)this.singleStaticImports.get(identifier);
        if (l != null) {
            it = l.iterator();
            while (it.hasNext()) {
                o = it.next();
                if (!(o instanceof IClass)) continue;
                return new Java.SimpleType(null, (IClass)o);
            }
        }
        IClass importedType = null;
        it = this.staticImportsOnDemand.iterator();
        while (it.hasNext()) {
            IClass ic = (IClass)it.next();
            IClass[] memberTypes = ic.getDeclaredIClasses();
            for (int i = 0; i < memberTypes.length; ++i) {
                IClass mt = memberTypes[i];
                if (!this.isAccessible(mt, (Java.Scope)scopeBlockStatement) || !mt.getDescriptor().endsWith('$' + identifier + ';')) continue;
                if (importedType != null) {
                    this.compileError("Ambiguous static type import: \"" + importedType.toString() + "\" vs. \"" + mt.toString() + "\"");
                }
                importedType = mt;
            }
        }
        if (importedType != null) {
            return new Java.SimpleType(null, importedType);
        }
        return new Java.Package(location, identifier);
    }

    private void determineValue(Java.FieldAccessExpression fae) throws CompileException {
        if (fae.value != null) {
            return;
        }
        IClass lhsType = this.getType(fae.lhs);
        if (fae.fieldName.equals("length") && lhsType.isArray()) {
            fae.value = new Java.ArrayLength(fae.getLocation(), this.toRvalueOrCE(fae.lhs));
        } else {
            IClass.IField iField = this.findIField(lhsType, fae.fieldName, fae.getLocation());
            if (iField == null) {
                this.compileError("\"" + this.getType(fae.lhs).toString() + "\" has no field \"" + fae.fieldName + "\"", fae.getLocation());
                fae.value = new Java.Rvalue(fae.getLocation()){

                    public String toString() {
                        return "???";
                    }

                    public final void accept(Visitor.AtomVisitor visitor) {
                    }

                    public final void accept(Visitor.RvalueVisitor visitor) {
                    }
                };
                return;
            }
            fae.value = new Java.FieldAccess(fae.getLocation(), fae.lhs, iField);
        }
        fae.value.setEnclosingBlockStatement(fae.getEnclosingBlockStatement());
    }

    private void determineValue(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        if (scfae.value != null) {
            return;
        }
        Java.ThisReference tr = new Java.ThisReference(scfae.getLocation());
        tr.setEnclosingBlockStatement(scfae.getEnclosingBlockStatement());
        IClass type = scfae.optionalQualification != null ? this.getType(scfae.optionalQualification) : this.getType(tr);
        Java.Cast lhs = new Java.Cast(scfae.getLocation(), new Java.SimpleType(scfae.getLocation(), type.getSuperclass()), tr);
        IClass.IField iField = this.findIField(this.getType(lhs), scfae.fieldName, scfae.getLocation());
        if (iField == null) {
            this.compileError("Class has no field \"" + scfae.fieldName + "\"", scfae.getLocation());
            scfae.value = new Java.Rvalue(scfae.getLocation()){

                public String toString() {
                    return "???";
                }

                public final void accept(Visitor.AtomVisitor visitor) {
                }

                public final void accept(Visitor.RvalueVisitor visitor) {
                }
            };
            return;
        }
        scfae.value = new Java.FieldAccess(scfae.getLocation(), lhs, iField);
        scfae.value.setEnclosingBlockStatement(scfae.getEnclosingBlockStatement());
    }

    public IClass.IMethod findIMethod(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod;
        block11: {
            block14: {
                List l;
                block13: {
                    block12: {
                        if (mi.optionalTarget != null) break block12;
                        Java.Scope s = mi.getEnclosingBlockStatement();
                        while (!(s instanceof Java.CompilationUnit)) {
                            Java.TypeDeclaration td;
                            if (!(s instanceof Java.TypeDeclaration) || (iMethod = this.findIMethod(this.resolve(td = (Java.TypeDeclaration)s), mi)) == null) {
                                s = s.getEnclosingScope();
                                continue;
                            }
                            break block11;
                        }
                        break block13;
                    }
                    iMethod = this.findIMethod(this.getType(mi.optionalTarget), mi);
                    if (iMethod != null) break block11;
                }
                if ((l = (List)this.singleStaticImports.get(mi.methodName)) == null) break block14;
                iMethod = null;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    IClass declaringIClass;
                    IClass.IMethod im;
                    Object o = it.next();
                    if (!(o instanceof IClass.IMethod) || (im = this.findIMethod(declaringIClass = ((IClass.IMethod)o).getDeclaringIClass(), mi)) == null) continue;
                    if (iMethod != null && iMethod != im) {
                        this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + im.toString() + "\"");
                    }
                    iMethod = im;
                }
                if (iMethod != null) break block11;
            }
            iMethod = null;
            Iterator it = this.staticImportsOnDemand.iterator();
            while (it.hasNext()) {
                IClass iClass = (IClass)it.next();
                IClass.IMethod im = this.findIMethod(iClass, mi);
                if (im == null) continue;
                if (iMethod != null) {
                    this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + im.toString() + "\"");
                }
                iMethod = im;
            }
            if (iMethod == null) {
                this.compileError("A method named \"" + mi.methodName + "\" is not declared in any enclosing class nor any supertype, nor through a static import", mi.getLocation());
                return this.fakeIMethod(this.iClassLoader.OBJECT, mi.methodName, mi.arguments);
            }
        }
        this.checkThrownExceptions(mi, iMethod);
        return iMethod;
    }

    private IClass.IMethod findIMethod(IClass targetType, Java.Invocation invocation) throws CompileException {
        ArrayList<IClass.IMethod> ms = new ArrayList<IClass.IMethod>();
        this.getIMethods(targetType, invocation.methodName, ms);
        if (targetType.isInterface()) {
            IClass.IMethod[] oms = this.iClassLoader.OBJECT.getDeclaredIMethods(invocation.methodName);
            for (int i = 0; i < oms.length; ++i) {
                IClass.IMethod om = oms[i];
                if (om.isStatic() || om.getAccess() != Access.PUBLIC) continue;
                ms.add(om);
            }
        }
        if (ms.size() == 0) {
            return null;
        }
        return (IClass.IMethod)this.findMostSpecificIInvocable(invocation, ms.toArray(new IClass.IMethod[ms.size()]), invocation.arguments, invocation.getEnclosingBlockStatement());
    }

    private IClass.IMethod fakeIMethod(IClass targetType, final String name, Java.Rvalue[] arguments) throws CompileException {
        final IClass[] pts = new IClass[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            pts[i] = this.getType(arguments[i]);
        }
        IClass iClass = targetType;
        iClass.getClass();
        return new IClass.IMethod(iClass){

            public String getName() {
                return name;
            }

            public IClass getReturnType() throws CompileException {
                return IClass.INT;
            }

            public boolean isStatic() {
                return false;
            }

            public boolean isAbstract() {
                return false;
            }

            public IClass[] getParameterTypes() throws CompileException {
                return pts;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return new IClass[0];
            }

            public Access getAccess() {
                return Access.PUBLIC;
            }
        };
    }

    public void getIMethods(IClass type, String methodName, List v) throws CompileException {
        IClass.IMethod[] ims = type.getDeclaredIMethods(methodName);
        for (int i = 0; i < ims.length; ++i) {
            v.add(ims[i]);
        }
        IClass superclass = type.getSuperclass();
        if (superclass != null) {
            this.getIMethods(superclass, methodName, v);
        }
        IClass[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.getIMethods(interfaces[i], methodName, v);
        }
    }

    public IClass.IMethod findIMethod(Java.SuperclassMethodInvocation scmi) throws CompileException {
        Java.Scope s = scmi.getEnclosingBlockStatement();
        while (true) {
            if (s instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s;
                if ((fd.modifiers & 8) != 0) {
                    this.compileError("Superclass method cannot be invoked in static context", scmi.getLocation());
                }
            }
            if (s instanceof Java.ClassDeclaration) break;
            s = s.getEnclosingScope();
        }
        Java.ClassDeclaration declaringClass = (Java.ClassDeclaration)s;
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        IClass.IMethod iMethod = this.findIMethod(superclass, scmi);
        if (iMethod == null) {
            this.compileError("Class \"" + superclass + "\" has no method named \"" + scmi.methodName + "\"", scmi.getLocation());
            return this.fakeIMethod(superclass, scmi.methodName, scmi.arguments);
        }
        this.checkThrownExceptions(scmi, iMethod);
        return iMethod;
    }

    private IClass.IInvocable findMostSpecificIInvocable(Java.Locatable l, final IClass.IInvocable[] iInvocables, Java.Rvalue[] arguments, Java.Scope contextScope) throws CompileException {
        int i;
        final IClass[] argumentTypes = new IClass[arguments.length];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            argumentTypes[i2] = this.getType(arguments[i2]);
        }
        IClass.IInvocable ii = this.findMostSpecificIInvocable(l, iInvocables, argumentTypes, false, contextScope);
        if (ii != null) {
            return ii;
        }
        ii = this.findMostSpecificIInvocable(l, iInvocables, argumentTypes, true, contextScope);
        if (ii != null) {
            return ii;
        }
        StringBuffer sb = new StringBuffer("No applicable constructor/method found for ");
        if (argumentTypes.length == 0) {
            sb.append("zero actual parameters");
        } else {
            sb.append("actual parameters \"").append(argumentTypes[0]);
            for (i = 1; i < argumentTypes.length; ++i) {
                sb.append(", ").append(argumentTypes[i]);
            }
            sb.append("\"");
        }
        sb.append("; candidates are: ").append('\"' + iInvocables[0].toString() + '\"');
        for (i = 1; i < iInvocables.length; ++i) {
            sb.append(", ").append('\"' + iInvocables[i].toString() + '\"');
        }
        this.compileError(sb.toString(), l.getLocation());
        if (iInvocables[0] instanceof IClass.IConstructor) {
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IConstructor(iClass){

                public IClass[] getParameterTypes() {
                    return argumentTypes;
                }

                public Access getAccess() {
                    return Access.PUBLIC;
                }

                public IClass[] getThrownExceptions() {
                    return new IClass[0];
                }
            };
        }
        if (iInvocables[0] instanceof IClass.IMethod) {
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IMethod(iClass){

                public boolean isStatic() {
                    return true;
                }

                public boolean isAbstract() {
                    return false;
                }

                public IClass getReturnType() {
                    return IClass.INT;
                }

                public String getName() {
                    return ((IClass.IMethod)iInvocables[0]).getName();
                }

                public Access getAccess() {
                    return Access.PUBLIC;
                }

                public IClass[] getParameterTypes() {
                    return argumentTypes;
                }

                public IClass[] getThrownExceptions() {
                    return new IClass[0];
                }
            };
        }
        return iInvocables[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IClass.IInvocable findMostSpecificIInvocable(Java.Locatable l, IClass.IInvocable[] iInvocables, IClass[] argumentTypes, boolean boxingPermitted, Java.Scope contextScope) throws CompileException {
        int i;
        ArrayList<IClass.IInvocable> maximallySpecificIInvocables;
        block31: {
            ArrayList<IClass.IInvocable> applicableIInvocables = new ArrayList<IClass.IInvocable>();
            block0: for (int i2 = 0; i2 < iInvocables.length; ++i2) {
                IClass.IInvocable ii = iInvocables[i2];
                IClass[] parameterTypes = ii.getParameterTypes();
                if (parameterTypes.length != argumentTypes.length || !this.isAccessible(ii, contextScope)) continue;
                for (int j = 0; j < argumentTypes.length; ++j) {
                    if (!this.isMethodInvocationConvertible(argumentTypes[j], parameterTypes[j], boxingPermitted)) continue block0;
                }
                applicableIInvocables.add(ii);
            }
            if (applicableIInvocables.size() == 0) {
                return null;
            }
            if (applicableIInvocables.size() == 1) {
                return (IClass.IInvocable)applicableIInvocables.get(0);
            }
            maximallySpecificIInvocables = new ArrayList<IClass.IInvocable>();
            for (int i3 = 0; i3 < applicableIInvocables.size(); ++i3) {
                IClass.IInvocable applicableIInvocable = (IClass.IInvocable)applicableIInvocables.get(i3);
                int moreSpecific = 0;
                int lessSpecific = 0;
                for (int j = 0; j < maximallySpecificIInvocables.size(); ++j) {
                    IClass.IInvocable mostSpecificIInvocable = (IClass.IInvocable)maximallySpecificIInvocables.get(j);
                    if (applicableIInvocable.isMoreSpecificThan(mostSpecificIInvocable)) {
                        ++moreSpecific;
                        continue;
                    }
                    if (!applicableIInvocable.isLessSpecificThan(mostSpecificIInvocable)) continue;
                    ++lessSpecific;
                }
                if (moreSpecific == maximallySpecificIInvocables.size()) {
                    maximallySpecificIInvocables.clear();
                    maximallySpecificIInvocables.add(applicableIInvocable);
                    continue;
                }
                if (lessSpecific >= maximallySpecificIInvocables.size()) continue;
                maximallySpecificIInvocables.add(applicableIInvocable);
            }
            if (maximallySpecificIInvocables.size() == 1) {
                return (IClass.IInvocable)maximallySpecificIInvocables.get(0);
            }
            if (maximallySpecificIInvocables.size() > 1 && iInvocables[0] instanceof IClass.IMethod) {
                int i4;
                IClass.IMethod theNonAbstractMethod = null;
                Iterator it = maximallySpecificIInvocables.iterator();
                IClass.IMethod m = (IClass.IMethod)it.next();
                IClass[] parameterTypesOfFirstMethod = m.getParameterTypes();
                block4: while (true) {
                    if (!m.isAbstract()) {
                        if (theNonAbstractMethod == null) {
                            theNonAbstractMethod = m;
                        } else {
                            IClass theNonAbstractMethodDeclaringIClass;
                            IClass declaringIClass = m.getDeclaringIClass();
                            if (declaringIClass == (theNonAbstractMethodDeclaringIClass = theNonAbstractMethod.getDeclaringIClass())) {
                                if (m.getReturnType() == theNonAbstractMethod.getReturnType()) {
                                    throw new JaninoRuntimeException("Two non-abstract methods '" + m + "' have the same parameter types, " + "declaring type and return type");
                                }
                                if (!m.getReturnType().isAssignableFrom(theNonAbstractMethod.getReturnType())) {
                                    if (!theNonAbstractMethod.getReturnType().isAssignableFrom(m.getReturnType())) throw new JaninoRuntimeException("Incompatible return types");
                                    theNonAbstractMethod = m;
                                }
                            } else if (!declaringIClass.isAssignableFrom(theNonAbstractMethodDeclaringIClass)) {
                                if (!theNonAbstractMethodDeclaringIClass.isAssignableFrom(declaringIClass)) throw new JaninoRuntimeException("SNO: Types declaring '" + theNonAbstractMethod + "' are not assignable");
                                theNonAbstractMethod = m;
                            }
                        }
                    }
                    if (!it.hasNext()) break;
                    m = (IClass.IMethod)it.next();
                    IClass[] pts = m.getParameterTypes();
                    int i5 = 0;
                    while (true) {
                        if (i5 >= pts.length) continue block4;
                        if (pts[i5] == parameterTypesOfFirstMethod[i5]) {
                            ++i5;
                            continue;
                        }
                        break block31;
                        break;
                    }
                    break;
                }
                if (theNonAbstractMethod != null) {
                    return theNonAbstractMethod;
                }
                HashSet<IClass> s = new HashSet<IClass>();
                IClass[][] tes = new IClass[maximallySpecificIInvocables.size()][];
                Iterator it2 = maximallySpecificIInvocables.iterator();
                for (i4 = 0; i4 < tes.length; ++i4) {
                    tes[i4] = ((IClass.IMethod)it2.next()).getThrownExceptions();
                }
                for (i4 = 0; i4 < tes.length; ++i4) {
                    block8: for (int j = 0; j < tes[i4].length; ++j) {
                        IClass te1 = tes[i4][j];
                        block9: for (int k = 0; k < tes.length; ++k) {
                            if (k == i4) continue;
                            for (int m2 = 0; m2 < tes[k].length; ++m2) {
                                IClass te2 = tes[k][m2];
                                if (te2.isAssignableFrom(te1)) continue block9;
                            }
                            continue block8;
                        }
                        s.add(te1);
                    }
                }
                final IClass.IMethod im = (IClass.IMethod)maximallySpecificIInvocables.get(0);
                final IClass[] tes2 = s.toArray(new IClass[s.size()]);
                IClass iClass = im.getDeclaringIClass();
                iClass.getClass();
                return new IClass.IMethod(iClass){

                    public String getName() {
                        return im.getName();
                    }

                    public IClass getReturnType() throws CompileException {
                        return im.getReturnType();
                    }

                    public boolean isAbstract() {
                        return im.isAbstract();
                    }

                    public boolean isStatic() {
                        return im.isStatic();
                    }

                    public Access getAccess() {
                        return im.getAccess();
                    }

                    public IClass[] getParameterTypes() throws CompileException {
                        return im.getParameterTypes();
                    }

                    public IClass[] getThrownExceptions() {
                        return tes2;
                    }
                };
            }
        }
        StringBuffer sb = new StringBuffer("Invocation of constructor/method with actual parameter type(s) \"");
        for (i = 0; i < argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Descriptor.toString(argumentTypes[i].getDescriptor()));
        }
        sb.append("\" is ambiguous: ");
        for (i = 0; i < maximallySpecificIInvocables.size(); ++i) {
            if (i > 0) {
                sb.append(" vs. ");
            }
            sb.append("\"" + maximallySpecificIInvocables.get(i) + "\"");
        }
        this.compileError(sb.toString(), l.getLocation());
        return (IClass.IMethod)iInvocables[0];
    }

    private boolean isMethodInvocationConvertible(IClass sourceType, IClass targetType, boolean boxingPermitted) throws CompileException {
        IClass unboxedType;
        IClass boxedType;
        if (sourceType == targetType) {
            return true;
        }
        if (this.isWideningPrimitiveConvertible(sourceType, targetType)) {
            return true;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return true;
        }
        if (boxingPermitted && (boxedType = this.isBoxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(boxedType, targetType) || this.isWideningReferenceConvertible(boxedType, targetType);
        }
        if (boxingPermitted && (unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(unboxedType, targetType) || this.isWideningPrimitiveConvertible(unboxedType, targetType);
        }
        return false;
    }

    private void checkThrownExceptions(Java.Invocation in, IClass.IMethod iMethod) throws CompileException {
        IClass[] thrownExceptions = iMethod.getThrownExceptions();
        for (int i = 0; i < thrownExceptions.length; ++i) {
            this.checkThrownException(in, thrownExceptions[i], in.getEnclosingBlockStatement());
        }
    }

    private void checkThrownException(Java.Locatable l, IClass type, Java.Scope scope) throws CompileException {
        if (!this.iClassLoader.THROWABLE.isAssignableFrom(type)) {
            this.compileError("Thrown object of type \"" + type + "\" is not assignable to \"Throwable\"", l.getLocation());
        }
        if (this.iClassLoader.RUNTIME_EXCEPTION.isAssignableFrom(type) || this.iClassLoader.ERROR.isAssignableFrom(type)) {
            return;
        }
        while (true) {
            int i;
            if (scope instanceof Java.TryStatement) {
                Java.TryStatement ts = (Java.TryStatement)scope;
                for (i = 0; i < ts.catchClauses.size(); ++i) {
                    Java.CatchClause cc = (Java.CatchClause)ts.catchClauses.get(i);
                    IClass caughtType = this.getType(cc.caughtException.type);
                    if (!caughtType.isAssignableFrom(type)) continue;
                    return;
                }
            } else {
                if (scope instanceof Java.FunctionDeclarator) {
                    Java.FunctionDeclarator fd = (Java.FunctionDeclarator)scope;
                    for (i = 0; i < fd.thrownExceptions.length; ++i) {
                        IClass te = this.getType(fd.thrownExceptions[i]);
                        if (!te.isAssignableFrom(type)) continue;
                        return;
                    }
                    break;
                }
                if (scope instanceof Java.TypeBodyDeclaration) break;
            }
            scope = scope.getEnclosingScope();
        }
        this.compileError("Thrown exception of type \"" + type + "\" is neither caught by a \"try...catch\" block " + "nor declared in the \"throws\" clause of the declaring function", l.getLocation());
    }

    private IClass getTargetIClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.targetIClass == null) {
            qtr.targetIClass = this.getType(qtr.qualification);
        }
        return qtr.targetIClass;
    }

    Java.LocalVariable isIntLV(Java.Crement c) throws CompileException {
        if (!(c.operand instanceof Java.AmbiguousName)) {
            return null;
        }
        Java.AmbiguousName an = (Java.AmbiguousName)c.operand;
        Java.Atom rec = this.reclassify(an);
        if (!(rec instanceof Java.LocalVariableAccess)) {
            return null;
        }
        Java.LocalVariableAccess lva = (Java.LocalVariableAccess)rec;
        Java.LocalVariable lv = lva.localVariable;
        if (lv.finaL) {
            this.compileError("Must not increment or decrement \"final\" local variable", lva.getLocation());
        }
        if (lv.type == IClass.BYTE || lv.type == IClass.SHORT || lv.type == IClass.INT || lv.type == IClass.CHAR) {
            return lv;
        }
        return null;
    }

    private IClass resolve(final Java.TypeDeclaration td) {
        final Java.AbstractTypeDeclaration atd = (Java.AbstractTypeDeclaration)td;
        if (atd.resolvedType == null) {
            atd.resolvedType = new IClass(){
                private IClass[] declaredClasses = null;

                protected IClass.IMethod[] getDeclaredIMethods2() {
                    IClass.IMethod[] res = new IClass.IMethod[atd.getMethodDeclarations().size()];
                    int i = 0;
                    Iterator it = atd.getMethodDeclarations().iterator();
                    while (it.hasNext()) {
                        res[i++] = UnitCompiler.this.toIMethod((Java.MethodDeclarator)it.next());
                    }
                    return res;
                }

                protected IClass[] getDeclaredIClasses2() {
                    if (this.declaredClasses == null) {
                        Collection mtds = td.getMemberTypeDeclarations();
                        IClass[] mts = new IClass[mtds.size()];
                        int i = 0;
                        Iterator it = mtds.iterator();
                        while (it.hasNext()) {
                            mts[i++] = UnitCompiler.this.resolve((Java.AbstractTypeDeclaration)it.next());
                        }
                        this.declaredClasses = mts;
                    }
                    return this.declaredClasses;
                }

                protected IClass getDeclaringIClass2() {
                    Java.Scope s = atd;
                    while (!(s instanceof Java.TypeBodyDeclaration)) {
                        if (s instanceof Java.CompilationUnit) {
                            return null;
                        }
                        s = s.getEnclosingScope();
                    }
                    return UnitCompiler.this.resolve((Java.AbstractTypeDeclaration)s.getEnclosingScope());
                }

                protected IClass getOuterIClass2() throws CompileException {
                    Java.AbstractTypeDeclaration oc = (Java.AbstractTypeDeclaration)UnitCompiler.getOuterClass(atd);
                    if (oc == null) {
                        return null;
                    }
                    return UnitCompiler.this.resolve(oc);
                }

                protected final String getDescriptor2() {
                    return Descriptor.fromClassName(atd.getClassName());
                }

                public boolean isArray() {
                    return false;
                }

                protected IClass getComponentType2() {
                    throw new JaninoRuntimeException("SNO: Non-array type has no component type");
                }

                public boolean isPrimitive() {
                    return false;
                }

                public boolean isPrimitiveNumeric() {
                    return false;
                }

                protected IClass.IConstructor[] getDeclaredIConstructors2() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Java.ConstructorDeclarator[] cs = ((Java.ClassDeclaration)atd).getConstructors();
                        IClass.IConstructor[] res = new IClass.IConstructor[cs.length];
                        for (int i = 0; i < cs.length; ++i) {
                            res[i] = UnitCompiler.this.toIConstructor(cs[i]);
                        }
                        return res;
                    }
                    return new IClass.IConstructor[0];
                }

                protected IClass.IField[] getDeclaredIFields2() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Java.ClassDeclaration cd = (Java.ClassDeclaration)atd;
                        ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                        for (int i = 0; i < cd.variableDeclaratorsAndInitializers.size(); ++i) {
                            Java.BlockStatement vdoi = (Java.BlockStatement)cd.variableDeclaratorsAndInitializers.get(i);
                            if (!(vdoi instanceof Java.FieldDeclaration)) continue;
                            Java.FieldDeclaration fd = (Java.FieldDeclaration)vdoi;
                            IClass.IField[] flds = UnitCompiler.this.getIFields(fd);
                            for (int j = 0; j < flds.length; ++j) {
                                l.add(flds[j]);
                            }
                        }
                        return l.toArray(new IClass.IField[l.size()]);
                    }
                    if (atd instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                        ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                        for (int i = 0; i < id.constantDeclarations.size(); ++i) {
                            Java.BlockStatement bs = (Java.BlockStatement)id.constantDeclarations.get(i);
                            if (!(bs instanceof Java.FieldDeclaration)) continue;
                            Java.FieldDeclaration fd = (Java.FieldDeclaration)bs;
                            IClass.IField[] flds = UnitCompiler.this.getIFields(fd);
                            for (int j = 0; j < flds.length; ++j) {
                                l.add(flds[j]);
                            }
                        }
                        return l.toArray(new IClass.IField[l.size()]);
                    }
                    throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
                }

                public IClass.IField[] getSyntheticIFields() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Collection c = ((Java.ClassDeclaration)atd).syntheticFields.values();
                        return c.toArray(new IClass.IField[c.size()]);
                    }
                    return new IClass.IField[0];
                }

                protected IClass getSuperclass2() throws CompileException {
                    if (atd instanceof Java.AnonymousClassDeclaration) {
                        IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                        return bt.isInterface() ? ((UnitCompiler)UnitCompiler.this).iClassLoader.OBJECT : bt;
                    }
                    if (atd instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                        if (ncd.optionalExtendedType == null) {
                            return ((UnitCompiler)UnitCompiler.this).iClassLoader.OBJECT;
                        }
                        IClass superclass = UnitCompiler.this.getType(ncd.optionalExtendedType);
                        if (superclass.isInterface()) {
                            UnitCompiler.this.compileError("\"" + superclass.toString() + "\" is an interface; classes can only extend a class", td.getLocation());
                        }
                        return superclass;
                    }
                    return null;
                }

                public Access getAccess() {
                    return UnitCompiler.modifiers2Access(atd.getModifiers());
                }

                public boolean isFinal() {
                    return (atd.getModifiers() & 0x10) != 0;
                }

                protected IClass[] getInterfaces2() throws CompileException {
                    if (atd instanceof Java.AnonymousClassDeclaration) {
                        IClass[] iClassArray;
                        IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                        if (bt.isInterface()) {
                            IClass[] iClassArray2 = new IClass[1];
                            iClassArray = iClassArray2;
                            iClassArray2[0] = bt;
                        } else {
                            iClassArray = new IClass[]{};
                        }
                        return iClassArray;
                    }
                    if (atd instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                        IClass[] res = new IClass[ncd.implementedTypes.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = UnitCompiler.this.getType(ncd.implementedTypes[i]);
                            if (res[i].isInterface()) continue;
                            UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; classes can only implement interfaces", td.getLocation());
                        }
                        return res;
                    }
                    if (atd instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                        IClass[] res = new IClass[id.extendedTypes.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = UnitCompiler.this.getType(id.extendedTypes[i]);
                            if (res[i].isInterface()) continue;
                            UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; interfaces can only extend interfaces", td.getLocation());
                        }
                        return res;
                    }
                    throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
                }

                public boolean isAbstract() {
                    return atd instanceof Java.InterfaceDeclaration || (atd.getModifiers() & 0x400) != 0;
                }

                public boolean isInterface() {
                    return atd instanceof Java.InterfaceDeclaration;
                }
            };
        }
        return atd.resolvedType;
    }

    private void referenceThis(Java.Locatable l, Java.ClassDeclaration declaringClass, Java.TypeBodyDeclaration declaringTypeBodyDeclaration, IClass targetIClass) throws CompileException {
        int i;
        int j;
        List path;
        block8: {
            path = UnitCompiler.getOuterClasses(declaringClass);
            if (declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static context", l.getLocation());
            }
            for (j = 0; j < path.size(); ++j) {
                if (!targetIClass.isAssignableFrom(this.resolve((Java.AbstractTypeDeclaration)path.get(j)))) {
                    continue;
                }
                break block8;
            }
            this.compileError("\"" + declaringClass + "\" is not enclosed by \"" + targetIClass + "\"", l.getLocation());
        }
        if (declaringTypeBodyDeclaration instanceof Java.ConstructorDeclarator) {
            if (j == 0) {
                this.writeOpcode(l, 42);
                return;
            }
            Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)declaringTypeBodyDeclaration;
            String spn = "this$" + (path.size() - 2);
            Java.LocalVariable syntheticParameter = (Java.LocalVariable)constructorDeclarator.syntheticParameters.get(spn);
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter \"" + spn + "\" not found");
            }
            this.load(l, syntheticParameter);
            i = 1;
        } else {
            this.writeOpcode(l, 42);
            i = 0;
        }
        while (i < j) {
            String fieldName = "this$" + (path.size() - i - 2);
            Java.InnerClassDeclaration inner = (Java.InnerClassDeclaration)path.get(i);
            IClass iic = this.resolve((Java.AbstractTypeDeclaration)((Object)inner));
            Java.TypeDeclaration outer = (Java.TypeDeclaration)path.get(i + 1);
            IClass oic = this.resolve((Java.AbstractTypeDeclaration)outer);
            inner.defineSyntheticField(new SimpleIField(iic, fieldName, oic));
            this.writeOpcode(l, -76);
            this.writeConstantFieldrefInfo(iic.getDescriptor(), fieldName, oic.getDescriptor());
            ++i;
        }
    }

    private static List getOuterClasses(Java.TypeDeclaration inner) {
        ArrayList<Java.TypeDeclaration> path = new ArrayList<Java.TypeDeclaration>();
        Java.TypeDeclaration ic = inner;
        while (ic != null) {
            path.add(ic);
            ic = UnitCompiler.getOuterClass(ic);
        }
        return path;
    }

    static Java.TypeDeclaration getOuterClass(Java.TypeDeclaration atd) {
        if (atd instanceof Java.PackageMemberClassDeclaration) {
            return null;
        }
        if (atd instanceof Java.LocalClassDeclaration) {
            Java.Scope s = atd.getEnclosingScope();
            while (!(s instanceof Java.FunctionDeclarator)) {
                s = s.getEnclosingScope();
            }
            if (s instanceof Java.MethodDeclarator && (((Java.FunctionDeclarator)s).modifiers & 8) != 0) {
                return null;
            }
            while (!(s instanceof Java.TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeDeclaration immediatelyEnclosingTypeDeclaration = (Java.TypeDeclaration)s;
            return immediatelyEnclosingTypeDeclaration instanceof Java.ClassDeclaration ? immediatelyEnclosingTypeDeclaration : null;
        }
        if (atd instanceof Java.MemberClassDeclaration && (((Java.MemberClassDeclaration)atd).getModifiers() & 8) != 0) {
            return null;
        }
        Java.Scope s = atd;
        while (!(s instanceof Java.TypeBodyDeclaration)) {
            if (s instanceof Java.ConstructorInvocation) {
                return null;
            }
            if (s instanceof Java.CompilationUnit) {
                return null;
            }
            s = s.getEnclosingScope();
        }
        if (((Java.TypeBodyDeclaration)s).isStatic()) {
            return null;
        }
        return (Java.AbstractTypeDeclaration)s.getEnclosingScope();
    }

    private IClass getIClass(Java.ThisReference tr) throws CompileException {
        if (tr.iClass == null) {
            Java.Scope s = tr.getEnclosingBlockStatement();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                s = s.getEnclosingScope();
            }
            if (s instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator function = (Java.FunctionDeclarator)s;
                if ((function.modifiers & 8) != 0) {
                    this.compileError("No current instance available in static method", tr.getLocation());
                }
            }
            while (!(s instanceof Java.TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            if (!(s instanceof Java.ClassDeclaration)) {
                this.compileError("Only methods of classes can have a current instance", tr.getLocation());
            }
            tr.iClass = this.resolve((Java.ClassDeclaration)s);
        }
        return tr.iClass;
    }

    private IClass getReturnType(Java.FunctionDeclarator fd) throws CompileException {
        if (fd.returnType == null) {
            fd.returnType = this.getType(fd.type);
        }
        return fd.returnType;
    }

    IClass.IConstructor toIConstructor(final Java.ConstructorDeclarator cd) {
        if (cd.iConstructor != null) {
            return cd.iConstructor;
        }
        IClass iClass = this.resolve((Java.AbstractTypeDeclaration)cd.getDeclaringType());
        iClass.getClass();
        cd.iConstructor = new IClass.IConstructor(iClass){

            public Access getAccess() {
                switch (cd.modifiers & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            public String getDescriptor() throws CompileException {
                if (!(cd.getDeclaringClass() instanceof Java.InnerClassDeclaration)) {
                    return super.getDescriptor();
                }
                ArrayList<String> l = new ArrayList<String>();
                IClass outerClass = UnitCompiler.this.resolve(cd.getDeclaringClass()).getOuterIClass();
                if (outerClass != null) {
                    l.add(outerClass.getDescriptor());
                }
                Iterator it = cd.getDeclaringClass().syntheticFields.values().iterator();
                while (it.hasNext()) {
                    IClass.IField sf = (IClass.IField)it.next();
                    if (!sf.getName().startsWith("val$")) continue;
                    l.add(sf.getType().getDescriptor());
                }
                Java.FunctionDeclarator.FormalParameter[] fps = cd.formalParameters;
                for (int i = 0; i < fps.length; ++i) {
                    l.add(UnitCompiler.this.getType(fps[i].type).getDescriptor());
                }
                String[] apd = l.toArray(new String[l.size()]);
                return new MethodDescriptor(apd, "V").toString();
            }

            public IClass[] getParameterTypes() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] fps = cd.formalParameters;
                IClass[] res = new IClass[fps.length];
                for (int i = 0; i < fps.length; ++i) {
                    res[i] = UnitCompiler.this.getType(fps[i].type);
                }
                return res;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                IClass[] res = new IClass[cd.thrownExceptions.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = UnitCompiler.this.getType(cd.thrownExceptions[i]);
                }
                return res;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(cd.getDeclaringType().getClassName());
                sb.append('(');
                Java.FunctionDeclarator.FormalParameter[] fps = cd.formalParameters;
                for (int i = 0; i < fps.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    try {
                        sb.append(UnitCompiler.this.getType(fps[i].type).toString());
                        continue;
                    }
                    catch (CompileException ex) {
                        sb.append("???");
                    }
                }
                return sb.append(')').toString();
            }
        };
        return cd.iConstructor;
    }

    public IClass.IMethod toIMethod(final Java.MethodDeclarator md) {
        if (md.iMethod != null) {
            return md.iMethod;
        }
        IClass iClass = this.resolve((Java.AbstractTypeDeclaration)md.getDeclaringType());
        iClass.getClass();
        md.iMethod = new IClass.IMethod(iClass){

            public Access getAccess() {
                switch (md.modifiers & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            public IClass[] getParameterTypes() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] fps = md.formalParameters;
                IClass[] res = new IClass[fps.length];
                for (int i = 0; i < fps.length; ++i) {
                    res[i] = UnitCompiler.this.getType(fps[i].type);
                }
                return res;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                IClass[] res = new IClass[md.thrownExceptions.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = UnitCompiler.this.getType(md.thrownExceptions[i]);
                }
                return res;
            }

            public boolean isStatic() {
                return (md.modifiers & 8) != 0;
            }

            public boolean isAbstract() {
                return md.getDeclaringType() instanceof Java.InterfaceDeclaration || (md.modifiers & 0x400) != 0;
            }

            public IClass getReturnType() throws CompileException {
                return UnitCompiler.this.getReturnType(md);
            }

            public String getName() {
                return md.name;
            }
        };
        return md.iMethod;
    }

    private IClass.IInvocable toIInvocable(Java.FunctionDeclarator fd) {
        if (fd instanceof Java.ConstructorDeclarator) {
            return this.toIConstructor((Java.ConstructorDeclarator)fd);
        }
        if (fd instanceof Java.MethodDeclarator) {
            return this.toIMethod((Java.MethodDeclarator)fd);
        }
        throw new JaninoRuntimeException("FunctionDeclarator is neither ConstructorDeclarator nor MethodDeclarator");
    }

    private IClass importSingleType(String simpleTypeName, Location location) throws CompileException {
        Object[] ss = this.getSingleTypeImport(simpleTypeName);
        if (ss == null) {
            return null;
        }
        IClass iClass = this.loadFullyQualifiedClass((String[])ss);
        if (iClass == null) {
            this.compileError("Imported class \"" + Java.join(ss, ".") + "\" could not be loaded", location);
            return this.iClassLoader.OBJECT;
        }
        return iClass;
    }

    public String[] getSingleTypeImport(String name) {
        return (String[])this.singleTypeImports.get(name);
    }

    public IClass importTypeOnDemand(String simpleTypeName, Location location) throws CompileException {
        IClass importedClass = (IClass)this.onDemandImportableTypes.get(simpleTypeName);
        if (importedClass != null) {
            return importedClass;
        }
        Iterator i = this.typeImportsOnDemand.iterator();
        while (i.hasNext()) {
            String[] ss = (String[])i.next();
            String[] ss2 = UnitCompiler.concat(ss, simpleTypeName);
            IClass iClass = this.loadFullyQualifiedClass(ss2);
            if (iClass == null) continue;
            if (importedClass != null && importedClass != iClass) {
                this.compileError("Ambiguous class name: \"" + importedClass + "\" vs. \"" + iClass + "\"", location);
            }
            importedClass = iClass;
        }
        if (importedClass == null) {
            return null;
        }
        this.onDemandImportableTypes.put(simpleTypeName, importedClass);
        return importedClass;
    }

    private void declareClassDollarMethod(Java.ClassLiteral cl) {
        IClass noClassDefFoundErrorIClass;
        IClass classNotFoundExceptionIClass;
        Location loc = cl.getLocation();
        Java.Scope s = cl.getEnclosingBlockStatement();
        while (true) {
            if (s instanceof Java.AbstractTypeDeclaration) break;
            s = s.getEnclosingScope();
        }
        Java.AbstractTypeDeclaration declaringType = (Java.AbstractTypeDeclaration)s;
        Java.MethodInvocation mi = new Java.MethodInvocation(loc, new Java.SimpleType(loc, this.iClassLoader.CLASS), "forName", new Java.Rvalue[]{new Java.AmbiguousName(loc, new String[]{"className"})});
        try {
            classNotFoundExceptionIClass = this.iClassLoader.loadIClass("Ljava/lang/ClassNotFoundException;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"ClassNotFoundException\": " + ex.getMessage());
        }
        if (classNotFoundExceptionIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"ClassNotFoundException\"");
        }
        try {
            noClassDefFoundErrorIClass = this.iClassLoader.loadIClass("Ljava/lang/NoClassDefFoundError;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"NoClassDefFoundError\": " + ex.getMessage());
        }
        if (noClassDefFoundErrorIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"NoClassFoundError\"");
        }
        Java.Block b = new Java.Block(loc);
        b.addStatement(new Java.ThrowStatement(loc, new Java.NewClassInstance(loc, null, new Java.SimpleType(loc, noClassDefFoundErrorIClass), new Java.Rvalue[]{new Java.MethodInvocation(loc, new Java.AmbiguousName(loc, new String[]{"ex"}), "getMessage", new Java.Rvalue[0])})));
        ArrayList<Java.CatchClause> l = new ArrayList<Java.CatchClause>();
        l.add(new Java.CatchClause(loc, new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, classNotFoundExceptionIClass), "ex"), b));
        Java.TryStatement ts = new Java.TryStatement(loc, new Java.ReturnStatement(loc, mi), l, null);
        ArrayList<Java.TryStatement> statements = new ArrayList<Java.TryStatement>();
        statements.add(ts);
        Java.FunctionDeclarator.FormalParameter fp = new Java.FunctionDeclarator.FormalParameter(loc, false, new Java.SimpleType(loc, this.iClassLoader.STRING), "className");
        Java.MethodDeclarator cdmd = new Java.MethodDeclarator(loc, null, 8, new Java.SimpleType(loc, this.iClassLoader.CLASS), "class$", new Java.FunctionDeclarator.FormalParameter[]{fp}, new Java.Type[0], statements);
        declaringType.addDeclaredMethod(cdmd);
        declaringType.invalidateMethodCaches();
    }

    private IClass pushConstant(Java.Locatable l, Object value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Character || value instanceof Byte) {
            int i;
            int n = i = value instanceof Character ? ((Character)value).charValue() : ((Number)value).intValue();
            if (i >= -1 && i <= 5) {
                this.writeOpcode(l, 3 + i);
            } else if (i >= -128 && i <= 127) {
                this.writeOpcode(l, 16);
                this.writeByte((byte)i);
            } else {
                this.writeLDC(l, this.addConstantIntegerInfo(i));
            }
            return IClass.INT;
        }
        if (value instanceof Long) {
            long lv = (Long)value;
            if (lv >= 0L && lv <= 1L) {
                this.writeOpcode(l, 9 + (int)lv);
            } else {
                this.writeOpcode(l, 20);
                this.writeConstantLongInfo(lv);
            }
            return IClass.LONG;
        }
        if (value instanceof Float) {
            float fv = ((Float)value).floatValue();
            if (Float.floatToIntBits(fv) == Float.floatToIntBits(0.0f) || fv == 1.0f || fv == 2.0f) {
                this.writeOpcode(l, 11 + (int)fv);
            } else {
                this.writeLDC(l, this.addConstantFloatInfo(fv));
            }
            return IClass.FLOAT;
        }
        if (value instanceof Double) {
            double dv = (Double)value;
            if (Double.doubleToLongBits(dv) == Double.doubleToLongBits(0.0) || dv == 1.0) {
                this.writeOpcode(l, 14 + (int)dv);
            } else {
                this.writeOpcode(l, 20);
                this.writeConstantDoubleInfo(dv);
            }
            return IClass.DOUBLE;
        }
        if (value instanceof String) {
            String s = (String)value;
            String[] ss = UnitCompiler.makeUTF8Able(s);
            this.writeLDC(l, this.addConstantStringInfo(ss[0]));
            for (int i = 1; i < ss.length; ++i) {
                this.writeLDC(l, this.addConstantStringInfo(ss[i]));
                this.writeOpcode(l, -74);
                this.writeConstantMethodrefInfo("Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
            }
            return this.iClassLoader.STRING;
        }
        if (value instanceof Boolean) {
            this.writeOpcode(l, (Boolean)value != false ? 4 : 3);
            return IClass.BOOLEAN;
        }
        if (value == Java.Rvalue.CONSTANT_VALUE_NULL) {
            this.writeOpcode(l, 1);
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("Unknown literal type \"" + value.getClass().getName() + "\"");
    }

    private static String[] makeUTF8Able(String s) {
        if (s.length() < 21845) {
            return new String[]{s};
        }
        int sLength = s.length();
        int uTFLength = 0;
        int from = 0;
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (true) {
            char c;
            if (i == sLength) {
                l.add(s.substring(from));
                break;
            }
            if (uTFLength >= 65532) {
                l.add(s.substring(from, i));
                if (i + 21845 > sLength) {
                    l.add(s.substring(i));
                    break;
                }
                from = i;
                uTFLength = 0;
            }
            uTFLength = (c = s.charAt(i)) >= '\u0001' && c <= '\u007f' ? ++uTFLength : (c > '\u07ff' ? (uTFLength += 3) : (uTFLength += 2));
            ++i;
        }
        return l.toArray(new String[l.size()]);
    }

    private void writeLDC(Java.Locatable l, short index) {
        if (0 <= index && index <= 255) {
            this.writeOpcode(l, 18);
            this.writeByte((byte)index);
        } else {
            this.writeOpcode(l, 19);
            this.writeShort(index);
        }
    }

    private void assignmentConversion(Java.Locatable l, IClass sourceType, IClass targetType, Object optionalConstantValue) throws CompileException {
        IClass unboxedType;
        if (this.tryIdentityConversion(sourceType, targetType)) {
            return;
        }
        if (this.tryWideningPrimitiveConversion(l, sourceType, targetType)) {
            return;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return;
        }
        IClass boxedType = this.isBoxingConvertible(sourceType);
        if (boxedType != null) {
            if (this.tryIdentityConversion(boxedType, targetType)) {
                this.boxingConversion(l, sourceType, boxedType);
                return;
            }
            if (this.isWideningReferenceConvertible(boxedType, targetType)) {
                this.boxingConversion(l, sourceType, boxedType);
                return;
            }
        }
        if ((unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            if (this.tryIdentityConversion(unboxedType, targetType)) {
                this.unboxingConversion(l, sourceType, unboxedType);
                return;
            }
            if (this.isWideningPrimitiveConvertible(unboxedType, targetType)) {
                this.unboxingConversion(l, sourceType, unboxedType);
                this.tryWideningPrimitiveConversion(l, unboxedType, targetType);
                return;
            }
        }
        if (optionalConstantValue != null && this.tryConstantAssignmentConversion(l, optionalConstantValue, targetType)) {
            return;
        }
        this.compileError("Assignment conversion not possible from type \"" + sourceType + "\" to type \"" + targetType + "\"", l.getLocation());
    }

    private Object assignmentConversion(Java.Locatable l, Object value, IClass targetType) throws CompileException {
        Object result = null;
        if (targetType == IClass.BOOLEAN) {
            if (value instanceof Boolean) {
                result = value;
            }
        } else if (targetType == this.iClassLoader.STRING) {
            if (value instanceof String) {
                result = value;
            }
        } else if (targetType == IClass.BYTE) {
            char x;
            if (value instanceof Byte) {
                result = value;
            } else if (value instanceof Short || value instanceof Integer) {
                int x2 = ((Number)value).intValue();
                if (x2 >= -128 && x2 <= 127) {
                    result = new Byte((byte)x2);
                }
            } else if (value instanceof Character && (x = ((Character)value).charValue()) >= '\uffffff80' && x <= '\u007f') {
                result = new Byte((byte)x);
            }
        } else if (targetType == IClass.SHORT) {
            int x;
            if (value instanceof Byte) {
                result = new Short(((Number)value).shortValue());
            } else if (value instanceof Short) {
                result = value;
            } else if (value instanceof Character) {
                char x3 = ((Character)value).charValue();
                if (x3 >= Short.MIN_VALUE && x3 <= Short.MAX_VALUE) {
                    result = new Short((short)x3);
                }
            } else if (value instanceof Integer && (x = ((Integer)value).intValue()) >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                result = new Short((short)x);
            }
        } else if (targetType == IClass.CHAR) {
            int x;
            if (value instanceof Short) {
                result = value;
            } else if ((value instanceof Byte || value instanceof Short || value instanceof Integer) && (x = ((Number)value).intValue()) >= 0 && x <= 65535) {
                result = new Character((char)x);
            }
        } else if (targetType == IClass.INT) {
            if (value instanceof Integer) {
                result = value;
            } else if (value instanceof Byte || value instanceof Short) {
                result = new Integer(((Number)value).intValue());
            } else if (value instanceof Character) {
                result = new Integer(((Character)value).charValue());
            }
        } else if (targetType == IClass.LONG) {
            if (value instanceof Long) {
                result = value;
            } else if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                result = new Long(((Number)value).longValue());
            } else if (value instanceof Character) {
                result = new Long(((Character)value).charValue());
            }
        } else if (targetType == IClass.FLOAT) {
            if (value instanceof Float) {
                result = value;
            } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                result = new Float(((Number)value).floatValue());
            } else if (value instanceof Character) {
                result = new Float(((Character)value).charValue());
            }
        } else if (targetType == IClass.DOUBLE) {
            if (value instanceof Double) {
                result = value;
            } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float) {
                result = new Double(((Number)value).doubleValue());
            } else if (value instanceof Character) {
                result = new Double(((Character)value).charValue());
            }
        } else if (value == Java.Rvalue.CONSTANT_VALUE_NULL && !targetType.isPrimitive()) {
            result = value;
        }
        if (result == null) {
            this.compileError("Cannot convert constant of type \"" + value.getClass().getName() + "\" to type \"" + targetType.toString() + "\"", l.getLocation());
        }
        return result;
    }

    private IClass unaryNumericPromotion(Java.Locatable l, IClass type) throws CompileException {
        type = this.convertToPrimitiveNumericType(l, type);
        IClass promotedType = this.unaryNumericPromotionType(l, type);
        this.numericPromotion(l, type, promotedType);
        return promotedType;
    }

    private void reverseUnaryNumericPromotion(Java.Locatable l, IClass sourceType, IClass targetType) throws CompileException {
        IClass pt;
        IClass unboxedType = this.isUnboxingConvertible(targetType);
        IClass iClass = pt = unboxedType != null ? unboxedType : targetType;
        if (!this.tryIdentityConversion(sourceType, pt) && !this.tryNarrowingPrimitiveConversion(l, sourceType, pt)) {
            throw new JaninoRuntimeException("SNO: reverse unary numeric promotion failed");
        }
        if (unboxedType != null) {
            this.boxingConversion(l, unboxedType, targetType);
        }
    }

    private IClass convertToPrimitiveNumericType(Java.Locatable l, IClass type) throws CompileException {
        if (type.isPrimitiveNumeric()) {
            return type;
        }
        IClass unboxedType = this.isUnboxingConvertible(type);
        if (unboxedType != null) {
            this.unboxingConversion(l, type, unboxedType);
            return unboxedType;
        }
        this.compileError("Object of type \"" + type.toString() + "\" cannot be converted to a numeric type", l.getLocation());
        return type;
    }

    private void numericPromotion(Java.Locatable l, IClass sourceType, IClass targetType) {
        if (!this.tryIdentityConversion(sourceType, targetType) && !this.tryWideningPrimitiveConversion(l, sourceType, targetType)) {
            throw new JaninoRuntimeException("SNO: Conversion failed");
        }
    }

    private IClass unaryNumericPromotionType(Java.Locatable l, IClass type) throws CompileException {
        if (!type.isPrimitiveNumeric()) {
            this.compileError("Unary numeric promotion not possible on non-numeric-primitive type \"" + type + "\"", l.getLocation());
        }
        return type == IClass.DOUBLE ? IClass.DOUBLE : (type == IClass.FLOAT ? IClass.FLOAT : (type == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private IClass binaryNumericPromotion(Java.Locatable locatable, IClass type1, CodeContext.Inserter convertInserter1, IClass type2) throws CompileException {
        return this.binaryNumericPromotion(locatable, type1, convertInserter1, type2, this.codeContext.currentInserter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass binaryNumericPromotion(Java.Locatable l, IClass type1, CodeContext.Inserter convertInserter1, IClass type2, CodeContext.Inserter convertInserter2) throws CompileException {
        IClass c1 = this.isUnboxingConvertible(type1);
        IClass c2 = this.isUnboxingConvertible(type2);
        IClass promotedType = this.binaryNumericPromotionType(l, c1 != null ? c1 : type1, c2 != null ? c2 : type2);
        if (convertInserter1 != null) {
            this.codeContext.pushInserter(convertInserter1);
            try {
                this.numericPromotion(l, this.convertToPrimitiveNumericType(l, type1), promotedType);
            }
            finally {
                this.codeContext.popInserter();
            }
        }
        if (convertInserter2 != null) {
            this.codeContext.pushInserter(convertInserter2);
            try {
                this.numericPromotion(l, this.convertToPrimitiveNumericType(l, type2), promotedType);
            }
            finally {
                this.codeContext.popInserter();
            }
        }
        return promotedType;
    }

    private IClass binaryNumericPromotionType(Java.Locatable locatable, IClass type1, IClass type2) throws CompileException {
        if (!type1.isPrimitiveNumeric() || !type2.isPrimitiveNumeric()) {
            this.compileError("Binary numeric promotion not possible on types \"" + type1 + "\" and \"" + type2 + "\"", locatable.getLocation());
        }
        return type1 == IClass.DOUBLE || type2 == IClass.DOUBLE ? IClass.DOUBLE : (type1 == IClass.FLOAT || type2 == IClass.FLOAT ? IClass.FLOAT : (type1 == IClass.LONG || type2 == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private boolean isIdentityConvertible(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean tryIdentityConversion(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean isWideningPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor()) != null;
    }

    private boolean tryWideningPrimitiveConversion(Java.Locatable l, IClass sourceType, IClass targetType) {
        byte[] opcodes = (byte[])PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes != null) {
            this.writeOpcodes(l, opcodes);
            return true;
        }
        return false;
    }

    private static void fillConversionMap(Object[] array, HashMap map) {
        byte[] opcodes = null;
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (o instanceof byte[]) {
                opcodes = (byte[])o;
                continue;
            }
            map.put(o, opcodes);
        }
    }

    private boolean isWideningReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean tryWideningReferenceConversion(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean isNarrowingPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_NARROWING_CONVERSIONS.containsKey(sourceType.getDescriptor() + targetType.getDescriptor());
    }

    private boolean tryNarrowingPrimitiveConversion(Java.Locatable l, IClass sourceType, IClass targetType) {
        byte[] opcodes = (byte[])PRIMITIVE_NARROWING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes != null) {
            this.writeOpcodes(l, opcodes);
            return true;
        }
        return false;
    }

    private boolean tryConstantAssignmentConversion(Java.Locatable l, Object constantValue, IClass targetType) throws CompileException {
        int cv;
        if (constantValue instanceof Byte) {
            cv = ((Byte)constantValue).byteValue();
        } else if (constantValue instanceof Short) {
            cv = ((Short)constantValue).shortValue();
        } else if (constantValue instanceof Integer) {
            cv = (Integer)constantValue;
        } else if (constantValue instanceof Character) {
            cv = ((Character)constantValue).charValue();
        } else {
            return false;
        }
        if (targetType == IClass.BYTE) {
            return cv >= -128 && cv <= 127;
        }
        if (targetType == IClass.SHORT) {
            return cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE;
        }
        if (targetType == IClass.CHAR) {
            return cv >= 0 && cv <= 65535;
        }
        IClassLoader icl = this.iClassLoader;
        if (targetType == icl.BYTE && cv >= -128 && cv <= 127) {
            this.boxingConversion(l, IClass.BYTE, targetType);
            return true;
        }
        if (targetType == icl.SHORT && cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE) {
            this.boxingConversion(l, IClass.SHORT, targetType);
            return true;
        }
        if (targetType == icl.CHARACTER && cv >= 0 && cv <= 65535) {
            this.boxingConversion(l, IClass.CHAR, targetType);
            return true;
        }
        return false;
    }

    private boolean isNarrowingReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        IClass tt;
        IClass st;
        if (sourceType.isPrimitive()) {
            return false;
        }
        if (sourceType == targetType) {
            return false;
        }
        if (sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (targetType.isInterface() && !sourceType.isFinal() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType == this.iClassLoader.OBJECT && targetType.isArray()) {
            return true;
        }
        if (sourceType == this.iClassLoader.OBJECT && targetType.isInterface()) {
            return true;
        }
        if (sourceType.isInterface() && !targetType.isFinal()) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isFinal() && sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isInterface() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType.isArray() && targetType.isArray() && (this.isNarrowingPrimitiveConvertible(st = sourceType.getComponentType(), tt = targetType.getComponentType()) || this.isNarrowingReferenceConvertible(st, tt));
    }

    private boolean tryNarrowingReferenceConversion(Java.Locatable l, IClass sourceType, IClass targetType) throws CompileException {
        if (!this.isNarrowingReferenceConvertible(sourceType, targetType)) {
            return false;
        }
        this.writeOpcode(l, -64);
        this.writeConstantClassInfo(targetType.getDescriptor());
        return true;
    }

    private IClass isBoxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == IClass.BOOLEAN) {
            return icl.BOOLEAN;
        }
        if (sourceType == IClass.BYTE) {
            return icl.BYTE;
        }
        if (sourceType == IClass.CHAR) {
            return icl.CHARACTER;
        }
        if (sourceType == IClass.SHORT) {
            return icl.SHORT;
        }
        if (sourceType == IClass.INT) {
            return icl.INTEGER;
        }
        if (sourceType == IClass.LONG) {
            return icl.LONG;
        }
        if (sourceType == IClass.FLOAT) {
            return icl.FLOAT;
        }
        if (sourceType == IClass.DOUBLE) {
            return icl.DOUBLE;
        }
        return null;
    }

    private boolean tryBoxingConversion(Java.Locatable l, IClass sourceType, IClass targetType) throws CompileException {
        if (this.isBoxingConvertible(sourceType) == targetType) {
            this.boxingConversion(l, sourceType, targetType);
            return true;
        }
        return false;
    }

    private void boxingConversion(Java.Locatable l, IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.hasIMethod("valueOf", new IClass[]{sourceType})) {
            this.writeOpcode(l, -72);
            this.writeConstantMethodrefInfo(targetType.getDescriptor(), "valueOf", '(' + sourceType.getDescriptor() + ')' + targetType.getDescriptor());
            return;
        }
        this.writeOpcode(l, -69);
        this.writeConstantClassInfo(targetType.getDescriptor());
        if (Descriptor.hasSize2(sourceType.getDescriptor())) {
            this.writeOpcode(l, 91);
            this.writeOpcode(l, 91);
            this.writeOpcode(l, 87);
        } else {
            this.writeOpcode(l, 90);
            this.writeOpcode(l, 95);
        }
        this.writeOpcode(l, -73);
        this.writeConstantMethodrefInfo(targetType.getDescriptor(), "<init>", '(' + sourceType.getDescriptor() + ')' + "V");
    }

    private IClass isUnboxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == icl.BOOLEAN) {
            return IClass.BOOLEAN;
        }
        if (sourceType == icl.BYTE) {
            return IClass.BYTE;
        }
        if (sourceType == icl.CHARACTER) {
            return IClass.CHAR;
        }
        if (sourceType == icl.SHORT) {
            return IClass.SHORT;
        }
        if (sourceType == icl.INTEGER) {
            return IClass.INT;
        }
        if (sourceType == icl.LONG) {
            return IClass.LONG;
        }
        if (sourceType == icl.FLOAT) {
            return IClass.FLOAT;
        }
        if (sourceType == icl.DOUBLE) {
            return IClass.DOUBLE;
        }
        return null;
    }

    private boolean tryUnboxingConversion(Java.Locatable l, IClass sourceType, IClass targetType) {
        if (this.isUnboxingConvertible(sourceType) == targetType) {
            this.unboxingConversion(l, sourceType, targetType);
            return true;
        }
        return false;
    }

    private void unboxingConversion(Java.Locatable l, IClass sourceType, IClass targetType) {
        this.writeOpcode(l, -74);
        this.writeConstantMethodrefInfo(sourceType.getDescriptor(), targetType.toString() + "Value", "()" + targetType.getDescriptor());
    }

    private IClass loadFullyQualifiedClass(String[] identifiers) throws CompileException {
        int[] slashes = new int[identifiers.length - 1];
        StringBuffer sb = new StringBuffer("L");
        int i = 0;
        while (true) {
            sb.append(identifiers[i]);
            if (i == identifiers.length - 1) break;
            slashes[i] = sb.length();
            sb.append('/');
            ++i;
        }
        sb.append(';');
        int j = slashes.length - 1;
        while (true) {
            IClass result;
            try {
                result = this.iClassLoader.loadIClass(sb.toString());
            }
            catch (ClassNotFoundException ex) {
                if (ex.getException() instanceof CompileException) {
                    throw (CompileException)ex.getException();
                }
                throw new CompileException(sb.toString(), null, ex);
            }
            if (result != null) {
                return result;
            }
            if (j < 0) break;
            sb.setCharAt(slashes[j], '$');
            --j;
        }
        return null;
    }

    private IClass load(Java.Locatable l, Java.LocalVariable localVariable) {
        this.load(l, localVariable.type, localVariable.getSlotIndex());
        return localVariable.type;
    }

    private void load(Java.Locatable l, IClass type, int index) {
        if (index <= 3) {
            this.writeOpcode(l, 26 + 4 * this.ilfda(type) + index);
        } else if (index <= 255) {
            this.writeOpcode(l, 21 + this.ilfda(type));
            this.writeByte(index);
        } else {
            this.writeOpcode(l, -60);
            this.writeOpcode(l, 21 + this.ilfda(type));
            this.writeShort(index);
        }
    }

    private void store(Java.Locatable l, IClass valueType, Java.LocalVariable localVariable) {
        this.store(l, localVariable.type, localVariable.getSlotIndex());
    }

    private void store(Java.Locatable l, IClass lvType, short lvIndex) {
        if (lvIndex <= 3) {
            this.writeOpcode(l, 59 + 4 * this.ilfda(lvType) + lvIndex);
        } else if (lvIndex <= 255) {
            this.writeOpcode(l, 54 + this.ilfda(lvType));
            this.writeByte(lvIndex);
        } else {
            this.writeOpcode(l, -60);
            this.writeOpcode(l, 54 + this.ilfda(lvType));
            this.writeShort(lvIndex);
        }
    }

    private void dup(Java.Locatable l, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.writeOpcode(l, 89);
                break;
            }
            case 2: {
                this.writeOpcode(l, 92);
                break;
            }
            default: {
                throw new JaninoRuntimeException("dup(" + n + ")");
            }
        }
    }

    private void dupx(Java.Locatable l, IClass type, int x) {
        if (x < 0 || x > 2) {
            throw new JaninoRuntimeException("SNO: x has value " + x);
        }
        int dup = 89 + x;
        int dup2 = 92 + x;
        this.writeOpcode(l, type == IClass.LONG || type == IClass.DOUBLE ? dup2 : dup);
    }

    private void pop(Java.Locatable l, IClass type) {
        if (type == IClass.VOID) {
            return;
        }
        this.writeOpcode(l, type == IClass.LONG || type == IClass.DOUBLE ? 88 : 87);
    }

    static int ilfd(IClass t) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    static int ilfd(IClass t, int opcodeInt, int opcodeLong, int opcodeFloat, int opcodeDouble) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return opcodeInt;
        }
        if (t == IClass.LONG) {
            return opcodeLong;
        }
        if (t == IClass.FLOAT) {
            return opcodeFloat;
        }
        if (t == IClass.DOUBLE) {
            return opcodeDouble;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private int ilfda(IClass t) {
        return !t.isPrimitive() ? 4 : UnitCompiler.ilfd(t);
    }

    static int ilfdabcs(IClass t) {
        if (t == IClass.INT) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        if (!t.isPrimitive()) {
            return 4;
        }
        if (t == IClass.BOOLEAN) {
            return 5;
        }
        if (t == IClass.BYTE) {
            return 5;
        }
        if (t == IClass.CHAR) {
            return 6;
        }
        if (t == IClass.SHORT) {
            return 7;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private IClass.IField findIField(IClass iClass, String name, Location location) throws CompileException {
        IClass.IField f = iClass.getDeclaredIField(name);
        if (f != null) {
            return f;
        }
        IClass superclass = iClass.getSuperclass();
        if (superclass != null) {
            f = this.findIField(superclass, name, location);
        }
        IClass[] ifs = iClass.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            IClass.IField f2 = this.findIField(ifs[i], name, location);
            if (f2 == null) continue;
            if (f != null) {
                throw new CompileException("Access to field \"" + name + "\" is ambiguous - both \"" + f.getDeclaringIClass() + "\" and \"" + f2.getDeclaringIClass() + "\" declare it", location);
            }
            f = f2;
        }
        return f;
    }

    private IClass findMemberType(IClass iClass, String name, Location location) throws CompileException {
        IClass[] types = iClass.findMemberType(name);
        if (types.length == 0) {
            return null;
        }
        if (types.length == 1) {
            return types[0];
        }
        StringBuffer sb = new StringBuffer("Type \"" + name + "\" is ambiguous: " + types[0].toString());
        for (int i = 1; i < types.length; ++i) {
            sb.append(" vs. ").append(types[i].toString());
        }
        this.compileError(sb.toString(), location);
        return types[0];
    }

    public IClass findClass(String className) {
        StringTokenizer st;
        Java.NamedTypeDeclaration td;
        String packageName;
        String string = packageName = this.compilationUnit.optionalPackageDeclaration == null ? null : this.compilationUnit.optionalPackageDeclaration.packageName;
        if (packageName != null) {
            if (!className.startsWith(packageName + '.')) {
                return null;
            }
            className = className.substring(packageName.length() + 1);
        }
        if ((td = this.compilationUnit.getPackageMemberTypeDeclaration((st = new StringTokenizer(className, "$")).nextToken())) == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if ((td = td.getMemberTypeDeclaration(st.nextToken())) != null) continue;
            return null;
        }
        return this.resolve((Java.AbstractTypeDeclaration)((Object)td));
    }

    private void compileError(String message) throws CompileException {
        this.compileError(message, null);
    }

    private void compileError(String message, Location optionalLocation) throws CompileException {
        ++this.compileErrorCount;
        if (this.optionalCompileErrorHandler == null) {
            throw new CompileException(message, optionalLocation);
        }
        this.optionalCompileErrorHandler.handleError(message, optionalLocation);
    }

    private void warning(String handle, String message, Location optionalLocation) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    private CodeContext getCodeContext() {
        CodeContext res = this.codeContext;
        if (res == null) {
            throw new JaninoRuntimeException("S.N.O.: Null CodeContext");
        }
        return res;
    }

    private CodeContext replaceCodeContext(CodeContext newCodeContext) {
        CodeContext oldCodeContext = this.codeContext;
        this.codeContext = newCodeContext;
        return oldCodeContext;
    }

    private CodeContext createDummyCodeContext() {
        return new CodeContext(this.getCodeContext().getClassFile());
    }

    private void writeByte(int v) {
        if (v > 255) {
            throw new JaninoRuntimeException("Byte value out of legal range");
        }
        this.codeContext.write((short)-1, (byte)v);
    }

    private void writeShort(int v) {
        if (v > 65535) {
            throw new JaninoRuntimeException("Short value out of legal range");
        }
        this.codeContext.write((short)-1, (byte)(v >> 8), (byte)v);
    }

    private void writeInt(int v) {
        this.codeContext.write((short)-1, (byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v);
    }

    private void writeOpcode(Java.Locatable l, int opcode) {
        this.codeContext.write(l.getLocation().getLineNumber(), (byte)opcode);
    }

    private void writeOpcodes(Java.Locatable l, byte[] opcodes) {
        this.codeContext.write(l.getLocation().getLineNumber(), opcodes);
    }

    private void writeBranch(Java.Locatable l, int opcode, CodeContext.Offset dst) {
        this.codeContext.writeBranch(l.getLocation().getLineNumber(), opcode, dst);
    }

    private void writeOffset(CodeContext.Offset src, CodeContext.Offset dst) {
        this.codeContext.writeOffset((short)-1, src, dst);
    }

    private void writeConstantClassInfo(String descriptor) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantClassInfo(descriptor));
    }

    private void writeConstantFieldrefInfo(String classFD, String fieldName, String fieldFD) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantFieldrefInfo(classFD, fieldName, fieldFD));
    }

    private void writeConstantMethodrefInfo(String classFD, String methodName, String methodMD) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantMethodrefInfo(classFD, methodName, methodMD));
    }

    private void writeConstantInterfaceMethodrefInfo(String classFD, String methodName, String methodMD) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantInterfaceMethodrefInfo(classFD, methodName, methodMD));
    }

    private short addConstantStringInfo(String value) {
        return this.codeContext.getClassFile().addConstantStringInfo(value);
    }

    private short addConstantIntegerInfo(int value) {
        return this.codeContext.getClassFile().addConstantIntegerInfo(value);
    }

    private short addConstantFloatInfo(float value) {
        return this.codeContext.getClassFile().addConstantFloatInfo(value);
    }

    private void writeConstantLongInfo(long value) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantLongInfo(value));
    }

    private void writeConstantDoubleInfo(double value) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantDoubleInfo(value));
    }

    public CodeContext.Offset getWhereToBreak(Java.BreakableStatement bs) {
        if (bs.whereToBreak == null) {
            bs.whereToBreak = this.codeContext.new CodeContext.Offset();
        }
        return bs.whereToBreak;
    }

    private Java.TypeBodyDeclaration getDeclaringTypeBodyDeclaration(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringTypeBodyDeclaration == null) {
            Java.Scope s = qtr.getEnclosingBlockStatement();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            qtr.declaringTypeBodyDeclaration = (Java.TypeBodyDeclaration)s;
            if (qtr.declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static method", qtr.getLocation());
            }
            qtr.declaringClass = (Java.ClassDeclaration)qtr.declaringTypeBodyDeclaration.getDeclaringType();
        }
        return qtr.declaringTypeBodyDeclaration;
    }

    private Java.ClassDeclaration getDeclaringClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringClass == null) {
            this.getDeclaringTypeBodyDeclaration(qtr);
        }
        return qtr.declaringClass;
    }

    private void referenceThis(Java.Locatable l) {
        this.writeOpcode(l, 42);
    }

    private IClass newArray(Java.Locatable l, int dimExprCount, int dims, IClass componentType) {
        if (dimExprCount == 1 && dims == 0 && componentType.isPrimitive()) {
            this.writeOpcode(l, -68);
            this.writeByte(componentType == IClass.BOOLEAN ? 4 : (componentType == IClass.CHAR ? 5 : (componentType == IClass.FLOAT ? 6 : (componentType == IClass.DOUBLE ? 7 : (componentType == IClass.BYTE ? 8 : (componentType == IClass.SHORT ? 9 : (componentType == IClass.INT ? 10 : (componentType == IClass.LONG ? 11 : -1))))))));
            return componentType.getArrayIClass(this.iClassLoader.OBJECT);
        }
        if (dimExprCount == 1) {
            IClass at = componentType.getArrayIClass(dims, this.iClassLoader.OBJECT);
            this.writeOpcode(l, -67);
            this.writeConstantClassInfo(at.getDescriptor());
            return at.getArrayIClass(this.iClassLoader.OBJECT);
        }
        IClass at = componentType.getArrayIClass(dimExprCount + dims, this.iClassLoader.OBJECT);
        this.writeOpcode(l, -59);
        this.writeConstantClassInfo(at.getDescriptor());
        this.writeByte(dimExprCount);
        return at;
    }

    private static Access modifiers2Access(short modifiers) {
        return (modifiers & 1) != 0 ? Access.PUBLIC : ((modifiers & 4) != 0 ? Access.PROTECTED : ((modifiers & 2) != 0 ? Access.PRIVATE : Access.DEFAULT));
    }

    private static String last(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        return sa[sa.length - 1];
    }

    private static String[] allButLast(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        String[] tmp = new String[sa.length - 1];
        System.arraycopy(sa, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private static String[] concat(String[] sa, String s) {
        String[] tmp = new String[sa.length + 1];
        System.arraycopy(sa, 0, tmp, 0, sa.length);
        tmp[sa.length] = s;
        return tmp;
    }

    static {
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BS", "BI", "SI", "CI", new byte[]{-123}, "BJ", "SJ", "CJ", "IJ", new byte[]{-122}, "BF", "SF", "CF", "IF", new byte[]{-119}, "JF", new byte[]{-121}, "BD", "SD", "CD", "ID", new byte[]{-118}, "JD", new byte[]{-115}, "FD"}, PRIMITIVE_WIDENING_CONVERSIONS);
        PRIMITIVE_NARROWING_CONVERSIONS = new HashMap();
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BC", "SC", "CS", new byte[]{-111}, "SB", "CB", "IB", new byte[]{-109}, "IS", "IC", new byte[]{-120, -111}, "JB", new byte[]{-120, -109}, "JS", "JC", new byte[]{-120}, "JI", new byte[]{-117, -111}, "FB", new byte[]{-117, -109}, "FS", "FC", new byte[]{-117}, "FI", new byte[]{-116}, "FJ", new byte[]{-114, -111}, "DB", new byte[]{-114, -109}, "DS", "DC", new byte[]{-114}, "DI", new byte[]{-113}, "DJ", new byte[]{-112}, "DF"}, PRIMITIVE_NARROWING_CONVERSIONS);
    }

    public static class SimpleIField
    extends IClass.IField {
        private final String name;
        private final IClass type;

        public SimpleIField(IClass declaringIClass, String name, IClass type) {
            this.name = name;
            this.type = type;
        }

        public Object getConstantValue() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public IClass getType() {
            return this.type;
        }

        public boolean isStatic() {
            return false;
        }

        public Access getAccess() {
            return Access.DEFAULT;
        }
    }

    public static interface ErrorHandler {
        public void handleError(String var1, Location var2) throws CompileException;
    }

    static interface Compilable {
        public void compile() throws CompileException;
    }
}

