/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.UnicodeUnescapeException;
import org.codehaus.janino.UnicodeUnescapeReader;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.TeeReader;

public class Scanner {
    public static final Integer MAGIC_INTEGER;
    public static final Long MAGIC_LONG;
    private String optionalFileName;
    private Reader in;
    private int nextChar = -1;
    private boolean crLfPending = false;
    private short nextCharLineNumber;
    private short nextCharColumnNumber;
    private Token nextToken = new Token(){};
    private Token nextButOneToken;
    private short tokenLineNumber;
    private short tokenColumnNumber;
    private String docComment = null;
    private static final Map JAVA_KEYWORDS;
    private static final Map JAVA_OPERATORS;
    private WarningHandler optionalWarningHandler = null;

    public Scanner(String optionalFileName, Reader in) throws CompileException, IOException {
        this(optionalFileName, in, 1, 0);
    }

    public Scanner(String optionalFileName, Reader in, short initialLineNumber, short initialColumnNumber) throws CompileException, IOException {
        if (optionalFileName == null && Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
            String dirName = System.getProperty("org.codehaus.janino.source_debugging.dir");
            File dir = dirName == null ? null : new File(dirName);
            File temporaryFile = File.createTempFile("janino", ".java", dir);
            temporaryFile.deleteOnExit();
            in = new TeeReader(in, new FileWriter(temporaryFile), true);
            optionalFileName = temporaryFile.getAbsolutePath();
        }
        this.optionalFileName = optionalFileName;
        this.in = new UnicodeUnescapeReader(in);
        this.nextCharLineNumber = initialLineNumber;
        this.nextCharColumnNumber = initialColumnNumber;
        this.readNextChar();
        this.nextToken = this.internalRead();
        this.nextButOneToken = null;
    }

    public String getFileName() {
        return this.optionalFileName;
    }

    public Token read() throws CompileException, IOException {
        Token res = this.nextToken;
        if (this.nextButOneToken != null) {
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
        } else {
            this.nextToken = this.internalRead();
        }
        return res;
    }

    public Token peek() {
        return this.nextToken;
    }

    public Token peekNextButOne() throws CompileException, IOException {
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.internalRead();
        }
        return this.nextButOneToken;
    }

    public String doc() {
        String s = this.docComment;
        this.docComment = null;
        return s;
    }

    public Location location() {
        return this.nextToken.getLocation();
    }

    public static String literalValueToString(Object v) {
        if (v instanceof String) {
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            String s = (String)v;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                Scanner.escapeCharacter(c, sb);
            }
            sb.append('\"');
            return sb.toString();
        }
        if (v instanceof Character) {
            char c = ((Character)v).charValue();
            if (c == '\'') {
                return "'\\''";
            }
            StringBuffer sb = new StringBuffer("'");
            Scanner.escapeCharacter(c, sb);
            return sb.append('\'').toString();
        }
        if (v instanceof Integer) {
            if (v == MAGIC_INTEGER) {
                return "2147483648";
            }
            int iv = (Integer)v;
            return iv < 0 ? "0x" + Integer.toHexString(iv) : Integer.toString(iv);
        }
        if (v instanceof Long) {
            if (v == MAGIC_LONG) {
                return "9223372036854775808L";
            }
            long lv = (Long)v;
            return lv < 0L ? "0x" + Long.toHexString(lv) + 'L' : Long.toString(lv) + 'L';
        }
        if (v instanceof Float) {
            return v.toString() + 'F';
        }
        if (v instanceof Double) {
            return v.toString() + 'D';
        }
        if (v instanceof Boolean) {
            return v.toString();
        }
        if (v instanceof Byte) {
            return "((byte)" + v.toString() + ")";
        }
        if (v instanceof Short) {
            return "((short)" + v.toString() + ")";
        }
        if (v == null) {
            return "null";
        }
        throw new JaninoRuntimeException("Unexpected value type \"" + v.getClass().getName() + "\"");
    }

    private static void escapeCharacter(char c, StringBuffer sb) {
        int idx = "\b\t\n\f\r\\".indexOf(c);
        if (idx != -1) {
            sb.append('\\').append("btnfr\\".charAt(idx));
        } else if (c >= ' ' && c < '\u00ff' && c != '\u007f') {
            sb.append(c);
        } else {
            sb.append("\\u");
            String hs = Integer.toHexString(0xFFFF & c);
            for (int j = hs.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hs);
        }
    }

    private Token internalRead() throws CompileException, IOException {
        if (this.docComment != null) {
            this.warning("MDC", "Misplaced doc comment", this.nextToken.getLocation());
            this.docComment = null;
        }
        int state = 0;
        StringBuffer dcsb = null;
        block13: while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == -1) {
                        return new EOFToken();
                    }
                    if (Character.isWhitespace((char)this.nextChar)) break;
                    if (this.nextChar != 47) break block13;
                    state = 1;
                    break;
                }
                case 1: {
                    if (this.nextChar == -1) {
                        return new OperatorToken("/");
                    }
                    if (this.nextChar == 61) {
                        this.readNextChar();
                        return new OperatorToken("/=");
                    }
                    if (this.nextChar == 47) {
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 42) {
                        state = 3;
                        break;
                    }
                    return new OperatorToken("/");
                }
                case 2: {
                    if (this.nextChar == -1) {
                        return new EOFToken();
                    }
                    if (this.nextChar != 13 && this.nextChar != 10) break;
                    state = 0;
                    break;
                }
                case 3: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 4;
                        break;
                    }
                    state = 9;
                    break;
                }
                case 4: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.docComment != null) {
                        this.warning("MDC", "Multiple doc comments", new Location(this.optionalFileName, this.nextCharLineNumber, this.nextCharColumnNumber));
                    }
                    dcsb = new StringBuffer();
                    dcsb.append((char)this.nextChar);
                    state = this.nextChar == 13 || this.nextChar == 10 ? 6 : (this.nextChar == 42 ? 8 : 5);
                    break;
                }
                case 5: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 8;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        state = 6;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    break;
                }
                case 6: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 32 || this.nextChar == 9) break;
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 7: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) break;
                    if (this.nextChar == 47) {
                        this.docComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 8: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        this.docComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) {
                        dcsb.append('*');
                        break;
                    }
                    dcsb.append('*');
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 9: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar != 42) break;
                    state = 10;
                    break;
                }
                case 10: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) break;
                    state = 9;
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(Integer.toString(state));
                }
            }
            this.readNextChar();
        }
        this.tokenLineNumber = this.nextCharLineNumber;
        this.tokenColumnNumber = this.nextCharColumnNumber;
        if (Character.isJavaIdentifierStart((char)this.nextChar)) {
            StringBuffer sb = new StringBuffer();
            sb.append((char)this.nextChar);
            while (true) {
                this.readNextChar();
                if (this.nextChar == -1 || !Character.isJavaIdentifierPart((char)this.nextChar)) break;
                sb.append((char)this.nextChar);
            }
            String s = sb.toString();
            if (s.equals("true")) {
                return new LiteralToken(Boolean.TRUE);
            }
            if (s.equals("false")) {
                return new LiteralToken(Boolean.FALSE);
            }
            if (s.equals("null")) {
                return new LiteralToken((Object)null);
            }
            String v = (String)JAVA_KEYWORDS.get(s);
            if (v != null) {
                return new KeywordToken(v);
            }
            return new IdentifierToken(s);
        }
        if (Character.isDigit((char)this.nextChar)) {
            return this.scanNumericLiteral(0);
        }
        if (this.nextChar == 46) {
            this.readNextChar();
            if (Character.isDigit((char)this.nextChar)) {
                return this.scanNumericLiteral(2);
            }
            return new OperatorToken(".");
        }
        if (this.nextChar == 34) {
            StringBuffer sb = new StringBuffer("");
            this.readNextChar();
            if (this.nextChar == -1) {
                throw new CompileException("EOF in string literal", this.location());
            }
            if (this.nextChar == 13 || this.nextChar == 10) {
                throw new CompileException("Line break in string literal", this.location());
            }
            while (this.nextChar != 34) {
                sb.append(this.unescapeCharacterLiteral());
            }
            this.readNextChar();
            return new LiteralToken(sb.toString());
        }
        if (this.nextChar == 39) {
            this.readNextChar();
            if (this.nextChar == 39) {
                throw new CompileException("Single quote must be backslash-escaped in character literal", this.location());
            }
            char lit = this.unescapeCharacterLiteral();
            if (this.nextChar != 39) {
                throw new CompileException("Closing single quote missing", this.location());
            }
            this.readNextChar();
            return new LiteralToken(new Character(lit));
        }
        String v = (String)JAVA_OPERATORS.get(new String(new char[]{(char)this.nextChar}));
        if (v != null) {
            while (true) {
                this.readNextChar();
                String v2 = (String)JAVA_OPERATORS.get(v + (char)this.nextChar);
                if (v2 == null) {
                    return new OperatorToken(v);
                }
                v = v2;
            }
        }
        throw new CompileException("Invalid character input \"" + (char)this.nextChar + "\" (character code " + this.nextChar + ")", this.location());
    }

    private Token scanNumericLiteral(int initialState) throws CompileException, IOException {
        StringBuffer sb = initialState == 2 ? new StringBuffer("0.") : new StringBuffer();
        int state = initialState;
        while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == 48) {
                        state = 6;
                        break;
                    }
                    sb.append((char)this.nextChar);
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 46) {
                        sb.append('.');
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 10);
                }
                case 2: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 101 || this.nextChar == 69) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    return this.stringToDoubleLiteralToken(sb.toString());
                }
                case 3: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    if (this.nextChar == 45 || this.nextChar == 43) {
                        sb.append((char)this.nextChar);
                        state = 4;
                        break;
                    }
                    throw new CompileException("Exponent missing after \"E\"", this.location());
                }
                case 4: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    throw new CompileException("Exponent missing after \"E\" and sign", this.location());
                }
                case 5: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    return this.stringToDoubleLiteralToken(sb.toString());
                }
                case 6: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken("0", 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken("0");
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken("0");
                    }
                    if (this.nextChar == 46) {
                        sb.append("0.");
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 120 || this.nextChar == 88) {
                        state = 8;
                        break;
                    }
                    return this.stringToIntegerLiteralToken("0", 10);
                }
                case 7: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 56 || this.nextChar == 57) {
                        throw new CompileException("Digit '" + (char)this.nextChar + "' not allowed in octal literal", this.location());
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 8);
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 8);
                }
                case 8: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        state = 9;
                        break;
                    }
                    throw new CompileException("Hex digit expected after \"0x\"", this.location());
                }
                case 9: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 16);
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 16);
                }
                default: {
                    throw new JaninoRuntimeException(Integer.toString(state));
                }
            }
            this.readNextChar();
        }
    }

    private LiteralToken stringToIntegerLiteralToken(String s, int radix) throws CompileException {
        int x;
        switch (radix) {
            case 10: {
                if (s.equals("2147483648")) {
                    return new LiteralToken(MAGIC_INTEGER);
                }
                try {
                    x = Integer.parseInt(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new CompileException("Value of decimal integer literal \"" + s + "\" is out of range", this.location());
                }
            }
            case 8: {
                x = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xE0000000) != 0) {
                        throw new CompileException("Value of octal integer literal \"" + s + "\" is out of range", this.location());
                    }
                    x = (x << 3) + Character.digit(s.charAt(i), 8);
                }
                break;
            }
            case 16: {
                x = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xF0000000) != 0) {
                        throw new CompileException("Value of hexadecimal integer literal \"" + s + "\" is out of range", this.location());
                    }
                    x = (x << 4) + Character.digit(s.charAt(i), 16);
                }
                break;
            }
            default: {
                throw new JaninoRuntimeException("Illegal radix " + radix);
            }
        }
        return new LiteralToken(new Integer(x));
    }

    private LiteralToken stringToLongLiteralToken(String s, int radix) throws CompileException {
        long x;
        switch (radix) {
            case 10: {
                if (s.equals("9223372036854775808")) {
                    return new LiteralToken(MAGIC_LONG);
                }
                try {
                    x = Long.parseLong(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new CompileException("Value of decimal long literal \"" + s + "\" is out of range", this.location());
                }
            }
            case 8: {
                x = 0L;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xE000000000000000L) != 0L) {
                        throw new CompileException("Value of octal long literal \"" + s + "\" is out of range", this.location());
                    }
                    x = (x << 3) + (long)Character.digit(s.charAt(i), 8);
                }
                break;
            }
            case 16: {
                x = 0L;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xF000000000000000L) != 0L) {
                        throw new CompileException("Value of hexadecimal long literal \"" + s + "\" is out of range", this.location());
                    }
                    x = (x << 4) + (long)Character.digit(s.charAt(i), 16);
                }
                break;
            }
            default: {
                throw new JaninoRuntimeException("Illegal radix " + radix);
            }
        }
        return new LiteralToken(new Long(x));
    }

    private LiteralToken stringToFloatLiteralToken(String s) throws CompileException {
        float f;
        try {
            f = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new JaninoRuntimeException("SNO: parsing float literal \"" + s + "\" throws a \"NumberFormatException\"");
        }
        if (Float.isInfinite(f)) {
            throw new CompileException("Value of float literal \"" + s + "\" is out of range", this.location());
        }
        if (Float.isNaN(f)) {
            throw new JaninoRuntimeException("SNO: parsing float literal \"" + s + "\" results is NaN");
        }
        if (f == 0.0f) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if ("123456789".indexOf(c) != -1) {
                    throw new CompileException("Literal \"" + s + "\" is too small to be represented as a float", this.location());
                }
                if ("0.".indexOf(c) == -1) break;
            }
        }
        return new LiteralToken(new Float(f));
    }

    private LiteralToken stringToDoubleLiteralToken(String s) throws CompileException {
        double d;
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new JaninoRuntimeException("SNO: parsing double literal \"" + s + "\" throws a \"NumberFormatException\"");
        }
        if (Double.isInfinite(d)) {
            throw new CompileException("Value of double literal \"" + s + "\" is out of range", this.location());
        }
        if (Double.isNaN(d)) {
            throw new JaninoRuntimeException("SNO: parsing double literal \"" + s + "\" results is NaN");
        }
        if (d == 0.0) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if ("123456789".indexOf(c) != -1) {
                    throw new CompileException("Literal \"" + s + "\" is too small to be represented as a double", this.location());
                }
                if ("0.".indexOf(c) == -1) break;
            }
        }
        return new LiteralToken(new Double(d));
    }

    private char unescapeCharacterLiteral() throws CompileException, IOException {
        if (this.nextChar == -1) {
            throw new CompileException("EOF in character literal", this.location());
        }
        if (this.nextChar == 13 || this.nextChar == 10) {
            throw new CompileException("Line break in literal not allowed", this.location());
        }
        if (this.nextChar != 92) {
            char res = (char)this.nextChar;
            this.readNextChar();
            return res;
        }
        this.readNextChar();
        int idx = "btnfr".indexOf(this.nextChar);
        if (idx != -1) {
            char res = "\b\t\n\f\r".charAt(idx);
            this.readNextChar();
            return res;
        }
        idx = "01234567".indexOf(this.nextChar);
        if (idx != -1) {
            int code = idx;
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return (char)code;
            }
            code = 8 * code + idx;
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return (char)code;
            }
            if ((code = 8 * code + idx) > 255) {
                throw new CompileException("Invalid octal escape", this.location());
            }
            this.readNextChar();
            return (char)code;
        }
        char res = (char)this.nextChar;
        this.readNextChar();
        return res;
    }

    private void readNextChar() throws IOException, CompileException {
        try {
            this.nextChar = this.in.read();
        }
        catch (UnicodeUnescapeException ex) {
            throw new CompileException(ex.getMessage(), this.location(), ex);
        }
        if (this.nextChar == 13) {
            this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
            this.nextCharColumnNumber = 0;
            this.crLfPending = true;
        } else if (this.nextChar == 10) {
            if (this.crLfPending) {
                this.crLfPending = false;
            } else {
                this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
                this.nextCharColumnNumber = 0;
            }
        } else {
            this.nextCharColumnNumber = (short)(this.nextCharColumnNumber + 1);
        }
    }

    private void warning(String handle, String message, Location optionalLocation) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    static {
        int i;
        MAGIC_INTEGER = new Integer(Integer.MIN_VALUE);
        MAGIC_LONG = new Long(Long.MIN_VALUE);
        JAVA_KEYWORDS = new HashMap();
        String[] ks = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        for (i = 0; i < ks.length; ++i) {
            JAVA_KEYWORDS.put(ks[i], ks[i]);
        }
        JAVA_OPERATORS = new HashMap();
        String[] ops = new String[]{"(", ")", "{", "}", "[", "]", ";", ",", ".", "=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="};
        for (i = 0; i < ops.length; ++i) {
            JAVA_OPERATORS.put(ops[i], ops[i]);
        }
    }

    public class EOFToken
    extends Token {
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "End-Of-File";
        }
    }

    private class OperatorToken
    extends Token {
        private final String operator;

        OperatorToken(String operator) {
            this.operator = operator;
        }

        public boolean isOperator() {
            return true;
        }

        public boolean isOperator(String o) {
            return this.operator == o;
        }

        public boolean isOperator(String[] os) {
            for (int i = 0; i < os.length; ++i) {
                if (this.operator != os[i]) continue;
                return true;
            }
            return false;
        }

        public String getOperator() {
            return this.operator;
        }

        public String toString() {
            return this.operator;
        }
    }

    public final class LiteralToken
    extends Token {
        private final Object value;

        public LiteralToken(Object value) {
            this.value = value;
        }

        public boolean isLiteral() {
            return true;
        }

        public Object getLiteralValue() {
            return this.value;
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public class IdentifierToken
    extends Token {
        private final String identifier;

        IdentifierToken(String identifier) {
            this.identifier = identifier;
        }

        public boolean isIdentifier() {
            return true;
        }

        public boolean isIdentifier(String id) {
            return this.identifier.equals(id);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }

    public class KeywordToken
    extends Token {
        private final String keyword;

        KeywordToken(String keyword) {
            this.keyword = keyword;
        }

        public boolean isKeyword() {
            return true;
        }

        public boolean isKeyword(String k) {
            return this.keyword == k;
        }

        public boolean isKeyword(String[] ks) {
            for (int i = 0; i < ks.length; ++i) {
                if (this.keyword != ks[i]) continue;
                return true;
            }
            return false;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String toString() {
            return this.keyword;
        }
    }

    public abstract class Token {
        private String optionalFileName;
        private short lineNumber;
        private short columnNumber;
        private Location location = null;

        private Token() {
            this.optionalFileName = Scanner.this.optionalFileName;
            this.lineNumber = Scanner.this.tokenLineNumber;
            this.columnNumber = Scanner.this.tokenColumnNumber;
        }

        public Location getLocation() {
            if (this.location == null) {
                this.location = new Location(this.optionalFileName, this.lineNumber, this.columnNumber);
            }
            return this.location;
        }

        public boolean isKeyword() {
            return false;
        }

        public boolean isKeyword(String k) {
            return false;
        }

        public boolean isKeyword(String[] ks) {
            return false;
        }

        public String getKeyword() throws CompileException {
            throw new CompileException("Not a keyword token", Scanner.this.location());
        }

        public boolean isIdentifier() {
            return false;
        }

        public boolean isIdentifier(String id) {
            return false;
        }

        public String getIdentifier() throws CompileException {
            throw new CompileException("Not an identifier token", Scanner.this.location());
        }

        public boolean isLiteral() {
            return false;
        }

        public Object getLiteralValue() throws CompileException {
            throw new CompileException("Not a literal token", Scanner.this.location());
        }

        public boolean isOperator() {
            return false;
        }

        public boolean isOperator(String o) {
            return false;
        }

        public boolean isOperator(String[] os) {
            return false;
        }

        public String getOperator() throws CompileException {
            throw new CompileException("Not an operator token", Scanner.this.location());
        }

        public boolean isEOF() {
            return false;
        }
    }
}

