/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JaninoRuntimeException;

public final class Descriptor {
    private static final Map classNameToDescriptor = new HashMap();
    private static final Map descriptorToClassName = new HashMap();

    public static boolean isReference(String d) {
        return d.length() > 1;
    }

    public static boolean isClassOrInterfaceReference(String d) {
        return d.charAt(0) == 'L';
    }

    public static boolean isArrayReference(String d) {
        return d.charAt(0) == '[';
    }

    public static String getComponentDescriptor(String d) {
        if (d.charAt(0) != '[') {
            throw new JaninoRuntimeException("Cannot determine component descriptor from non-array descriptor \"" + d + "\"");
        }
        return d.substring(1);
    }

    public static short size(String d) {
        if (d.equals("V")) {
            return 0;
        }
        if (Descriptor.hasSize1(d)) {
            return 1;
        }
        if (Descriptor.hasSize2(d)) {
            return 2;
        }
        throw new JaninoRuntimeException("No size defined for type \"" + Descriptor.toString(d) + "\"");
    }

    public static boolean hasSize1(String d) {
        if (d.length() == 1) {
            return "BCFISZ".indexOf(d) != -1;
        }
        return Descriptor.isReference(d);
    }

    public static boolean hasSize2(String d) {
        return d.equals("J") || d.equals("D");
    }

    public static String toString(String d) {
        int idx = 0;
        StringBuffer sb = new StringBuffer();
        if (d.charAt(0) == '(') {
            ++idx;
            sb.append("(");
            while (idx < d.length() && d.charAt(idx) != ')') {
                if (idx != 1) {
                    sb.append(", ");
                }
                idx = Descriptor.toString(d, idx, sb);
            }
            if (idx >= d.length()) {
                throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
            }
            sb.append(") => ");
            ++idx;
        }
        Descriptor.toString(d, idx, sb);
        return sb.toString();
    }

    private static int toString(String d, int idx, StringBuffer sb) {
        int dimensions = 0;
        while (idx < d.length() && d.charAt(idx) == '[') {
            ++dimensions;
            ++idx;
        }
        if (idx >= d.length()) {
            throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
        }
        switch (d.charAt(idx)) {
            case 'L': {
                int idx2 = d.indexOf(59, idx);
                if (idx2 == -1) {
                    throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
                }
                sb.append(d.substring(idx + 1, idx2).replace('/', '.'));
                idx = idx2;
                break;
            }
            case 'V': {
                sb.append("void");
                break;
            }
            case 'B': {
                sb.append("byte");
                break;
            }
            case 'C': {
                sb.append("char");
                break;
            }
            case 'D': {
                sb.append("double");
                break;
            }
            case 'F': {
                sb.append("float");
                break;
            }
            case 'I': {
                sb.append("int");
                break;
            }
            case 'J': {
                sb.append("long");
                break;
            }
            case 'S': {
                sb.append("short");
                break;
            }
            case 'Z': {
                sb.append("boolean");
                break;
            }
            default: {
                throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
            }
        }
        while (dimensions > 0) {
            sb.append("[]");
            --dimensions;
        }
        return idx + 1;
    }

    public static String fromClassName(String className) {
        String res = (String)classNameToDescriptor.get(className);
        if (res != null) {
            return res;
        }
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        return 'L' + className.replace('.', '/') + ';';
    }

    public static String toClassName(String d) {
        String res = (String)descriptorToClassName.get(d);
        if (res != null) {
            return res;
        }
        char firstChar = d.charAt(0);
        if (firstChar == 'L' && d.endsWith(";")) {
            return d.substring(1, d.length() - 1).replace('/', '.');
        }
        if (firstChar == '[') {
            return d.replace('/', '.');
        }
        throw new JaninoRuntimeException("(Invalid field descriptor \"" + d + "\")");
    }

    public static String toInternalForm(String d) {
        if (d.charAt(0) != 'L') {
            throw new JaninoRuntimeException("Attempt to convert non-class descriptor \"" + d + "\" into internal form");
        }
        return d.substring(1, d.length() - 1);
    }

    public static boolean isPrimitive(String d) {
        return d.length() == 1 && "VBCDFIJSZ".indexOf(d.charAt(0)) != -1;
    }

    public static boolean isPrimitiveNumeric(String d) {
        return d.length() == 1 && "BDFIJSC".indexOf(d.charAt(0)) != -1;
    }

    public static String getPackageName(String d) {
        if (d.charAt(0) != 'L') {
            throw new JaninoRuntimeException("Attempt to get package name of non-class descriptor \"" + d + "\"");
        }
        int idx = d.lastIndexOf(47);
        return idx == -1 ? null : d.substring(1, idx).replace('/', '.');
    }

    public static boolean areInSamePackage(String d1, String d2) {
        String packageName1 = Descriptor.getPackageName(d1);
        String packageName2 = Descriptor.getPackageName(d2);
        return packageName1 == null ? packageName2 == null : packageName1.equals(packageName2);
    }

    static {
        descriptorToClassName.put("V", "void");
        descriptorToClassName.put("B", "byte");
        descriptorToClassName.put("C", "char");
        descriptorToClassName.put("D", "double");
        descriptorToClassName.put("F", "float");
        descriptorToClassName.put("I", "int");
        descriptorToClassName.put("J", "long");
        descriptorToClassName.put("S", "short");
        descriptorToClassName.put("Z", "boolean");
        descriptorToClassName.put("Ljava/lang/Object;", "java.lang.Object");
        descriptorToClassName.put("Ljava/lang/String;", "java.lang.String");
        descriptorToClassName.put("Ljava/lang/StringBuffer;", "java.lang.StringBuffer");
        descriptorToClassName.put("Ljava/lang/StringBuilder;", "java.lang.StringBuilder");
        descriptorToClassName.put("Ljava/lang/Class;", "java.lang.Class");
        descriptorToClassName.put("Ljava/lang/Throwable;", "java.lang.Throwable");
        descriptorToClassName.put("Ljava/lang/RuntimeException;", "java.lang.RuntimeException");
        descriptorToClassName.put("Ljava/lang/Error;", "java.lang.Error");
        descriptorToClassName.put("Ljava/lang/Cloneable;", "java.lang.Cloneable");
        descriptorToClassName.put("Ljava/io/Serializable;", "java.io.Serializable");
        descriptorToClassName.put("Ljava/lang/Boolean;", "java.lang.Boolean");
        descriptorToClassName.put("Ljava/lang/Byte;", "java.lang.Byte");
        descriptorToClassName.put("Ljava/lang/Character;", "java.lang.Character");
        descriptorToClassName.put("Ljava/lang/Short;", "java.lang.Short");
        descriptorToClassName.put("Ljava/lang/Integer;", "java.lang.Integer");
        descriptorToClassName.put("Ljava/lang/Long;", "java.lang.Long");
        descriptorToClassName.put("Ljava/lang/Float;", "java.lang.Float");
        descriptorToClassName.put("Ljava/lang/Double;", "java.lang.Double");
        Iterator it = descriptorToClassName.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            classNameToDescriptor.put(e.getValue(), e.getKey());
        }
    }
}

