/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;

public class LearnerInfo
implements Record {
    private long serverid;
    private int protocolVersion;

    public LearnerInfo() {
    }

    public LearnerInfo(long serverid, int protocolVersion) {
        this.serverid = serverid;
        this.protocolVersion = protocolVersion;
    }

    public long getServerid() {
        return this.serverid;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeLong(this.serverid, "serverid");
        a_.writeInt(this.protocolVersion, "protocolVersion");
        a_.endRecord(this, tag);
    }

    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.serverid = a_.readLong("serverid");
        this.protocolVersion = a_.readInt("protocolVersion");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeLong(this.serverid, "serverid");
            a_.writeInt(this.protocolVersion, "protocolVersion");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof LearnerInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        LearnerInfo peer = (LearnerInfo)peer_;
        boolean ret = false;
        boolean bl = ret = this.serverid == peer.serverid;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.protocolVersion == peer.protocolVersion;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = (int)(this.serverid ^ this.serverid >>> 32);
        result = 37 * result + ret;
        ret = this.protocolVersion;
        result = 37 * result + ret;
        return result;
    }
}

