/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final ByteBuffer fill = ByteBuffer.allocateDirect(1);

    public static String makeSnapshotName(long zxid) {
        return "snapshot." + Long.toHexString(zxid);
    }

    public static long getZxidFromName(String name, String prefix) {
        long zxid = -1L;
        String[] nameParts = name.split("\\.");
        if (nameParts.length == 2 && nameParts[0].equals(prefix)) {
            try {
                zxid = Long.parseLong(nameParts[1], 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return zxid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidSnapshot(File f) throws IOException {
        RandomAccessFile raf;
        block9: {
            byte[] bytes;
            block8: {
                boolean bl;
                block7: {
                    if (f == null || Util.getZxidFromName(f.getName(), "snapshot") == -1L) {
                        return false;
                    }
                    raf = new RandomAccessFile(f, "r");
                    if (raf.length() >= 10L) break block7;
                    boolean bl2 = false;
                    Object var10_4 = null;
                    raf.close();
                    return bl2;
                }
                try {
                    int readlen;
                    int l;
                    raf.seek(raf.length() - 5L);
                    bytes = new byte[5];
                    for (readlen = 0; readlen < 5 && (l = raf.read(bytes, readlen, bytes.length - readlen)) >= 0; readlen += l) {
                    }
                    if (readlen == bytes.length) break block8;
                    LOG.info("Invalid snapshot " + f + " too short, len = " + readlen);
                    bl = false;
                    Object var10_5 = null;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    raf.close();
                    throw throwable;
                }
                raf.close();
                return bl;
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int len = bb.getInt();
            byte b = bb.get();
            if (len == 1 && b == 47) break block9;
            LOG.info("Invalid snapshot " + f + " len = " + len + " byte = " + (b & 0xFF));
            boolean bl = false;
            Object var10_6 = null;
            raf.close();
            return bl;
        }
        Object var10_7 = null;
        raf.close();
        return true;
    }

    public static long padLogFile(FileOutputStream f, long currentSize, long preAllocSize) throws IOException {
        long position = f.getChannel().position();
        if (position + 4096L >= currentSize) {
            fill.position(0);
            f.getChannel().write(fill, (currentSize += preAllocSize) - (long)fill.remaining());
        }
        return currentSize;
    }

    public static byte[] readTxnBytes(InputArchive ia) throws IOException {
        try {
            byte[] bytes = ia.readBuffer("txtEntry");
            if (bytes.length == 0) {
                return bytes;
            }
            if (ia.readByte("EOF") != 66) {
                LOG.error("Last transaction was partial.");
                return null;
            }
            return bytes;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public static byte[] marshallTxnEntry(TxnHeader hdr, Record txn) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        hdr.serialize(boa, "hdr");
        if (txn != null) {
            txn.serialize(boa, "txn");
        }
        return baos.toByteArray();
    }

    public static void writeTxnBytes(OutputArchive oa, byte[] bytes) throws IOException {
        oa.writeBuffer(bytes, "txnEntry");
        oa.writeByte((byte)66, "EOR");
    }

    public static List<File> sortDataDir(File[] files, String prefix, boolean ascending) {
        if (files == null) {
            return new ArrayList<File>(0);
        }
        List<File> filelist = Arrays.asList(files);
        Collections.sort(filelist, new DataDirFileComparator(prefix, ascending));
        return filelist;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataDirFileComparator
    implements Serializable,
    Comparator<File> {
        private String prefix;
        private boolean ascending;

        public DataDirFileComparator(String prefix, boolean ascending) {
            this.prefix = prefix;
            this.ascending = ascending;
        }

        @Override
        public int compare(File o1, File o2) {
            long z2;
            long z1 = Util.getZxidFromName(o1.getName(), this.prefix);
            int result = z1 < (z2 = Util.getZxidFromName(o2.getName(), this.prefix)) ? -1 : (z1 > z2 ? 1 : 0);
            return this.ascending ? result : -result;
        }
    }
}

