/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;

public class FileHeader
implements Record {
    private int magic;
    private int version;
    private long dbid;

    public FileHeader() {
    }

    public FileHeader(int magic, int version, long dbid) {
        this.magic = magic;
        this.version = version;
        this.dbid = dbid;
    }

    public int getMagic() {
        return this.magic;
    }

    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeInt(this.magic, "magic");
        a_.writeInt(this.version, "version");
        a_.writeLong(this.dbid, "dbid");
        a_.endRecord(this, tag);
    }

    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.magic = a_.readInt("magic");
        this.version = a_.readInt("version");
        this.dbid = a_.readLong("dbid");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeInt(this.magic, "magic");
            a_.writeInt(this.version, "version");
            a_.writeLong(this.dbid, "dbid");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof FileHeader)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        FileHeader peer = (FileHeader)peer_;
        boolean ret = false;
        boolean bl = ret = this.magic == peer.magic;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.version == peer.version;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.dbid == peer.dbid;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = this.magic;
        result = 37 * result + ret;
        ret = this.version;
        result = 37 * result + ret;
        ret = (int)(this.dbid ^ this.dbid >>> 32);
        result = 37 * result + ret;
        return result;
    }
}

