/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.slf4j.Logger;

public class ZooTrace {
    private static long traceMask = 306L;

    public static long getTextTraceLevel() {
        return traceMask;
    }

    public static boolean isTraceEnabled(Logger log, long mask) {
        return log.isTraceEnabled() && (mask & traceMask) != 0L;
    }

    public static void logTraceMessage(Logger log, long mask, String msg) {
        if (ZooTrace.isTraceEnabled(log, mask)) {
            log.trace(msg);
        }
    }

    public static void logQuorumPacket(Logger log, long mask, char direction, QuorumPacket qp) {
    }

    public static void logRequest(Logger log, long mask, char rp, Request request, String header) {
        if (ZooTrace.isTraceEnabled(log, mask)) {
            log.trace(header + ":" + rp + request.toString());
        }
    }
}

