/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.management.ObjectName;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.Stats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionBean
implements ZKMBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionBean.class);
    private final ServerCnxn connection;
    private final Stats stats;
    private final ZooKeeperServer zk;
    private final String remoteIP;
    private final long sessionId;

    public ConnectionBean(ServerCnxn connection, ZooKeeperServer zk) {
        InetAddress addr;
        this.connection = connection;
        this.stats = connection;
        this.zk = zk;
        InetSocketAddress sockAddr = connection.getRemoteSocketAddress();
        this.remoteIP = sockAddr == null ? "Unknown" : ((addr = sockAddr.getAddress()) instanceof Inet6Address ? ObjectName.quote(addr.getHostAddress()) : addr.getHostAddress());
        this.sessionId = connection.getSessionId();
    }

    public String getSessionId() {
        return "0x" + Long.toHexString(this.sessionId);
    }

    public String getSourceIP() {
        InetSocketAddress sockAddr = this.connection.getRemoteSocketAddress();
        if (sockAddr == null) {
            return null;
        }
        return sockAddr.getAddress().getHostAddress() + ":" + sockAddr.getPort();
    }

    public String getName() {
        return MBeanRegistry.getInstance().makeFullPath("Connections", this.remoteIP, this.getSessionId());
    }

    public boolean isHidden() {
        return false;
    }

    public String toString() {
        return "ConnectionBean{ClientIP=" + ObjectName.quote(this.getSourceIP()) + ",SessionId=0x" + this.getSessionId() + "}";
    }
}

