/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.proto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.Utils;

public class ConnectResponse
implements Record {
    private int protocolVersion;
    private int timeOut;
    private long sessionId;
    private byte[] passwd;

    public ConnectResponse() {
    }

    public ConnectResponse(int protocolVersion, int timeOut, long sessionId, byte[] passwd) {
        this.protocolVersion = protocolVersion;
        this.timeOut = timeOut;
        this.sessionId = sessionId;
        this.passwd = passwd;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getPasswd() {
        return this.passwd;
    }

    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeInt(this.protocolVersion, "protocolVersion");
        a_.writeInt(this.timeOut, "timeOut");
        a_.writeLong(this.sessionId, "sessionId");
        a_.writeBuffer(this.passwd, "passwd");
        a_.endRecord(this, tag);
    }

    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.protocolVersion = a_.readInt("protocolVersion");
        this.timeOut = a_.readInt("timeOut");
        this.sessionId = a_.readLong("sessionId");
        this.passwd = a_.readBuffer("passwd");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeInt(this.protocolVersion, "protocolVersion");
            a_.writeInt(this.timeOut, "timeOut");
            a_.writeLong(this.sessionId, "sessionId");
            a_.writeBuffer(this.passwd, "passwd");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof ConnectResponse)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ConnectResponse peer = (ConnectResponse)peer_;
        boolean ret = false;
        boolean bl = ret = this.protocolVersion == peer.protocolVersion;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.timeOut == peer.timeOut;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.sessionId == peer.sessionId;
        if (!ret) {
            return ret;
        }
        ret = Utils.bufEquals(this.passwd, peer.passwd);
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = this.protocolVersion;
        result = 37 * result + ret;
        ret = this.timeOut;
        result = 37 * result + ret;
        ret = (int)(this.sessionId ^ this.sessionId >>> 32);
        result = 37 * result + ret;
        ret = Arrays.toString(this.passwd).hashCode();
        result = 37 * result + ret;
        return result;
    }
}

