/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.slf4j.helpers.Util;

class Log4jLoggerFactory {
    private static ConcurrentMap<String, Logger> log4jLoggers = new ConcurrentHashMap<String, Logger>();

    public static Logger getLogger(String name) {
        Logger instance = (Logger)log4jLoggers.get(name);
        if (instance != null) {
            return instance;
        }
        Logger newInstance = new Logger(name);
        Logger oldInstance = log4jLoggers.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    static {
        try {
            Class.forName("org.slf4j.impl.Log4jLoggerFactory");
            String part1 = "Detected both log4j-over-slf4j.jar AND slf4j-log4j12.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#log4jDelegationLoop for more details.";
            Util.report(part1);
            Util.report(part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

