/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import net.hydromatic.avatica.ColumnMetaData;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.jdbc.BasicList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillColumnMetaDataList
extends BasicList<ColumnMetaData> {
    static final Logger logger = LoggerFactory.getLogger(DrillColumnMetaDataList.class);
    private ColumnMetaData[] columns = new ColumnMetaData[0];

    @Override
    public int size() {
        return this.columns.length;
    }

    @Override
    public ColumnMetaData get(int index) {
        return this.columns[index];
    }

    public void updateColumnMetaData(String catalogName, String schemaName, String tableName, BatchSchema schema) {
        this.columns = new ColumnMetaData[schema.getFieldCount()];
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            ColumnMetaData col;
            MaterializedField f = schema.getColumn(i);
            TypeProtos.MajorType t = f.getType();
            this.columns[i] = col = new ColumnMetaData(i, false, true, false, false, f.getDataMode() == TypeProtos.DataMode.OPTIONAL ? 1 : 0, !Types.isUnSigned(t), 10, f.getAsSchemaPath().getRootSegment().getPath(), f.getAsSchemaPath().getRootSegment().getPath(), schemaName, t.hasPrecision() ? t.getPrecision() : 0, t.hasScale() ? t.getScale() : 0, null, catalogName, DrillColumnMetaDataList.getAvaticaType(t), true, false, false, "none");
        }
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(TypeProtos.MajorType t) {
        int sqlTypeId = Types.getSqlType(t);
        return ColumnMetaData.scalar(sqlTypeId, DrillColumnMetaDataList.getSqlTypeName(sqlTypeId), ColumnMetaData.Rep.BOOLEAN);
    }

    private static String getSqlTypeName(int type) {
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "?";
    }
}

