/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.user;

import java.util.UUID;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWorker {
    static final Logger logger = LoggerFactory.getLogger(UserWorker.class);
    private final WorkManager.WorkerBee bee;

    public UserWorker(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public UserBitShared.QueryId submitWork(UserServer.UserClientConnection connection, UserProtos.RunQuery query) {
        UUID uuid = UUID.randomUUID();
        UserBitShared.QueryId id = UserBitShared.QueryId.newBuilder().setPart1(uuid.getMostSignificantBits()).setPart2(uuid.getLeastSignificantBits()).build();
        Foreman foreman = new Foreman(this.bee, this.bee.getContext(), connection, id, query);
        this.bee.addNewForeman(foreman);
        return id;
    }

    public UserBitShared.QueryResult getResult(UserServer.UserClientConnection connection, UserProtos.RequestResults req) {
        Foreman foreman = this.bee.getForemanForQueryId(req.getQueryId());
        if (foreman == null) {
            return UserBitShared.QueryResult.newBuilder().setQueryState(UserBitShared.QueryResult.QueryState.UNKNOWN_QUERY).build();
        }
        return foreman.getResult(connection, req);
    }

    public GeneralRPCProtos.Ack cancelQuery(UserBitShared.QueryId query) {
        Foreman foreman = this.bee.getForemanForQueryId(query);
        if (foreman != null) {
            foreman.cancel();
        }
        return Acks.OK;
    }

    public OptionManager getSystemOptions() {
        return this.bee.getContext().getOptionManager();
    }
}

