/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.fragment.NonRootStatusReporter;
import org.apache.drill.exec.work.fragment.StatusReporter;

public class NonRootFragmentManager
implements FragmentManager {
    private final BitControl.PlanFragment fragment;
    private FragmentRoot root;
    private final IncomingBuffers buffers;
    private final StatusReporter runnerListener;
    private volatile FragmentExecutor runner;
    private volatile boolean cancel = false;
    private final WorkManager.WorkerBee bee;
    private final FragmentContext context;
    private List<RemoteConnection> connections = new CopyOnWriteArrayList<RemoteConnection>();

    public NonRootFragmentManager(BitControl.PlanFragment fragment, WorkManager.WorkerBee bee) throws FragmentSetupException {
        try {
            this.fragment = fragment;
            DrillbitContext context = bee.getContext();
            this.bee = bee;
            this.root = context.getPlanReader().readFragmentOperator(fragment.getFragmentJson());
            this.context = new FragmentContext(context, fragment, null, context.getFunctionImplementationRegistry());
            this.buffers = new IncomingBuffers(this.root, this.context);
            this.context.setBuffers(this.buffers);
            this.runnerListener = new NonRootStatusReporter(this.context, context.getController().getTunnel(fragment.getForeman()));
        }
        catch (IOException | ExecutionSetupException e) {
            throw new FragmentSetupException("Failure while decoding fragment.", e);
        }
    }

    @Override
    public boolean handle(RawFragmentBatch batch) throws FragmentSetupException {
        return this.buffers.batchArrived(batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FragmentExecutor getRunnable() {
        NonRootFragmentManager nonRootFragmentManager = this;
        synchronized (nonRootFragmentManager) {
            if (this.runner != null) {
                throw new IllegalStateException("Get Runnable can only be run once.");
            }
            if (this.cancel) {
                return null;
            }
            this.runner = new FragmentExecutor(this.context, this.bee, this.root, this.runnerListener);
            return this.runner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        NonRootFragmentManager nonRootFragmentManager = this;
        synchronized (nonRootFragmentManager) {
            this.cancel = true;
            if (this.runner != null) {
                this.runner.cancel();
            }
        }
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.fragment.getHandle();
    }

    @Override
    public boolean isWaiting() {
        return !this.buffers.isDone() && !this.cancel;
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.context;
    }
}

