/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.fragment.StatusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentExecutor
implements Comparable,
Runnable {
    static final Logger logger = LoggerFactory.getLogger(FragmentExecutor.class);
    private final AtomicInteger state = new AtomicInteger(1);
    private final FragmentRoot rootOperator;
    private RootExec root;
    private final FragmentContext context;
    private final WorkManager.WorkerBee bee;
    private final StatusReporter listener;
    private Thread executionThread;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public FragmentExecutor(FragmentContext context, WorkManager.WorkerBee bee, FragmentRoot rootOperator, StatusReporter listener) {
        this.context = context;
        this.bee = bee;
        this.rootOperator = rootOperator;
        this.listener = listener;
    }

    public void cancel() {
        this.updateState(UserBitShared.FragmentState.CANCELLED);
        logger.debug("Cancelled Fragment {}", (Object)this.context.getHandle());
        this.context.cancel();
        if (this.executionThread != null) {
            this.executionThread.interrupt();
        }
    }

    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        this.root.receivingFragmentFinished(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String originalThread = Thread.currentThread().getName();
        try {
            String newThreadName = String.format("%s:frag:%s:%s", QueryIdHelper.getQueryId(this.context.getHandle().getQueryId()), this.context.getHandle().getMajorFragmentId(), this.context.getHandle().getMinorFragmentId());
            Thread.currentThread().setName(newThreadName);
            this.executionThread = Thread.currentThread();
            this.root = ImplCreator.getExec(this.context, this.rootOperator);
            logger.debug("Starting fragment runner. {}:{}", (Object)this.context.getHandle().getMajorFragmentId(), (Object)this.context.getHandle().getMinorFragmentId());
            if (!this.updateState(UserBitShared.FragmentState.AWAITING_ALLOCATION, UserBitShared.FragmentState.RUNNING, false)) {
                this.internalFail(new RuntimeException(String.format("Run was called when fragment was in %s state.  FragmentRunnables should only be started when they are currently in awaiting allocation state.", UserBitShared.FragmentState.valueOf(this.state.get()))));
                return;
            }
            while (this.state.get() == 2) {
                if (this.root.next()) continue;
                if (this.context.isFailed()) {
                    this.internalFail(this.context.getFailureCause());
                    this.closeOutResources(false);
                } else {
                    this.closeOutResources(true);
                    this.updateState(UserBitShared.FragmentState.RUNNING, UserBitShared.FragmentState.FINISHED, false);
                }
                break;
            }
        }
        catch (AssertionError | Exception e) {
            logger.debug("Error while initializing or executing fragment", (Throwable)e);
            this.context.fail((Throwable)e);
            this.internalFail((Throwable)e);
        }
        finally {
            this.bee.removeFragment(this.context.getHandle());
            logger.debug("Fragment runner complete. {}:{}", (Object)this.context.getHandle().getMajorFragmentId(), (Object)this.context.getHandle().getMinorFragmentId());
            Thread.currentThread().setName(originalThread);
        }
    }

    private void closeOutResources(boolean throwFailure) {
        if (this.closed.get()) {
            return;
        }
        try {
            this.root.stop();
        }
        catch (RuntimeException e) {
            if (throwFailure) {
                throw e;
            }
            logger.warn("Failure while closing out resources.", e);
        }
        try {
            this.context.close();
        }
        catch (RuntimeException e) {
            if (throwFailure) {
                throw e;
            }
            logger.warn("Failure while closing out resources.", e);
        }
        this.closed.set(true);
    }

    private void internalFail(Throwable excep) {
        this.state.set(5);
        this.listener.fail(this.context.getHandle(), "Failure while running fragment.", excep);
    }

    private void updateState(UserBitShared.FragmentState update) {
        this.state.set(update.getNumber());
        this.listener.stateChanged(this.context.getHandle(), update);
    }

    private boolean updateState(UserBitShared.FragmentState current, UserBitShared.FragmentState update, boolean exceptionOnFailure) {
        boolean success = this.state.compareAndSet(current.getNumber(), update.getNumber());
        if (!success && exceptionOnFailure) {
            this.internalFail(new RuntimeException(String.format("State was different than expected.  Attempting to update state from %s to %s however current state was %s.", current.name(), update.name(), UserBitShared.FragmentState.valueOf(this.state.get()))));
            return false;
        }
        this.listener.stateChanged(this.context.getHandle(), update);
        return true;
    }

    public int compareTo(Object o) {
        return o.hashCode() - this.hashCode();
    }

    public FragmentContext getContext() {
        return this.context;
    }
}

