/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.SchemaUserBitShared;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.FragmentData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStatus {
    static final Logger logger = LoggerFactory.getLogger(QueryStatus.class);
    public static final PStoreConfig<UserBitShared.QueryProfile> QUERY_PROFILE = PStoreConfig.newProtoBuilder(SchemaUserBitShared.QueryProfile.WRITE, SchemaUserBitShared.QueryProfile.MERGE).name("query_profiles").build();
    private IntObjectOpenHashMap<IntObjectOpenHashMap<FragmentData>> fragmentDataMap = new IntObjectOpenHashMap();
    private List<FragmentData> fragmentDataSet = Lists.newArrayList();
    private final String queryId;
    private final UserBitShared.QueryId id;
    private UserProtos.RunQuery query;
    private String planText;
    private Foreman foreman;
    private long startTime;
    private long endTime;
    private int totalFragments;
    private int finishedFragments = 0;
    private final PStore<UserBitShared.QueryProfile> profileCache;

    public QueryStatus(UserProtos.RunQuery query, UserBitShared.QueryId id, PStoreProvider provider, Foreman foreman) {
        this.id = id;
        this.query = query;
        this.queryId = QueryIdHelper.getQueryId(id);
        try {
            this.profileCache = provider.getPStore(QUERY_PROFILE);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
        this.foreman = foreman;
    }

    public List<FragmentData> getFragmentData() {
        return this.fragmentDataSet;
    }

    public void setPlanText(String planText) {
        this.planText = planText;
        this.updateCache();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setTotalFragments(int totalFragments) {
        this.totalFragments = totalFragments;
    }

    public void incrementFinishedFragments() {
        ++this.finishedFragments;
        assert (this.finishedFragments <= this.totalFragments);
    }

    void add(FragmentData data) {
        int majorFragmentId = data.getHandle().getMajorFragmentId();
        int minorFragmentId = data.getHandle().getMinorFragmentId();
        IntObjectOpenHashMap<FragmentData> minorMap = this.fragmentDataMap.get(majorFragmentId);
        if (minorMap == null) {
            minorMap = new IntObjectOpenHashMap();
            this.fragmentDataMap.put(majorFragmentId, minorMap);
        }
        minorMap.put(minorFragmentId, data);
        this.fragmentDataSet.add(data);
    }

    void update(BitControl.FragmentStatus status, boolean updateCache) {
        int majorFragmentId = status.getHandle().getMajorFragmentId();
        int minorFragmentId = status.getHandle().getMinorFragmentId();
        this.fragmentDataMap.get(majorFragmentId).get(minorFragmentId).setStatus(status);
        if (updateCache) {
            this.updateCache();
        }
    }

    public void updateCache() {
        UserBitShared.QueryResult.QueryState queryState = this.foreman.getQueryState();
        boolean fullStatus = queryState == UserBitShared.QueryResult.QueryState.COMPLETED || queryState == UserBitShared.QueryResult.QueryState.FAILED;
        this.profileCache.put(this.queryId, this.getAsProfile(fullStatus));
    }

    public String toString() {
        return this.fragmentDataMap.toString();
    }

    public UserBitShared.QueryProfile getAsProfile(boolean fullStatus) {
        UserBitShared.QueryProfile.Builder b = UserBitShared.QueryProfile.newBuilder();
        b.setQuery(this.query.getPlan());
        b.setType(this.query.getType());
        if (this.planText != null) {
            b.setPlan(this.planText);
        }
        b.setId(this.id);
        if (fullStatus) {
            for (int i = 0; i < this.fragmentDataMap.allocated.length; ++i) {
                if (!this.fragmentDataMap.allocated[i]) continue;
                int majorFragmentId = this.fragmentDataMap.keys[i];
                IntObjectOpenHashMap minorMap = (IntObjectOpenHashMap)this.fragmentDataMap.values[i];
                UserBitShared.MajorFragmentProfile.Builder fb = UserBitShared.MajorFragmentProfile.newBuilder();
                fb.setMajorFragmentId(majorFragmentId);
                for (int v = 0; v < minorMap.allocated.length; ++v) {
                    if (!minorMap.allocated[v]) continue;
                    FragmentData data = (FragmentData)minorMap.values[v];
                    fb.addMinorFragmentProfile(data.getStatus().getProfile());
                }
                b.addFragmentProfile(fb);
            }
        }
        b.setState(this.foreman.getQueryState());
        b.setForeman(this.foreman.getContext().getCurrentEndpoint());
        b.setStart(this.startTime);
        b.setEnd(this.endTime);
        b.setTotalFragments(this.totalFragments);
        b.setFinishedFragments(this.finishedFragments);
        return b.build();
    }
}

