/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.work.EndpointListener;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.FragmentData;
import org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.apache.drill.exec.work.fragment.AbstractStatusReporter;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.RootFragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager
implements FragmentStatusListener {
    static final Logger logger = LoggerFactory.getLogger(QueryManager.class);
    private final QueryStatus status;
    private final Controller controller;
    private Foreman.ForemanManagerListener foremanManagerListener;
    private AtomicInteger remainingFragmentCount;
    private WorkEventBus workBus;
    private UserBitShared.QueryId queryId;
    private FragmentExecutor rootRunner;
    private UserProtos.RunQuery query;
    private volatile boolean running = false;
    private volatile boolean cancelled = false;
    private volatile boolean stopped = false;

    public QueryManager(UserBitShared.QueryId id, UserProtos.RunQuery query, PStoreProvider pStoreProvider, Foreman.ForemanManagerListener foremanManagerListener, Controller controller, Foreman foreman) {
        this.foremanManagerListener = foremanManagerListener;
        this.query = query;
        this.queryId = id;
        this.controller = controller;
        this.remainingFragmentCount = new AtomicInteger(0);
        this.status = new QueryStatus(query, id, pStoreProvider, foreman);
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    public void runFragments(WorkManager.WorkerBee bee, BitControl.PlanFragment rootFragment, FragmentRoot rootOperator, UserServer.UserClientConnection rootClient, List<BitControl.PlanFragment> leafFragments, List<BitControl.PlanFragment> intermediateFragments) throws ExecutionSetupException {
        logger.debug("Setting up fragment runs.");
        this.remainingFragmentCount.set(intermediateFragments.size() + leafFragments.size() + 1);
        assert (this.queryId == rootFragment.getHandle().getQueryId());
        this.workBus = bee.getContext().getWorkBus();
        logger.debug("Setting up root context.");
        FragmentContext rootContext = new FragmentContext(bee.getContext(), rootFragment, rootClient, bee.getContext().getFunctionImplementationRegistry());
        logger.debug("Setting up incoming buffers");
        IncomingBuffers buffers = new IncomingBuffers(rootOperator, rootContext);
        logger.debug("Setting buffers on root context.");
        rootContext.setBuffers(buffers);
        this.status.add(new FragmentData(rootFragment.getHandle(), null, true));
        logger.debug("Fragment added to local node.");
        this.rootRunner = new FragmentExecutor(rootContext, bee, rootOperator, new RootStatusHandler(rootContext, rootFragment));
        RootFragmentManager fragmentManager = new RootFragmentManager(rootFragment.getHandle(), buffers, this.rootRunner);
        if (buffers.isDone()) {
            bee.addFragmentRunner(fragmentManager.getRunnable());
        } else {
            this.workBus.setRootFragmentManager(fragmentManager);
        }
        for (BitControl.PlanFragment f : intermediateFragments) {
            logger.debug("Tracking intermediate remote node {} with data {}", (Object)f.getAssignment(), (Object)f.getFragmentJson());
            this.status.add(new FragmentData(f.getHandle(), f.getAssignment(), false));
        }
        for (BitControl.PlanFragment f : leafFragments) {
            this.sendRemoteFragment(f);
        }
        logger.debug("Fragment runs setup is complete.");
        this.running = true;
        if (this.cancelled && !this.stopped) {
            this.stopQuery();
        }
    }

    private void sendRemoteFragment(BitControl.PlanFragment fragment) {
        logger.debug("Sending remote fragment to node {} with data {}", (Object)fragment.getAssignment(), (Object)fragment.getFragmentJson());
        this.status.add(new FragmentData(fragment.getHandle(), fragment.getAssignment(), false));
        FragmentSubmitListener listener = new FragmentSubmitListener(fragment.getAssignment(), fragment);
        this.controller.getTunnel(fragment.getAssignment()).sendFragment(listener, fragment);
    }

    @Override
    public void statusUpdate(BitControl.FragmentStatus status) {
        logger.debug("New fragment status was provided to Foreman of {}", (Object)status);
        switch (status.getProfile().getState()) {
            case AWAITING_ALLOCATION: {
                this.updateStatus(status, true);
                break;
            }
            case CANCELLED: {
                break;
            }
            case FAILED: {
                this.fail(status);
                break;
            }
            case FINISHED: {
                this.finished(status);
                break;
            }
            case RUNNING: {
                this.updateStatus(status, false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Received status of %s", status));
            }
        }
    }

    private void updateStatus(BitControl.FragmentStatus status, boolean updateCache) {
        this.status.update(status, updateCache);
    }

    private void finished(BitControl.FragmentStatus status) {
        int remaining = this.remainingFragmentCount.decrementAndGet();
        if (remaining == 0) {
            logger.info("Outcome status: {}", (Object)this.status);
            UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().setQueryState(UserBitShared.QueryResult.QueryState.COMPLETED).setQueryId(this.queryId).build();
            this.foremanManagerListener.cleanupAndSendResult(result);
            this.workBus.removeFragmentStatusListener(this.queryId);
        }
        this.status.setEndTime(System.currentTimeMillis());
        this.status.incrementFinishedFragments();
        this.updateStatus(status, true);
    }

    private void fail(BitControl.FragmentStatus status) {
        this.stopQuery();
        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().setQueryId(this.queryId).setQueryState(UserBitShared.QueryResult.QueryState.FAILED).addError(status.getProfile().getError()).build();
        this.foremanManagerListener.cleanupAndSendResult(result);
        this.status.setEndTime(System.currentTimeMillis());
        this.updateStatus(status, true);
    }

    private void stopQuery() {
        this.workBus.removeFragmentStatusListener(this.queryId);
        List<FragmentData> fragments = this.status.getFragmentData();
        Collections.sort(fragments, new Comparator<FragmentData>(){

            @Override
            public int compare(FragmentData o1, FragmentData o2) {
                return o2.getHandle().getMajorFragmentId() - o1.getHandle().getMajorFragmentId();
            }
        });
        for (FragmentData data : fragments) {
            ExecProtos.FragmentHandle handle = data.getStatus().getHandle();
            switch (data.getStatus().getProfile().getState()) {
                case AWAITING_ALLOCATION: 
                case RUNNING: 
                case SENDING: {
                    if (data.isLocal()) {
                        this.rootRunner.cancel();
                        break;
                    }
                    this.controller.getTunnel(data.getEndpoint()).cancelFragment(new CancelListener(data.getEndpoint(), handle), handle);
                    break;
                }
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.running) {
            this.stopQuery();
            this.stopped = true;
        }
    }

    private class RootStatusHandler
    extends AbstractStatusReporter {
        private RootStatusHandler(FragmentContext context, BitControl.PlanFragment fragment) {
            super(context);
        }

        @Override
        protected void statusChange(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus status) {
            QueryManager.this.statusUpdate(status);
        }
    }

    private class FragmentSubmitListener
    extends EndpointListener<GeneralRPCProtos.Ack, BitControl.PlanFragment> {
        public FragmentSubmitListener(CoordinationProtos.DrillbitEndpoint endpoint, BitControl.PlanFragment value) {
            super(endpoint, value);
        }

        @Override
        public void failed(RpcException ex) {
            logger.debug("Failure while sending fragment.  Stopping query.", ex);
            QueryManager.this.stopQuery();
        }
    }

    private class CancelListener
    extends EndpointListener<GeneralRPCProtos.Ack, ExecProtos.FragmentHandle> {
        public CancelListener(CoordinationProtos.DrillbitEndpoint endpoint, ExecProtos.FragmentHandle handle) {
            super(endpoint, handle);
        }

        @Override
        public void failed(RpcException ex) {
            logger.error("Failure while attempting to cancel fragment {} on endpoint {}.", this.value, this.endpoint, ex);
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buf) {
            if (!value.getOk()) {
                logger.warn("Remote node {} responded negative on cancellation request for fragment {}.", (Object)this.endpoint, (Object)value);
            }
        }
    }
}

