/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;

public class FragmentData {
    private final boolean isLocal;
    private volatile BitControl.FragmentStatus status;
    private volatile long lastStatusUpdate = 0L;
    private final CoordinationProtos.DrillbitEndpoint endpoint;

    public FragmentData(ExecProtos.FragmentHandle handle, CoordinationProtos.DrillbitEndpoint endpoint, boolean isLocal) {
        UserBitShared.MinorFragmentProfile f = UserBitShared.MinorFragmentProfile.newBuilder().setState(UserBitShared.FragmentState.SENDING).setMinorFragmentId(handle.getMinorFragmentId()).build();
        this.status = BitControl.FragmentStatus.newBuilder().setHandle(handle).setProfile(f).build();
        this.endpoint = endpoint;
        this.isLocal = isLocal;
    }

    public void setStatus(BitControl.FragmentStatus status) {
        this.status = status;
        this.lastStatusUpdate = System.currentTimeMillis();
    }

    public BitControl.FragmentStatus getStatus() {
        return this.status;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ExecProtos.FragmentHandle getHandle() {
        return this.status.getHandle();
    }

    public String toString() {
        return "FragmentData [isLocal=" + this.isLocal + ", status=" + this.status + ", lastStatusUpdate=" + this.lastStatusUpdate + ", endpoint=" + this.endpoint + "]";
    }
}

