/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.exception.OptimizerException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.opt.BasicOptimizer;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.ExternalSort;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.planner.fragment.StatsCollector;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.DrillSqlWorker;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.util.AtomicState;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.ErrorHelper;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.QueryManager;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foreman
implements Closeable,
Comparable<Object>,
Runnable {
    static final Logger logger = LoggerFactory.getLogger(Foreman.class);
    public static final DistributedCache.CacheConfig<ExecProtos.FragmentHandle, BitControl.PlanFragment> FRAGMENT_CACHE = DistributedCache.CacheConfig.newBuilder(ExecProtos.FragmentHandle.class, BitControl.PlanFragment.class).mode(DistributedCache.SerializationMode.PROTOBUF).build();
    private UserBitShared.QueryId queryId;
    private UserProtos.RunQuery queryRequest;
    private QueryContext context;
    private QueryManager fragmentManager;
    private WorkManager.WorkerBee bee;
    private UserServer.UserClientConnection initiatingClient;
    private final AtomicState<UserBitShared.QueryResult.QueryState> state;
    private final DistributedSemaphore smallSemaphore;
    private final DistributedSemaphore largeSemaphore;
    private final long queueThreshold;
    private final long queueTimeout;
    private volatile DistributedSemaphore.DistributedLease lease;
    private final boolean queuingEnabled;

    public Foreman(WorkManager.WorkerBee bee, DrillbitContext dContext, UserServer.UserClientConnection connection, UserBitShared.QueryId queryId, UserProtos.RunQuery queryRequest) {
        this.queryId = queryId;
        this.queryRequest = queryRequest;
        this.context = new QueryContext(connection.getSession(), queryId, dContext);
        this.queuingEnabled = this.context.getOptions().getOption((String)"exec.queue.enable").bool_val;
        if (this.queuingEnabled) {
            int smallQueue = this.context.getOptions().getOption((String)"exec.queue.small").num_val.intValue();
            int largeQueue = this.context.getOptions().getOption((String)"exec.queue.large").num_val.intValue();
            this.largeSemaphore = dContext.getClusterCoordinator().getSemaphore("query.large", largeQueue);
            this.smallSemaphore = dContext.getClusterCoordinator().getSemaphore("query.small", smallQueue);
            this.queueThreshold = this.context.getOptions().getOption((String)"exec.queue.threshold").num_val;
            this.queueTimeout = this.context.getOptions().getOption((String)"exec.queue.timeout_millis").num_val;
        } else {
            this.largeSemaphore = null;
            this.smallSemaphore = null;
            this.queueThreshold = 0L;
            this.queueTimeout = 0L;
        }
        this.initiatingClient = connection;
        this.fragmentManager = new QueryManager(queryId, queryRequest, bee.getContext().getPersistentStoreProvider(), new ForemanManagerListener(), dContext.getController(), this);
        this.bee = bee;
        this.state = new AtomicState<UserBitShared.QueryResult.QueryState>(UserBitShared.QueryResult.QueryState.PENDING){

            @Override
            protected UserBitShared.QueryResult.QueryState getStateFromNumber(int i) {
                return UserBitShared.QueryResult.QueryState.valueOf(i);
            }
        };
    }

    public QueryContext getContext() {
        return this.context;
    }

    private boolean isFinished() {
        switch (this.state.getState()) {
            case PENDING: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    private void fail(String message, Throwable t) {
        if (this.isFinished()) {
            logger.error("Received a failure message query finished of: {}", (Object)message, (Object)t);
        }
        if (!this.state.updateState(UserBitShared.QueryResult.QueryState.RUNNING, UserBitShared.QueryResult.QueryState.FAILED) && !this.state.updateState(UserBitShared.QueryResult.QueryState.PENDING, UserBitShared.QueryResult.QueryState.FAILED)) {
            logger.warn("Tried to update query state to FAILED, but was not RUNNING");
        }
        boolean verbose = this.getContext().getOptions().getOption((String)"exec.errors.verbose").bool_val;
        UserBitShared.DrillPBError error = ErrorHelper.logAndConvertError(this.context.getCurrentEndpoint(), message, t, logger, verbose);
        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().addError(error).setIsLastChunk(true).setQueryState(UserBitShared.QueryResult.QueryState.FAILED).setQueryId(this.queryId).build();
        this.cleanupAndSendResult(result);
    }

    public void cancel() {
        if (this.isFinished()) {
            return;
        }
        this.fragmentManager.cancel();
        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().setQueryState(UserBitShared.QueryResult.QueryState.CANCELED).setIsLastChunk(true).setQueryId(this.queryId).build();
        this.cleanupAndSendResult(result);
    }

    void cleanupAndSendResult(UserBitShared.QueryResult result) {
        this.bee.retireForeman(this);
        this.initiatingClient.sendResult(new ResponseSendListener(), new QueryWritableBatch(result, new ByteBuf[0]), true);
        this.state.updateState(UserBitShared.QueryResult.QueryState.RUNNING, UserBitShared.QueryResult.QueryState.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String originalThread = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryIdHelper.getQueryId(this.queryId) + ":foreman");
        this.fragmentManager.getStatus().setStartTime(System.currentTimeMillis());
        try {
            switch (this.queryRequest.getType()) {
                case LOGICAL: {
                    this.parseAndRunLogicalPlan(this.queryRequest.getPlan());
                    return;
                }
                case PHYSICAL: {
                    this.parseAndRunPhysicalPlan(this.queryRequest.getPlan());
                    return;
                }
                case SQL: {
                    this.runSQL(this.queryRequest.getPlan());
                    return;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (AssertionError | Exception ex) {
            this.fail("Failure while setting up Foreman.", (Throwable)ex);
            return;
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory, exiting.");
            System.out.flush();
            System.exit(-1);
            return;
        }
        finally {
            this.releaseLease();
            Thread.currentThread().setName(originalThread);
        }
    }

    private void releaseLease() {
        if (this.lease != null) {
            try {
                this.lease.close();
            }
            catch (Exception e) {
                logger.warn("Failure while releasing lease.", e);
            }
        }
    }

    private void parseAndRunLogicalPlan(String json) {
        try {
            LogicalPlan logicalPlan = this.context.getPlanReader().readLogicalPlan(json);
            if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.LOGICAL) {
                this.fail("Failure running plan.  You requested a result mode of LOGICAL and submitted a logical plan.  In this case you're output mode must be PHYSICAL or EXEC.", new Exception());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Logical {}", (Object)logicalPlan.unparse(this.context.getConfig()));
            }
            PhysicalPlan physicalPlan = this.convert(logicalPlan);
            if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.PHYSICAL) {
                this.returnPhysical(physicalPlan);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Physical {}", (Object)this.context.getConfig().getMapper().writeValueAsString(physicalPlan));
            }
            this.runPhysicalPlan(physicalPlan);
        }
        catch (IOException e) {
            this.fail("Failure while parsing logical plan.", e);
        }
        catch (OptimizerException e) {
            this.fail("Failure while converting logical plan to physical plan.", e);
        }
    }

    private void returnPhysical(PhysicalPlan plan) {
        String jsonPlan = plan.unparse(this.context.getConfig().getMapper().writer());
        this.runPhysicalPlan(DirectPlan.createDirectPlan(this.context, new PhysicalFromLogicalExplain(jsonPlan)));
    }

    private void parseAndRunPhysicalPlan(String json) {
        try {
            PhysicalPlan plan = this.context.getPlanReader().readPhysicalPlan(json);
            this.runPhysicalPlan(plan);
        }
        catch (IOException e) {
            this.fail("Failure while parsing physical plan.", e);
        }
    }

    private void runPhysicalPlan(PhysicalPlan plan) {
        Fragment rootFragment;
        if (plan.getProperties().resultMode != PlanProperties.Generator.ResultMode.EXEC) {
            this.fail(String.format("Failure running plan.  You requested a result mode of %s and a physical plan can only be output as EXEC", new Object[]{plan.getProperties().resultMode}), new Exception());
        }
        PhysicalOperator rootOperator = plan.getSortedOperators(false).iterator().next();
        MakeFragmentsVisitor makeFragmentsVisitor = new MakeFragmentsVisitor();
        try {
            rootFragment = rootOperator.accept(makeFragmentsVisitor, null);
        }
        catch (FragmentSetupException e) {
            this.fail("Failure while fragmenting query.", e);
            return;
        }
        int sortCount = 0;
        for (PhysicalOperator op : plan.getSortedOperators()) {
            if (!(op instanceof ExternalSort)) continue;
            ++sortCount;
        }
        if (sortCount > 0) {
            long maxWidthPerNode = this.context.getOptions().getOption((String)"planner.width.max_per_node").num_val;
            long maxAllocPerNode = Math.min(DrillConfig.getMaxDirectMemory(), this.context.getConfig().getLong("drill.exec.memory.top.max"));
            maxAllocPerNode = Math.min(maxAllocPerNode, this.context.getOptions().getOption((String)"planner.memory.max_query_memory_per_node").num_val);
            long maxSortAlloc = maxAllocPerNode / ((long)sortCount * maxWidthPerNode);
            logger.debug("Max sort alloc: {}", (Object)maxSortAlloc);
            for (PhysicalOperator op : plan.getSortedOperators()) {
                if (!(op instanceof ExternalSort)) continue;
                ((ExternalSort)op).setMaxAllocation(maxSortAlloc);
            }
        }
        PlanningSet planningSet = StatsCollector.collectStats(rootFragment);
        SimpleParallelizer parallelizer = new SimpleParallelizer(this.context);
        try {
            double size = 0.0;
            for (PhysicalOperator ops : plan.getSortedOperators()) {
                size += ops.getCost();
            }
            if (this.queuingEnabled) {
                this.lease = size > (double)this.queueThreshold ? this.largeSemaphore.acquire(this.queueTimeout, TimeUnit.MILLISECONDS) : this.smallSemaphore.acquire(this.queueTimeout, TimeUnit.MILLISECONDS);
            }
            QueryWorkUnit work = parallelizer.getFragments(this.context.getOptions().getOptionList(), this.context.getCurrentEndpoint(), this.queryId, this.context.getActiveEndpoints(), this.context.getPlanReader(), rootFragment, planningSet);
            this.context.getWorkBus().setFragmentStatusListener(work.getRootFragment().getHandle().getQueryId(), this.fragmentManager);
            ArrayList<BitControl.PlanFragment> leafFragments = Lists.newArrayList();
            ArrayList<BitControl.PlanFragment> intermediateFragments = Lists.newArrayList();
            logger.debug("Storing fragments");
            LinkedList<Future<BitControl.PlanFragment>> queue = new LinkedList<Future<BitControl.PlanFragment>>();
            for (BitControl.PlanFragment planFragment : work.getFragments()) {
                queue.add(this.context.getCache().getMap(FRAGMENT_CACHE).put(planFragment.getHandle(), planFragment));
                if (planFragment.getLeafFragment()) {
                    leafFragments.add(planFragment);
                    continue;
                }
                intermediateFragments.add(planFragment);
            }
            for (Future future : queue) {
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new ExecutionSetupException("failure while storing plan fragments", e);
                }
            }
            int totalFragments = 1 + intermediateFragments.size() + leafFragments.size();
            this.fragmentManager.getStatus().setTotalFragments(totalFragments);
            this.fragmentManager.getStatus().updateCache();
            logger.debug("Fragments stored.");
            logger.debug("Submitting fragments to run.");
            this.fragmentManager.runFragments(this.bee, work.getRootFragment(), work.getRootOperator(), this.initiatingClient, leafFragments, intermediateFragments);
            logger.debug("Fragments running.");
            this.state.updateState(UserBitShared.QueryResult.QueryState.PENDING, UserBitShared.QueryResult.QueryState.RUNNING);
        }
        catch (Exception e) {
            this.fail("Failure while setting up query.", e);
        }
    }

    private void runSQL(String sql) {
        try {
            DrillSqlWorker sqlWorker = new DrillSqlWorker(this.context);
            Pointer<String> textPlan = new Pointer<String>();
            PhysicalPlan plan = sqlWorker.getPlan(sql, textPlan);
            this.fragmentManager.getStatus().setPlanText((String)textPlan.value);
            this.runPhysicalPlan(plan);
        }
        catch (Exception e) {
            this.fail("Failure while parsing sql.", e);
        }
    }

    private PhysicalPlan convert(LogicalPlan plan) throws OptimizerException {
        if (logger.isDebugEnabled()) {
            logger.debug("Converting logical plan {}.", (Object)plan.toJsonStringSafe(this.context.getConfig()));
        }
        return new BasicOptimizer(DrillConfig.create(), this.context, this.initiatingClient).optimize(new BasicOptimizer.BasicOptimizationContext(this.context), plan);
    }

    public UserBitShared.QueryResult getResult(UserServer.UserClientConnection connection, UserProtos.RequestResults req) {
        throw new UnsupportedOperationException();
    }

    public UserBitShared.QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public void close() throws IOException {
    }

    public UserBitShared.QueryResult.QueryState getQueryState() {
        return this.state.getState();
    }

    public QueryStatus getQueryStatus() {
        return this.fragmentManager.getStatus();
    }

    @Override
    public int compareTo(Object o) {
        return o.hashCode() - o.hashCode();
    }

    class ForemanManagerListener {
        ForemanManagerListener() {
        }

        void cleanupAndSendResult(UserBitShared.QueryResult result) {
            Foreman.this.cleanupAndSendResult(result);
        }
    }

    private class PhysicalFromLogicalExplain {
        public String json;

        public PhysicalFromLogicalExplain(String json) {
            this.json = json;
        }
    }

    private class ResponseSendListener
    extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
        private ResponseSendListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.info("Failure while trying communicate query result to initating client.  This would happen if a client is disconnected before response notice can be sent.", ex);
        }
    }
}

