/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlTunnel;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.fragment.NonRootStatusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlHandlerImpl
implements ControlMessageHandler {
    static final Logger logger = LoggerFactory.getLogger(ControlHandlerImpl.class);
    private final WorkManager.WorkerBee bee;

    public ControlHandlerImpl(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    @Override
    public Response handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 6: {
                ExecProtos.FragmentHandle handle = RpcBus.get(pBody, ExecProtos.FragmentHandle.PARSER);
                this.cancelFragment(handle);
                return DataRpcConfig.OK;
            }
            case 7: {
                BitControl.FinishedReceiver finishedReceiver = RpcBus.get(pBody, BitControl.FinishedReceiver.PARSER);
                this.receivingFragmentFinished(finishedReceiver);
                return DataRpcConfig.OK;
            }
            case 8: {
                this.bee.getContext().getWorkBus().status(RpcBus.get(pBody, BitControl.FragmentStatus.PARSER));
                return DataRpcConfig.OK;
            }
            case 3: {
                BitControl.PlanFragment fragment = RpcBus.get(pBody, BitControl.PlanFragment.PARSER);
                try {
                    this.startNewRemoteFragment(fragment);
                    return DataRpcConfig.OK;
                }
                catch (ExecutionSetupException e) {
                    logger.error("Failure while attempting to start remote fragment.", (Object)fragment);
                    return new Response(BitControl.RpcType.ACK, Acks.FAIL, new ByteBuf[0]);
                }
            }
            case 10: {
                UserBitShared.QueryProfile profile;
                UserBitShared.QueryId queryId = RpcBus.get(pBody, UserBitShared.QueryId.PARSER);
                Foreman foreman = this.bee.getForemanForQueryId(queryId);
                if (foreman == null) {
                    try {
                        profile = this.bee.getContext().getPersistentStoreProvider().getPStore(QueryStatus.QUERY_PROFILE).get(QueryIdHelper.getQueryId(queryId));
                    }
                    catch (IOException e) {
                        throw new RpcException("Failed to get persistent store", e);
                    }
                } else {
                    profile = this.bee.getForemanForQueryId(queryId).getQueryStatus().getAsProfile(true);
                }
                return new Response(BitControl.RpcType.RESP_QUERY_STATUS, profile, new ByteBuf[0]);
            }
        }
        throw new RpcException("Not yet supported.");
    }

    public void startNewRemoteFragment(BitControl.PlanFragment fragment) throws ExecutionSetupException {
        logger.debug("Received remote fragment start instruction", (Object)fragment);
        FragmentContext context = new FragmentContext(this.bee.getContext(), fragment, null, this.bee.getContext().getFunctionImplementationRegistry());
        ControlTunnel tunnel = this.bee.getContext().getController().getTunnel(fragment.getForeman());
        NonRootStatusReporter listener = new NonRootStatusReporter(context, tunnel);
        try {
            FragmentRoot rootOperator = this.bee.getContext().getPlanReader().readFragmentOperator(fragment.getFragmentJson());
            FragmentExecutor fr = new FragmentExecutor(context, this.bee, rootOperator, listener);
            this.bee.addFragmentRunner(fr);
        }
        catch (Exception e) {
            listener.fail(fragment.getHandle(), "Failure due to uncaught exception", e);
        }
        catch (OutOfMemoryError t) {
            if (t.getMessage().startsWith("Direct buffer")) {
                listener.fail(fragment.getHandle(), "Failure due to error", t);
            }
            throw t;
        }
    }

    public GeneralRPCProtos.Ack cancelFragment(ExecProtos.FragmentHandle handle) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManager(handle);
        if (manager != null) {
            manager.cancel();
        } else {
            FragmentExecutor runner = this.bee.getFragmentRunner(handle);
            if (runner != null) {
                runner.cancel();
            }
        }
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack receivingFragmentFinished(BitControl.FinishedReceiver finishedReceiver) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManager(finishedReceiver.getSender());
        FragmentExecutor executor = manager != null ? manager.getRunnable() : this.bee.getFragmentRunner(finishedReceiver.getSender());
        if (executor != null) {
            executor.receivingFragmentFinished(finishedReceiver.getReceiver());
        }
        return Acks.OK;
    }
}

