/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import org.apache.drill.exec.planner.sql.parser.impl.ParseException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.eigenbase.sql.parser.SqlParseException;
import org.slf4j.Logger;

public class ErrorHelper {
    public static UserBitShared.DrillPBError logAndConvertError(CoordinationProtos.DrillbitEndpoint endpoint, String message, Throwable t, Logger logger, boolean verbose) {
        String id = UUID.randomUUID().toString();
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setEndpoint(endpoint);
        builder.setErrorId(id);
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append(" ");
        }
        sb.append("%s ").append("[").append(id).append("]");
        if (verbose) {
            sb.append("\n").append("Node details: ").append(endpoint.getAddress()).append(":").append(endpoint.getControlPort()).append("/").append(endpoint.getDataPort());
        }
        if (verbose) {
            StringWriter errors = new StringWriter();
            errors.write("\n");
            t.printStackTrace(new PrintWriter(errors));
            sb.append(errors);
        }
        Throwable original = t;
        Throwable rootCause = null;
        while (true) {
            rootCause = t;
            if (t.getCause() == null || t.getCause() == t || t instanceof SqlParseException && t.getCause() instanceof ParseException) break;
            t = t.getCause();
        }
        String finalMsg = rootCause.getMessage() == null ? original.getMessage() : rootCause.getMessage();
        builder.setMessage(String.format(sb.toString(), finalMsg));
        builder.setErrorType(0);
        logger.error("Error {}: {}", id, message, t);
        return builder.build();
    }
}

