/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Date;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DATE);
    private final DateVector.Accessor ac;

    public DateAccessor(DateVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index);
    }

    @Override
    public Date getDate(int index) {
        DateTime date = new DateTime(this.ac.get(index), DateTimeZone.UTC);
        date = date.withZoneRetainFields(DateTimeZone.getDefault());
        return new Date(date.getMillis());
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    TypeProtos.MajorType getType() {
        return TYPE;
    }
}

