/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.Var16CharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Var16CharVector
extends BaseDataValueVector
implements VariableWidthVector {
    static final Logger logger = LoggerFactory.getLogger(Var16CharVector.class);
    private final UInt4Vector offsetVector;
    private final Accessor accessor;
    private final Mutator mutator;
    private final UInt4Vector.Accessor oAccessor;
    private int allocationTotalByteCount = 32768;
    private int allocationMonitor = 0;

    public Var16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsetVector = new UInt4Vector(null, allocator);
        this.oAccessor = this.offsetVector.getAccessor();
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getBufferSize() + this.data.writerIndex();
    }

    public int getByteCapacity() {
        return this.data.capacity();
    }

    public int getVarByteLength() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(this.valueCount);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setVarByteLength(this.getVarByteLength()).setBufferLength(this.getBufferSize()).build();
    }

    public int load(int dataBytes, int valueCount, DrillBuf buf) {
        this.valueCount = valueCount;
        if (valueCount == 0) {
            this.allocateNew(0, 0);
            return 0;
        }
        int loaded = this.offsetVector.load(valueCount + 1, buf);
        this.data = buf.slice(loaded, dataBytes - loaded);
        this.data.retain();
        return dataBytes;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getBufferLength(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public void clear() {
        super.clear();
        this.offsetVector.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsetVector.getBuffers(clear), super.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(Var16CharVector target) {
        this.offsetVector.transferTo(target.offsetVector);
        target.data = this.data;
        target.data.retain();
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationTotalByteCount = Math.max(8, this.allocationTotalByteCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationTotalByteCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationTotalByteCount);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        if (!this.offsetVector.allocateNewSafe()) {
            return false;
        }
        this.offsetVector.zeroVector();
        return true;
    }

    public void allocateNew(int totalBytes, int valueCount) {
        this.clear();
        assert (totalBytes >= 0);
        this.data = this.allocator.buffer(totalBytes);
        this.data.readerIndex(0);
        this.allocationTotalByteCount = totalBytes;
        this.offsetVector.allocateNew(valueCount + 1);
        this.offsetVector.zeroVector();
    }

    private void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements VariableWidthVector.VariableWidthMutator {
        public boolean setSafe(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = Var16CharVector.this.offsetVector.getAccessor().get(index);
            if (Var16CharVector.this.data.capacity() < currentOffset + bytes.length) {
                Var16CharVector.this.decrementAllocationMonitor();
                return false;
            }
            if (!Var16CharVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + bytes.length)) {
                return false;
            }
            Var16CharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + bytes.length);
            Var16CharVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
            return true;
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentByteCapacity = Var16CharVector.this.getByteCapacity();
            Var16CharVector.this.valueCount = valueCount;
            int idx = Var16CharVector.this.offsetVector.getAccessor().get(valueCount);
            Var16CharVector.this.data.writerIndex(idx);
            if (valueCount > 0 && currentByteCapacity > idx * 2) {
                Var16CharVector.this.incrementAllocationMonitor();
            } else if (Var16CharVector.this.allocationMonitor > 0) {
                Var16CharVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Var16CharVector.this.data, idx);
            Var16CharVector.this.offsetVector.getMutator().setValueCount(valueCount + 1);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final FieldReader reader;
        final UInt4Vector.Accessor oAccessor;

        public Accessor() {
            this.reader = new Var16CharReaderImpl(Var16CharVector.this);
            this.oAccessor = Var16CharVector.this.offsetVector.getAccessor();
        }

        public byte[] get(int index) {
            assert (index >= 0);
            int startIdx = this.oAccessor.get(index);
            int length = this.oAccessor.get(index + 1) - startIdx;
            assert (length >= 0);
            byte[] dst = new byte[length];
            Var16CharVector.this.data.getBytes(startIdx, dst, 0, length);
            return dst;
        }

        public void get(int index, Var16CharHolder holder) {
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = Var16CharVector.this.data;
        }

        public void get(int index, NullableVar16CharHolder holder) {
            holder.isSet = 1;
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = Var16CharVector.this.data;
        }

        @Override
        public String getObject(int index) {
            return new String(this.get(index), Charsets.UTF_16);
        }
    }

    private class TransferImpl
    implements TransferPair {
        Var16CharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Var16CharVector(field, Var16CharVector.this.allocator);
        }

        @Override
        public Var16CharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Var16CharVector.this.transferTo(this.to);
        }
    }
}

