/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.RepeatedMutator;
import org.apache.drill.exec.vector.RepeatedVariableWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedVarCharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.hadoop.io.Text;

public final class RepeatedVarCharVector
extends BaseValueVector
implements RepeatedVariableWidthVector {
    private int parentValueCount;
    private int childValueCount;
    private final UInt4Vector offsets;
    private final VarCharVector values;
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsets = new UInt4Vector(null, allocator);
        this.values = new VarCharVector(null, allocator);
    }

    @Override
    public int getBufferSize() {
        return this.offsets.getBufferSize() + this.values.getBufferSize();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(RepeatedVarCharVector target) {
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        target.parentValueCount = this.parentValueCount;
        target.childValueCount = this.childValueCount;
        this.clear();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        this.offsets.allocateNew();
        this.offsets.zeroVector();
        this.values.allocateNew();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setGroupCount(this.parentValueCount).setValueCount(this.childValueCount).setVarByteLength(this.values.getVarByteLength()).setBufferLength(this.getBufferSize()).build();
    }

    public int load(int dataBytes, int parentValueCount, int childValueCount, DrillBuf buf) {
        this.clear();
        this.parentValueCount = parentValueCount;
        this.childValueCount = childValueCount;
        int loaded = 0;
        loaded += this.offsets.load(parentValueCount + 1, buf.slice(loaded, buf.capacity() - loaded));
        loaded += this.values.load(dataBytes + 4 * (childValueCount + 1), childValueCount, buf.slice(loaded, buf.capacity() - loaded));
        return loaded;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getVarByteLength(), metadata.getGroupCount(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.values.clear();
        this.parentValueCount = 0;
        this.childValueCount = 0;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    public final class Mutator
    implements RepeatedMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int groupCount) {
            RepeatedVarCharVector.this.parentValueCount = groupCount;
            RepeatedVarCharVector.this.childValueCount = RepeatedVarCharVector.this.offsets.getAccessor().get(groupCount);
            RepeatedVarCharVector.this.offsets.getMutator().setValueCount(groupCount + 1);
            RepeatedVarCharVector.this.values.getMutator().setValueCount(RepeatedVarCharVector.this.childValueCount);
        }

        public void reset() {
        }
    }

    public final class Accessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new RepeatedVarCharReaderImpl(RepeatedVarCharVector.this);
        }

        @Override
        public List<Text> getObject(int index) {
            JsonStringArrayList<Text> vals = new JsonStringArrayList<Text>();
            int start = RepeatedVarCharVector.this.offsets.getAccessor().get(index);
            int end = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            for (int i = start; i < end; ++i) {
                vals.add(RepeatedVarCharVector.this.values.getAccessor().getObject(i));
            }
            return vals;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        RepeatedVarCharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedVarCharVector(field, RepeatedVarCharVector.this.allocator);
        }

        @Override
        public RepeatedVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVarCharVector.this.transferTo(this.to);
        }
    }
}

