/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.Decimal28SparseVector;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.complex.impl.RepeatedDecimal28SparseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal28SparseVector
extends BaseValueVector
implements RepeatedFixedWidthVector {
    private int parentValueCount;
    private int childValueCount;
    private final UInt4Vector offsets;
    private final Decimal28SparseVector values;
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal28SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsets = new UInt4Vector(null, allocator);
        this.values = new Decimal28SparseVector(null, allocator);
    }

    @Override
    public int getBufferSize() {
        return this.offsets.getBufferSize() + this.values.getBufferSize();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(RepeatedDecimal28SparseVector target) {
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        target.parentValueCount = this.parentValueCount;
        target.childValueCount = this.childValueCount;
        this.clear();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        this.offsets.allocateNew();
        this.offsets.zeroVector();
        this.values.allocateNew();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setGroupCount(this.parentValueCount).setValueCount(this.childValueCount).setBufferLength(this.getBufferSize()).build();
    }

    public int load(int parentValueCount, int childValueCount, DrillBuf buf) {
        this.clear();
        this.parentValueCount = parentValueCount;
        this.childValueCount = childValueCount;
        int loaded = 0;
        loaded += this.offsets.load(parentValueCount + 1, buf.slice(loaded, buf.capacity() - loaded));
        loaded += this.values.load(childValueCount, buf.slice(loaded, buf.capacity() - loaded));
        return loaded;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getGroupCount(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.values.clear();
        this.parentValueCount = 0;
        this.childValueCount = 0;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    public final class Mutator
    implements RepeatedFixedWidthVector.RepeatedMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int groupCount) {
            RepeatedDecimal28SparseVector.this.parentValueCount = groupCount;
            RepeatedDecimal28SparseVector.this.childValueCount = RepeatedDecimal28SparseVector.this.offsets.getAccessor().get(groupCount);
            RepeatedDecimal28SparseVector.this.offsets.getMutator().setValueCount(groupCount + 1);
            RepeatedDecimal28SparseVector.this.values.getMutator().setValueCount(RepeatedDecimal28SparseVector.this.childValueCount);
        }

        public void reset() {
        }
    }

    public final class Accessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new RepeatedDecimal28SparseReaderImpl(RepeatedDecimal28SparseVector.this);
        }

        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            int start = RepeatedDecimal28SparseVector.this.offsets.getAccessor().get(index);
            int end = RepeatedDecimal28SparseVector.this.offsets.getAccessor().get(index + 1);
            for (int i = start; i < end; ++i) {
                vals.add(RepeatedDecimal28SparseVector.this.values.getAccessor().getObject(i));
            }
            return vals;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        RepeatedDecimal28SparseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedDecimal28SparseVector(field, RepeatedDecimal28SparseVector.this.allocator);
        }

        @Override
        public RepeatedDecimal28SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedDecimal28SparseVector.this.transferTo(this.to);
        }
    }
}

