/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.complex.impl.NullableVar16CharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableVar16CharVector
extends BaseValueVector
implements NullableVector,
VariableWidthVector {
    private int valueCount;
    final UInt1Vector bits;
    final Var16CharVector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableVar16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new Var16CharVector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setVarByteLength(this.values.getVarByteLength()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    public int load(int dataBytes, int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        dataBytes -= loaded;
        this.mutator.lastSet = valueCount;
        return loaded += this.values.load(dataBytes, valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getBufferLength(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(NullableVar16CharVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator,
    VariableWidthVector.VariableWidthMutator {
        private int setCount;
        private int lastSet = -1;

        private Mutator() {
        }

        private boolean fillEmpties(int index) {
            for (int i = this.lastSet + 1; i < index; ++i) {
                if (NullableVar16CharVector.this.values.getMutator().setSafe(i, new byte[0])) continue;
                return false;
            }
            this.lastSet = index;
            return true;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            NullableVar16CharVector.this.valueCount = valueCount;
            NullableVar16CharVector.this.values.getMutator().setValueCount(valueCount);
            NullableVar16CharVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
            this.lastSet = -1;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor,
    VariableWidthVector.VariableWidthAccessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final Var16CharVector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableVar16CharReaderImpl(NullableVar16CharVector.this);
            this.bAccessor = NullableVar16CharVector.this.bits.getAccessor();
            this.vAccessor = NullableVar16CharVector.this.values.getAccessor();
        }

        public byte[] get(int index) {
            assert (!this.isNull(index)) : "Tried to get null value";
            return this.vAccessor.get(index);
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableVar16CharHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public String getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableVar16CharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableVar16CharVector(field, NullableVar16CharVector.this.allocator);
        }

        @Override
        public NullableVar16CharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableVar16CharVector.this.transferTo(this.to);
        }
    }
}

