/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableFloat4ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableFloat4Vector
extends BaseValueVector
implements FixedWidthVector,
NullableVector {
    private int valueCount;
    final UInt1Vector bits;
    final Float4Vector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableFloat4Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new Float4Vector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        this.values.allocateNew();
        this.bits.allocateNew();
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        return loaded += this.values.load(valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(NullableFloat4Vector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator {
        private int setCount;

        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableFloat4Vector.this.valueCount = valueCount;
            NullableFloat4Vector.this.values.getMutator().setValueCount(valueCount);
            NullableFloat4Vector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final Float4Vector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableFloat4ReaderImpl(NullableFloat4Vector.this);
            this.bAccessor = NullableFloat4Vector.this.bits.getAccessor();
            this.vAccessor = NullableFloat4Vector.this.values.getAccessor();
        }

        public float get(int index) {
            assert (!this.isNull(index)) : "Tried to get null value";
            return this.vAccessor.get(index);
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public Float getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableFloat4Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableFloat4Vector(field, NullableFloat4Vector.this.allocator);
        }

        @Override
        public NullableFloat4Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableFloat4Vector.this.transferTo(this.to);
        }
    }
}

