/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.Decimal38DenseVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal38DenseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableDecimal38DenseVector
extends BaseValueVector
implements FixedWidthVector,
NullableVector {
    private int valueCount;
    final UInt1Vector bits;
    final Decimal38DenseVector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableDecimal38DenseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new Decimal38DenseVector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        this.values.allocateNew();
        this.bits.allocateNew();
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        return loaded += this.values.load(valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(NullableDecimal38DenseVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator {
        private int setCount;

        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableDecimal38DenseVector.this.valueCount = valueCount;
            NullableDecimal38DenseVector.this.values.getMutator().setValueCount(valueCount);
            NullableDecimal38DenseVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final Decimal38DenseVector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableDecimal38DenseReaderImpl(NullableDecimal38DenseVector.this);
            this.bAccessor = NullableDecimal38DenseVector.this.bits.getAccessor();
            this.vAccessor = NullableDecimal38DenseVector.this.values.getAccessor();
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public BigDecimal getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableDecimal38DenseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableDecimal38DenseVector(field, NullableDecimal38DenseVector.this.allocator);
        }

        @Override
        public NullableDecimal38DenseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableDecimal38DenseVector.this.transferTo(this.to);
        }
    }
}

