/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableBigIntReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableBigIntVector
extends BaseValueVector
implements FixedWidthVector,
NullableVector {
    private int valueCount;
    final UInt1Vector bits;
    final BigIntVector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableBigIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new BigIntVector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        this.values.allocateNew();
        this.bits.allocateNew();
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        return loaded += this.values.load(valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().clone(ref));
    }

    public void transferTo(NullableBigIntVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator {
        private int setCount;

        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableBigIntVector.this.valueCount = valueCount;
            NullableBigIntVector.this.values.getMutator().setValueCount(valueCount);
            NullableBigIntVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final BigIntVector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableBigIntReaderImpl(NullableBigIntVector.this);
            this.bAccessor = NullableBigIntVector.this.bits.getAccessor();
            this.vAccessor = NullableBigIntVector.this.values.getAccessor();
        }

        public long get(int index) {
            assert (!this.isNull(index)) : "Tried to get null value";
            return this.vAccessor.get(index);
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public Long getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableBigIntVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableBigIntVector(field, NullableBigIntVector.this.allocator);
        }

        @Override
        public NullableBigIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableBigIntVector.this.transferTo(this.to);
        }
    }
}

