/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.drill.common.util.CoreDecimalUtility;

public class DecimalUtility
extends CoreDecimalUtility {
    public static final String[] decimalToString = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    public static final long[] scale_long_constants = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static BigDecimal getBigDecimalFromIntermediate(DrillBuf data, int startIndex, int nDecimalDigits, int scale) {
        return DecimalUtility.getBigDecimalFromDrillBuf(data, startIndex, nDecimalDigits, scale, false);
    }

    public static BigDecimal getBigDecimalFromSparse(DrillBuf data, int startIndex, int nDecimalDigits, int scale) {
        return DecimalUtility.getBigDecimalFromDrillBuf(data, startIndex, nDecimalDigits, scale, true);
    }

    public static BigDecimal getBigDecimalFromDrillBuf(DrillBuf data, int startIndex, int nDecimalDigits, int scale, boolean truncateScale) {
        int actualDigits;
        BigInteger decimalDigits = BigInteger.valueOf(data.getInt(startIndex) & Integer.MAX_VALUE);
        BigInteger base = BigInteger.valueOf(1000000000L);
        for (int i = 1; i < nDecimalDigits; ++i) {
            BigInteger temp = BigInteger.valueOf(data.getInt(startIndex + i * 4));
            decimalDigits = decimalDigits.multiply(base);
            decimalDigits = decimalDigits.add(temp);
        }
        if (truncateScale && scale > 0 && (actualDigits = scale % 9) != 0) {
            BigInteger truncate = BigInteger.valueOf((int)Math.pow(10.0, 9 - actualDigits));
            decimalDigits = decimalDigits.divide(truncate);
        }
        if ((data.getInt(startIndex) & Integer.MIN_VALUE) != 0) {
            decimalDigits = decimalDigits.negate();
        }
        BigDecimal decimal = new BigDecimal(decimalDigits, scale);
        return decimal;
    }

    public static BigDecimal getBigDecimalFromDense(DrillBuf data, int startIndex, int nDecimalDigits, int scale, int maxPrecision, int width) {
        byte shiftBits;
        int shiftOrder;
        int maskIndex;
        byte[] intermediateBytes = new byte[(nDecimalDigits + 1) * 4];
        int intermediateIndex = 3;
        int[] mask = new int[]{3, 15, 63, 255};
        int[] reverseMask = new int[]{252, 240, 192, 0};
        if (maxPrecision == 38) {
            maskIndex = 0;
            shiftOrder = 6;
            shiftBits = 0;
            intermediateBytes[intermediateIndex++] = (byte)(data.getByte(startIndex) & 0x7F);
        } else if (maxPrecision == 28) {
            maskIndex = 1;
            shiftOrder = 4;
            shiftBits = (byte)((data.getByte(startIndex) & 3) << shiftOrder);
            intermediateBytes[intermediateIndex++] = (byte)((data.getByte(startIndex) & 0x3C & 0xFF) >>> 2);
        } else {
            throw new UnsupportedOperationException("Dense types with max precision 38 and 28 are only supported");
        }
        int inputIndex = 1;
        boolean sign = false;
        if ((data.getByte(startIndex) & 0x80) != 0) {
            sign = true;
        }
        while (inputIndex < width) {
            intermediateBytes[intermediateIndex] = (byte)(shiftBits | (data.getByte(startIndex + inputIndex) & reverseMask[maskIndex] & 0xFF) >>> 8 - shiftOrder);
            shiftBits = (byte)((data.getByte(startIndex + inputIndex) & mask[maskIndex]) << shiftOrder);
            ++intermediateIndex;
            if ((++inputIndex - 1) % 4 != 0) continue;
            shiftBits = (byte)((shiftBits & 0xFF) >>> 2);
            ++maskIndex;
            shiftOrder -= 2;
        }
        intermediateBytes[intermediateIndex] = shiftBits;
        if (sign) {
            intermediateBytes[0] = (byte)(intermediateBytes[0] | 0x80);
        }
        DrillBuf intermediate = data.getAllocator().buffer(intermediateBytes.length);
        intermediate.setBytes(0, intermediateBytes);
        BigDecimal ret = DecimalUtility.getBigDecimalFromIntermediate(intermediate, 0, nDecimalDigits + 1, scale);
        intermediate.release();
        return ret;
    }
}

