/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.serialize;

import com.dyuproject.protostuff.JsonIOUtil;
import com.dyuproject.protostuff.Schema;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.drill.exec.store.sys.serialize.PClassSerializer;

public class ProtoSerializer<X, B extends Message.Builder>
implements PClassSerializer<X> {
    private final Schema<X> writeSchema;
    private final Schema<B> readSchema;

    public ProtoSerializer(Schema<X> writeSchema, Schema<B> readSchema) {
        this.writeSchema = writeSchema;
        this.readSchema = readSchema;
    }

    @Override
    public byte[] serialize(X val) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonIOUtil.writeTo((OutputStream)baos, val, this.writeSchema, false);
        return baos.toByteArray();
    }

    @Override
    public X deserialize(byte[] bytes) throws IOException {
        Message.Builder b = (Message.Builder)this.readSchema.newMessage();
        JsonIOUtil.mergeFrom(bytes, b, this.readSchema, false);
        return (X)b.build();
    }
}

