/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.drill.exec.store.sys.serialize.PClassSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer<X>
implements PClassSerializer<X> {
    static final Logger logger = LoggerFactory.getLogger(JacksonSerializer.class);
    private ObjectWriter writer;
    private ObjectReader reader;

    public JacksonSerializer(ObjectMapper mapper, Class<X> clazz) {
        this.reader = mapper.reader(clazz);
        this.writer = mapper.writer();
    }

    @Override
    public byte[] serialize(X val) throws IOException {
        return this.writer.writeValueAsBytes(val);
    }

    @Override
    public X deserialize(byte[] bytes) throws IOException {
        return (X)this.reader.readValue(bytes);
    }
}

