/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.local;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.LocalPStore;
import org.apache.drill.exec.store.sys.local.NoWriteLocalPStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPStoreProvider
implements PStoreProvider {
    static final Logger logger = LoggerFactory.getLogger(LocalPStoreProvider.class);
    private File path;
    private final boolean enableWrite;
    private ConcurrentMap<PStoreConfig<?>, PStore<?>> pstores;

    public LocalPStoreProvider(DrillConfig config) {
        this.path = new File(config.getString("drill.exec.sys.store.provider.local.path"));
        this.enableWrite = config.getBoolean("drill.exec.sys.store.provider.local.write");
        if (!this.enableWrite) {
            this.pstores = Maps.newConcurrentMap();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public <V> PStore<V> getPStore(PStoreConfig<V> storeConfig) throws IOException {
        if (this.enableWrite) {
            return new LocalPStore<V>(this.path, storeConfig);
        }
        NoWriteLocalPStore p = new NoWriteLocalPStore();
        PStore p2 = this.pstores.putIfAbsent(storeConfig, p);
        if (p2 != null) {
            return p2;
        }
        return p;
    }

    @Override
    public void start() {
    }
}

