/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPStore<V>
implements PStore<V> {
    static final Logger logger = LoggerFactory.getLogger(LocalPStore.class);
    private final File basePath;
    private final PStoreConfig<V> config;

    public LocalPStore(File base, PStoreConfig<V> config) {
        this.basePath = new File(base, config.getName());
        if (!this.basePath.exists()) {
            this.basePath.mkdirs();
        }
        this.config = config;
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        String[] f = this.basePath.list();
        if (f == null) {
            return Collections.emptyIterator();
        }
        ArrayList<String> files = Lists.newArrayList();
        for (String s : f) {
            if (!s.endsWith(".sys.drill")) continue;
            files.add(s.substring(0, s.length() - ".sys.drill".length()));
        }
        return new Iter(files.iterator());
    }

    private File p(String name) throws IOException {
        Preconditions.checkArgument(!name.contains("/") && !name.contains(":") && !name.contains(".."));
        File f = new File(this.basePath, name + ".sys.drill");
        f.getCanonicalPath();
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(String key) {
        try (FileInputStream is = new FileInputStream(this.p(key));){
            V v = this.config.getSerializer().deserialize(IOUtils.toByteArray((InputStream)is));
            return v;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(String key, V value) {
        try (FileOutputStream os = new FileOutputStream(this.p(key));){
            IOUtils.write((byte[])this.config.getSerializer().serialize(value), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        try {
            File f = this.p(key);
            if (f.exists()) {
                return false;
            }
            this.put(key, value);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.p(key).delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class Iter
    implements Iterator<Map.Entry<String, V>> {
        private Iterator<String> keys;
        private String current;

        public Iter(Iterator<String> keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            this.current = this.keys.next();
            return new DeferredEntry(this.current);
        }

        @Override
        public void remove() {
            LocalPStore.this.delete(this.current);
            this.keys.remove();
        }

        private class DeferredEntry
        implements Map.Entry<String, V> {
            private String name;

            public DeferredEntry(String name) {
                this.name = name;
            }

            @Override
            public String getKey() {
                return this.name;
            }

            @Override
            public V getValue() {
                return LocalPStore.this.get(this.name);
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

