/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.dyuproject.protostuff.Schema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.apache.drill.exec.store.sys.serialize.JacksonSerializer;
import org.apache.drill.exec.store.sys.serialize.PClassSerializer;
import org.apache.drill.exec.store.sys.serialize.ProtoSerializer;

public class PStoreConfig<V> {
    private final String name;
    private final PClassSerializer<V> valueSerializer;

    private PStoreConfig(String name, PClassSerializer<V> valueSerializer) {
        this.name = name;
        this.valueSerializer = valueSerializer;
    }

    public String getName() {
        return this.name;
    }

    public PClassSerializer<V> getSerializer() {
        return this.valueSerializer;
    }

    public static <V extends Message, X extends Message.Builder> PStoreConfigBuilder<V> newProtoBuilder(Schema<V> writeSchema, Schema<X> readSchema) {
        return new PStoreConfigBuilder(new ProtoSerializer<V, X>(writeSchema, readSchema));
    }

    public static <V> PStoreConfigBuilder<V> newJacksonBuilder(ObjectMapper mapper, Class<V> clazz) {
        return new PStoreConfigBuilder<V>(new JacksonSerializer<V>(mapper, clazz));
    }

    public static class PStoreConfigBuilder<V> {
        String name;
        PClassSerializer<V> serializer;

        PStoreConfigBuilder(PClassSerializer<V> serializer) {
            this.serializer = serializer;
        }

        public <X extends Message.Builder> PStoreConfigBuilder<V> name(String name) {
            this.name = name;
            return this;
        }

        public PStoreConfig<V> build() {
            Preconditions.checkNotNull(this.name);
            return new PStoreConfig(this.name, this.serializer);
        }
    }
}

