/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoDataType {
    static final Logger logger = LoggerFactory.getLogger(PojoDataType.class);
    public List<SqlTypeName> types = Lists.newArrayList();
    public List<String> names = Lists.newArrayList();

    public PojoDataType(Class<?> pojoClass) {
        logger.debug(pojoClass.getName());
        Field[] fields = pojoClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> type = f.getType();
            this.names.add(f.getName());
            if (type == Integer.TYPE || type == Integer.class) {
                this.types.add(SqlTypeName.INTEGER);
                continue;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                this.types.add(SqlTypeName.BOOLEAN);
                continue;
            }
            if (type == Long.TYPE || type == Long.class) {
                this.types.add(SqlTypeName.BIGINT);
                continue;
            }
            if (type == Double.TYPE || type == Double.class) {
                this.types.add(SqlTypeName.DOUBLE);
                continue;
            }
            if (type == String.class) {
                this.types.add(SqlTypeName.VARCHAR);
                continue;
            }
            if (type.isEnum()) {
                this.types.add(SqlTypeName.VARCHAR);
                continue;
            }
            if (type == Timestamp.class) {
                this.types.add(SqlTypeName.TIMESTAMP);
                continue;
            }
            throw new RuntimeException(String.format("PojoRecord reader doesn't yet support conversions from type [%s].", type));
        }
    }

    public RelDataType getRowType(RelDataTypeFactory f) {
        ArrayList<RelDataType> fields = Lists.newArrayList();
        for (SqlTypeName n : this.types) {
            fields.add(f.createSqlType(n));
        }
        return f.createStructType(fields, this.names);
    }
}

