/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.store.ischema.RecordGenerator;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeName;

public abstract class InfoSchemaTable {
    public static final TypeProtos.MajorType VARCHAR = Types.required(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType INT = Types.required(TypeProtos.MinorType.INT);
    private final String tableName;
    private final List<Field> fields;

    public InfoSchemaTable(String tableName, List<Field> fields) {
        this.tableName = tableName;
        this.fields = fields;
    }

    public static RelDataType getRelDataType(RelDataTypeFactory typeFactory, TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case VARCHAR: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
        }
        throw new UnsupportedOperationException("Only INT and VARCHAR types are supported in INFORMATION_SCHEMA");
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> relTypes = Lists.newArrayList();
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (Field field : this.fields) {
            relTypes.add(InfoSchemaTable.getRelDataType(typeFactory, field.type));
            fieldNames.add(field.name);
        }
        return typeFactory.createStructType(relTypes, fieldNames);
    }

    public abstract RecordGenerator getRecordGenerator();

    public static class Columns
    extends InfoSchemaTable {
        private static final List<Field> fields = ImmutableList.of(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("COLUMN_NAME", VARCHAR), Field.create("ORDINAL_POSITION", INT), Field.create("IS_NULLABLE", VARCHAR), Field.create("DATA_TYPE", VARCHAR), Field.create("CHARACTER_MAXIMUM_LENGTH", INT), Field.create("NUMERIC_PRECISION_RADIX", INT), Field.create("NUMERIC_SCALE", INT), Field.create("NUMERIC_PRECISION", INT));

        public Columns() {
            super("COLUMNS", fields);
        }

        @Override
        public RecordGenerator getRecordGenerator() {
            return new RecordGenerator.Columns();
        }
    }

    public static class Views
    extends InfoSchemaTable {
        private static final List<Field> fields = ImmutableList.of(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("VIEW_DEFINITION", VARCHAR));

        public Views() {
            super("VIEWS", fields);
        }

        @Override
        public RecordGenerator getRecordGenerator() {
            return new RecordGenerator.Views();
        }
    }

    public static class Tables
    extends InfoSchemaTable {
        private static final List<Field> fields = ImmutableList.of(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("TABLE_TYPE", VARCHAR));

        public Tables() {
            super("TABLES", fields);
        }

        @Override
        public RecordGenerator getRecordGenerator() {
            return new RecordGenerator.Tables();
        }
    }

    public static class Schemata
    extends InfoSchemaTable {
        private static final List<Field> fields = ImmutableList.of(Field.create("CATALOG_NAME", VARCHAR), Field.create("SCHEMA_NAME", VARCHAR), Field.create("SCHEMA_OWNER", VARCHAR), Field.create("TYPE", VARCHAR), Field.create("IS_MUTABLE", VARCHAR));

        public Schemata() {
            super("SCHEMATA", fields);
        }

        @Override
        public RecordGenerator getRecordGenerator() {
            return new RecordGenerator.Schemata();
        }
    }

    public static class Catalogs
    extends InfoSchemaTable {
        private static final List<Field> fields = ImmutableList.of(Field.create("CATALOG_NAME", VARCHAR), Field.create("CATALOG_DESCRIPTION", VARCHAR), Field.create("CATALOG_CONNECT", VARCHAR));

        Catalogs() {
            super("CATALOGS", fields);
        }

        @Override
        public RecordGenerator getRecordGenerator() {
            return new RecordGenerator.Catalogs();
        }
    }

    public static class Field {
        public String name;
        public TypeProtos.MajorType type;

        public static Field create(String name, TypeProtos.MajorType type) {
            Field field = new Field();
            field.name = name;
            field.type = type;
            return field;
        }
    }
}

