/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.ischema.InfoSchemaConfig;
import org.apache.drill.exec.store.ischema.InfoSchemaDrillTable;
import org.apache.drill.exec.store.ischema.InfoSchemaGroupScan;
import org.apache.drill.exec.store.ischema.SelectedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoSchemaStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(InfoSchemaStoragePlugin.class);
    private final InfoSchemaConfig config;
    private final DrillbitContext context;
    private final String name;

    public InfoSchemaStoragePlugin(InfoSchemaConfig config, DrillbitContext context, String name) {
        this.config = config;
        this.context = context;
        this.name = name;
    }

    @Override
    public InfoSchemaGroupScan getPhysicalScan(JSONOptions selection, List<SchemaPath> columns) throws IOException {
        SelectedTable table = selection.getWith(this.context.getConfig(), SelectedTable.class);
        return new InfoSchemaGroupScan(table, columns);
    }

    @Override
    public StoragePluginConfig getConfig() {
        return this.config;
    }

    @Override
    public void registerSchemas(UserSession session, SchemaPlus parent) {
        ISchema s = new ISchema(parent, this);
        parent.add(s.getName(), s);
    }

    private class ISchema
    extends AbstractSchema {
        private Map<String, InfoSchemaDrillTable> tables;

        public ISchema(SchemaPlus parent, InfoSchemaStoragePlugin plugin) {
            super(ImmutableList.of(), "INFORMATION_SCHEMA");
            HashMap<String, InfoSchemaDrillTable> tbls = Maps.newHashMap();
            for (SelectedTable tbl : SelectedTable.values()) {
                tbls.put(tbl.name(), new InfoSchemaDrillTable(plugin, "INFORMATION_SCHEMA", tbl, InfoSchemaStoragePlugin.this.config));
            }
            this.tables = ImmutableMap.copyOf(tbls);
        }

        @Override
        public Table getTable(String name) {
            return this.tables.get(name);
        }

        @Override
        public Set<String> getTableNames() {
            return this.tables.keySet();
        }

        @Override
        public String getTypeName() {
            return "ischema";
        }
    }
}

