/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.ischema.InfoSchemaSubScan;
import org.apache.drill.exec.store.ischema.SelectedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="info-schema")
public class InfoSchemaGroupScan
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(InfoSchemaGroupScan.class);
    private final SelectedTable table;
    private List<SchemaPath> columns;

    @JsonCreator
    public InfoSchemaGroupScan(@JsonProperty(value="table") SelectedTable table, @JsonProperty(value="columns") List<SchemaPath> columns) {
        this.table = table;
        this.columns = columns;
    }

    private InfoSchemaGroupScan(InfoSchemaGroupScan that) {
        this.table = that.table;
        this.columns = that.columns;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
        Preconditions.checkArgument(endpoints.size() == 1);
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        Preconditions.checkArgument(minorFragmentId == 0);
        return new InfoSchemaSubScan(this.table);
    }

    @Override
    public ScanStats getScanStats() {
        return ScanStats.TRIVIAL_TABLE;
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new InfoSchemaGroupScan(this);
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        return Collections.emptyList();
    }

    @Override
    public String getDigest() {
        return this.table.toString() + "columns=" + this.columns;
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        InfoSchemaGroupScan newScan = new InfoSchemaGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }
}

